/*
 * Decompiled with CFR 0.152.
 */
package jd;

import it.sauronsoftware.junique.AlreadyLockedException;
import it.sauronsoftware.junique.JUnique;
import it.sauronsoftware.junique.MessageHandler;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import jd.Config;
import jd.JDInit;
import jd.JDInitFlags;
import jd.ParameterManager;
import jd.SplashScreen;
import jd.captcha.JACController;
import jd.captcha.JACMethod;
import jd.captcha.JAntiCaptcha;
import jd.captcha.pixelgrid.Captcha;
import jd.config.SubConfiguration;
import jd.controlling.DynamicPluginInterface;
import jd.controlling.JDController;
import jd.controlling.JDLogger;
import jd.controlling.interaction.Interaction;
import jd.event.ControlEvent;
import jd.gui.UserIO;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.MacOSController;
import jd.gui.swing.components.linkbutton.JLink;
import jd.gui.swing.jdgui.GUIUtils;
import jd.gui.swing.jdgui.userio.UserIOGui;
import jd.http.Browser;
import jd.http.URLConnectionAdapter;
import jd.nutils.OSDetector;
import jd.nutils.OutdatedParser;
import jd.update.FileUpdate;
import jd.update.WebUpdater;
import jd.utils.CheckJava;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.WebUpdate;
import jd.utils.locale.JDL;

public class Main {
    private static Logger LOGGER;
    public static final String instanceID;
    private static boolean instanceStarted;

    static {
        instanceID = Main.class.getName();
        instanceStarted = false;
    }

    public static String getCaptcha(String string, String string2) {
        if (JACMethod.hasMethod((String)string2)) {
            Object object;
            Object object2;
            File file;
            if (string.contains("http://")) {
                block9: {
                    try {
                        file = new File(System.getProperty("user.dir"), "jac_captcha.img");
                        object2 = new Browser();
                        object = object2.openGetConnection(string);
                        if (object.getLongContentLength() > 0L) break block9;
                        return "Could not download captcha image";
                    }
                    catch (IOException iOException) {
                        return "Downloaderror";
                    }
                }
                Browser.download((File)file, (URLConnectionAdapter)object);
            }
            file = new File(string);
            if (!file.exists()) {
                return "File does not exist";
            }
            try {
                object2 = new JFrame();
                object = ImageIO.read(file);
                MediaTracker mediaTracker = new MediaTracker((Component)object2);
                mediaTracker.addImage((Image)object, 0);
                mediaTracker.waitForID(0);
                mediaTracker.removeImage((Image)object);
                JAntiCaptcha jAntiCaptcha = new JAntiCaptcha(string2);
                Captcha captcha = jAntiCaptcha.createCaptcha((Image)object);
                String string3 = jAntiCaptcha.checkCaptcha(file, captcha);
                if (string.contains("http://")) {
                    file.delete();
                }
                return string3;
            }
            catch (Exception exception) {
                return exception.getStackTrace().toString();
            }
        }
        return "jDownloader has no method for " + string2;
    }

    public static boolean returnedfromUpdate() {
        return JDInitFlags.SWITCH_RETURNED_FROM_UPDATE;
    }

    public static void main(String[] stringArray) {
        System.setProperty("file.encoding", "UTF-8");
        OSDetector.setOSString((String)System.getProperty("os.name"));
        System.setProperty("sun.swing.enableImprovedDragGesture", "true");
        LOGGER = JDLogger.getLogger();
        Main.initMACProperties();
        LOGGER.info("Start JDownloader");
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            if (string.equalsIgnoreCase("-debug")) {
                JDInitFlags.SWITCH_DEBUG = true;
                LOGGER.info("DEBUG Modus aktiv");
            } else if (string.equalsIgnoreCase("-brdebug")) {
                JDInitFlags.SWITCH_DEBUG = true;
                Browser.setVerbose((boolean)true);
                LOGGER.info("Browser DEBUG Modus aktiv");
            } else {
                if (string.equalsIgnoreCase("-config")) {
                    new Config();
                    return;
                }
                if (string.equalsIgnoreCase("-trdebug")) {
                    JDL.DEBUG = true;
                    LOGGER.info("Translation DEBUG Modus aktiv");
                } else if (string.equalsIgnoreCase("-rfu")) {
                    JDInitFlags.SWITCH_RETURNED_FROM_UPDATE = true;
                }
            }
            ++n2;
        }
        if (JDUtilities.getRunType() == 1) {
            JDInitFlags.SWITCH_DEBUG = true;
        }
        UserIO.setInstance((UserIO)UserIOGui.getInstance());
        Main.preInitChecks();
        JDUtilities.setJDargs(stringArray);
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3].equalsIgnoreCase("-branch")) {
                SubConfiguration subConfiguration = WebUpdater.getConfig("WEBUPDATE");
                if (stringArray[n3 + 1].equalsIgnoreCase("reset")) {
                    subConfiguration.setProperty("BRANCH", null);
                    if (subConfiguration.hasChanges()) {
                        subConfiguration.save();
                        LOGGER.info("Switching back to default JDownloader branch");
                    }
                } else {
                    subConfiguration.setProperty("BRANCH", stringArray[n3 + 1]);
                    if (subConfiguration.hasChanges()) {
                        subConfiguration.save();
                        LOGGER.info("Switching to " + stringArray[n3 + 1] + " JDownloader branch");
                    }
                }
                ++n3;
            } else if (stringArray[n3].equals("-prot")) {
                LOGGER.finer(String.valueOf(stringArray[n3]) + " " + stringArray[n3 + 1]);
                ++n3;
            } else if (stringArray[n3].equals("-lng")) {
                LOGGER.finer(String.valueOf(stringArray[n3]) + " " + stringArray[n3 + 1]);
                if (new File(stringArray[n3 + 1]).exists() && stringArray[n3 + 1].trim().endsWith(".loc")) {
                    LOGGER.info("Use custom languagefile: " + stringArray[n3 + 1]);
                    JDL.setStaticLocale(stringArray[n3 + 1]);
                }
                ++n3;
            } else if (stringArray[n3].equals("--new-instance") || stringArray[n3].equals("-n")) {
                if (!JDInitFlags.ENOUGH_MEMORY) {
                    JDUtilities.restartJDandWait();
                }
                LOGGER.finer(String.valueOf(stringArray[n3]) + " parameter");
                JDInitFlags.SWITCH_NEW_INSTANCE = true;
            } else if (stringArray[n3].equals("--help") || stringArray[n3].equals("-h")) {
                ParameterManager.showCmdHelp();
                System.exit(0);
            } else if (stringArray[n3].equals("--captcha") || stringArray[n3].equals("-c")) {
                if (stringArray.length > n3 + 2) {
                    LOGGER.setLevel(Level.OFF);
                    String string = Main.getCaptcha(stringArray[n3 + 1], stringArray[n3 + 2]);
                    System.out.println(string);
                    System.exit(0);
                } else {
                    System.out.println("Error: Please define filepath and JAC method");
                    System.out.println("Usage: java -jar JDownloader.jar --captcha /path/file.png example.com");
                    System.exit(0);
                }
            } else if (stringArray[n3].equals("--show") || stringArray[n3].equals("-s")) {
                JACController.showDialog((boolean)false);
                JDInitFlags.STOP = true;
            } else if (stringArray[n3].equals("--train") || stringArray[n3].equals("-t")) {
                JACController.showDialog((boolean)true);
                JDInitFlags.STOP = true;
            } else if (JDInitFlags.SHOW_SPLASH && stringArray[n3].matches("(--add-.*|--start-download|-[dDmfHr]|--stop-download|--minimize|--focus|--hide|--reconnect)")) {
                JDInitFlags.SHOW_SPLASH = false;
            }
            ++n3;
        }
        try {
            JUnique.acquireLock((String)instanceID, (MessageHandler)new MessageHandler(){
                private int counter = -1;
                private Vector<String> params = new Vector();

                public String handle(String string) {
                    if (this.counter == -2) {
                        return null;
                    }
                    if (this.counter == -1) {
                        try {
                            this.counter = Integer.parseInt(string.trim());
                        }
                        catch (Exception exception) {
                            this.counter = -2;
                            return null;
                        }
                        if (this.counter == -1) {
                            this.counter = -2;
                        }
                    } else {
                        this.params.add(string);
                        --this.counter;
                        if (this.counter == 0) {
                            String[] stringArray = this.params.toArray(new String[this.params.size()]);
                            ParameterManager.processParameters(stringArray);
                            this.counter = -1;
                            this.params = new Vector();
                        }
                    }
                    return null;
                }
            });
            instanceStarted = true;
        }
        catch (AlreadyLockedException alreadyLockedException) {
            LOGGER.info("existing jD instance found!");
            instanceStarted = false;
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
            LOGGER.severe("Instance Handling not possible!");
            instanceStarted = true;
        }
        JDController.getInstance();
        if (instanceStarted || JDInitFlags.SWITCH_NEW_INSTANCE) {
            JDTheme.setTheme("default");
            if (JDInitFlags.SHOW_SPLASH && GUIUtils.getConfig().getBooleanProperty("SHOW_SPLASH", true).booleanValue()) {
                LOGGER.info("init Splash");
                new GuiRunnable<Object>(){

                    public Object runSave() {
                        try {
                            new SplashScreen(JDController.getInstance());
                        }
                        catch (Exception exception) {
                            JDLogger.exception(exception);
                        }
                        return null;
                    }
                }.waitForEDT();
            }
            Interaction.deleteInteractions();
            Main.start(stringArray);
        } else {
            if (stringArray.length > 0) {
                LOGGER.info("Send parameters to existing jD instance and exit");
                JUnique.sendMessage((String)instanceID, (String)("" + stringArray.length));
                int n4 = 0;
                while (n4 < stringArray.length) {
                    JUnique.sendMessage((String)instanceID, (String)stringArray[n4]);
                    ++n4;
                }
            } else {
                LOGGER.info("There is already a running jD instance");
                JUnique.sendMessage((String)instanceID, (String)"1");
                JUnique.sendMessage((String)instanceID, (String)"--focus");
            }
            System.exit(0);
        }
    }

    private static void start(final String[] stringArray) {
        if (!JDInitFlags.STOP && !JDInitFlags.ENOUGH_MEMORY) {
            JDUtilities.restartJDandWait();
            return;
        }
        if (!JDInitFlags.STOP) {
            Main main = new Main();
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    Main.this.go();
                    String[] stringArray2 = stringArray;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string = stringArray2[n2];
                        LOGGER.finest("Param: " + string);
                        ++n2;
                    }
                    ParameterManager.processParameters(stringArray);
                }
            });
        }
    }

    private static void preInitChecks() {
        Main.heapCheck();
        Main.javaCheck();
    }

    private static void heapCheck() {
        boolean bl = JDInitFlags.ENOUGH_MEMORY = Runtime.getRuntime().maxMemory() >= 100000000L;
        if (!JDInitFlags.ENOUGH_MEMORY) {
            JDInitFlags.SHOW_SPLASH = false;
            LOGGER.warning("Heapcheck: Not enough heap. use: java -Xmx512m -jar JDownloader.jar");
        }
    }

    private static void javaCheck() {
        int n;
        if (!CheckJava.check()) {
            LOGGER.warning("Javacheck: Wrong Java Version! JDownloader needs at least Java 1.5 or higher!");
            System.exit(0);
        }
        if (JDUtilities.getJavaVersion() < 1.6 && !OSDetector.isMac() && ((n = UserIO.getInstance().requestConfirmDialog(48, JDL.LF("gui.javacheck.newerjavaavailable.title", "Outdated Javaversion found: %s!", JDUtilities.getJavaVersion()), JDL.L("gui.javacheck.newerjavaavailable.msg", "Although JDownloader runs on your javaversion, we advise to install the latest java updates. \r\nJDownloader will run more stable, faster, and will look better. \r\n\r\nVisit http://jdownloader.org/download."), JDTheme.II("gui.images.warning", 32, 32), null, null)) & 8) == 0) {
            try {
                JLink.openURL((String)"http://jdownloader.org/download/index?updatejava=1");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void initMACProperties() {
        if (OSDetector.isMac()) {
            LOGGER.info("com.apple.mrj.application.growbox.intrudes=false");
            LOGGER.info("com.apple.mrj.application.apple.menu.about.name=jDownloader");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "jDownloader");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
            new MacOSController();
            if (System.getProperty("java.version").startsWith("1.5")) {
                File file = JDUtilities.getResourceFile("../../info_15.plist");
                File file2 = JDUtilities.getResourceFile("../../info.plist");
                if (file.exists() && file2.delete()) {
                    file.renameTo(JDUtilities.getResourceFile("../../info.plist"));
                }
            }
        }
    }

    private void go() {
        final JDInit jDInit = new JDInit();
        final JDController jDController = JDController.getInstance();
        jDInit.init();
        LOGGER.info("" + new Date());
        LOGGER.info("init Configuration");
        if (jDInit.loadConfiguration() == null) {
            UserIO.getInstance().requestMessageDialog("JDownloader cannot create the config files. Make sure, that JD_HOME/config/ exists and is writeable");
        }
        if (JDInitFlags.SWITCH_DEBUG) {
            LOGGER.info("DEBUG MODE ACTIVATED");
            LOGGER.setLevel(Level.ALL);
        } else {
            JDLogger.removeConsoleHandler();
        }
        if (!OutdatedParser.parseFile((File)JDUtilities.getResourceFile("outdated.dat"))) {
            LOGGER.severe("COULD NOT DELETE OUTDATED FILES.RESTART REQUIRED");
            int n = UserIO.getInstance().requestConfirmDialog(0, JDL.L("jd.Main.removerestart.title", "Updater"), JDL.L("jd.Main.removerestart.message", "Could not remove outdated libraries. Restart recommended!"), null, JDL.L("jd.Main.removerestart.ok", "Restart now!"), JDL.L("jd.Main.removerestart.cancel", "Continue"));
            if (UserIO.isOK((int)n)) {
                JDUtilities.restartJD(true);
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(5000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }
        LOGGER.info("init Controller");
        LOGGER.info("init Webupdate");
        JDUtilities.getController().fireControlEvent(new ControlEvent(this, 1, JDL.L("gui.splash.progress.webupdate", "Check updates")));
        LOGGER.info("init plugins");
        JDUtilities.getController().fireControlEvent(new ControlEvent(this, 1, JDL.L("gui.splash.progress.initplugins", "Init plugins")));
        jDInit.initPlugins();
        Locale.setDefault(Locale.ENGLISH);
        LOGGER.info("init downloadqueue");
        JDUtilities.getController().fireControlEvent(new ControlEvent(this, 1, JDL.L("gui.splash.progress.controller", "Start controller")));
        jDInit.initControllers();
        LOGGER.info("init gui");
        JDUtilities.getController().fireControlEvent(new ControlEvent(this, 1, JDL.L("gui.splash.progress.paintgui", "Paint user interface")));
        new GuiRunnable<Object>(){

            public Object runSave() {
                jDInit.initGUI(jDController);
                return null;
            }
        }.waitForEDT();
        LOGGER.info("Initialisation finished");
        jDController.setInitStatus(0);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("rev", JDUtilities.getRevision());
        JDUtilities.getConfiguration().setProperty("head", hashMap);
        Properties properties = System.getProperties();
        TreeSet<Object> treeSet = new TreeSet<Object>(properties.keySet());
        for (Object object : treeSet) {
            String string = object.toString();
            LOGGER.finer(String.valueOf(string) + "=" + properties.get(string));
        }
        LOGGER.info("Revision: " + JDUtilities.getRevision());
        LOGGER.finer("Runtype: " + JDUtilities.getRunType());
        jDInit.checkUpdate();
        JDUtilities.getController().fireControlEvent(new ControlEvent(this, 30, null));
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            JDLogger.exception(interruptedException);
        }
        LOGGER.info("update start");
        new Thread(){

            public void run() {
                try {
                    Thread.sleep(5000L);
                    new WebUpdate().doUpdateCheck(false);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }.start();
        try {
            Main.loadDynamics();
        }
        catch (Exception exception) {
            JDLogger.exception(Level.FINEST, exception);
        }
        WebUpdate.DynamicPluginsFinished();
        LOGGER.info("update end");
    }

    public static void loadDynamics() throws Exception {
        Object object;
        Object object2;
        Object object3;
        ArrayList<String> arrayList = new ArrayList<String>();
        URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{JDUtilities.getJDHomeDirectoryFromEnvironment().toURI().toURL(), JDUtilities.getResourceFile("java").toURI().toURL()}, Thread.currentThread().getContextClassLoader());
        if (JDUtilities.getRunType() == 1) {
            Enumeration<URL> object4 = uRLClassLoader.getResources("jd/dynamics/");
            Iterator<String> iterator = new ArrayList();
            while (object4.hasMoreElements()) {
                object3 = object4.nextElement();
                if (((URL)object3).toURI().getPath() == null || (object2 = new File(((URL)object3).toURI().getPath()).list()) == null) continue;
                String[] stringArray = object2;
                int n = ((String[])object2).length;
                int n2 = 0;
                while (n2 < n) {
                    object = stringArray[n2];
                    ((ArrayList)((Object)iterator)).add(new File((String)object).getName());
                    ++n2;
                }
            }
            if (((ArrayList)((Object)iterator)).size() == 0) {
                return;
            }
            object2 = ((ArrayList)((Object)iterator)).iterator();
            while (object2.hasNext()) {
                object3 = (String)object2.next();
                if (((String)object3).contains("$") || arrayList.contains("/jd/dynamics/" + (String)object3) || ((String)object3).equalsIgnoreCase("DynamicPluginInterface.class")) continue;
                System.out.println("Plugins: " + object3);
                arrayList.add("/jd/dynamics/" + object3);
            }
        } else {
            JDLogger.getLogger().finest("Run dynamics");
            if (WebUpdater.getPluginList() == null) {
                return;
            }
            for (Map.Entry entry : WebUpdater.PLUGIN_LIST.entrySet()) {
                System.out.println("Plugins: " + (String)entry.getKey());
                if (!((String)entry.getKey()).startsWith("/jd/dynamics/") || ((String)entry.getKey()).contains("DynamicPluginInterface")) continue;
                JDLogger.getLogger().finest("Found dynamic: " + (String)entry.getKey());
                if (!((FileUpdate)entry.getValue()).equals()) {
                    if (!new WebUpdater().updateUpdatefile((FileUpdate)entry.getValue())) {
                        JDLogger.getLogger().warning("Could not update " + entry.getValue());
                        continue;
                    }
                    JDLogger.getLogger().finest("Update OK!");
                }
                if (((String)entry.getKey()).contains("$") || arrayList.contains(entry.getKey())) continue;
                arrayList.add((String)entry.getKey());
            }
        }
        for (String string : arrayList) {
            try {
                JDLogger.getLogger().finest("Init Dynamic " + string);
                object3 = uRLClassLoader.loadClass(string.replace("/", ".").replace(".class", "").substring(1));
                if (object3 == null) {
                    JDLogger.getLogger().info("Could not load " + string);
                    continue;
                }
                if (object3 == DynamicPluginInterface.class) continue;
                object2 = ((Class)object3).getConstructor(new Class[0]);
                object = (DynamicPluginInterface)((Constructor)object2).newInstance(new Object[0]);
                ((DynamicPluginInterface)object).execute();
            }
            catch (Exception exception) {
                JDLogger.exception(Level.FINER, exception);
            }
        }
    }
}

