/*
 * Decompiled with CFR 0.152.
 */
package jd.config;

import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import jd.config.ConfigEntry;
import jd.config.ConfigGroup;
import jd.config.Property;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigContainer
implements Serializable {
    public static final int ACTION_REQUEST_SAVE = 0;
    private static final long serialVersionUID = 6583843494325603616L;
    public static final int TYPE_TEXTFIELD = 0;
    public static final int TYPE_COMBOBOX = 1;
    public static final int TYPE_BUTTON = 2;
    public static final int TYPE_CHECKBOX = 3;
    public static final int TYPE_LABEL = 4;
    public static final int TYPE_RADIOFIELD = 5;
    public static final int TYPE_SEPARATOR = 6;
    public static final int TYPE_BROWSEFILE = 7;
    public static final int TYPE_SPINNER = 8;
    public static final int TYPE_BROWSEFOLDER = 9;
    public static final int TYPE_TEXTAREA = 10;
    public static final int TYPE_PASSWORDFIELD = 11;
    public static final int TYPE_LINK = 12;
    public static final int TYPE_CONTAINER = 13;
    public static final int TYPE_LISTCONTROLLED = 110;
    public static final int TYPE_COMBOBOX_INDEX = 15;
    private int containers = 0;
    private ArrayList<ConfigEntry> content;
    private Property propertyInstance;
    private String title;
    private ConfigGroup group;
    private ImageIcon icon;

    public ConfigContainer() {
        this(JDL.L("config.container.defaultname", "Allgemein"));
    }

    public ConfigContainer(String string) {
        this.title = string;
        this.propertyInstance = JDUtilities.getConfiguration();
        this.content = new ArrayList();
    }

    public void addEntry(ConfigEntry configEntry) {
        if (configEntry.getGroup() == null) {
            configEntry.setGroup(this.group);
        }
        if (configEntry.getContainer() != null) {
            ++this.containers;
        }
        if (configEntry.getPropertyInstance() == null) {
            configEntry.setPropertyInstance(this.propertyInstance);
        }
        this.content.add(configEntry);
    }

    public int getContainerNum() {
        return this.containers;
    }

    public ArrayList<ConfigEntry> getEntries() {
        return this.content;
    }

    public ConfigEntry getEntryAt(int n) {
        if (this.content.size() <= n) {
            return null;
        }
        return this.content.get(n);
    }

    public Property getPropertyInstance() {
        return this.propertyInstance;
    }

    public String getTitle() {
        return this.title;
    }

    public void setPropertyInstance(Property property) {
        this.propertyInstance = property;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setGroup(ConfigGroup configGroup) {
        this.group = configGroup;
    }

    public ConfigGroup getGroup() {
        return this.group;
    }

    public void setIcon(ImageIcon imageIcon) {
        this.icon = imageIcon;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }
}

