/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.Timer;
import jd.config.SubConfiguration;
import jd.controlling.AccountControllerEvent;
import jd.controlling.AccountControllerListener;
import jd.controlling.JDController;
import jd.controlling.JDLogger;
import jd.event.JDBroadcaster;
import jd.gui.swing.components.Balloon;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.PluginForHost;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccountController
extends SubConfiguration
implements ActionListener,
AccountControllerListener {
    private static final long serialVersionUID = -7560087582989096645L;
    public static final String PROPERTY_ACCOUNT_SELECTION = "ACCOUNT_SELECTION";
    private static TreeMap<String, ArrayList<Account>> hosteraccounts = null;
    private static AccountController INSTANCE = null;
    private JDBroadcaster<AccountControllerListener, AccountControllerEvent> broadcaster = new JDBroadcaster<AccountControllerListener, AccountControllerEvent>(){

        @Override
        protected void fireEvent(AccountControllerListener accountControllerListener, AccountControllerEvent accountControllerEvent) {
            accountControllerListener.onAccountControllerEvent(accountControllerEvent);
        }
    };
    private Timer asyncSaveIntervalTimer = new Timer(2000, this);
    private boolean saveinprogress = false;
    private long lastballoon = 0L;
    private long waittimeAccountInfoUpdate = 900000L;
    private final long ballooninterval = 1800000L;
    public static final Object ACCOUNT_LOCK = new Object();
    private static Comparator<Account> COMPARE_MOST_TRAFFIC_LEFT = new Comparator<Account>(){

        @Override
        public int compare(Account account, Account account2) {
            AccountInfo accountInfo = account.getAccountInfo();
            AccountInfo accountInfo2 = account2.getAccountInfo();
            if (accountInfo != null && accountInfo2 != null) {
                if (accountInfo.getTrafficLeft() < accountInfo2.getTrafficLeft()) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    };

    public long getUpdateTime() {
        return this.waittimeAccountInfoUpdate;
    }

    public void setUpdateTime(long l) {
        this.waittimeAccountInfoUpdate = l;
    }

    private AccountController() {
        super("AccountController");
        this.asyncSaveIntervalTimer.setInitialDelay(2000);
        this.asyncSaveIntervalTimer.setRepeats(false);
        hosteraccounts = this.loadAccounts();
        this.broadcaster.addListener(this);
    }

    public AccountInfo updateAccountInfo(PluginForHost pluginForHost, Account account, boolean bl) {
        return this.updateAccountInfo(pluginForHost.getHost(), account, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountInfo updateAccountInfo(String string, Account account, boolean bl) {
        AccountInfo accountInfo;
        String string2;
        block17: {
            String string3 = string2 = string != null ? string : this.getHosterName(account);
            if (string2 == null) {
                account.setAccountInfo(null);
                this.logger.severe("Cannot update AccountInfo, no Hostername available!");
                return null;
            }
            PluginForHost pluginForHost = JDUtilities.getNewPluginForHostInstance(string2);
            if (pluginForHost == null) {
                account.setAccountInfo(null);
                this.logger.severe("Cannot update AccountInfo, no HosterPlugin available!");
                return null;
            }
            accountInfo = account.getAccountInfo();
            if (!bl) {
                if (account.lastUpdateTime() != 0L && accountInfo != null && accountInfo.isExpired()) {
                    return accountInfo;
                }
                if (!account.isValid() && account.lastUpdateTime() != 0L) {
                    return accountInfo;
                }
                if (System.currentTimeMillis() - account.lastUpdateTime() < this.waittimeAccountInfoUpdate) {
                    return accountInfo;
                }
            }
            account.setUpdateTime(System.currentTimeMillis());
            account.setValid(true);
            accountInfo = pluginForHost.fetchAccountInfo(account);
            if (accountInfo != null) break block17;
            account.setAccountInfo(null);
            this.broadcaster.fireEvent(new AccountControllerEvent(this, 20, string2, account));
            return null;
        }
        try {
            Object object = ACCOUNT_LOCK;
            synchronized (object) {
                account.setAccountInfo(accountInfo);
            }
            if (accountInfo.isExpired()) {
                account.setEnabled(false);
                this.broadcaster.fireEvent(new AccountControllerEvent(this, 31, string2, account));
            } else if (!account.isValid()) {
                account.setEnabled(false);
                this.broadcaster.fireEvent(new AccountControllerEvent(this, 30, string2, account));
            } else {
                this.broadcaster.fireEvent(new AccountControllerEvent(this, 20, string2, account));
            }
        }
        catch (IOException iOException) {
            this.logger.severe("AccountUpdate: " + string + " failed!");
        }
        catch (Exception exception) {
            this.logger.severe("AccountUpdate: " + string + " failed!");
            JDLogger.exception(exception);
            account.setAccountInfo(null);
            account.setEnabled(false);
            account.setValid(false);
            this.broadcaster.fireEvent(new AccountControllerEvent(this, 30, string2, account));
        }
        return accountInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHosterName(Account account) {
        if (account.getHoster() != null) {
            return account.getHoster();
        }
        TreeMap<String, ArrayList<Account>> treeMap = hosteraccounts;
        synchronized (treeMap) {
            for (String string : hosteraccounts.keySet()) {
                if (!hosteraccounts.get(string).contains(account)) continue;
                account.setHoster(string);
                return string;
            }
        }
        return null;
    }

    public static synchronized AccountController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AccountController();
        }
        return INSTANCE;
    }

    public void addListener(AccountControllerListener accountControllerListener) {
        this.broadcaster.addListener(accountControllerListener);
    }

    public void removeListener(AccountControllerListener accountControllerListener) {
        this.broadcaster.removeListener(accountControllerListener);
    }

    private TreeMap<String, ArrayList<Account>> loadAccounts() {
        return this.getGenericProperty("accountlist", new TreeMap());
    }

    public void addAccount(PluginForHost pluginForHost, Account account) {
        String string = pluginForHost.getHost();
        this.addAccount(string, account);
    }

    public boolean hasAccounts(String string) {
        return !this.getAllAccounts(string).isEmpty();
    }

    public ArrayList<Account> getAllAccounts(PluginForHost pluginForHost) {
        if (pluginForHost == null) {
            return new ArrayList<Account>();
        }
        return this.getAllAccounts(pluginForHost.getHost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Account> getAllAccounts(String string) {
        if (string == null) {
            return new ArrayList<Account>();
        }
        TreeMap<String, ArrayList<Account>> treeMap = hosteraccounts;
        synchronized (treeMap) {
            if (hosteraccounts.containsKey(string)) {
                return hosteraccounts.get(string);
            }
            ArrayList<Account> arrayList = new ArrayList<Account>();
            hosteraccounts.put(string, arrayList);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int validAccounts() {
        int n = 0;
        TreeMap<String, ArrayList<Account>> treeMap = hosteraccounts;
        synchronized (treeMap) {
            for (ArrayList<Account> arrayList : hosteraccounts.values()) {
                for (Account account : arrayList) {
                    if (!account.isEnabled()) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAccount(String string, Account account) {
        if (string == null) {
            return;
        }
        if (account == null) {
            return;
        }
        TreeMap<String, ArrayList<Account>> treeMap = hosteraccounts;
        synchronized (treeMap) {
            if (hosteraccounts.containsKey(string)) {
                ArrayList<Account> arrayList;
                ArrayList<Account> arrayList2 = arrayList = hosteraccounts.get(string);
                synchronized (arrayList2) {
                    boolean bl = arrayList.contains(account);
                    if (!bl) {
                        boolean bl2 = false;
                        ArrayList<Account> arrayList3 = new ArrayList<Account>(arrayList);
                        for (Account account2 : arrayList3) {
                            if (!account2.equals(account)) continue;
                            bl2 = true;
                            break;
                        }
                        if (!bl2) {
                            arrayList.add(account);
                            bl = true;
                        }
                    }
                    if (bl) {
                        this.broadcaster.fireEvent(new AccountControllerEvent(this, 10, string, account));
                    }
                }
            } else {
                ArrayList<Account> arrayList = new ArrayList<Account>();
                arrayList.add(account);
                hosteraccounts.put(string, arrayList);
                this.broadcaster.fireEvent(new AccountControllerEvent(this, 10, string, account));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAccount(String string, Account account) {
        if (account == null) {
            return false;
        }
        String string2 = string;
        if (string2 == null) {
            string2 = this.getHosterName(account);
        }
        if (string2 == null) {
            return false;
        }
        TreeMap<String, ArrayList<Account>> treeMap = hosteraccounts;
        synchronized (treeMap) {
            ArrayList<Account> arrayList;
            block13: {
                if (hosteraccounts.containsKey(string2)) break block13;
                return false;
            }
            ArrayList<Account> arrayList2 = arrayList = hosteraccounts.get(string2);
            synchronized (arrayList2) {
                boolean bl = arrayList.remove(account);
                if (!bl) {
                    ArrayList<Account> arrayList3 = new ArrayList<Account>(arrayList);
                    for (Account account2 : arrayList3) {
                        if (!account2.equals(account)) continue;
                        account = account2;
                        bl = arrayList.remove(account);
                        break;
                    }
                }
                if (bl) {
                    this.broadcaster.fireEvent(new AccountControllerEvent(this, 11, string2, account));
                }
                return bl;
            }
        }
    }

    public boolean removeAccount(PluginForHost pluginForHost, Account account) {
        if (account == null) {
            return false;
        }
        if (pluginForHost == null) {
            return this.removeAccount((String)null, account);
        }
        return this.removeAccount(pluginForHost.getHost(), account);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.asyncSaveIntervalTimer) {
            this.saveSync();
        }
    }

    @Override
    public void onAccountControllerEvent(AccountControllerEvent accountControllerEvent) {
        switch (accountControllerEvent.getID()) {
            case 10: {
                JDUtilities.getConfiguration().setProperty("USE_PREMIUM_V3", true);
                JDUtilities.getConfiguration().save();
                this.saveAsync();
                break;
            }
            case 11: 
            case 20: 
            case 30: 
            case 31: {
                this.saveAsync();
                break;
            }
        }
    }

    public void throwUpdateEvent(PluginForHost pluginForHost, Account account) {
        if (pluginForHost != null) {
            this.broadcaster.fireEvent(new AccountControllerEvent(this, 20, pluginForHost.getHost(), account));
        } else {
            this.broadcaster.fireEvent(new AccountControllerEvent(this, 20, null, account));
        }
    }

    public void saveAsync() {
        if (this.saveinprogress) {
            return;
        }
        this.asyncSaveIntervalTimer.restart();
    }

    public void saveSync() {
        if (this.saveinprogress) {
            return;
        }
        new Thread(){

            public void run() {
                AccountController.this.saveSyncnonThread();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSyncnonThread() {
        this.asyncSaveIntervalTimer.stop();
        String string = JDController.requestDelayExit("accountcontroller");
        TreeMap<String, ArrayList<Account>> treeMap = hosteraccounts;
        synchronized (treeMap) {
            this.saveinprogress = true;
            this.save();
            this.saveinprogress = false;
        }
        JDController.releaseDelayExit(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Account getValidAccount(PluginForHost pluginForHost) {
        Account account = null;
        TreeMap<String, ArrayList<Account>> treeMap = hosteraccounts;
        synchronized (treeMap) {
            ArrayList<Account> arrayList = new ArrayList<Account>(this.getAllAccounts(pluginForHost));
            if (this.getBooleanProperty(PROPERTY_ACCOUNT_SELECTION, true).booleanValue()) {
                Collections.sort(arrayList, COMPARE_MOST_TRAFFIC_LEFT);
            }
            int n = 0;
            while (n < arrayList.size()) {
                Account account2 = arrayList.get(n);
                if (!account2.isTempDisabled() && account2.isEnabled() && account2.isValid()) {
                    account = account2;
                    break;
                }
                ++n;
            }
        }
        if (account != null && !JDUtilities.getConfiguration().getBooleanProperty("USE_PREMIUM_V3", true).booleanValue()) {
            if (System.currentTimeMillis() - this.lastballoon > 1800000L) {
                this.lastballoon = System.currentTimeMillis();
                Balloon.show((String)JDL.L("gui.ballon.accountmanager.title", "Accountmanager"), (ImageIcon)JDTheme.II("gui.images.accounts", 32, 32), (String)JDL.L("gui.accountcontroller.globpremdisabled", "Premiumaccounts are globally disabled!<br/>Click <a href='http://jdownloader.org/knowledge/wiki/gui/premiummenu'>here</a> for help."));
            }
            account = null;
        }
        return account;
    }
}

