/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import jd.controlling.ByteBufferEntry;
import jd.controlling.JDLogger;
import jd.nutils.Formatter;

public class ByteBufferController {
    private ArrayList<ByteBufferEntry> bufferpool;
    public static final String MAXBUFFERSIZE = "MAX_BUFFER_SIZE_V3";
    private static ByteBufferController INSTANCE;
    private Comparator<ByteBufferEntry> bytebuffercomp = new Comparator<ByteBufferEntry>(){

        @Override
        public int compare(ByteBufferEntry byteBufferEntry, ByteBufferEntry byteBufferEntry2) {
            return byteBufferEntry.capacity() == byteBufferEntry2.capacity() ? 0 : (byteBufferEntry.capacity() > byteBufferEntry2.capacity() ? 1 : -1);
        }
    };
    protected long bufferEntries = 0L;

    public static synchronized ByteBufferController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ByteBufferController();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printDebug() {
        long l = 0L;
        ArrayList<ByteBufferEntry> arrayList = this.bufferpool;
        synchronized (arrayList) {
            for (ByteBufferEntry byteBufferEntry : this.bufferpool) {
                l += (long)byteBufferEntry.capacity();
            }
        }
        JDLogger.getLogger().info("ByteBufferController: Used: " + Formatter.formatReadable((long)(this.bufferEntries - l)) + " Free: " + Formatter.formatReadable((long)l));
    }

    private ByteBufferController() {
        this.bufferpool = new ArrayList();
        Thread thread = new Thread("ByteBuffer debugger"){

            public void run() {
                while (true) {
                    try {
                        2.sleep(600000L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                    ByteBufferController.getInstance().printDebug();
                }
            }
        };
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteBufferEntry getByteBufferEntry(int n) {
        ByteBufferEntry byteBufferEntry = null;
        ArrayList<ByteBufferEntry> arrayList = this.bufferpool;
        synchronized (arrayList) {
            for (ByteBufferEntry byteBufferEntry2 : this.bufferpool) {
                if (byteBufferEntry2.capacity() < n) continue;
                byteBufferEntry = byteBufferEntry2;
                this.bufferpool.remove(byteBufferEntry2);
                return byteBufferEntry.getbytebufferentry(n);
            }
        }
        this.bufferEntries += (long)n;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putByteBufferEntry(ByteBufferEntry byteBufferEntry) {
        ArrayList<ByteBufferEntry> arrayList = this.bufferpool;
        synchronized (arrayList) {
            if (!this.bufferpool.contains(byteBufferEntry)) {
                this.bufferpool.add(byteBufferEntry);
            }
            Collections.sort(this.bufferpool, this.bytebuffercomp);
        }
    }
}

