/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Timer;
import jd.config.SubConfiguration;
import jd.controlling.JDController;
import jd.controlling.ListController;
import jd.http.Browser;
import jd.nutils.encoding.Encoding;
import jd.parser.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTACCESSController
implements ActionListener,
ListController {
    private static transient SubConfiguration CONFIG = null;
    private transient HashMap<String, String[]> LIST;
    private static transient HTACCESSController INSTANCE = null;
    private Timer asyncSaveIntervalTimer;
    private boolean saveinprogress;

    public static synchronized HTACCESSController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HTACCESSController();
        }
        return INSTANCE;
    }

    private HTACCESSController() {
        CONFIG = SubConfiguration.getConfig("HTACCESSLIST");
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        hashMap.put("example.com", new String[]{"username", "passwd"});
        this.LIST = CONFIG.getGenericProperty("LIST2", hashMap);
        this.asyncSaveIntervalTimer = new Timer(2000, this);
        this.asyncSaveIntervalTimer.setInitialDelay(2000);
        this.asyncSaveIntervalTimer.setRepeats(false);
        this.asyncSaveIntervalTimer.stop();
        this.saveSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String string, String string2, String string3) {
        if (string == null || string.length() == 0) {
            return;
        }
        String string4 = Browser.getHost((String)string.trim()).toLowerCase();
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        HashMap<String, String[]> hashMap = this.LIST;
        synchronized (hashMap) {
            this.LIST.remove(string4);
            this.LIST.put(string4, new String[]{string2.trim(), string3.trim()});
        }
    }

    public static String[] getUserDatafromBasicauth(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.startsWith("Basic")) {
            string = new Regex(string, "Basic (.*?)$").getMatch(0);
        }
        string = Encoding.Base64Decode((String)string);
        String[] stringArray = new Regex(string, "(.*?):(.*?)$").getRow(0);
        return new String[]{stringArray[0], stringArray[1]};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String string, String string2) {
        if (string == null || string.length() == 0) {
            return;
        }
        String string3 = Browser.getHost((String)string.trim()).toLowerCase();
        String[] stringArray = HTACCESSController.getUserDatafromBasicauth(string2);
        if (stringArray == null) {
            return;
        }
        HashMap<String, String[]> hashMap = this.LIST;
        synchronized (hashMap) {
            this.LIST.remove(string3);
            this.LIST.put(string3, stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = Browser.getHost((String)string.trim()).toLowerCase();
        HashMap<String, String[]> hashMap = this.LIST;
        synchronized (hashMap) {
            block5: {
                if (this.LIST.containsKey(string2)) break block5;
                return null;
            }
            return "Basic " + Encoding.Base64Encode((String)(String.valueOf(this.LIST.get(string2)[0]) + ":" + this.LIST.get(string2)[1]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        String string2 = Browser.getHost((String)string.trim()).toLowerCase();
        HashMap<String, String[]> hashMap = this.LIST;
        synchronized (hashMap) {
            this.LIST.remove(string2);
        }
    }

    public HashMap<String, String[]> getPasswordList() {
        return this.LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setList(String string) {
        String[] stringArray = Regex.getLines(string);
        HashMap<String, String[]> hashMap = this.LIST;
        synchronized (hashMap) {
            this.LIST.clear();
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                String[] stringArray3 = new Regex(string2, "(.*?)%%%%(.*?)%%%%(.*?)$").getRow(0);
                if (stringArray3 != null) {
                    this.add(stringArray3[0], stringArray3[1], stringArray3[2]);
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getList() {
        HashMap<String, String[]> hashMap = this.LIST;
        synchronized (hashMap) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : this.LIST.keySet()) {
                String[] stringArray = this.LIST.get(string);
                stringBuilder.append(String.valueOf(string) + " %%%% " + stringArray[0] + " %%%% " + stringArray[1]);
            }
            return stringBuilder.toString().trim();
        }
    }

    public void save() {
        this.asyncSaveIntervalTimer.restart();
    }

    public void saveAsync() {
        if (this.saveinprogress) {
            return;
        }
        new Thread(){

            public void run() {
                this.setName("PasswordList: Saving");
                HTACCESSController.this.saveinprogress = true;
                HTACCESSController.this.saveSync();
                HTACCESSController.this.saveinprogress = false;
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSync() {
        String string = JDController.requestDelayExit("htaccesscontroller");
        HashMap<String, String[]> hashMap = this.LIST;
        synchronized (hashMap) {
            CONFIG.setProperty("LIST", this.LIST);
            CONFIG.save();
        }
        JDController.releaseDelayExit(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.asyncSaveIntervalTimer) {
            this.saveAsync();
        }
    }
}

