/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import it.sauronsoftware.junique.JUnique;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import jd.CPluginWrapper;
import jd.Main;
import jd.config.DatabaseConnector;
import jd.config.SubConfiguration;
import jd.controlling.AccountController;
import jd.controlling.DistributeData;
import jd.controlling.DownloadWatchDog;
import jd.controlling.HTACCESSController;
import jd.controlling.JDLogger;
import jd.controlling.LinkGrabberController;
import jd.controlling.PasswordListController;
import jd.controlling.ProgressController;
import jd.controlling.ProgressControllerEvent;
import jd.controlling.ProgressControllerListener;
import jd.controlling.SingleDownloadController;
import jd.event.ControlEvent;
import jd.event.ControlListener;
import jd.gui.UserIO;
import jd.http.Browser;
import jd.nutils.JDFlags;
import jd.nutils.io.JDIO;
import jd.parser.Regex;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.PluginForHost;
import jd.plugins.PluginsC;
import jd.update.FileUpdate;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDController
implements ControlListener {
    public static final int INIT_STATUS_COMPLETE = 0;
    private transient ArrayList<ControlListener> controlListener = new ArrayList();
    private transient ArrayList<ControlListener> removeList = new ArrayList();
    private ArrayList<ControlEvent> eventQueue = new ArrayList();
    private EventSender eventSender = null;
    private int initStatus = -1;
    private DownloadLink lastDownloadFinished;
    private Logger logger = JDLogger.getLogger();
    private ArrayList<FileUpdate> waitingUpdates = new ArrayList();
    private boolean alreadyAutostart = false;
    private static ArrayList<String> delayMap = new ArrayList();
    private static JDController INSTANCE;
    private static final Object SHUTDOWNLOCK;

    static {
        SHUTDOWNLOCK = new Object();
    }

    public static JDController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JDController();
        }
        return INSTANCE;
    }

    public JDController() {
        this.eventSender = this.getEventSender();
        JDUtilities.setController(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addControlListener(ControlListener controlListener) {
        if (controlListener == null) {
            throw new NullPointerException();
        }
        ArrayList<ControlListener> arrayList = this.controlListener;
        synchronized (arrayList) {
            ArrayList<ControlListener> arrayList2 = this.removeList;
            synchronized (arrayList2) {
                if (this.removeList.contains(controlListener)) {
                    this.removeList.remove(controlListener);
                }
            }
            if (!this.controlListener.contains(controlListener)) {
                this.controlListener.add(controlListener);
            }
        }
    }

    private String callService(String string, String string2) throws Exception {
        this.logger.finer("Call " + string);
        Browser browser = new Browser();
        browser.postPage(string, "jd=1&srcType=plain&data=" + string2);
        this.logger.info("Call re: " + browser.toString());
        if (!browser.getHttpConnection().isOK() || !browser.containsHTML("<rc>")) {
            return null;
        }
        String string3 = browser.getRegex("<rc>(.*?)</rc>").getMatch(0);
        if (string3.trim().length() < 80) {
            return null;
        }
        return string3;
    }

    @Override
    public void controlEvent(ControlEvent controlEvent) {
        if (controlEvent == null) {
            this.logger.warning("event= NULL");
            return;
        }
        switch (controlEvent.getID()) {
            case 30: {
                DownloadWatchDog.getInstance();
                break;
            }
            case 33: {
                File[] fileArray;
                File[] fileArray2 = fileArray = (File[])controlEvent.getParameter();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray2[n2];
                    if (this.isContainerFile(file) && JDUtilities.getConfiguration().getBooleanProperty("RELOADCONTAINER", true).booleanValue()) {
                        this.loadContainerFile(file);
                    }
                    ++n2;
                }
                break;
            }
            case 29: {
                break;
            }
            case 26: {
                break;
            }
            case 4: {
                if (!(controlEvent.getSource() instanceof PluginForHost)) {
                    return;
                }
                this.lastDownloadFinished = ((SingleDownloadController)controlEvent.getParameter()).getDownloadLink();
                if (this.lastDownloadFinished.getFilePackage().getRemainingLinks() == 0 && JDUtilities.getConfiguration().getIntegerProperty("FINISHED_DOWNLOADS_ACTION", 3) == 2) {
                    JDUtilities.getDownloadController().removePackage(this.lastDownloadFinished.getFilePackage());
                    break;
                }
                if (!this.lastDownloadFinished.getLinkStatus().isFinished() || JDUtilities.getConfiguration().getIntegerProperty("FINISHED_DOWNLOADS_ACTION", 3) != 0) break;
                this.lastDownloadFinished.getFilePackage().remove(this.lastDownloadFinished);
            }
        }
    }

    public String encryptDLC(String string) {
        String string2;
        block4: {
            String[] stringArray = JDUtilities.encrypt(string, "dlc");
            if (stringArray == null) {
                this.logger.severe("Container Encryption failed.");
                return null;
            }
            String string3 = stringArray[1];
            string = stringArray[0];
            String string4 = "http://service.jdownloader.org/dlcrypt/service.php";
            try {
                string2 = this.callService(string4, string3);
                if (string2 != null) break block4;
                return null;
            }
            catch (Exception exception) {
                JDLogger.exception(exception);
                return null;
            }
        }
        return String.valueOf(string) + string2;
    }

    public void exit() {
        new Thread(new Runnable(){

            public void run() {
                JDController.this.prepareShutdown(false);
                System.exit(0);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareShutdown(boolean bl) {
        Object object = SHUTDOWNLOCK;
        synchronized (object) {
            if (DatabaseConnector.isDatabaseShutdown()) {
                return;
            }
            this.logger.info("Stop all running downloads");
            DownloadWatchDog.getInstance().stopDownloads();
            if (!bl) {
                this.logger.info("Call Exit event");
                this.fireControlEventDirect(new ControlEvent(this, 26, this));
            }
            this.logger.info("Save Downloadlist");
            JDUtilities.getDownloadController().saveDownloadLinksSyncnonThread();
            this.logger.info("Save Accountlist");
            AccountController.getInstance().saveSyncnonThread();
            this.logger.info("Save Passwordlist");
            PasswordListController.getInstance().saveSync();
            this.logger.info("Save HTACCESSlist");
            HTACCESSController.getInstance().saveSync();
            if (!bl) {
                this.logger.info("Wait for delayExit");
                this.waitDelayExit();
            }
            this.logger.info("Shutdown Database");
            JDUtilities.getDatabaseConnector().shutdownDatabase();
            this.logger.info("Release JUnique Lock");
            try {
                JUnique.releaseLock((String)Main.instanceID);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fireControlEventDirect(new ControlEvent(this, 261, this));
        }
    }

    public void syncDatabase() {
        if (DatabaseConnector.isDatabaseShutdown()) {
            return;
        }
        this.logger.info("Sync Downloadlist");
        JDUtilities.getDownloadController().saveDownloadLinksSyncnonThread();
        this.logger.info("Sync Accountlist");
        AccountController.getInstance().saveSyncnonThread();
        this.logger.info("Sync Passwordlist");
        PasswordListController.getInstance().saveSync();
        this.logger.info("Sync HTACCESSlist");
        HTACCESSController.getInstance().saveSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String requestDelayExit(String string) {
        if (string == null) {
            string = "unknown";
        }
        ArrayList<String> arrayList = delayMap;
        synchronized (arrayList) {
            String string2 = "ID: " + string + " TIME: " + System.currentTimeMillis();
            while (delayMap.contains(string2)) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                string2 = "ID: " + string + " TIME: " + System.currentTimeMillis();
            }
            delayMap.add(string2);
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseDelayExit(String string) {
        ArrayList<String> arrayList = delayMap;
        synchronized (arrayList) {
            if (!delayMap.remove(string)) {
                JDLogger.getLogger().severe(String.valueOf(string) + " not found in delayMap!");
            }
        }
    }

    private void waitDelayExit() {
        long l = 10000L;
        while (l > 0L) {
            if (delayMap.size() <= 0) {
                return;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            l -= 200L;
        }
        this.logger.severe("Unable to satisfy all delayExit requests! " + delayMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireControlEvent(ControlEvent controlEvent) {
        if (controlEvent == null) {
            return;
        }
        try {
            ArrayList<ControlEvent> arrayList = this.eventQueue;
            synchronized (arrayList) {
                this.eventQueue.add(controlEvent);
                EventSender eventSender = this.eventSender;
                synchronized (eventSender) {
                    if (this.eventSender.waitFlag) {
                        this.eventSender.waitFlag = false;
                        this.eventSender.notify();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireControlEventDirect(ControlEvent controlEvent) {
        if (controlEvent == null) {
            return;
        }
        try {
            ArrayList<ControlListener> arrayList = this.controlListener;
            synchronized (arrayList) {
                ArrayList<ControlListener> object2 = this.removeList;
                synchronized (object2) {
                    this.controlListener.removeAll(this.removeList);
                    this.removeList.clear();
                }
                if (this.controlListener.size() > 0) {
                    for (ControlListener controlListener : this.controlListener) {
                        try {
                            controlListener.controlEvent(controlEvent);
                        }
                        catch (Exception exception) {
                            JDLogger.exception(exception);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void fireControlEvent(int n, Object object) {
        ControlEvent controlEvent = new ControlEvent(this, n, object);
        this.fireControlEvent(controlEvent);
    }

    private EventSender getEventSender() {
        if (this.eventSender != null && this.eventSender.isAlive()) {
            return this.eventSender;
        }
        EventSender eventSender = new EventSender();
        eventSender.start();
        return eventSender;
    }

    public int getForbiddenReconnectDownloadNum() {
        boolean bl = SubConfiguration.getConfig("DOWNLOAD").getBooleanProperty("PARAM_DOWNLOAD_AUTORESUME_ON_RECONNECT", true);
        int n = 0;
        ArrayList<DownloadLink> arrayList = DownloadWatchDog.getInstance().getRunningDownloads();
        for (DownloadLink downloadLink : arrayList) {
            if (!downloadLink.getLinkStatus().hasStatus(1024) || downloadLink.getTransferStatus().supportsResume() && bl) continue;
            ++n;
        }
        return n;
    }

    public int getInitStatus() {
        return this.initStatus;
    }

    public DownloadLink getLastFinishedDownloadLink() {
        return this.lastDownloadFinished;
    }

    public String getLastFinishedFile() {
        if (this.lastDownloadFinished == null) {
            return "";
        }
        return this.lastDownloadFinished.getFileOutput();
    }

    public ArrayList<FilePackage> getPackages() {
        return JDUtilities.getDownloadController().getPackages();
    }

    public int getSpeedMeter() {
        return DownloadWatchDog.getInstance().getTotalSpeed();
    }

    public ArrayList<FileUpdate> getWaitingUpdates() {
        return this.waitingUpdates;
    }

    public boolean isContainerFile(File file) {
        ArrayList<CPluginWrapper> arrayList = CPluginWrapper.getCWrapper();
        int n = 0;
        while (n < arrayList.size()) {
            CPluginWrapper cPluginWrapper = arrayList.get(n);
            if (cPluginWrapper.canHandle(file.getName())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public ArrayList<DownloadLink> getContainerLinks(File file) {
        ArrayList<CPluginWrapper> arrayList = CPluginWrapper.getCWrapper();
        ArrayList<DownloadLink> arrayList2 = new ArrayList<DownloadLink>();
        ProgressController progressController = new ProgressController("Containerloader", arrayList.size());
        this.logger.info("load Container: " + file);
        int n = 0;
        while (n < arrayList.size()) {
            block5: {
                CPluginWrapper cPluginWrapper = arrayList.get(n);
                progressController.setStatusText("Containerplugin: " + cPluginWrapper.getHost());
                if (cPluginWrapper.canHandle(file.getName())) {
                    PluginsC pluginsC = (PluginsC)cPluginWrapper.getNewPluginInstance();
                    try {
                        progressController.setSource(pluginsC);
                        pluginsC.initContainer(file.getAbsolutePath());
                        ArrayList<DownloadLink> arrayList3 = pluginsC.getContainedDownloadlinks();
                        if (arrayList3 == null || arrayList3.size() == 0) {
                            this.logger.severe("Container Decryption failed (1)");
                            break block5;
                        }
                        arrayList2 = arrayList3;
                        break;
                    }
                    catch (Throwable throwable) {
                        JDLogger.exception(throwable);
                    }
                }
            }
            progressController.increase(1L);
            ++n;
        }
        progressController.setStatusText(String.valueOf(arrayList2.size()) + " links found");
        progressController.doFinalize();
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeControlListener(ControlListener controlListener) {
        ArrayList<ControlListener> arrayList = this.removeList;
        synchronized (arrayList) {
            if (!this.removeList.contains(controlListener)) {
                this.removeList.add(controlListener);
            }
        }
    }

    public void loadContainerFile(File file) {
        this.loadContainerFile(file, false, false);
    }

    public void loadContainerFile(final File file, final boolean bl, final boolean bl2) {
        System.out.println("load container");
        new Thread(){

            public void run() {
                Object object;
                Object object2;
                ArrayList<CPluginWrapper> arrayList = CPluginWrapper.getCWrapper();
                Object object3 = new ArrayList<DownloadLink>();
                ProgressController progressController = new ProgressController("Containerloader", arrayList.size());
                JDController.this.logger.info("load Container: " + file);
                int n = 0;
                while (n < arrayList.size()) {
                    block9: {
                        CPluginWrapper cPluginWrapper = arrayList.get(n);
                        progressController.setStatusText("Containerplugin: " + cPluginWrapper.getHost());
                        if (cPluginWrapper.canHandle(file.getName())) {
                            object2 = (PluginsC)cPluginWrapper.getNewPluginInstance();
                            try {
                                progressController.setSource(object2);
                                ((PluginsC)object2).initContainer(file.getAbsolutePath());
                                object = ((PluginsC)object2).getContainedDownloadlinks();
                                if (object == null || ((ArrayList)object).size() == 0) {
                                    JDController.this.logger.severe("Container Decryption failed (1)");
                                    break block9;
                                }
                                object3 = object;
                                break;
                            }
                            catch (Exception exception) {
                                JDLogger.exception(exception);
                            }
                        }
                    }
                    progressController.increase(1L);
                    ++n;
                }
                progressController.setStatusText(String.valueOf(((ArrayList)object3).size()) + " links found");
                if (((ArrayList)object3).size() > 0) {
                    if (SubConfiguration.getConfig("GUI").getBooleanProperty("SHOW_CONTAINER_ONLOAD_OVERVIEW", false).booleanValue()) {
                        Object object4;
                        String string = "<style>p { font-size:9px;margin:1px; padding:0px;}div {font-family:Geneva, Arial, Helvetica, sans-serif; width:400px;background-color:#ffffff; padding:2px;}h1 { vertical-align:top; text-align:left;font-size:10px; margin:0px; display:block;font-weight:bold; padding:0px;}</style><div> <div align='center'> <p><img src='http://jdownloader.org/img/%s.gif'> </p> </div> <h1>%s</h1><hr> <table width='100%%' border='0' cellspacing='5'> <tr> <td><p>%s</p></td> <td style='width:100%%'><p>%s</p></td> </tr> <tr> <td><p>%s</p></td> <td style='width:100%%'><p>%s</p></td> </tr> <tr> <td><p>%s</p></td> <td style='width:100%%'><p>%s</p></td> </tr> <tr> <td><p>%s</p></td> <td style='width:100%%'><p>%s</p></td> </tr> </table> </div>";
                        if (((DownloadLink)((ArrayList)object3).get(0)).getFilePackage().getProperty("header", null) != null) {
                            object4 = ((ArrayList)object3).get(0).getFilePackage().getGenericProperty("header", new HashMap());
                            object = (String)((HashMap)object4).get("tribute");
                            object2 = String.valueOf((String)((HashMap)object4).get("generator.app")) + " v." + (String)((HashMap)object4).get("generator.version") + " (" + (String)((HashMap)object4).get("generator.url") + ")";
                        } else {
                            object2 = "n.A.";
                            object = "n.A";
                        }
                        object4 = ((ArrayList)object3).get(0).getFilePackage().getComment();
                        String string2 = ((ArrayList)object3).get(0).getFilePackage().getPassword();
                        JDFlags.hasAllFlags((int)UserIO.getInstance().requestConfirmDialog(132, JDL.L("container.message.title", "DownloadLinkContainer loaded"), String.format(string, JDIO.getFileExtension((File)file).toLowerCase(), JDL.L("container.message.title", "DownloadLinkContainer loaded"), JDL.L("container.message.uploaded", "Brought to you by"), object, JDL.L("container.message.created", "Created with"), object2, JDL.L("container.message.comment", "Comment"), object4, JDL.L("container.message.password", "Password"), string2)), (int[])new int[]{2});
                    }
                    LinkGrabberController.getInstance().addLinks((ArrayList<DownloadLink>)object3, bl, bl2);
                }
                progressController.doFinalize();
            }
        }.start();
    }

    public void saveDLC(File file, ArrayList<DownloadLink> arrayList) {
        String string = JDUtilities.createContainerString(arrayList, "dlc");
        String string2 = this.encryptDLC(string);
        if (string2 != null) {
            SubConfiguration subConfiguration = SubConfiguration.getConfig("DLCrypt");
            JDIO.writeLocalFile((File)file, (String)string2);
            if (subConfiguration.getBooleanProperty("SHOW_INFO_AFTER_CREATE", false).booleanValue() && JDFlags.hasSomeFlags((int)UserIO.getInstance().requestConfirmDialog(4, JDL.L("sys.dlc.success", "DLC encryption successfull. Run Testdecrypt now?")), (int[])new int[]{2})) {
                this.loadContainerFile(file);
                return;
            }
            return;
        }
        this.logger.severe("Container creation failed");
        UserIO.getInstance().requestMessageDialog("Container encryption failed");
    }

    public void setInitStatus(int n) {
        this.initStatus = n;
    }

    public void setWaitingUpdates(ArrayList<FileUpdate> arrayList) {
        this.waitingUpdates = arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<DownloadLink> getDownloadLinks(PluginForHost pluginForHost) {
        ArrayList<FilePackage> arrayList;
        ArrayList<DownloadLink> arrayList2 = new ArrayList<DownloadLink>();
        ArrayList<FilePackage> arrayList3 = arrayList = JDUtilities.getDownloadController().getPackages();
        synchronized (arrayList3) {
            for (FilePackage filePackage : arrayList) {
                for (DownloadLink downloadLink : filePackage.getDownloadLinkList()) {
                    if (downloadLink.getPlugin().getClass() != pluginForHost.getClass()) continue;
                    arrayList2.add(downloadLink);
                }
            }
        }
        return arrayList2;
    }

    public synchronized void autostartDownloadsonStartup() {
        if (this.alreadyAutostart) {
            return;
        }
        this.alreadyAutostart = true;
        new Thread(){

            public void run() {
                this.setName("Autostart counter");
                final ProgressController progressController = new ProgressController(JDL.L("gui.autostart", "Autostart downloads in few seconds..."));
                progressController.getBroadcaster().addListener(new ProgressControllerListener(){

                    public void onProgressControllerEvent(ProgressControllerEvent progressControllerEvent) {
                        progressController.setStatusText("Autostart aborted!");
                    }
                });
                progressController.doFinalize(10000L);
                while (!progressController.isFinished()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
                if (!progressController.isAbort()) {
                    DownloadWatchDog.getInstance().startDownloads();
                }
            }
        }.start();
    }

    public DownloadLink getDownloadLinkByFileOutput(File file, Integer n) {
        ArrayList<DownloadLink> arrayList = JDUtilities.getDownloadController().getAllDownloadLinks();
        try {
            for (DownloadLink downloadLink : arrayList) {
                if (!new File(downloadLink.getFileOutput()).getAbsoluteFile().equals(file.getAbsoluteFile())) continue;
                if (n != null) {
                    if (!downloadLink.getLinkStatus().hasStatus(n)) continue;
                    return downloadLink;
                }
                return downloadLink;
            }
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
        }
        return null;
    }

    public ArrayList<DownloadLink> getDownloadLinksByNamePattern(String string) {
        ArrayList<DownloadLink> arrayList = new ArrayList<DownloadLink>();
        ArrayList<FilePackage> arrayList2 = JDUtilities.getDownloadController().getPackages();
        try {
            Iterator<FilePackage> iterator = arrayList2.iterator();
            FilePackage filePackage = null;
            while (iterator.hasNext()) {
                filePackage = iterator.next();
                for (DownloadLink downloadLink : filePackage.getDownloadLinkList()) {
                    String string2 = new File(downloadLink.getFileOutput()).getName();
                    if (!new Regex(string2, string, 2).matches()) continue;
                    arrayList.add(downloadLink);
                }
            }
            return arrayList;
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
            return null;
        }
    }

    public ArrayList<DownloadLink> getDownloadLinksByPathPattern(String string) {
        ArrayList<DownloadLink> arrayList = new ArrayList<DownloadLink>();
        ArrayList<FilePackage> arrayList2 = JDUtilities.getDownloadController().getPackages();
        try {
            Iterator<FilePackage> iterator = arrayList2.iterator();
            FilePackage filePackage = null;
            while (iterator.hasNext()) {
                filePackage = iterator.next();
                for (DownloadLink downloadLink : filePackage.getDownloadLinkList()) {
                    String string2 = downloadLink.getFileOutput();
                    if (!new Regex(string2, string, 2).matches()) continue;
                    arrayList.add(downloadLink);
                }
            }
            return arrayList;
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
            return null;
        }
    }

    public void distributeLinks(String string) {
        new DistributeData(string).start();
    }

    private class EventSender
    extends Thread {
        protected static final long MAX_EVENT_TIME = 10000L;
        private ControlListener currentListener;
        private ControlEvent event;
        private long eventStart;
        public boolean waitFlag;
        private Thread watchDog;

        public EventSender() {
            super("EventSender");
            this.eventStart = 0L;
            this.waitFlag = true;
            this.watchDog = new Thread("EventSenderWatchDog"){

                public void run() {
                    while (true) {
                        if (EventSender.this.eventStart > 0L && System.currentTimeMillis() - EventSender.this.eventStart > 10000L) {
                            JDController.this.logger.finer("WATCHDOG: Execution Limit reached");
                            JDController.this.logger.finer("ControlListener: " + EventSender.this.currentListener);
                            JDController.this.logger.finer("Event: " + EventSender.this.event);
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            JDLogger.exception(interruptedException);
                            return;
                        }
                    }
                }
            };
            this.watchDog.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                Object object = this;
                synchronized (object) {
                    while (this.waitFlag) {
                        try {
                            this.wait();
                        }
                        catch (Exception exception) {
                            JDLogger.exception(exception);
                        }
                    }
                }
                try {
                    object = JDController.this.eventQueue;
                    synchronized (object) {
                        if (JDController.this.eventQueue.size() > 0) {
                            this.event = (ControlEvent)JDController.this.eventQueue.remove(0);
                        } else {
                            this.eventStart = 0L;
                            this.waitFlag = true;
                        }
                    }
                    if (this.event == null || this.waitFlag) continue;
                    this.eventStart = System.currentTimeMillis();
                    this.currentListener = JDController.this;
                    try {
                        JDController.this.controlEvent(this.event);
                    }
                    catch (Exception exception) {
                        JDLogger.exception(exception);
                    }
                    this.eventStart = 0L;
                    object = JDController.this.controlListener;
                    synchronized (object) {
                        Object object22;
                        if (JDController.this.controlListener.size() > 0) {
                            for (Object object22 : JDController.this.controlListener) {
                                this.eventStart = System.currentTimeMillis();
                                try {
                                    object22.controlEvent(this.event);
                                }
                                catch (Exception exception) {
                                    JDLogger.exception(exception);
                                }
                                this.eventStart = 0L;
                            }
                        }
                        object22 = JDController.this.removeList;
                        synchronized (object22) {
                            JDController.this.controlListener.removeAll(JDController.this.removeList);
                            JDController.this.removeList.clear();
                        }
                    }
                }
                catch (Exception exception) {
                    JDLogger.exception(exception);
                    this.eventStart = 0L;
                    continue;
                }
                break;
            }
        }
    }
}

