/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jd.controlling.JDLogHandler;
import jd.controlling.LogFormatter;
import jd.nutils.Formatter;

public class JDLogger {
    private static Logger LOGGER = null;
    public static String LOGGER_NAME = "java_downloader";
    private static ConsoleHandler console;

    protected JDLogger() {
    }

    public static Logger getLogger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger(LOGGER_NAME);
            LogFormatter logFormatter = new LogFormatter();
            LOGGER.setUseParentHandlers(false);
            console = new ConsoleHandler();
            console.setLevel(Level.ALL);
            console.setFormatter(logFormatter);
            LOGGER.addHandler(console);
            LOGGER.setLevel(Level.ALL);
            LOGGER.addHandler(JDLogHandler.getHandler());
            JDLogHandler.getHandler().setFormatter(logFormatter);
        }
        return LOGGER;
    }

    public static void timestamp(String string) {
        JDLogger.getLogger().warning(String.valueOf(Formatter.formatMilliseconds((long)System.currentTimeMillis())) + " : " + string);
    }

    public static void exception(Throwable throwable) {
        JDLogger.exception(Level.SEVERE, throwable);
    }

    public static void removeConsoleHandler() {
        if (console != null) {
            JDLogger.getLogger().removeHandler(console);
        }
        System.err.println("Removed Consolehandler. Start with -debug to see console output");
    }

    public static void addHeader(String string) {
        JDLogger.getLogger().info("\r\n\r\n--------------------------------------" + string + "-----------------------------------");
    }

    public static void exception(Level level, Throwable throwable) {
        JDLogger.getLogger().log(level, String.valueOf(level.getName()) + " Exception occurred", throwable);
    }

    public static void quickLog() {
        System.out.println("Footstep: " + new Exception().getStackTrace()[1]);
    }

    public static void warning(Object object) {
        JDLogger.getLogger().warning(object.toString());
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    public static String getLog(Level level) {
        Level level2 = JDLogger.getLogger().getLevel();
        JDLogger.getLogger().setLevel(level);
        try {
            ArrayList<LogRecord> arrayList = JDLogHandler.getHandler().getBuffer();
            StringBuilder stringBuilder = new StringBuilder();
            for (LogRecord logRecord : arrayList) {
                stringBuilder.append(JDLogHandler.getHandler().getFormatter().format(logRecord));
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            JDLogger.getLogger().setLevel(level2);
        }
    }
}

