/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.swing.Timer;
import jd.config.SubConfiguration;
import jd.controlling.DownloadControllerEvent;
import jd.controlling.DownloadControllerListener;
import jd.controlling.JDController;
import jd.controlling.ListController;
import jd.parser.Regex;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordListController
implements ActionListener,
DownloadControllerListener,
ListController {
    private static transient SubConfiguration CONFIG = null;
    private transient ArrayList<String> LIST2;
    private static transient PasswordListController INSTANCE = null;
    private Timer asyncSaveIntervalTimer;
    private boolean saveinprogress;

    public static synchronized PasswordListController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PasswordListController();
        }
        return INSTANCE;
    }

    private PasswordListController() {
        CONFIG = SubConfiguration.getConfig("PASSWORDLIST");
        this.LIST2 = CONFIG.getGenericProperty("LIST2", new ArrayList());
        this.asyncSaveIntervalTimer = new Timer(2000, this);
        this.asyncSaveIntervalTimer.setInitialDelay(2000);
        this.asyncSaveIntervalTimer.setRepeats(false);
        this.asyncSaveIntervalTimer.stop();
        this.saveSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPassword(String string, boolean bl) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        ArrayList<String> arrayList = this.LIST2;
        synchronized (arrayList) {
            if (this.LIST2.contains(string)) {
                if (bl) {
                    this.LIST2.remove(string);
                    this.LIST2.add(0, string);
                }
            } else if (bl) {
                this.LIST2.add(0, string);
            } else {
                this.LIST2.add(string);
            }
        }
        this.save();
    }

    public ArrayList<String> getPasswordList() {
        return this.LIST2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPasswordList(ArrayList<String> arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        ArrayList<String> arrayList2 = this.LIST2;
        synchronized (arrayList2) {
            this.LIST2.clear();
            this.addPasswords(arrayList);
            this.removeDups();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setList(String string) {
        if (string == null) {
            string = "";
        }
        String[] stringArray = Regex.getLines(string);
        ArrayList<String> arrayList = this.LIST2;
        synchronized (arrayList) {
            this.LIST2.clear();
            this.addPasswords(stringArray);
            this.removeDups();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getList() {
        ArrayList<String> arrayList = this.LIST2;
        synchronized (arrayList) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : this.getPasswordList()) {
                stringBuilder.append(String.valueOf(string) + "\r\n");
            }
            return stringBuilder.toString().trim();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPasswords(Collection<String> collection) {
        if (collection == null || collection.size() == 0) {
            return;
        }
        ArrayList<String> arrayList = this.LIST2;
        synchronized (arrayList) {
            for (String string : collection) {
                this.addPassword(string, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPasswords(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        ArrayList<String> arrayList = this.LIST2;
        synchronized (arrayList) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                this.addPassword(string, false);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDups() {
        ArrayList<String> arrayList = this.LIST2;
        synchronized (arrayList) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            for (String string : this.LIST2) {
                linkedHashSet.add(string);
            }
            this.LIST2.clear();
            this.LIST2.addAll(linkedHashSet);
            this.save();
        }
    }

    public void save() {
        if (this.saveinprogress) {
            return;
        }
        this.asyncSaveIntervalTimer.restart();
    }

    public void saveAsync() {
        if (this.saveinprogress) {
            return;
        }
        new Thread(){

            public void run() {
                this.setName("PasswordList: Saving");
                PasswordListController.this.saveSync();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSync() {
        this.asyncSaveIntervalTimer.stop();
        String string = JDController.requestDelayExit("passwordcontroller");
        ArrayList<String> arrayList = this.LIST2;
        synchronized (arrayList) {
            this.saveinprogress = true;
            CONFIG.setProperty("LIST2", this.LIST2);
            CONFIG.save();
            this.saveinprogress = false;
        }
        JDController.releaseDelayExit(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.asyncSaveIntervalTimer) {
            this.saveAsync();
        }
    }

    @Override
    public void onDownloadControllerEvent(DownloadControllerEvent downloadControllerEvent) {
        switch (downloadControllerEvent.getID()) {
            case 4: {
                this.addPasswords(((DownloadLink)downloadControllerEvent.getParameter()).getSourcePluginPasswordList());
                break;
            }
            case 2: {
                this.addPassword(((FilePackage)downloadControllerEvent.getParameter()).getPassword(), false);
                break;
            }
        }
    }
}

