/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import jd.config.SubConfiguration;
import jd.controlling.DownloadController;
import jd.controlling.DownloadWatchDog;
import jd.controlling.JDLogger;
import jd.event.ControlEvent;
import jd.gui.UserIO;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.components.Balloon;
import jd.gui.swing.dialog.AgbDialog;
import jd.http.Browser;
import jd.nutils.Formatter;
import jd.nutils.io.JDIO;
import jd.parser.Regex;
import jd.plugins.DownloadLink;
import jd.plugins.LinkStatus;
import jd.plugins.PluginException;
import jd.plugins.PluginForHost;
import jd.plugins.download.DownloadInterface;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

public class SingleDownloadController
extends Thread {
    public static final String WAIT_TIME_ON_CONNECTION_LOSS = "WAIT_TIME_ON_CONNECTION_LOSS";
    private static final Object DUPELOCK = new Object();
    private boolean aborted;
    private PluginForHost currentPlugin;
    private DownloadLink downloadLink;
    private LinkStatus linkStatus;
    private Logger logger = JDLogger.getLogger();
    private long startTime;

    public SingleDownloadController(DownloadLink downloadLink) {
        super("JD-StartDownloads");
        this.downloadLink = downloadLink;
        this.linkStatus = this.downloadLink.getLinkStatus();
        this.setPriority(1);
        this.downloadLink.setDownloadLinkController(this);
    }

    public SingleDownloadController abortDownload() {
        this.aborted = true;
        this.interrupt();
        return this;
    }

    private void fireControlEvent(ControlEvent controlEvent) {
        JDUtilities.getController().fireControlEvent(controlEvent);
    }

    private void fireControlEvent(int n, Object object) {
        JDUtilities.getController().fireControlEvent(n, object);
    }

    public PluginForHost getCurrentPlugin() {
        return this.currentPlugin;
    }

    public DownloadLink getDownloadLink() {
        return this.downloadLink;
    }

    private void handlePlugin() {
        try {
            this.startTime = System.currentTimeMillis();
            this.linkStatus.setStatusText(JDL.L("gui.download.create_connection", "Connecting..."));
            System.out.println("PreDupeChecked: no mirror found!");
            this.fireControlEvent(5, this.currentPlugin);
            DownloadController.getInstance().fireDownloadLinkUpdate(this.downloadLink);
            this.currentPlugin.init();
            try {
                try {
                    this.currentPlugin.handle(this.downloadLink);
                }
                catch (Browser.BrowserException browserException) {
                    browserException.closeConnection();
                    if (browserException.getException() != null) {
                        throw browserException.getException();
                    }
                    throw browserException;
                }
            }
            catch (UnknownHostException unknownHostException) {
                this.linkStatus.addStatus(2048);
                this.linkStatus.setErrorMessage(JDL.L("plugins.errors.nointernetconn", "No Internet connection?"));
                this.linkStatus.setValue(300000L);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.linkStatus.addStatus(2048);
                this.linkStatus.setErrorMessage(JDL.L("plugins.errors.hosteroffline", "Hoster offline?"));
                this.linkStatus.setValue(600000L);
            }
            catch (SocketException socketException) {
                this.linkStatus.addStatus(2048);
                this.linkStatus.setErrorMessage(JDL.L("plugins.errors.disconnect", "Disconnect?"));
                this.linkStatus.setValue(300000L);
            }
            catch (IOException iOException) {
                this.linkStatus.addStatus(2048);
                this.linkStatus.setErrorMessage(JDL.L("plugins.errors.hosterproblem", "Hoster problem?"));
                this.linkStatus.setValue(600000L);
            }
            catch (InterruptedException interruptedException) {
                this.logger.finest("Hoster Plugin Version: " + this.downloadLink.getPlugin().getVersion());
                this.linkStatus.addStatus(131072);
                this.linkStatus.setErrorMessage(String.valueOf(JDL.L("plugins.errors.error", "Error: ")) + JDUtilities.convertExceptionReadable(interruptedException));
            }
            catch (Exception exception) {
                this.logger.finest("Hoster Plugin Version: " + this.downloadLink.getPlugin().getVersion());
                JDLogger.exception(exception);
                this.linkStatus.addStatus(0x400000);
                this.linkStatus.setErrorMessage(String.valueOf(JDL.L("plugins.errors.error", "Error: ")) + JDUtilities.convertExceptionReadable(exception));
            }
            if (this.isAborted()) {
                this.logger.finest("Thread aborted");
                this.linkStatus.setStatus(1);
                return;
            }
            if (this.linkStatus.isFailed()) {
                this.logger.warning("\r\nError occured- " + this.downloadLink.getLinkStatus());
            }
            if (this.aborted) {
                this.linkStatus.setErrorMessage(null);
            }
            switch (this.linkStatus.getLatestStatus()) {
                case 0x200000: {
                    this.onErrorLocalIO(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 16: {
                    this.onErrorIPWaittime(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 2048: {
                    this.onErrorDownloadTemporarilyUnavailable(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 4096: {
                    this.onErrorHostTemporarilyUnavailable(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 65536: {
                    this.onErrorAGBNotSigned(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 32: {
                    Balloon.showIfHidden((String)JDL.L("ballon.download.error.title", "Error"), (ImageIcon)JDTheme.II("gui.images.bad", 32, 32), (String)JDL.LF("ballon.download.fnf.message", "<b>%s<b><hr>File not found", String.valueOf(this.downloadLink.getName()) + " (" + Formatter.formatReadable((long)this.downloadLink.getDownloadSize()) + ")"));
                    this.onErrorFileNotFound(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 524288: {
                    this.onErrorLinkBlock(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 131072: {
                    Balloon.showIfHidden((String)JDL.L("ballon.download.error.title", "Error"), (ImageIcon)JDTheme.II("gui.images.bad", 32, 32), (String)JDL.LF("ballon.download.fatalerror.message", "<b>%s<b><hr>Fatal Plugin Error", this.downloadLink.getHost()));
                    this.onErrorFatal(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 8: {
                    this.onErrorCaptcha(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 256: {
                    this.onErrorPremium(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 512: {
                    this.onErrorIncomplete(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 8192: {
                    this.onErrorFileExists(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 16384: {
                    this.onErrorChunkloadFailed(this.downloadLink, this.currentPlugin);
                    Balloon.showIfHidden((String)JDL.L("ballon.download.error.title", "Error"), (ImageIcon)JDTheme.II("gui.images.bad", 32, 32), (String)JDL.LF("ballon.download.failed.message", "<b>%s<b><hr>failed", String.valueOf(this.downloadLink.getName()) + " (" + Formatter.formatReadable((long)this.downloadLink.getDownloadSize()) + ")"));
                    break;
                }
                case 0x400000: {
                    this.onErrorPluginDefect(this.downloadLink, this.currentPlugin);
                    Balloon.showIfHidden((String)JDL.L("ballon.download.error.title", "Error"), (ImageIcon)JDTheme.II("gui.images.bad", 32, 32), (String)JDL.LF("ballon.download.plugindefect.message", "<b>%s<b><hr>Plugin defect", this.downloadLink.getHost()));
                    break;
                }
                case 32768: 
                case 0x100000: {
                    Balloon.showIfHidden((String)JDL.L("ballon.download.error.title", "Error"), (ImageIcon)JDTheme.II("gui.images.bad", 32, 32), (String)JDL.LF("ballon.download.connectionlost.message", "<b>%s<b><hr>Connection lost", this.downloadLink.getHost()));
                    this.onErrorNoConnection(this.downloadLink, this.currentPlugin);
                    break;
                }
                default: {
                    if (this.linkStatus.hasStatus(2)) {
                        this.logger.finest("\r\nFinished- " + this.downloadLink.getLinkStatus());
                        this.logger.info("\r\nFinished- " + this.downloadLink.getFileOutput());
                        this.onDownloadFinishedSuccessFull(this.downloadLink);
                        break;
                    }
                    this.retry(this.downloadLink, this.currentPlugin);
                    break;
                }
            }
        }
        catch (Exception exception) {
            this.logger.severe("Error in Plugin Version: " + this.downloadLink.getPlugin().getVersion());
            JDLogger.exception(exception);
        }
    }

    private void onErrorLinkBlock(DownloadLink downloadLink, PluginForHost pluginForHost) {
        LinkStatus linkStatus = downloadLink.getLinkStatus();
        if (linkStatus.hasStatus(8192)) {
            this.onErrorFileExists(downloadLink, pluginForHost);
        } else {
            linkStatus.resetWaitTime();
            downloadLink.setEnabled(false);
        }
    }

    private void onErrorPluginDefect(DownloadLink downloadLink, PluginForHost pluginForHost) {
        this.logger.warning("The Plugin for " + this.currentPlugin.getHost() + " seems to be out of date(rev" + this.downloadLink.getPlugin().getVersion() + "). Please inform the Support-team http://jdownloader.org/support.");
        if (downloadLink.getLinkStatus().getErrorMessage() != null) {
            this.logger.warning(downloadLink.getLinkStatus().getErrorMessage());
        }
        try {
            this.logger.finest("" + pluginForHost.getBrowser().getRequest().getHttpConnection());
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
        }
        try {
            this.logger.finest("" + pluginForHost.getBrowser());
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
        }
        downloadLink.getLinkStatus().setErrorMessage(JDL.L("controller.status.pluindefekt", "Plugin out of date"));
        this.downloadLink.requestGuiUpdate();
    }

    public boolean isAborted() {
        return this.aborted;
    }

    private void onDownloadFinishedSuccessFull(DownloadLink downloadLink) {
        if (System.currentTimeMillis() - this.startTime > 30000L) {
            Balloon.showIfHidden((String)JDL.L("ballon.download.successfull.title", "Download"), (ImageIcon)JDTheme.II("gui.images.ok", 32, 32), (String)JDL.LF("ballon.download.successfull.message", "<b>%s<b><hr>finished successfully", String.valueOf(downloadLink.getName()) + " (" + Formatter.formatReadable((long)downloadLink.getDownloadSize()) + ")"));
        }
        downloadLink.setProperty("STATIC_OUTPUTFILE", downloadLink.getFileOutput());
        DownloadController.getInstance().fireDownloadLinkUpdate(downloadLink);
        if (JDUtilities.getController().isContainerFile(new File(downloadLink.getFileOutput())) && JDUtilities.getConfiguration().getBooleanProperty("RELOADCONTAINER", true).booleanValue()) {
            JDUtilities.getController().loadContainerFile(new File(downloadLink.getFileOutput()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onErrorAGBNotSigned(DownloadLink downloadLink, PluginForHost pluginForHost) throws InterruptedException {
        downloadLink.getLinkStatus().setStatusText(JDL.L("controller.status.agb_tos", "TOS haven't been accepted."));
        if (!pluginForHost.isAGBChecked()) {
            Object object = JDUtilities.USERIO_LOCK;
            synchronized (object) {
                if (!pluginForHost.isAGBChecked()) {
                    this.showAGBDialog(downloadLink);
                } else {
                    downloadLink.getLinkStatus().reset();
                }
            }
        } else {
            downloadLink.getLinkStatus().reset();
        }
        DownloadController.getInstance().fireDownloadLinkUpdate(this.downloadLink);
    }

    private void showAGBDialog(final DownloadLink downloadLink) {
        new GuiRunnable<Object>(){

            public Object runSave() {
                AgbDialog.showDialog((DownloadLink)downloadLink);
                return null;
            }
        }.waitForEDT();
    }

    private void onErrorCaptcha(DownloadLink downloadLink, PluginForHost pluginForHost) {
        this.retry(downloadLink, pluginForHost);
    }

    private void retry(DownloadLink downloadLink, PluginForHost pluginForHost) {
        int n;
        if (downloadLink.getLinkStatus().getValue() > 0L) {
            downloadLink.getLinkStatus().setStatusText(null);
        }
        if ((n = downloadLink.getLinkStatus().getRetryCount()) <= pluginForHost.getMaxRetries()) {
            downloadLink.getLinkStatus().reset();
            downloadLink.getLinkStatus().setRetryCount(n + 1);
            downloadLink.getLinkStatus().setErrorMessage(null);
            try {
                pluginForHost.sleep(Math.max((int)downloadLink.getLinkStatus().getValue(), 2000), downloadLink);
            }
            catch (PluginException pluginException) {
                downloadLink.getLinkStatus().setStatusText(null);
                DownloadController.getInstance().fireDownloadLinkUpdate(downloadLink);
                return;
            }
        } else {
            downloadLink.getLinkStatus().addStatus(131072);
        }
        DownloadController.getInstance().fireDownloadLinkUpdate(downloadLink);
    }

    private void onErrorChunkloadFailed(DownloadLink downloadLink, PluginForHost pluginForHost) {
        LinkStatus linkStatus = downloadLink.getLinkStatus();
        if (linkStatus.getErrorMessage() == null) {
            linkStatus.setErrorMessage(JDL.L("plugins.error.downloadfailed", "Download failed"));
        }
        if (linkStatus.getValue() != 0x8000000L) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            this.retry(downloadLink, pluginForHost);
        }
    }

    private void onErrorFatal(DownloadLink downloadLink, PluginForHost pluginForHost) {
        downloadLink.requestGuiUpdate();
    }

    private void onErrorFileExists(DownloadLink downloadLink, PluginForHost pluginForHost) {
        LinkStatus linkStatus = downloadLink.getLinkStatus();
        Object[] objectArray = new String[]{JDL.L("system.download.triggerfileexists.overwrite", "Datei \u00fcberschreiben"), JDL.L("system.download.triggerfileexists.skip", "Link \u00fcberspringen"), JDL.L("system.download.triggerfileexists.rename", "Auto rename")};
        String string = JDL.L("jd.controlling.SingleDownloadController.askexists.title", "File exists");
        String string2 = JDL.LF("jd.controlling.SingleDownloadController.askexists", "The file \r\n%s\r\n already exists. What do you want to do?", downloadLink.getFileOutput());
        int n = SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("FILE_EXISTS", 1);
        if (n == 4) {
            n = UserIO.getInstance().requestComboDialog(4, string, string2, objectArray, 0, null, null, null, null);
        }
        if (n == 3) {
            if (downloadLink.getFilePackage().getIntegerProperty("DO_WHEN_EXISTS", -1) > 0) {
                n = downloadLink.getFilePackage().getIntegerProperty("DO_WHEN_EXISTS", -1);
                int n2 = UserIO.getCountdownTime();
                try {
                    UserIO.setCountdownTime((int)10);
                    n = UserIO.getInstance().requestComboDialog(0, string, string2, objectArray, n, null, null, null, null);
                    downloadLink.getFilePackage().setProperty("DO_WHEN_EXISTS", n);
                }
                finally {
                    UserIO.setCountdownTime((int)n2);
                }
            } else {
                n = UserIO.getInstance().requestComboDialog(0, string, string2, objectArray, 0, null, null, null, null);
                downloadLink.getFilePackage().setProperty("DO_WHEN_EXISTS", n);
            }
        }
        switch (n) {
            case 1: {
                linkStatus.setErrorMessage(JDL.L("controller.status.fileexists.skip", "File already exists."));
                downloadLink.setEnabled(false);
                break;
            }
            case 2: {
                linkStatus.reset();
                File file = new File(downloadLink.getFileOutput());
                String string3 = file.getName();
                String string4 = JDIO.getFileExtension((File)file);
                String string5 = string3.substring(0, string3.length() - string4.length() - 1);
                int n3 = 2;
                try {
                    String[] stringArray = new Regex(string5, "(.*)_(\\d+)").getRow(0);
                    n3 = Integer.parseInt(stringArray[1]) + 1;
                    downloadLink.setFinalFileName(String.valueOf(string5) + "_" + n3 + "." + string4);
                    while (new File(downloadLink.getFileOutput()).exists()) {
                        downloadLink.setFinalFileName(String.valueOf(string5) + "_" + ++n3 + "." + string4);
                    }
                }
                catch (Exception exception) {
                    n3 = 2;
                    downloadLink.setFinalFileName(String.valueOf(string5) + "_" + n3 + "." + string4);
                }
                break;
            }
            default: {
                if (new File(downloadLink.getFileOutput()).delete()) {
                    linkStatus.reset();
                    break;
                }
                linkStatus.addStatus(131072);
                linkStatus.setErrorMessage(String.valueOf(JDL.L("controller.status.fileexists.overwritefailed", "\u00dcberschreiben fehlgeschlagen ")) + downloadLink.getFileOutput());
            }
        }
        DownloadController.getInstance().fireDownloadLinkUpdate(downloadLink);
    }

    private void onErrorFileNotFound(DownloadLink downloadLink, PluginForHost pluginForHost) {
        this.logger.severe("File not found :" + downloadLink.getDownloadURL());
        downloadLink.setEnabled(false);
    }

    private void onErrorIncomplete(DownloadLink downloadLink, PluginForHost pluginForHost) {
        this.retry(downloadLink, pluginForHost);
    }

    private void onErrorNoConnection(DownloadLink downloadLink, PluginForHost pluginForHost) {
        LinkStatus linkStatus = downloadLink.getLinkStatus();
        this.logger.severe("Error occurred: No Server connection");
        long l = SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty(WAIT_TIME_ON_CONNECTION_LOSS, 300) * 1000;
        linkStatus.addStatus(2048);
        linkStatus.setWaitTime(l);
        if (linkStatus.getErrorMessage() == null) {
            linkStatus.setErrorMessage(JDL.L("controller.status.connectionproblems", "Connection lost."));
        }
    }

    private void onErrorPremium(DownloadLink downloadLink, PluginForHost pluginForHost) {
        LinkStatus linkStatus = downloadLink.getLinkStatus();
        linkStatus.reset();
    }

    private void onErrorLocalIO(DownloadLink downloadLink, PluginForHost pluginForHost) {
        LinkStatus linkStatus = downloadLink.getLinkStatus();
        linkStatus.setWaitTime(1800000L);
        downloadLink.setEnabled(false);
    }

    private void onErrorDownloadTemporarilyUnavailable(DownloadLink downloadLink, PluginForHost pluginForHost) {
        this.logger.warning("Error occurred: Temporarily unavailably: PLease wait " + downloadLink.getLinkStatus().getValue() + " ms for a retry");
        LinkStatus linkStatus = downloadLink.getLinkStatus();
        if (linkStatus.getErrorMessage() == null) {
            linkStatus.setErrorMessage(JDL.L("controller.status.tempUnavailable", "kurzzeitig nicht verf\u00fcgbar"));
        }
        if (linkStatus.getValue() > 0L) {
            linkStatus.setWaitTime(linkStatus.getValue());
        } else if (linkStatus.getValue() == 0L) {
            linkStatus.setWaitTime(1800000L);
        } else {
            linkStatus.resetWaitTime();
            downloadLink.setEnabled(false);
        }
        DownloadController.getInstance().fireDownloadLinkUpdate(downloadLink);
    }

    private void onErrorHostTemporarilyUnavailable(DownloadLink downloadLink, PluginForHost pluginForHost) {
        LinkStatus linkStatus = downloadLink.getLinkStatus();
        long l = downloadLink.getLinkStatus().getValue();
        if (l <= 0L) {
            this.logger.severe(JDL.L("plugins.errors.pluginerror", "Plugin error. Please inform Support"));
            l = 3600000L;
        }
        this.logger.warning("Error occurred: Download from this host is currently not possble: PLease wait " + l + " ms for a retry");
        linkStatus.setWaitTime(l);
        DownloadWatchDog.getInstance().setTempUnavailWaittime(pluginForHost.getHost(), l);
        DownloadController.getInstance().fireDownloadLinkUpdate(downloadLink);
    }

    private void onErrorIPWaittime(DownloadLink downloadLink, PluginForHost pluginForHost) {
        LinkStatus linkStatus = downloadLink.getLinkStatus();
        long l = downloadLink.getLinkStatus().getValue();
        if (l <= 0L) {
            this.logger.severe(JDL.L("plugins.errors.pluginerror", "Plugin error. Please inform Support"));
            l = 3600000L;
        }
        linkStatus.setWaitTime(l);
        DownloadWatchDog.getInstance().setIPBlockWaittime(pluginForHost.getHost(), l);
        DownloadController.getInstance().fireDownloadLinkUpdate(downloadLink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            PluginForHost pluginForHost;
            this.linkStatus.setStatusText(null);
            this.linkStatus.setErrorMessage(null);
            this.linkStatus.resetWaitTime();
            this.logger.info("Start working on " + this.downloadLink.getName());
            this.currentPlugin = pluginForHost = this.downloadLink.getPlugin();
            this.fireControlEvent(new ControlEvent(this.currentPlugin, 5, this));
            if (this.downloadLink.getDownloadURL() == null) {
                this.downloadLink.getLinkStatus().setStatusText(JDL.L("controller.status.containererror", "Container Error"));
                this.downloadLink.getLinkStatus().setErrorMessage(JDL.L("controller.status.containererror", "Container Error"));
                this.downloadLink.setEnabled(false);
                this.fireControlEvent(new ControlEvent(this.currentPlugin, 4, this));
                return;
            }
            Object object = DUPELOCK;
            synchronized (object) {
                if (DownloadInterface.preDownloadCheckFailed(this.downloadLink)) {
                    this.onErrorLinkBlock(this.downloadLink, this.currentPlugin);
                    this.fireControlEvent(new ControlEvent(this.currentPlugin, 4, this));
                    return;
                }
                this.linkStatus.setInProgress(true);
            }
            this.handlePlugin();
            this.fireControlEvent(new ControlEvent(this.currentPlugin, 4, this));
            pluginForHost.clean();
            this.downloadLink.requestGuiUpdate();
            return;
        }
        finally {
            this.linkStatus.setInProgress(false);
            this.linkStatus.setActive(false);
        }
    }
}

