/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import jd.config.ConfigEntry;
import jd.config.Configuration;
import jd.config.Property;
import jd.controlling.JDLogger;
import jd.controlling.ProgressController;
import jd.controlling.reconnect.ReconnectMethod;
import jd.nutils.OSDetector;
import jd.parser.Regex;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

public class ExternReconnect
extends ReconnectMethod {
    private Configuration configuration = JDUtilities.getConfiguration();
    private static final String PROPERTY_RECONNECT_COMMAND = "InteractionExternReconnect_Command";
    private static final String PROPERTY_RECONNECT_PARAMETER = "EXTERN_RECONNECT__PARAMETER";
    private static final String PROPERTY_IP_WAIT_FOR_RETURN = "WAIT_FOR_RETURN5";
    private static final String PROPERTY_RECONNECT_DUMMYBAT = "PROPERTY_RECONNECT_DUMMYBAT";

    protected void initConfig() {
        this.config.addEntry(new ConfigEntry(7, (Property)this.configuration, PROPERTY_RECONNECT_COMMAND, JDL.L("interaction.externreconnect.command", "Befehl (absolute Pfade verwenden)")));
        this.config.addEntry(new ConfigEntry(10, (Property)this.configuration, PROPERTY_RECONNECT_PARAMETER, JDL.L("interaction.externreconnect.parameter", "Parameter (1 Parameter/Zeile)")));
        if (OSDetector.isWindows()) {
            this.config.addEntry(new ConfigEntry(3, (Property)this.configuration, PROPERTY_RECONNECT_DUMMYBAT, JDL.L("interaction.externreconnect.dummybat", "Use special executer for windows")).setDefaultValue(true));
        }
    }

    protected boolean runCommands(ProgressController progressController) {
        int n = this.configuration.getIntegerProperty(PROPERTY_IP_WAIT_FOR_RETURN, 0);
        String string = this.configuration.getStringProperty(PROPERTY_RECONNECT_COMMAND, "").trim();
        if (string.length() == 0) {
            return false;
        }
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        String string2 = file.getAbsolutePath();
        String string3 = string2.substring(0, string2.indexOf(file.getName()) - 1).trim();
        if (OSDetector.isWindows() && this.configuration.getBooleanProperty(PROPERTY_RECONNECT_DUMMYBAT, true).booleanValue()) {
            File file2 = this.getDummyBat();
            if (file2 == null) {
                return false;
            }
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
                if (string3.contains(" ")) {
                    bufferedWriter.write("cd \"" + string3 + "\"\r\n");
                } else {
                    bufferedWriter.write("cd " + string3 + "\r\n");
                }
                String string4 = this.configuration.getStringProperty(PROPERTY_RECONNECT_PARAMETER);
                String[] stringArray = Regex.getLines(string4);
                StringBuilder stringBuilder = new StringBuilder(" ");
                String[] stringArray2 = stringArray;
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String string5 = stringArray2[n3];
                    stringBuilder.append(string5);
                    stringBuilder.append(" ");
                    ++n3;
                }
                if (string3.contains(" ")) {
                    bufferedWriter.write("\"" + string + "\"" + stringBuilder.toString() + " >nul 2>nul");
                } else {
                    bufferedWriter.write(String.valueOf(string) + " " + stringBuilder.toString() + ">nul 2>nul");
                }
                bufferedWriter.close();
            }
            catch (Exception exception) {
                JDLogger.exception(exception);
                return false;
            }
            logger.finer("Execute Returns: " + JDUtilities.runCommand(file2.toString(), new String[0], string3, n));
        } else {
            String string6 = this.configuration.getStringProperty(PROPERTY_RECONNECT_PARAMETER);
            logger.finer("Execute Returns: " + JDUtilities.runCommand(string, Regex.getLines(string6), string3, n));
        }
        return true;
    }

    private File getDummyBat() {
        int n = 0;
        while (true) {
            if (n == 100) {
                logger.severe("Cannot create dummy Bat file, please delete all recon_*.bat files in tmp folder!");
                return null;
            }
            File file = JDUtilities.getResourceFile("tmp/recon_" + n + ".bat", true);
            if (file.exists()) {
                if (file.delete()) {
                    return file;
                }
            } else {
                return file;
            }
            file.deleteOnExit();
            ++n;
        }
    }
}

