/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect;

import java.util.logging.Logger;
import jd.config.ConfigContainer;
import jd.config.SubConfiguration;
import jd.controlling.JDLogger;
import jd.controlling.ProgressController;
import jd.controlling.reconnect.Reconnecter;
import jd.gui.UserIF;
import jd.nrouter.IPCheck;
import jd.nutils.IPAddress;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

public abstract class ReconnectMethod {
    protected static Logger logger = JDLogger.getLogger();
    public static final String PARAM_RECONNECT_TYPE = "RECONNECT_TYPE";
    public static final int LIVEHEADER = 0;
    public static final int EXTERN = 1;
    public static final int BATCH = 2;
    public static final int CLR = 3;
    public static final String PARAM_IPCHECKWAITTIME = "RECONNECT_IPCHECKWAITTIME2";
    public static final String PARAM_RETRIES = "RECONNECT_RETRIES2";
    public static final String PARAM_WAITFORIPCHANGE = "RECONNECT_WAITFORIPCHANGE2";
    protected ConfigContainer config = null;

    protected ReconnectMethod() {
    }

    public final boolean doReconnect() {
        if (SubConfiguration.getConfig("DOWNLOAD").getBooleanProperty("GLOBAL_IP_DISABLE2", false).booleanValue()) {
            this.doReconnectInteral(1);
            Reconnecter.setCurrentIP("na");
            return true;
        }
        int n = JDUtilities.getConfiguration().getIntegerProperty(PARAM_RETRIES, 5);
        boolean bl = false;
        int n2 = 0;
        if (n <= -1) {
            while (!(bl = this.doReconnectInteral(++n2))) {
            }
        } else {
            n2 = 0;
            while (n2 <= n) {
                bl = this.doReconnectInteral(n2 + 1);
                if (bl) break;
                ++n2;
            }
        }
        return bl;
    }

    private String getIP() {
        if (SubConfiguration.getConfig("DOWNLOAD").getBooleanProperty("GLOBAL_IP_DISABLE2", false).booleanValue()) {
            return "na";
        }
        return IPCheck.getIPAddress();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean doReconnectInteral(int n) {
        ProgressController progressController = new ProgressController(this.toString(), 10L);
        progressController.setStatusText(String.valueOf(JDL.L("reconnect.progress.1_retries", "Reconnect #")) + n);
        try {
            int n2 = JDUtilities.getConfiguration().getIntegerProperty(PARAM_IPCHECKWAITTIME, 5);
            int n3 = JDUtilities.getConfiguration().getIntegerProperty(PARAM_WAITFORIPCHANGE, 30);
            logger.info("Starting " + this.toString() + " #" + n);
            String string = this.getIP();
            progressController.increase(1L);
            progressController.setStatusText(String.valueOf(JDL.L("reconnect.progress.2_oldIP", "Reconnect Old IP:")) + string);
            if (!this.runCommands(progressController)) {
                progressController.doFinalize();
                logger.severe("An error occured while processing the reconnect ... Terminating");
                return false;
            }
            logger.finer("Initial Waittime: " + n2 + " seconds");
            try {
                Thread.sleep(n2 * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            String string2 = this.getIP();
            progressController.setStatusText(JDL.LF("reconnect.progress.3_ipcheck", "Reconnect New IP: %s / %s", string2, string));
            long l = System.currentTimeMillis() + (long)(n3 * 1000);
            logger.info("Wait " + n3 + " sec for new ip");
            while (System.currentTimeMillis() <= l && (string2.equals(string) || string2.equals("na"))) {
                logger.finer("IP before: " + string + " after: " + string2);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                string2 = this.getIP();
                progressController.setStatusText(JDL.LF("reconnect.progress.3_ipcheck", "Reconnect New IP: %s / %s", string2, string));
            }
            if (SubConfiguration.getConfig("DOWNLOAD").getBooleanProperty("GLOBAL_IP_DISABLE2", false).booleanValue()) {
                Reconnecter.setCurrentIP("na");
                return true;
            }
            logger.finer("IP before: " + string + " after: " + string2);
            if (string2.equals("na") && !string2.equals(string)) {
                logger.warning("JD could disconnect your router, but could not connect afterwards. Try to rise the option 'Wait until first IP Check'");
                l = System.currentTimeMillis() + 120000L;
                while (System.currentTimeMillis() <= l && (string2.equals(string) || string2.equals("na"))) {
                    logger.finer("IP before: " + string + " after: " + string2);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    string2 = this.getIP();
                    progressController.setStatusText(JDL.LF("reconnect.progress.3_ipcheck", "Reconnect New IP: %s / %s", string, string2));
                }
            }
            if (string2.equals(string) || string2.equals("na")) return false;
            logger.finer("IP before: " + string + " after: " + string2);
            if (!IPAddress.validateIP((String)string2)) {
                logger.warning("IP " + string2 + " was filtered by mask: " + SubConfiguration.getConfig("DOWNLOAD").getStringProperty("PARAM_GLOBAL_IP_MASK2", "\\b(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?).){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b"));
                UserIF.getInstance().displayMiniWarning(JDL.L("reconnect.ipfiltered.warning.title", "Wrong IP!"), JDL.LF("reconnect.ipfiltered.warning.short", "Die IP %s wurde als nicht erlaubt identifiziert", string2));
                Reconnecter.setCurrentIP("na");
                return false;
            }
            progressController.doFinalize();
            Reconnecter.setCurrentIP(string2);
            return true;
        }
        finally {
            progressController.doFinalize();
        }
    }

    protected abstract boolean runCommands(ProgressController var1);

    protected abstract void initConfig();

    public final ConfigContainer getConfig() {
        if (this.config == null) {
            this.config = new ConfigContainer();
            this.initConfig();
        }
        return this.config;
    }
}

