/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect;

import java.awt.Color;
import java.util.ArrayList;
import java.util.logging.Logger;
import jd.config.SubConfiguration;
import jd.controlling.DownloadWatchDog;
import jd.controlling.JDLogger;
import jd.controlling.LinkCheck;
import jd.controlling.ProgressController;
import jd.controlling.reconnect.BatchReconnect;
import jd.controlling.reconnect.ExternReconnect;
import jd.controlling.reconnect.HTTPLiveHeader;
import jd.event.ControlEvent;
import jd.gui.UserIF;
import jd.gui.UserIO;
import jd.nrouter.IPCheck;
import jd.nutils.Formatter;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

public class Reconnecter {
    private static String CURRENT_IP = "";
    private static boolean RECONNECT_IN_PROGRESS = false;
    private static long LAST_UP_UPDATE_TIME = 0L;
    private static Logger logger = JDLogger.getLogger();
    private static boolean RECONNECT_REQUESTED = false;

    public static void toggleReconnect() {
        boolean bl = JDUtilities.getConfiguration().getBooleanProperty("ALLOW_RECONNECT", true) == false;
        JDUtilities.getConfiguration().setProperty("ALLOW_RECONNECT", bl);
        JDUtilities.getConfiguration().save();
        if (!bl) {
            UserIF.getInstance().displayMiniWarning(JDL.L("gui.warning.reconnect.hasbeendisabled", "Reconnect deaktiviert!"), JDL.L("gui.warning.reconnect.hasbeendisabled.tooltip", "Um erfolgreich einen Reconnect durchf\u00fchren zu k\u00f6nnen muss diese Funktion wieder aktiviert werden."));
        }
    }

    public static void setCurrentIP(String string) {
        if (string == null) {
            string = "na";
        }
        CURRENT_IP = string;
        LAST_UP_UPDATE_TIME = System.currentTimeMillis();
    }

    private static boolean checkExternalIPChange() {
        if (SubConfiguration.getConfig("DOWNLOAD").getBooleanProperty("GLOBAL_IP_DISABLE2", false).booleanValue()) {
            return false;
        }
        LAST_UP_UPDATE_TIME = System.currentTimeMillis();
        String string = CURRENT_IP;
        CURRENT_IP = IPCheck.getIPAddress();
        if (string == null) {
            string = CURRENT_IP;
        }
        if (!CURRENT_IP.equals("na") && string.length() > 0 && !string.equals(CURRENT_IP)) {
            logger.info("Detected external IP Change.");
            return true;
        }
        return false;
    }

    public static boolean doReconnect() {
        boolean bl = false;
        if (System.currentTimeMillis() - LAST_UP_UPDATE_TIME > (long)(60000 * SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("EXTERNAL_IP_CHECK_INTERVAL2", 10)) && Reconnecter.checkExternalIPChange()) {
            return true;
        }
        JDUtilities.getController().fireControlEvent(new ControlEvent(JDUtilities.getController(), 2, null));
        int n = JDUtilities.getConfiguration().getIntegerProperty("RECONNECT_TYPE", 0);
        logger.info("Try to reconnect...");
        ArrayList<DownloadLink> arrayList = DownloadWatchDog.getInstance().getRunningDownloads();
        if (arrayList.size() != 0) {
            logger.info("Stopping all running downloads!");
        }
        for (DownloadLink downloadLink : arrayList) {
            downloadLink.setEnabled(false);
        }
        int n2 = 0;
        while (n2 < 10) {
            if (DownloadWatchDog.getInstance().getActiveDownloads() == 0) break;
            try {
                Thread.sleep(1000L);
                logger.info("Still waiting for all downloads to stop!");
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            ++n2;
        }
        if (DownloadWatchDog.getInstance().getActiveDownloads() > 0) {
            logger.severe("Could not stop all running downloads!");
        }
        try {
            switch (n) {
                case 1: {
                    bl = new ExternReconnect().doReconnect();
                    break;
                }
                case 2: {
                    bl = new BatchReconnect().doReconnect();
                    break;
                }
                default: {
                    bl = new HTTPLiveHeader().doReconnect();
                    break;
                }
            }
        }
        catch (Exception exception) {
            logger.severe("ReconnectMethod failed!");
        }
        for (DownloadLink downloadLink : arrayList) {
            downloadLink.setEnabled(true);
        }
        return bl;
    }

    public static boolean isReconnecting() {
        return RECONNECT_IN_PROGRESS;
    }

    public static boolean isReconnectPrefered() {
        return Reconnecter.isReconnectRequested() && JDUtilities.getConfiguration().getBooleanProperty("ALLOW_RECONNECT", true) != false && SubConfiguration.getConfig("DOWNLOAD").getBooleanProperty("PARAM_DOWNLOAD_PREFER_RECONNECT", true) != false;
    }

    public static boolean doReconnectIfRequested(boolean bl) {
        if (RECONNECT_IN_PROGRESS) {
            return false;
        }
        if (LinkCheck.getLinkChecker().isRunning()) {
            return false;
        }
        if (JDUtilities.getController().getForbiddenReconnectDownloadNum() > 0) {
            return false;
        }
        RECONNECT_IN_PROGRESS = true;
        boolean bl2 = false;
        try {
            bl2 = Reconnecter.doReconnectIfRequestedInternal(bl);
            if (bl2) {
                Reconnecter.resetAllLinks();
                JDUtilities.getController().fireControlEvent(new ControlEvent(JDUtilities.getController(), 3, null));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        RECONNECT_IN_PROGRESS = false;
        return bl2;
    }

    public static boolean doReconnectIfRequestedInternal(boolean bl) {
        boolean bl2 = false;
        if (Reconnecter.isReconnectRequested()) {
            if (!bl && !JDUtilities.getConfiguration().getBooleanProperty("ALLOW_RECONNECT", true).booleanValue()) {
                if (System.currentTimeMillis() - LAST_UP_UPDATE_TIME > (long)(60000 * SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("EXTERNAL_IP_CHECK_INTERVAL2", 10))) {
                    return Reconnecter.checkExternalIPChange();
                }
                return false;
            }
            try {
                bl2 = Reconnecter.doReconnect();
                if (bl2) {
                    logger.info("Reconnect successfully!");
                } else {
                    logger.info("Reconnect failed!");
                }
            }
            catch (Exception exception) {
                logger.finest("Reconnect failed.");
            }
            if (!bl2) {
                ProgressController progressController = new ProgressController(JDL.L("jd.controlling.reconnect.Reconnector.progress.failed", "Reconnect failed! Please check your reconnect Settings and try a Manual Reconnect!"), 100L);
                progressController.doFinalize(10000L);
                int n = JDUtilities.getConfiguration().getIntegerProperty("RECONNECT_FAILED_COUNTER", 0) + 1;
                JDUtilities.getConfiguration().setProperty("RECONNECT_FAILED_COUNTER", n);
                if (n > 5) {
                    JDUtilities.getConfiguration().setProperty("PARAM_RECONNECT_OKAY", false);
                    JDUtilities.getConfiguration().setProperty("ALLOW_RECONNECT", false);
                    UserIO.getInstance().requestMessageDialog(JDL.L("jd.controlling.reconnect.Reconnector.progress.failed2", "Reconnect failed too often! Autoreconnect is disabled! Please check your reconnect Settings!"));
                    JDUtilities.getConfiguration().setProperty("RECONNECT_FAILED_COUNTER", 0);
                }
                JDUtilities.getConfiguration().save();
            } else {
                JDUtilities.getConfiguration().setProperty("RECONNECT_FAILED_COUNTER", 0);
                JDUtilities.getConfiguration().setProperty("PARAM_RECONNECT_OKAY", true);
                JDUtilities.getConfiguration().save();
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resetAllLinks() {
        ArrayList<FilePackage> arrayList = JDUtilities.getController().getPackages();
        DownloadWatchDog.getInstance().resetIPBlockWaittime(null);
        ArrayList<FilePackage> arrayList2 = arrayList;
        synchronized (arrayList2) {
            for (FilePackage filePackage : arrayList) {
                for (DownloadLink downloadLink : filePackage.getDownloadLinkList()) {
                    if (downloadLink.getPlugin() == null || !downloadLink.getLinkStatus().hasStatus(16)) continue;
                    downloadLink.getLinkStatus().setStatus(1);
                    downloadLink.getLinkStatus().resetWaitTime();
                }
            }
        }
    }

    public static boolean waitForNewIP(long l, boolean bl) {
        boolean bl2;
        if (!JDUtilities.getConfiguration().getBooleanProperty("ALLOW_RECONNECT", true).booleanValue() && !bl) {
            return false;
        }
        Reconnecter.setReconnectRequested(true);
        final ProgressController progressController = new ProgressController(JDL.LF("gui.reconnect.progress.status", "Reconnect running: %s m:s", "0:00s"), 2L);
        if (l > 0L) {
            l += System.currentTimeMillis();
        }
        progressController.setStatus(1L);
        final long l2 = System.currentTimeMillis();
        Thread thread = new Thread(){

            public void run() {
                while (true) {
                    progressController.setStatusText(JDL.LF("gui.reconnect.progress.status2", "Reconnect running: %s", Formatter.formatSeconds((long)((System.currentTimeMillis() - l2) / 1000L))));
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }
        };
        thread.start();
        while (!((bl2 = Reconnecter.doReconnectIfRequested(true)) || System.currentTimeMillis() >= l && l > 0L)) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                bl2 = false;
                break;
            }
        }
        thread.interrupt();
        if (!bl2) {
            progressController.setColor(Color.RED);
            progressController.setStatusText(JDL.L("gui.reconnect.progress.status.failed", "Reconnect failed"));
        } else {
            progressController.setStatusText(JDL.L("gui.reconnect.progress.status.success", "Reconnect successfull"));
        }
        Reconnecter.setReconnectRequested(false);
        progressController.doFinalize(4000L);
        return bl2;
    }

    public static boolean doManualReconnect() {
        boolean bl = DownloadWatchDog.getInstance().stopDownloads();
        boolean bl2 = Reconnecter.waitForNewIP(1L, true);
        if (bl) {
            DownloadWatchDog.getInstance().startDownloads();
        }
        return bl2;
    }

    public static void setReconnectRequested(boolean bl) {
        RECONNECT_REQUESTED = bl;
    }

    public static boolean isReconnectRequested() {
        return RECONNECT_REQUESTED;
    }
}

