/*
 * Decompiled with CFR 0.152.
 */
package jd.event;

import java.util.EventListener;
import java.util.Vector;
import jd.controlling.JDLogger;
import jd.event.JDEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JDBroadcaster<T extends EventListener, TT extends JDEvent> {
    protected transient Vector<T> callList = new Vector();
    protected transient Vector<T> removeList = new Vector();

    public void addListener(T t) {
        if (this.removeList.contains(t)) {
            this.removeList.remove(t);
        }
        if (!this.callList.contains(t)) {
            this.callList.add(t);
        }
    }

    public boolean hasListener() {
        return this.callList.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fireEvent(TT TT) {
        Vector<T> vector = this.removeList;
        synchronized (vector) {
            this.callList.removeAll(this.removeList);
            this.removeList.clear();
        }
        int n = this.callList.size() - 1;
        while (n >= 0) {
            try {
                this.fireEvent((EventListener)this.callList.get(n), TT);
            }
            catch (Exception exception) {
                JDLogger.exception(exception);
            }
            --n;
        }
        return false;
    }

    protected abstract void fireEvent(T var1, TT var2);

    public void removeListener(T t) {
        if (!this.removeList.contains(t)) {
            this.removeList.add(t);
        }
    }

    public Vector<T> getListener() {
        return this.callList;
    }

    public void addAllListener(Vector<T> vector) {
        for (EventListener eventListener : vector) {
            this.addListener(eventListener);
        }
    }
}

