/*
 * Decompiled with CFR 0.152.
 */
package jd.nrouter;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.controlling.JDLogger;
import jd.nutils.Executer;
import jd.nutils.OSDetector;
import jd.nutils.Threader;
import jd.nutils.jobber.JDRunnable;
import jd.parser.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouterUtils {
    public static final ArrayList<String> HOST_NAMES = new ArrayList();
    private static InetAddress ADDRESS_CACHE;
    private static InetAddress ASYNCH_RETURN;

    static {
        HOST_NAMES.add("fritz.fonwlan.box");
        HOST_NAMES.add("speedport.ip");
        HOST_NAMES.add("fritz.box");
        HOST_NAMES.add("dsldevice.lan");
        HOST_NAMES.add("speedtouch.lan");
        HOST_NAMES.add("mygateway1.ar7");
        HOST_NAMES.add("fritz.fon.box");
        HOST_NAMES.add("home");
        HOST_NAMES.add("arcor.easybox");
        HOST_NAMES.add("fritz.slwlan.box");
        HOST_NAMES.add("eumex.ip");
        HOST_NAMES.add("easy.box");
        HOST_NAMES.add("my.router");
        HOST_NAMES.add("fritz.fon");
        HOST_NAMES.add("router");
        HOST_NAMES.add("mygateway.ar7");
        HOST_NAMES.add("login.router");
        HOST_NAMES.add("SX541");
        HOST_NAMES.add("SE515.home");
        HOST_NAMES.add("sinus.ip");
        HOST_NAMES.add("fritz.wlan.box");
        HOST_NAMES.add("my.siemens");
        HOST_NAMES.add("local.gateway");
        HOST_NAMES.add("congstar.box");
        HOST_NAMES.add("login.modem");
        HOST_NAMES.add("homegate.homenet.telecomitalia.it");
        HOST_NAMES.add("SE551");
        HOST_NAMES.add("home.gateway");
        HOST_NAMES.add("alice.box");
        HOST_NAMES.add("www.brntech.com.tw");
        HOST_NAMES.add("buffalo.setup");
        HOST_NAMES.add("vood.lan");
        HOST_NAMES.add("DD-WRT");
        HOST_NAMES.add("versatel.modem");
        HOST_NAMES.add("myrouter.home");
        HOST_NAMES.add("MyDslModem.local.lan");
        HOST_NAMES.add("alicebox");
        HOST_NAMES.add("HSIB.home");
        HOST_NAMES.add("AolynkDslRouter.local.lan");
        HOST_NAMES.add("SL2141I.home");
        HOST_NAMES.add("e.home");
        HOST_NAMES.add("dsldevice.domain.name");
        HOST_NAMES.add("192.168.1.1");
        HOST_NAMES.add("192.168.2.1");
        HOST_NAMES.add("192.168.0.1");
        HOST_NAMES.add("192.168.178.1");
        HOST_NAMES.add("192.168.1.254");
        HOST_NAMES.add("10.0.0.138");
        HOST_NAMES.add("10.0.0.2");
        HOST_NAMES.add("192.168.123.254");
        HOST_NAMES.add("192.168.1.2");
        HOST_NAMES.add("192.168.0.254");
        HOST_NAMES.add("10.0.0.1");
        HOST_NAMES.add("192.168.10.1");
        HOST_NAMES.add("192.168.220.1");
        HOST_NAMES.add("192.168.254.254");
        HOST_NAMES.add("192.168.0.2");
        HOST_NAMES.add("192.168.100.1");
        HOST_NAMES.add("192.168.1.100");
        HOST_NAMES.add("10.1.1.1");
        HOST_NAMES.add("192.168.0.100");
        HOST_NAMES.add("192.168.3.1");
        HOST_NAMES.add("192.168.5.1");
        HOST_NAMES.add("192.168.2.2");
        HOST_NAMES.add("192.168.11.1");
        HOST_NAMES.add("192.168.1.10");
        HOST_NAMES.add("192.168.0.10");
        HOST_NAMES.add("192.168.0.253");
        HOST_NAMES.add("192.168.7.1");
        HOST_NAMES.add("192.168.182.1");
        HOST_NAMES.add("192.168.2.254");
        HOST_NAMES.add("192.168.178.2");
        HOST_NAMES.add("192.168.15.1");
        HOST_NAMES.add("192.168.1.5");
        HOST_NAMES.add("192.168.0.3");
        HOST_NAMES.add("192.168.123.1");
        HOST_NAMES.add("192.168.1.253");
        HOST_NAMES.add("192.168.0.99");
        HOST_NAMES.add("172.16.0.1");
        HOST_NAMES.add("192.168.4.1");
    }

    public static boolean validateIP(String string) {
        Pattern pattern = Pattern.compile("\\b(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b");
        if (pattern.matcher(string).matches()) {
            return true;
        }
        try {
            if (InetAddress.getByName(string).isReachable(1500)) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            JDLogger.exception(unknownHostException);
        }
        catch (IOException iOException) {
            JDLogger.exception(iOException);
        }
        return false;
    }

    public static ArrayList<InetAddress> getNetworkDeviceAdresses() {
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            block2: while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue block2;
                    if (!inetAddress.getHostAddress().matches("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}")) continue;
                    arrayList.add(inetAddress);
                }
            }
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
        }
        return arrayList;
    }

    public static boolean checkport(String string, int n) {
        try {
            Socket socket = new Socket(string, n);
            socket.setSoTimeout(200);
            return true;
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static synchronized InetAddress getAddress(boolean bl) {
        if (!bl && ADDRESS_CACHE != null) {
            return ADDRESS_CACHE;
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = RouterUtils.getIPFormNetStat();
            if (inetAddress != null) {
                InetAddress inetAddress2 = inetAddress;
                return inetAddress2;
            }
            inetAddress = RouterUtils.getIPFromRouteCommand();
            if (inetAddress != null) {
                InetAddress inetAddress3 = inetAddress;
                return inetAddress3;
            }
            InetAddress inetAddress4 = inetAddress = RouterUtils.getIpFormHostTable();
            return inetAddress4;
        }
        finally {
            ADDRESS_CACHE = inetAddress;
        }
    }

    private static void updateHostTable() {
        for (InetAddress inetAddress : RouterUtils.getNetworkDeviceAdresses()) {
            try {
                String string;
                if (RouterUtils.validateIP(String.valueOf(inetAddress.getHostAddress())) && (string = inetAddress.getHostAddress()) != null && string.lastIndexOf(".") != -1) {
                    String string2 = String.valueOf(string.substring(0, string.lastIndexOf("."))) + ".";
                    int n = 0;
                    while (n < 255) {
                        String string3 = String.valueOf(string2) + n;
                        if (!string3.equals(string) && !HOST_NAMES.contains(string3)) {
                            HOST_NAMES.add(string3);
                        }
                        ++n;
                    }
                }
                HOST_NAMES.remove(inetAddress.getHostName());
                HOST_NAMES.remove(inetAddress.getAddress());
            }
            catch (Exception exception) {
                JDLogger.exception(exception);
            }
        }
    }

    public static InetAddress getIpFormHostTable() {
        RouterUtils.updateHostTable();
        ASYNCH_RETURN = null;
        int n = HOST_NAMES.size();
        Threader threader = new Threader();
        int n2 = 0;
        while (n2 < n) {
            threader.add((JDRunnable)new WebServerChecker(HOST_NAMES.get(n2)));
            ++n2;
        }
        threader.getBroadcaster().addListener((Object)new Threader.WorkerListener(threader){

            public void onThreadException(Threader threader, JDRunnable jDRunnable, Exception exception) {
            }

            public void onThreadFinished(Threader threader, JDRunnable jDRunnable) {
                if (((WebServerChecker)jDRunnable).getAddress() != null) {
                    threader.interrupt();
                    ASYNCH_RETURN = ((WebServerChecker)jDRunnable).getAddress();
                }
            }

            public void onThreadStarts(Threader threader, JDRunnable jDRunnable) {
            }
        });
        threader.startAndWait();
        return ASYNCH_RETURN;
    }

    public static InetAddress getIPFromRouteCommand() {
        if (new File("/sbin/route").exists()) {
            try {
                if (OSDetector.isMac()) {
                    Executer executer = new Executer("/sbin/route");
                    executer.addParameters(new String[]{"-n", "get", "default"});
                    executer.setRunin("/");
                    executer.setWaitTimeout(1000);
                    executer.start();
                    executer.waitTimeout();
                    String string = String.valueOf(executer.getOutputStream()) + " \r\n " + executer.getErrorStream();
                    Pattern pattern = Pattern.compile("gateway: (\\S*)", 2);
                    Matcher matcher = pattern.matcher(string);
                    while (matcher.find()) {
                        String string2 = matcher.group(1).trim();
                        if (string2.matches("[\\s]*\\*[\\s]*")) continue;
                        try {
                            InetAddress inetAddress = InetAddress.getByName(string2);
                            if (!inetAddress.isReachable(1500) || !RouterUtils.checkport(string2, 80)) continue;
                            return inetAddress;
                        }
                        catch (UnknownHostException unknownHostException) {
                            JDLogger.exception(unknownHostException);
                        }
                        catch (IOException iOException) {
                            JDLogger.exception(iOException);
                        }
                    }
                } else {
                    Executer executer = new Executer("/sbin/route");
                    executer.addParameters(new String[]{"-n", "get", "default"});
                    executer.setRunin("/");
                    executer.setWaitTimeout(1000);
                    executer.start();
                    executer.waitTimeout();
                    String string = String.valueOf(executer.getOutputStream()) + " \r\n " + executer.getErrorStream();
                    string = string.replaceFirst(".*\n.*", "");
                    Pattern pattern = Pattern.compile(".{16}(.{16}).*", 2);
                    Matcher matcher = pattern.matcher(string);
                    while (matcher.find()) {
                        String string3 = matcher.group(1).trim();
                        if (string3.matches("[\\s]*\\*[\\s]*")) continue;
                        try {
                            InetAddress inetAddress = InetAddress.getByName(string3);
                            if (!inetAddress.isReachable(1500) || !RouterUtils.checkport(string3, 80)) continue;
                            return inetAddress;
                        }
                        catch (UnknownHostException unknownHostException) {
                            JDLogger.exception(unknownHostException);
                        }
                        catch (IOException iOException) {
                            JDLogger.exception(iOException);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static InetAddress getIPFormNetStat() {
        try {
            String[] stringArray;
            Pattern pattern = Pattern.compile("^\\s*(?:0\\.0\\.0\\.0\\s*){1,2}((?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)).*");
            Executer executer = new Executer("netstat");
            executer.addParameter("-rn");
            executer.setWaitTimeout(5000);
            executer.start();
            executer.waitTimeout();
            String[] stringArray2 = stringArray = Regex.getLines(executer.getOutputStream());
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                InetAddress inetAddress;
                String string = stringArray2[n2];
                String string2 = new Regex(string, pattern).getMatch(0);
                if (string2 != null && (inetAddress = InetAddress.getByName(string2)).isReachable(1500)) {
                    return inetAddress;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
        }
        return null;
    }

    static class WebServerChecker
    implements JDRunnable {
        private String host;
        private InetAddress address = null;

        public InetAddress getAddress() {
            return this.address;
        }

        public WebServerChecker(String string) {
            this.host = string;
        }

        public void go() throws Exception {
            try {
                InetAddress inetAddress = InetAddress.getByName(this.host);
                if (inetAddress.isReachable(1500) && RouterUtils.checkport(this.host, 80)) {
                    this.address = inetAddress;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

