/*
 * Decompiled with CFR 0.152.
 */
package jd.nrouter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.controlling.JDLogger;
import jd.http.Browser;
import jd.nrouter.IPCheck;
import jd.nrouter.IPCheckProvider;

class WebIPCheck
implements IPCheckProvider {
    private static int maxerror = 5;
    private String url;
    private Pattern pattern;
    private int errorcount = 0;
    private Browser br;

    public WebIPCheck(String string, String string2) {
        this.url = string;
        this.errorcount = 0;
        if (string2 != null) {
            this.pattern = Pattern.compile(string2, 34);
        }
        this.br = new Browser();
        this.br.setConnectTimeout(15000);
        this.br.setReadTimeout(15000);
    }

    public Object getIP() {
        if (this.errorcount > maxerror) {
            this.errorcount = 0;
            return IPCheck.CheckStatus.SEQFAILED;
        }
        try {
            Matcher matcher = this.pattern.matcher(this.br.getPage(this.url));
            if (matcher.find() && matcher.groupCount() > 0) {
                this.errorcount = 0;
                return matcher.group(1);
            }
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
        }
        ++this.errorcount;
        return IPCheck.CheckStatus.FAILED;
    }

    public String getInfo() {
        return this.url;
    }
}

