/*
 * Decompiled with CFR 0.152.
 */
package jd.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.controlling.JDLogger;
import jd.http.Browser;
import jd.http.Cookies;
import jd.nutils.encoding.Encoding;
import jd.parser.Document;
import jd.parser.Regex;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.io.WritableLineReader;
import org.lobobrowser.html.js.Executor;
import org.lobobrowser.html.js.Window;
import org.lobobrowser.html.test.SimpleUserAgentContext;
import org.lobobrowser.js.JavaFunctionObject;
import org.lobobrowser.js.JavaObjectWrapper;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.xml.sax.SAXException;

public final class JavaScript {
    public String javaScript;
    public Browser br;
    private ArrayList<String> executed = new ArrayList();
    private WritableLineReader wis;
    public boolean debug = false;
    private Context cx;
    private Scriptable scope;
    private Document d;

    public JavaScript(Browser browser) {
        this.br = browser;
    }

    public String callFunction(String string) throws SAXException, IOException {
        return this.callFunction(string, null);
    }

    public String callFunction(String string, String[] stringArray) throws SAXException, IOException {
        this.runPage();
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray != null && stringArray.length > 0) {
            stringBuilder.append('\'');
            stringBuilder.append(stringArray[0]);
            stringBuilder.append('\'');
            int n = 1;
            while (n < stringArray.length) {
                stringBuilder.append(new char[]{',', ' ', '\''});
                stringBuilder.append(stringArray[n]);
                stringBuilder.append('\'');
                ++n;
            }
        }
        String string2 = "function f(){ " + this.javaScript + "\nreturn " + string + "(" + stringBuilder.toString() + ")} f()";
        Object object = this.cx.evaluateString(this.scope, string2, "<cmd>", 1, null);
        String string3 = Context.toString((Object)object);
        return string3;
    }

    private String parseJS(String string) {
        return string.replaceAll("document\\.all\\.(.*?)\\.", "document.getElementById('$1').");
    }

    private void runString(String string) throws IOException {
        Matcher matcher;
        string = string.replaceAll("(?is)((?<!<script [^>]{0,100}>\\s{0,30})<!--.*?-->)", "");
        String string2 = this.br.getURL().toString();
        String string3 = "";
        String string4 = "";
        Pattern[] patternArray = new Pattern[]{Pattern.compile("(?s)<[ ]?base[^>]*?href='(.*?)'", 2), Pattern.compile("(?s)<[ ]?base[^>]*?href=\"(.*?)\"", 2), Pattern.compile("(?s)<[ ]?base[^>]*?href=([^'\"][^\\s]*)", 2)};
        Object object = patternArray;
        int n = patternArray.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern pattern = object[n2];
            matcher = pattern.matcher(string);
            if (matcher.find()) {
                string2 = Encoding.htmlDecode((String)matcher.group(1));
                break;
            }
            ++n2;
        }
        if (string2 != null) {
            int n3 = (string2 = string2.replace("http://", "")).lastIndexOf(47);
            string3 = n3 != -1 ? "http://" + string2.substring(0, n3 + 1) : "http://" + string2 + "/";
            n3 = string2.indexOf(47);
            string4 = n3 != -1 ? "http://" + string2.substring(0, n3) : "http://" + string2;
            string2 = "http://" + string2;
        } else {
            string2 = "";
        }
        String[][] stringArray = new Regex(string, "<[ ]?script(.*?)(/>|>(.*?)<[ ]?/script>)").getMatches();
        n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2][0].toLowerCase().contains("javascript")) {
                Pattern[] patternArray2;
                if (stringArray[n2].length == 3 && stringArray[n2][2] != null && stringArray[n2][2].length() > 0 && !this.executed.contains(stringArray[n2][2])) {
                    block16: {
                        try {
                            this.cx.evaluateString(this.scope, this.parseJS(stringArray[n2][2]), "<cmd>", 1, null);
                        }
                        catch (Exception exception) {
                            if (!this.debug) break block16;
                            JDLogger.exception(exception);
                            System.err.println(stringArray[n2][2]);
                        }
                    }
                    String string5 = this.d.getInnerHTML().replaceAll("(?is)((?<!<script [^>]{0,100}>\\s{0,30})<!--.*?-->)", "");
                    this.executed.add(stringArray[n2][2]);
                    this.runString(this.d.getContent());
                    if (!string5.equals(string) && !this.d.getContent().equals(string)) {
                        this.runString(string5);
                        return;
                    }
                }
                Pattern[] patternArray3 = patternArray2 = new Pattern[]{Pattern.compile(".*?src=\"(.*?)\"", 2), Pattern.compile(".*?src='(.*?)'", 2), Pattern.compile(".*?src=([^'\"][^\\s]*)", 2)};
                int n4 = patternArray2.length;
                int n5 = 0;
                while (n5 < n4) {
                    object = patternArray3[n5];
                    matcher = ((Pattern)object).matcher(stringArray[n2][0]);
                    while (matcher.find()) {
                        block17: {
                            String string6 = Encoding.htmlDecode((String)matcher.group(1));
                            if (!(string6.length() > 6 && string6.matches("(?is)https?://.*") || string6.length() <= 0)) {
                                if (string6.length() > 2 && string6.substring(0, 3).equals("www")) {
                                    string6 = "http://" + string6;
                                }
                                string6 = string6.charAt(0) == '/' ? String.valueOf(string4) + string6 : (string6.charAt(0) == '#' ? String.valueOf(string2) + string6 : String.valueOf(string3) + string6);
                            }
                            if (this.executed.contains(string6)) continue;
                            String string7 = this.br.cloneBrowser().getPage(string6);
                            this.executed.add(string6);
                            try {
                                this.cx.evaluateString(this.scope, this.parseJS(string7), "<cmd>", 1, null);
                            }
                            catch (Exception exception) {
                                if (!this.debug) break block17;
                                JDLogger.exception(exception);
                                System.err.println(string6);
                            }
                        }
                        String string8 = this.d.getInnerHTML().replaceAll("(?is)((?<!<script [^>]{0,100}>\\s{0,30})<!--.*?-->)", "");
                        this.runString(this.d.getContent());
                        if (string8.equals(string) || this.d.getContent().equals(string)) continue;
                        this.runString(string8);
                        return;
                    }
                    ++n5;
                }
            }
            ++n2;
        }
    }

    public void runPage() throws SAXException, IOException {
        Object object2;
        if (this.cx != null && this.scope != null) {
            return;
        }
        if (this.br == null) {
            return;
        }
        String string = this.br.toString();
        if (this.debug) {
            Logger.getLogger(JavaFunctionObject.class.getName()).setLevel(Level.WARNING);
        } else {
            Logger.getLogger(JavaFunctionObject.class.getName()).setLevel(Level.OFF);
            Logger.getLogger(Window.class.getName()).setLevel(Level.OFF);
            Logger.getLogger(JavaObjectWrapper.class.getName()).setLevel(Level.OFF);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        SimpleUserAgentContext simpleUserAgentContext = new SimpleUserAgentContext();
        simpleUserAgentContext.setExternalCSSEnabled(false);
        simpleUserAgentContext.setScriptingEnabled(false);
        simpleUserAgentContext.setScriptingOptimizationLevel(9);
        String string2 = this.br.getHost();
        if (string2.matches(".*\\..*\\..*")) {
            string2 = string2.replaceFirst(".*?\\.", "");
        }
        Cookies cookies = this.br.getCookies(string2);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (Object object2 : cookies.getCookies()) {
            if (bl) {
                stringBuilder.append("; ");
            } else {
                bl = true;
            }
            stringBuilder.append(String.valueOf(object2.getKey()) + "=" + object2.getValue());
        }
        simpleUserAgentContext.setCookie(new URL(this.br.getURL()), stringBuilder.toString());
        object2 = new InputStreamReader(byteArrayInputStream);
        this.wis = new WritableLineReader((Reader)object2);
        this.d = new Document((UserAgentContext)simpleUserAgentContext, null, this.wis, this.br.getURL());
        this.d.load();
        this.d.setCookie(stringBuilder.toString());
        this.cx = Executor.createContext((URL)new URL(this.br.getURL()), (UserAgentContext)simpleUserAgentContext);
        this.scope = (Scriptable)this.d.getUserData("cobra.js.scope");
        if (this.scope == null) {
            throw new IllegalStateException("Scriptable (scope) instance was expected to be keyed as UserData to document using cobra.js.scope");
        }
        this.runString(this.br.toString());
    }

    public String getVar(String string) throws SAXException, IOException {
        this.runPage();
        String string2 = (String)this.scope.get(string, this.scope);
        return string2;
    }

    public String runJavaScript() throws SAXException, IOException {
        this.runPage();
        Object object = this.cx.evaluateString(this.scope, this.javaScript, "<cmd>", 1, null);
        String string = Context.toString((Object)object);
        return string;
    }

    public Document getDocment() {
        return this.d;
    }

    public String toString() {
        try {
            this.runPage();
            return this.d.getInnerHTML();
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "Parse Error " + this.d.getInnerHTML();
    }
}

