/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import jd.config.Property;
import jd.config.SubConfiguration;
import jd.controlling.DownloadController;
import jd.controlling.DownloadWatchDog;
import jd.controlling.JDLogger;
import jd.controlling.SingleDownloadController;
import jd.event.JDBroadcaster;
import jd.nutils.JDImage;
import jd.nutils.OSDetector;
import jd.nutils.io.JDIO;
import jd.parser.Regex;
import jd.plugins.DownloadLinkBroadcaster;
import jd.plugins.DownloadLinkEvent;
import jd.plugins.DownloadLinkListener;
import jd.plugins.FilePackage;
import jd.plugins.LinkStatus;
import jd.plugins.Plugin;
import jd.plugins.PluginException;
import jd.plugins.PluginForHost;
import jd.plugins.PluginProgress;
import jd.plugins.PluginsC;
import jd.plugins.TransferStatus;
import jd.plugins.download.DownloadInterface;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadLink
extends Property
implements Serializable,
Comparable<DownloadLink> {
    public static final int LINKTYPE_CONTAINER = 1;
    public static final int LINKTYPE_NORMAL = 0;
    private static transient Logger logger = JDLogger.getLogger();
    private static final long serialVersionUID = 1981079856214268373L;
    public static final String UNKNOWN_FILE_NAME = "unknownFileName.file";
    public static final String STATIC_OUTPUTFILE = "STATIC_OUTPUTFILE";
    private transient AvailableStatus availableStatus = AvailableStatus.UNCHECKED;
    private long[] chunksProgress = null;
    private transient DownloadLinkBroadcaster broadcaster = new DownloadLinkBroadcaster();
    private String container;
    private String containerFile = null;
    private int containerIndex = -1;
    private long downloadCurrent = 0L;
    private transient DownloadInterface downloadInstance;
    private transient SingleDownloadController downloadLinkController;
    private long downloadMax = 0L;
    private String subdirectory = null;
    private String browserurl = null;
    private FilePackage filePackage;
    private String host;
    private boolean isEnabled;
    private boolean isMirror = false;
    private File latestCaptchaFile = null;
    private LinkStatus linkStatus;
    private TransferStatus transferstatus;
    private int linkType = 0;
    private int globalSpeedLimit = -1;
    private String name;
    private transient PluginForHost plugin;
    private transient PluginsC pluginForContainer;
    private String sourcePluginComment = null;
    private ArrayList<String> sourcePluginPasswordList = null;
    private String finalFileName;
    private String urlDownload;
    private String decrypterPassword;
    private String mD5Hash;
    private transient PluginProgress pluginProgress;
    private String sha1Hash;
    private int priority = 0;
    private transient ImageIcon icon = null;
    private long requestTime;
    private String partnum2 = null;
    private long created = -1L;
    private long finishedDate = -1L;
    private ImageIcon customIcon = null;
    private String customIconText = null;

    public DownloadLink(PluginForHost pluginForHost, String string, String string2, String string3, boolean bl) {
        this.setLoadedPlugin(pluginForHost);
        this.priority = 0;
        this.setName(string);
        this.sourcePluginPasswordList = new ArrayList();
        this.downloadMax = 0L;
        this.host = string2 == null ? null : string2.toLowerCase();
        this.isEnabled = bl;
        this.created = System.currentTimeMillis();
        this.finishedDate = -1L;
        this.setUrlDownload(string3);
        if (pluginForHost != null && this.getDownloadURL() != null) {
            try {
                pluginForHost.correctDownloadLink(this);
            }
            catch (Exception exception) {
                JDLogger.exception(exception);
            }
        }
        if (string == null && string3 != null) {
            this.name = Plugin.extractFileNameFromURL(this.getDownloadURL());
        }
    }

    public long getFinishedDate() {
        return this.finishedDate;
    }

    public void setFinishedDate(long l) {
        this.finishedDate = l;
    }

    public long getCreated() {
        return this.created;
    }

    public void setCreated(long l) {
        this.created = l;
    }

    public synchronized JDBroadcaster<DownloadLinkListener, DownloadLinkEvent> getBroadcaster() {
        if (this.broadcaster == null) {
            this.broadcaster = new DownloadLinkBroadcaster();
        }
        return this.broadcaster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadLink addSourcePluginPassword(String string) {
        if (string == null || string.trim().length() == 0) {
            return this;
        }
        ArrayList<String> arrayList = this.sourcePluginPasswordList;
        synchronized (arrayList) {
            if (!this.sourcePluginPasswordList.contains(string)) {
                this.sourcePluginPasswordList.add(string);
            }
            return this;
        }
    }

    public void addSourcePluginPasswords(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            this.addSourcePluginPassword(string);
            ++n2;
        }
    }

    public void addSourcePluginPasswordList(ArrayList<String> arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        int n = 0;
        while (n < arrayList.size()) {
            this.addSourcePluginPassword(arrayList.get(n));
            ++n;
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int n) {
        this.priority = n >= -1 && n < 4 ? n : 0;
    }

    public void setSubdirectory(DownloadLink downloadLink) {
        this.subdirectory = downloadLink.getSubdirectory();
    }

    @Override
    public int compareTo(DownloadLink downloadLink) {
        return this.getDownloadURL().compareTo(downloadLink.getDownloadURL());
    }

    public long[] getChunksProgress() {
        return this.chunksProgress;
    }

    public String getContainer() {
        return this.container;
    }

    public String getContainerFile() {
        if (this.containerFile == null) {
            return null;
        }
        if (new File(this.containerFile).isAbsolute()) {
            this.containerFile = "container/" + new File(this.containerFile).getName();
        }
        return this.containerFile;
    }

    public int getContainerIndex() {
        return this.containerIndex;
    }

    public long getDownloadCurrent() {
        return this.downloadCurrent;
    }

    public DownloadInterface getDownloadInstance() {
        return this.downloadInstance;
    }

    public SingleDownloadController getDownloadLinkController() {
        return this.downloadLinkController;
    }

    public long getDownloadSize() {
        return Math.max(this.getDownloadCurrent(), this.downloadMax);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDownloadSpeed() {
        if (!this.getLinkStatus().hasStatus(1024)) {
            return 0;
        }
        int n = 0;
        Vector<DownloadInterface.Chunk> vector = this.getDownloadInstance().getChunks();
        synchronized (vector) {
            for (DownloadInterface.Chunk chunk : this.getDownloadInstance().getChunks()) {
                if (!chunk.inProgress()) continue;
                n += chunk.getSpeedMeter().getSpeed();
            }
        }
        return n;
    }

    public String getDownloadURL() {
        if (this.linkType == 1) {
            if (this.urlDownload != null) {
                return this.urlDownload;
            }
            if (this.pluginForContainer != null) {
                this.urlDownload = this.pluginForContainer.extractDownloadURL(this);
                if (this.urlDownload == null) {
                    logger.severe(this + " is a containerlink. Container could not be extracted. Is your JD Version up2date?");
                }
                return this.urlDownload;
            }
            logger.severe(this + " is a containerlink, but no plugin could be found");
            return null;
        }
        return this.urlDownload;
    }

    public String getBrowserUrl() {
        if (this.browserurl != null) {
            return this.browserurl;
        }
        return this.getDownloadURL();
    }

    public void setBrowserUrl(String string) {
        this.browserurl = string;
    }

    public boolean gotBrowserUrl() {
        return this.browserurl != null;
    }

    public String getFileInfomationString() {
        return this.getPlugin().getFileInformationString(this);
    }

    public String getFileOutput() {
        return this.getFileOutput0();
    }

    public String getFileOutput0() {
        String string = this.getStringProperty(STATIC_OUTPUTFILE, null);
        if (this.getFilePackage() == FilePackage.getDefaultFilePackage() && string != null && new File(string).exists()) {
            return string;
        }
        if (this.subdirectory != null) {
            if (this.getFilePackage() != null && this.getFilePackage().getDownloadDirectory() != null && this.getFilePackage().getDownloadDirectory().length() > 0) {
                return new File(new File(this.getFilePackage().getDownloadDirectory(), String.valueOf(File.separator) + this.subdirectory), this.getName()).getAbsolutePath();
            }
            return null;
        }
        if (this.getFilePackage() != null && this.getFilePackage().getDownloadDirectory() != null && this.getFilePackage().getDownloadDirectory().length() > 0) {
            return new File(new File(this.getFilePackage().getDownloadDirectory()), this.getName()).getAbsolutePath();
        }
        return null;
    }

    public FilePackage getFilePackage() {
        if (this.filePackage == null) {
            this.setFilePackage(FilePackage.getDefaultFilePackage());
        }
        return this.filePackage;
    }

    public String getHost() {
        if (this.host == null) {
            return null;
        }
        return this.host.toLowerCase();
    }

    public File getLatestCaptchaFile() {
        return this.latestCaptchaFile;
    }

    public LinkStatus getLinkStatus() {
        if (this.linkStatus == null) {
            this.linkStatus = new LinkStatus(this);
        }
        return this.linkStatus;
    }

    public TransferStatus getTransferStatus() {
        if (this.transferstatus == null) {
            this.transferstatus = new TransferStatus();
        }
        return this.transferstatus;
    }

    public int getLinkType() {
        return this.linkType;
    }

    public int getSpeedLimit() {
        if (this.globalSpeedLimit <= 0) {
            this.globalSpeedLimit = Integer.MAX_VALUE;
        }
        return this.globalSpeedLimit;
    }

    public void setSpeedLimit(int n) {
        int n2 = Math.abs(this.globalSpeedLimit - (n = Math.max(20, n)));
        if (n2 > 500) {
            this.globalSpeedLimit = n;
        }
    }

    public String getName() {
        if (this.getFinalFileName() == null) {
            try {
                String string;
                return this.name == null ? ((string = new File(new URL(this.getDownloadURL()).toURI()).getName()) != null ? string : UNKNOWN_FILE_NAME) : this.name;
            }
            catch (Exception exception) {
                return UNKNOWN_FILE_NAME;
            }
        }
        return this.getFinalFileName();
    }

    public PluginForHost getPlugin() {
        return this.plugin;
    }

    public PluginsC getPluginForContainer() {
        return this.pluginForContainer;
    }

    public String getSourcePluginComment() {
        return this.sourcePluginComment;
    }

    public ArrayList<String> getSourcePluginPasswordList() {
        return this.sourcePluginPasswordList;
    }

    public String getFinalFileName() {
        return this.finalFileName;
    }

    public boolean isAborted() {
        if (this.getDownloadLinkController() == null) {
            return false;
        }
        return this.getDownloadLinkController().isAborted();
    }

    public boolean isAvailabilityStatusChecked() {
        return this.availableStatus != AvailableStatus.UNCHECKED;
    }

    public boolean isAvailable() {
        return this.getAvailableStatus() != AvailableStatus.FALSE;
    }

    public AvailableStatus getAvailableStatus() {
        if (this.availableStatus != AvailableStatus.UNCHECKED) {
            return this.availableStatus;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < 5) {
            block13: {
                try {
                    long l = System.currentTimeMillis();
                    this.availableStatus = this.getPlugin().requestFileInformation(this);
                    this.requestTime = System.currentTimeMillis() - l;
                    try {
                        this.getPlugin().getBrowser().getHttpConnection().disconnect();
                    }
                    catch (Exception exception) {
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    this.availableStatus = AvailableStatus.UNCHECKABLE;
                }
                catch (PluginException pluginException) {
                    pluginException.fillLinkStatus(this.getLinkStatus());
                    if (this.getLinkStatus().hasStatus(16) || this.getLinkStatus().hasStatus(4096) || this.getLinkStatus().hasStatus(2048)) {
                        this.availableStatus = AvailableStatus.UNCHECKABLE;
                        break;
                    }
                    this.availableStatus = AvailableStatus.FALSE;
                }
                catch (IOException iOException) {
                    if (!iOException.getMessage().contains("code: 500")) break;
                    try {
                        JDLogger.getLogger().finer("500 Error Code, retrying in " + (n += 500));
                        Thread.sleep(n);
                        break block13;
                    }
                    catch (InterruptedException interruptedException) {
                        this.availableStatus = AvailableStatus.UNCHECKABLE;
                    }
                }
                catch (Exception exception) {
                    this.availableStatus = AvailableStatus.UNCHECKABLE;
                }
                break;
            }
            ++n2;
        }
        if (this.availableStatus == null) {
            this.availableStatus = AvailableStatus.UNCHECKABLE;
        }
        return this.availableStatus;
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public void setRequestTime(long l) {
        this.requestTime = l;
    }

    public void setAvailableStatus(AvailableStatus availableStatus) {
        this.availableStatus = availableStatus;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public static boolean isSpeedLimited() {
        return SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("DOWNLOAD_MAX_SPEED_V2", 0) != 0;
    }

    public boolean isMirror() {
        return this.isMirror;
    }

    public void requestGuiUpdate() {
        DownloadController.getInstance().fireDownloadLinkUpdate(this);
    }

    public void reset() {
        if (this.getLinkStatus().isPluginActive()) {
            this.setAborted(true);
            while (this.getLinkStatus().isPluginActive()) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    JDLogger.exception(interruptedException);
                }
            }
        }
        this.priority = 0;
        this.chunksProgress = null;
        this.downloadLinkController = null;
        this.downloadCurrent = 0L;
        this.finishedDate = -1L;
        this.linkStatus.reset();
        this.availableStatus = AvailableStatus.UNCHECKED;
        this.setEnabled(true);
        this.getTransferStatus().usePremium(false);
        this.getTransferStatus().setResumeSupport(false);
        this.deleteFile(true, true);
        this.finalFileName = null;
        DownloadWatchDog.getInstance().resetIPBlockWaittime(this.getHost());
        DownloadWatchDog.getInstance().resetTempUnavailWaittime(this.getHost());
        if (this.getPlugin() != null) {
            this.getPlugin().resetDownloadlink(this);
        }
    }

    public void deleteFile(boolean bl, boolean bl2) {
        File file;
        int n = 5;
        while (this.getLinkStatus().isPluginActive()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                JDLogger.exception(interruptedException);
            }
            if (--n == 0) break;
        }
        if (bl2 && new File(this.getFileOutput()).exists() && !new File(this.getFileOutput()).delete()) {
            logger.severe(String.valueOf(JDL.L("system.download.errors.couldnotdelete", "Could not delete file")) + this.getFileOutput());
        }
        if (bl && new File(String.valueOf(this.getFileOutput()) + ".part").exists() && !new File(String.valueOf(this.getFileOutput()) + ".part").delete()) {
            logger.severe(String.valueOf(JDL.L("system.download.errors.couldnotdelete", "Could not delete file")) + this.getFileOutput());
        }
        if ((file = new File(this.getFileOutput()).getParentFile()) != null && file.exists() && file.isDirectory() && file.listFiles() != null && file.listFiles().length == 0 && !new File(JDUtilities.getDefaultDownloadDirectory()).equals(file)) {
            file.delete();
        }
    }

    public boolean existsFile() {
        return new File(this.getFileOutput()).exists() || new File(String.valueOf(this.getFileOutput()) + ".part").exists();
    }

    public void setAborted(boolean bl) {
        if (!bl) {
            return;
        }
        if (this.getDownloadLinkController() == null) {
            this.linkStatus.setInProgress(false);
            return;
        }
        this.getDownloadLinkController().abortDownload();
    }

    public void setAvailable(boolean bl) {
        this.availableStatus = bl ? AvailableStatus.TRUE : AvailableStatus.FALSE;
    }

    public void setChunksProgress(long[] lArray) {
        this.chunksProgress = lArray;
    }

    public void setContainerFile(String string) {
        int n = (string = string.replace("\\", "/")).indexOf("/container/");
        if (n > 0) {
            string = string.substring(n + 1);
        }
        this.containerFile = string;
    }

    public void setContainerIndex(int n) {
        this.containerIndex = n;
    }

    public void setDownloadCurrent(long l) {
        this.downloadCurrent = l;
    }

    public void setDownloadInstance(DownloadInterface downloadInterface) {
        this.downloadInstance = downloadInterface;
    }

    public void setDownloadLinkController(SingleDownloadController singleDownloadController) {
        this.downloadLinkController = singleDownloadController;
    }

    public void setDownloadSize(long l) {
        this.downloadMax = l;
    }

    public void addSubdirectory(String string) {
        this.subdirectory = string != null && this.name.length() > 0 ? (this.subdirectory != null ? this.subdirectory + File.separator + JDUtilities.removeEndingPoints(JDIO.validateFileandPathName((String)string)) : JDUtilities.removeEndingPoints(JDIO.validateFileandPathName((String)string))) : null;
    }

    public String getSubdirectory() {
        return this.subdirectory;
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled != bl) {
            if (!bl) {
                this.getBroadcaster().fireEvent(new DownloadLinkEvent(this, 4));
            } else {
                this.getBroadcaster().fireEvent(new DownloadLinkEvent(this, 3));
            }
        }
        this.getLinkStatus().removeStatus(2048);
        this.isEnabled = bl;
        if (!bl) {
            this.setAborted(true);
        } else {
            this.setAborted(false);
        }
        if (bl) {
            this.setAborted(false);
            if (this.host != null && this.plugin == null) {
                logger.severe("Es ist kein passendes HostPlugin geladen");
                return;
            }
            if (this.container != null && this.pluginForContainer == null) {
                logger.severe("Es ist kein passendes ContainerPlugin geladen");
                return;
            }
        }
    }

    public void setFilePackage(FilePackage filePackage) {
        if (filePackage != null && filePackage == this.filePackage) {
            if (!filePackage.contains(this)) {
                filePackage.add(this);
            }
            return;
        }
        if (this.filePackage != null) {
            this.filePackage.remove(this);
        }
        this.filePackage = filePackage;
        if (filePackage != null && !filePackage.contains(this)) {
            filePackage.add(this);
        }
    }

    public void setLatestCaptchaFile(File file) {
        this.latestCaptchaFile = file;
    }

    public void setLinkType(int n) {
        if (n == this.linkType) {
            return;
        }
        if (this.linkType == 1) {
            logger.severe("You are not allowd to Change the Linktype of " + this);
            return;
        }
        this.linkType = n;
    }

    public void setLoadedPlugin(PluginForHost pluginForHost) {
        this.plugin = pluginForHost;
        if (pluginForHost != null) {
            this.getTransferStatus().setPremiumSupport(pluginForHost.isPremiumEnabled());
        }
    }

    public void setLoadedPluginForContainer(PluginsC pluginsC) {
        this.pluginForContainer = pluginsC;
        this.container = pluginsC.getHost();
    }

    public void setMirror(boolean bl) {
        this.isMirror = bl;
    }

    public void setName(String string) {
        if (string != null && string.length() > 0) {
            this.name = JDUtilities.removeEndingPoints(JDIO.validateFileandPathName((String)string));
        }
        this.setIcon(null);
        this.setPart(string);
    }

    private void setPart(String string) {
        if (string == null) {
            this.partnum2 = null;
            return;
        }
        this.partnum2 = new Regex(string, ".*\\.pa?r?t?(\\d+)").getMatch(0);
        if (this.partnum2 == null) {
            this.partnum2 = new Regex(string, ".*\\.r(\\d+)").getMatch(0);
        }
        if (this.partnum2 == null) {
            this.partnum2 = new Regex(string, ".*\\.(\\d+)").getMatch(0);
        }
        if (this.partnum2 == null) {
            this.partnum2 = "";
        }
    }

    public String getPart() {
        if (this.partnum2 == null) {
            this.setPart(this.getName());
        }
        return this.partnum2;
    }

    private void setIcon(ImageIcon imageIcon) {
        this.icon = imageIcon;
    }

    public DownloadLink setSourcePluginComment(String string) {
        this.sourcePluginComment = string;
        return this;
    }

    public DownloadLink setSourcePluginPasswordList(ArrayList<String> arrayList) {
        this.sourcePluginPasswordList = arrayList;
        return this;
    }

    public void setFinalFileName(String string) {
        this.setName(string);
        if (string != null && string.length() > 0) {
            if (new Regex(string, Pattern.compile("r..\\.htm.?$", 2)).matches()) {
                logger.info("Use Workaround for stupid >>rar.html<< uploaders!");
                string = string.substring(0, string.length() - new Regex(string, Pattern.compile("r..(\\.htm.?)$", 2)).getMatch(0).length());
            }
            this.finalFileName = JDUtilities.removeEndingPoints(JDIO.validateFileandPathName((String)string));
        } else {
            this.finalFileName = null;
        }
        this.setPart(this.finalFileName);
    }

    public void setUrlDownload(String string) {
        this.urlDownload = string != null ? string.trim() : null;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public int getPercent() {
        if (Math.min(this.downloadCurrent, this.downloadMax) <= 0L) {
            return 0;
        }
        return (int)(10000L * this.downloadCurrent / Math.max(1L, Math.max(this.downloadCurrent, this.downloadMax)));
    }

    public String getDecrypterPassword() {
        return this.decrypterPassword;
    }

    public void setDecrypterPassword(String string) {
        this.decrypterPassword = string;
    }

    public void setMD5Hash(String string) {
        this.mD5Hash = string;
    }

    public String getMD5Hash() {
        return this.mD5Hash;
    }

    public void setPluginProgress(PluginProgress pluginProgress) {
        this.pluginProgress = pluginProgress;
    }

    public PluginProgress getPluginProgress() {
        return this.pluginProgress;
    }

    public void setSha1Hash(String string) {
        this.sha1Hash = string;
    }

    public String getSha1Hash() {
        return this.sha1Hash;
    }

    public ImageIcon getUnscaledIcon() {
        return JDImage.getFileIcon((String)JDIO.getFileExtension((String)this.getFileOutput()));
    }

    public ImageIcon getIcon() {
        if (this.icon == null) {
            if (OSDetector.isLinux() || OSDetector.isMac()) {
                try {
                    Image image = JDTheme.getImage(String.valueOf(JDTheme.getTheme()) + "/mime/" + JDIO.getFileExtension((String)this.getName()), 16, 16);
                    this.icon = new ImageIcon(image);
                }
                catch (Exception exception) {
                    this.icon = JDTheme.II("gui.images.link", 16, 16);
                }
            } else {
                try {
                    this.icon = JDImage.getScaledImageIcon((ImageIcon)JDImage.getFileIcon((String)JDIO.getFileExtension((String)this.getFileOutput())), (int)16, (int)16);
                }
                catch (Exception exception) {
                    try {
                        Image image = JDTheme.getImage(String.valueOf(JDTheme.getTheme()) + "/mime/" + JDIO.getFileExtension((String)this.getName()), 16, 16);
                        this.icon = new ImageIcon(image);
                    }
                    catch (Exception exception2) {
                        this.icon = JDTheme.II("gui.images.link", 16, 16);
                    }
                }
            }
        }
        return this.icon;
    }

    public static Set<String> getHosterList(ArrayList<DownloadLink> arrayList) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (DownloadLink downloadLink : arrayList) {
            if (hashMap.containsKey(downloadLink.getPlugin().getHost())) continue;
            hashMap.put(downloadLink.getPlugin().getHost(), "");
        }
        return hashMap.keySet();
    }

    public ImageIcon getCustomIcon() {
        return this.customIcon;
    }

    public String getCustomIconText() {
        return this.customIconText;
    }

    public void setCustomIcon(ImageIcon imageIcon, String string) {
        this.customIcon = imageIcon;
        this.customIconText = string;
    }

    public boolean hasCustomIcon() {
        return this.customIcon != null && this.customIconText != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AvailableStatus {
        UNCHECKED,
        FALSE,
        UNCHECKABLE,
        TRUE;

    }
}

