/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import jd.config.Property;
import jd.controlling.DownloadController;
import jd.nutils.io.JDIO;
import jd.plugins.DownloadLink;
import jd.plugins.DownloadLinkEvent;
import jd.plugins.DownloadLinkListener;
import jd.plugins.FilePackageBroadcaster;
import jd.plugins.FilePackageEvent;
import jd.plugins.FilePackageListener;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePackage
extends Property
implements Serializable,
DownloadLinkListener,
FilePackageListener {
    private static int counter = 0;
    private static final long serialVersionUID = -8859842964299890820L;
    private static final long UPDATE_INTERVAL = 2000L;
    private String comment;
    private String downloadDirectory;
    private ArrayList<DownloadLink> downloadLinkList;
    private static transient FilePackage FP = null;
    private String id;
    private boolean sortasc = false;
    private int linksFailed;
    private int linksFinished;
    private int linksInProgress;
    private String name = null;
    private String password2;
    private boolean extractAfterDownload = true;
    private long totalBytesLoaded_v2;
    private long totalDownloadSpeed_v2;
    private long totalEstimatedPackageSize_v2;
    private long updateTime;
    private long updateTime1;
    private boolean isFinished;
    private transient FilePackageBroadcaster broadcaster = new FilePackageBroadcaster();
    private Integer links_Disabled = new Integer(0);
    private String ListHoster = null;
    private long created = -1L;
    private long finishedDate = -1L;
    @Deprecated
    private Vector<DownloadLink> downloadLinks;

    public static synchronized FilePackage getDefaultFilePackage() {
        if (FP == null) {
            FP = new FilePackage();
            FP.setName(JDL.L("controller.packages.defaultname", "various"));
        }
        return FP;
    }

    public void addListener(FilePackageListener filePackageListener) {
        this.broadcaster.addListener(filePackageListener);
    }

    public void removeListener(FilePackageListener filePackageListener) {
        this.broadcaster.removeListener(filePackageListener);
    }

    public static FilePackage getInstance() {
        return new FilePackage();
    }

    public void remove(ArrayList<DownloadLink> arrayList) {
        for (DownloadLink downloadLink : arrayList) {
            this.remove(downloadLink);
        }
    }

    private FilePackage() {
        this.downloadDirectory = JDUtilities.getDefaultDownloadDirectory();
        this.id = String.valueOf(System.currentTimeMillis()) + "_" + ++counter;
        this.downloadLinkList = new ArrayList();
        this.broadcaster = new FilePackageBroadcaster();
        this.broadcaster.addListener(this);
        this.created = System.currentTimeMillis();
        this.finishedDate = -1L;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.links_Disabled = new Integer(0);
        this.broadcaster = new FilePackageBroadcaster();
        this.broadcaster.addListener(this);
    }

    public long getCreated() {
        return this.created;
    }

    public void setCreated(long l) {
        this.created = l;
    }

    public long getFinishedDate() {
        return this.finishedDate;
    }

    public void setFinishedDate(long l) {
        this.finishedDate = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(DownloadLink downloadLink) {
        Object object = DownloadController.ControllerLock;
        synchronized (object) {
            ArrayList<DownloadLink> arrayList = this.downloadLinkList;
            synchronized (arrayList) {
                if (!this.downloadLinkList.contains(downloadLink)) {
                    this.downloadLinkList.add(downloadLink);
                    downloadLink.setFilePackage(this);
                    if (!downloadLink.isEnabled()) {
                        Integer n = this.links_Disabled;
                        synchronized (n) {
                            this.links_Disabled = this.links_Disabled + 1;
                        }
                    }
                    downloadLink.getBroadcaster().addListener(this);
                    this.broadcaster.fireEvent(new FilePackageEvent(this, 2, downloadLink));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(int n, DownloadLink downloadLink, int n2) {
        Object object = DownloadController.ControllerLock;
        synchronized (object) {
            boolean bl = false;
            Serializable serializable = this.downloadLinkList;
            synchronized (serializable) {
                if (this.downloadLinkList.contains(downloadLink)) {
                    int n3 = this.indexOf(downloadLink);
                    if (n3 <= n) {
                        n -= ++n2;
                    }
                    this.downloadLinkList.remove(downloadLink);
                    if (n > this.downloadLinkList.size() - 1) {
                        this.downloadLinkList.add(downloadLink);
                    } else if (n < 0) {
                        this.downloadLinkList.add(0, downloadLink);
                    } else {
                        this.downloadLinkList.add(n, downloadLink);
                    }
                } else {
                    if (n > this.downloadLinkList.size() - 1) {
                        this.downloadLinkList.add(downloadLink);
                    } else if (n < 0) {
                        this.downloadLinkList.add(0, downloadLink);
                    } else {
                        this.downloadLinkList.add(n, downloadLink);
                    }
                    bl = true;
                }
            }
            if (bl) {
                if (!downloadLink.isEnabled()) {
                    serializable = this.links_Disabled;
                    synchronized (serializable) {
                        this.links_Disabled = this.links_Disabled + 1;
                    }
                }
                downloadLink.setFilePackage(this);
                downloadLink.getBroadcaster().addListener(this);
                this.broadcaster.fireEvent(new FilePackageEvent(this, 2, downloadLink));
            } else {
                this.broadcaster.fireEvent(new FilePackageEvent(this, 1));
            }
        }
        return n2;
    }

    public void addLinks(ArrayList<DownloadLink> arrayList) {
        for (DownloadLink downloadLink : arrayList) {
            this.add(downloadLink);
        }
    }

    public boolean isExtractAfterDownload() {
        return this.extractAfterDownload;
    }

    public void setExtractAfterDownload(boolean bl) {
        this.extractAfterDownload = bl;
    }

    public void addLinksAt(ArrayList<DownloadLink> arrayList, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < arrayList.size()) {
            n2 = this.add(n + n3, arrayList.get(n3), n2);
            ++n3;
        }
    }

    public boolean contains(DownloadLink downloadLink) {
        return this.downloadLinkList.contains(downloadLink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadLink get(int n) {
        ArrayList<DownloadLink> arrayList = this.downloadLinkList;
        synchronized (arrayList) {
            try {
                return this.downloadLinkList.get(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
        }
    }

    public String getComment() {
        return this.comment == null ? "" : this.comment;
    }

    public String getDownloadDirectory() {
        return this.downloadDirectory == null ? JDUtilities.getDefaultDownloadDirectory() : this.downloadDirectory;
    }

    public String getDownloadDirectoryName() {
        if (!this.hasDownloadDirectory()) {
            return ".";
        }
        return new File(this.downloadDirectory).getName();
    }

    public ArrayList<DownloadLink> getDownloadLinkList() {
        return this.downloadLinkList;
    }

    @Deprecated
    public Vector<DownloadLink> getDownloadLinks() {
        return this.downloadLinks;
    }

    public long getETA() {
        if (System.currentTimeMillis() - this.updateTime > 2000L) {
            this.updateCollectives();
        }
        if (this.totalDownloadSpeed_v2 / 1024L == 0L) {
            return -1L;
        }
        return (Math.max(this.totalBytesLoaded_v2, this.totalEstimatedPackageSize_v2) - this.totalBytesLoaded_v2) / this.totalDownloadSpeed_v2;
    }

    public String getId() {
        return this.id;
    }

    public int getLinksFailed() {
        if (System.currentTimeMillis() - this.updateTime > 2000L) {
            this.updateCollectives();
        }
        return this.linksFailed;
    }

    public int getLinksFinished() {
        if (System.currentTimeMillis() - this.updateTime > 2000L) {
            this.updateCollectives();
        }
        return this.linksFinished;
    }

    public int getLinksInProgress() {
        if (System.currentTimeMillis() - this.updateTime > 2000L) {
            this.updateCollectives();
        }
        return this.linksInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinished() {
        if (System.currentTimeMillis() - this.updateTime1 > 2000L) {
            this.updateTime1 = System.currentTimeMillis();
            boolean bl = true;
            long l = 0L;
            if (this.linksFinished > 0) {
                ArrayList<DownloadLink> arrayList = this.downloadLinkList;
                synchronized (arrayList) {
                    for (DownloadLink downloadLink : this.downloadLinkList) {
                        if (!downloadLink.getLinkStatus().hasStatus(2) && downloadLink.isEnabled()) {
                            bl = false;
                            break;
                        }
                        if (downloadLink.getFinishedDate() == -1L) continue;
                        long l2 = l = l >= downloadLink.getFinishedDate() ? l : downloadLink.getFinishedDate();
                    }
                }
            } else {
                bl = false;
            }
            this.isFinished = bl;
            if (!this.isFinished) {
                this.finishedDate = -1L;
            } else if (this.isFinished && this.finishedDate == -1L) {
                this.finishedDate = l;
            }
        }
        return this.isFinished;
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public String getPassword() {
        return this.password2 == null ? "" : this.password2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getPasswordAuto() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<DownloadLink> arrayList2 = this.downloadLinkList;
        synchronized (arrayList2) {
            for (DownloadLink downloadLink : this.downloadLinkList) {
                if (downloadLink.getSourcePluginPasswordList() == null) continue;
                for (String string : downloadLink.getSourcePluginPasswordList()) {
                    if (arrayList.contains(string)) continue;
                    arrayList.add(string);
                }
            }
        }
        return arrayList;
    }

    public double getPercent() {
        if (System.currentTimeMillis() - this.updateTime > 2000L) {
            this.updateCollectives();
        }
        return 100.0 * (double)this.totalBytesLoaded_v2 / (double)Math.max(1L, Math.max(this.totalBytesLoaded_v2, this.totalEstimatedPackageSize_v2));
    }

    public int getRemainingLinks() {
        this.updateCollectives();
        return this.size() - this.linksFinished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadLink getSFV() {
        ArrayList<DownloadLink> arrayList = this.downloadLinkList;
        synchronized (arrayList) {
            for (DownloadLink downloadLink : this.downloadLinkList) {
                if (!downloadLink.getFileOutput().toLowerCase().endsWith(".sfv")) continue;
                return downloadLink;
            }
        }
        return null;
    }

    public long getTotalDownloadSpeed() {
        if (System.currentTimeMillis() - this.updateTime > 2000L) {
            this.updateCollectives();
        }
        return this.totalDownloadSpeed_v2;
    }

    public long getTotalEstimatedPackageSize() {
        if (System.currentTimeMillis() - this.updateTime > 2000L) {
            this.updateCollectives();
        }
        return Math.max(this.totalBytesLoaded_v2, this.totalEstimatedPackageSize_v2);
    }

    public long getTotalKBLoaded() {
        if (System.currentTimeMillis() - this.updateTime > 2000L) {
            this.updateCollectives();
        }
        return this.totalBytesLoaded_v2;
    }

    public boolean hasDownloadDirectory() {
        return this.downloadDirectory != null && this.downloadDirectory.length() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(DownloadLink downloadLink) {
        ArrayList<DownloadLink> arrayList = this.downloadLinkList;
        synchronized (arrayList) {
            return this.downloadLinkList.indexOf(downloadLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(DownloadLink downloadLink) {
        if (downloadLink == null) {
            return;
        }
        Object object = DownloadController.ControllerLock;
        synchronized (object) {
            ArrayList<DownloadLink> arrayList = this.downloadLinkList;
            synchronized (arrayList) {
                boolean bl = this.downloadLinkList.remove(downloadLink);
                if (bl) {
                    if (!downloadLink.isEnabled()) {
                        Integer n = this.links_Disabled;
                        synchronized (n) {
                            this.links_Disabled = this.links_Disabled - 1;
                        }
                    }
                    downloadLink.getBroadcaster().removeListener(this);
                    downloadLink.setFilePackage(null);
                    this.broadcaster.fireEvent(new FilePackageEvent(this, 3, downloadLink));
                    if (this.downloadLinkList.size() == 0) {
                        this.broadcaster.fireEvent(new FilePackageEvent(this, 999));
                    }
                }
            }
        }
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setDownloadDirectory(String string) {
        this.downloadDirectory = JDUtilities.removeEndingPoints(string);
    }

    public void setName(String string) {
        this.name = string == null || string.length() == 0 ? JDUtilities.removeEndingPoints(FilePackage.getDefaultFilePackage().name) : JDUtilities.removeEndingPoints(JDIO.validateFileandPathName((String)string));
    }

    public void setPassword(String string) {
        this.password2 = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ArrayList<DownloadLink> arrayList = this.downloadLinkList;
        synchronized (arrayList) {
            return this.downloadLinkList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortDownload() {
        ArrayList<DownloadLink> arrayList = this.downloadLinkList;
        synchronized (arrayList) {
            for (DownloadLink downloadLink : this.downloadLinkList) {
                downloadLink.setAborted(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<DownloadLink> getLinksListbyStatus(int n) {
        ArrayList<DownloadLink> arrayList = new ArrayList<DownloadLink>();
        ArrayList<DownloadLink> arrayList2 = this.downloadLinkList;
        synchronized (arrayList2) {
            for (DownloadLink downloadLink : this.downloadLinkList) {
                if (!downloadLink.getLinkStatus().hasStatus(n)) continue;
                arrayList.add(downloadLink);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHoster() {
        if (this.ListHoster == null) {
            HashSet<String> hashSet = new HashSet<String>();
            ArrayList<DownloadLink> arrayList = this.downloadLinkList;
            synchronized (arrayList) {
                for (DownloadLink downloadLink : this.downloadLinkList) {
                    hashSet.add(downloadLink.getHost());
                }
            }
            this.ListHoster = ((Object)hashSet).toString();
        }
        return this.ListHoster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(final int n) {
        this.sortasc = !this.sortasc;
        ArrayList<DownloadLink> arrayList = this.downloadLinkList;
        synchronized (arrayList) {
            Collections.sort(this.downloadLinkList, new Comparator<DownloadLink>(){

                @Override
                public int compare(DownloadLink downloadLink, DownloadLink downloadLink2) {
                    if (downloadLink.getName().endsWith(".sfv")) {
                        return -1;
                    }
                    if (downloadLink2.getName().endsWith(".sfv")) {
                        return 1;
                    }
                    DownloadLink downloadLink3 = downloadLink2;
                    DownloadLink downloadLink4 = downloadLink;
                    if (FilePackage.this.sortasc) {
                        downloadLink3 = downloadLink;
                        downloadLink4 = downloadLink2;
                    }
                    switch (n) {
                        case 0: {
                            return downloadLink3.getName().compareToIgnoreCase(downloadLink4.getName());
                        }
                        case 1: {
                            return downloadLink3.getHost().compareToIgnoreCase(downloadLink4.getHost());
                        }
                        case 2: {
                            if (downloadLink3.isAvailabilityStatusChecked() && downloadLink4.isAvailabilityStatusChecked()) {
                                return downloadLink3.isAvailable() && !downloadLink4.isAvailable() ? 1 : -1;
                            }
                            return -1;
                        }
                        case 3: {
                            return downloadLink3.getPercent() < downloadLink4.getPercent() ? 1 : -1;
                        }
                    }
                    return -1;
                }
            });
        }
        this.broadcaster.fireEvent(new FilePackageEvent(this, 1));
    }

    @Override
    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCollectives() {
        ArrayList<DownloadLink> arrayList = this.downloadLinkList;
        synchronized (arrayList) {
            this.totalEstimatedPackageSize_v2 = 0L;
            this.totalDownloadSpeed_v2 = 0L;
            this.linksFinished = 0;
            this.linksInProgress = 0;
            this.linksFailed = 0;
            this.totalBytesLoaded_v2 = 0L;
            long l = 0L;
            int n = 0;
            Iterator<DownloadLink> iterator = this.downloadLinkList.iterator();
            while (iterator.hasNext()) {
                DownloadLink downloadLink = iterator.next();
                if (downloadLink.getDownloadSize() > 0L) {
                    if (downloadLink.isEnabled()) {
                        this.totalEstimatedPackageSize_v2 += downloadLink.getDownloadSize();
                    }
                    l = ((long)n * l + downloadLink.getDownloadSize()) / (long)(n + 1);
                    ++n;
                } else if (iterator.hasNext()) {
                    if (downloadLink.isEnabled()) {
                        this.totalEstimatedPackageSize_v2 += l;
                    }
                } else if (downloadLink.isEnabled()) {
                    this.totalEstimatedPackageSize_v2 += l / 2L;
                }
                this.totalDownloadSpeed_v2 += (long)downloadLink.getDownloadSpeed();
                if (downloadLink.isEnabled()) {
                    this.totalBytesLoaded_v2 += downloadLink.getDownloadCurrent();
                }
                this.linksInProgress += downloadLink.getLinkStatus().isPluginActive() ? 1 : 0;
                if (downloadLink.getLinkStatus().isFinished()) {
                    ++this.linksFinished;
                }
                if (!downloadLink.getLinkStatus().isFailed() || !downloadLink.isEnabled()) continue;
                ++this.linksFailed;
            }
        }
        this.updateTime = System.currentTimeMillis();
    }

    public int getLinksDisabled() {
        return this.links_Disabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        ArrayList<DownloadLink> arrayList = this.downloadLinkList;
        synchronized (arrayList) {
            block4: {
                if (this.downloadLinkList.size() > this.getLinksDisabled()) break block4;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update_linksDisabled() {
        Integer n = this.links_Disabled;
        synchronized (n) {
            this.links_Disabled = 0;
            ArrayList<DownloadLink> arrayList = this.downloadLinkList;
            synchronized (arrayList) {
                for (DownloadLink downloadLink : this.downloadLinkList) {
                    if (downloadLink.isEnabled()) continue;
                    this.links_Disabled = this.links_Disabled + 1;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDownloadLinkEvent(DownloadLinkEvent downloadLinkEvent) {
        switch (downloadLinkEvent.getID()) {
            case 4: {
                Integer n = this.links_Disabled;
                synchronized (n) {
                    this.links_Disabled = this.links_Disabled + 1;
                }
                this.broadcaster.fireEvent(new FilePackageEvent(this, 1));
                break;
            }
            case 3: {
                Integer n = this.links_Disabled;
                synchronized (n) {
                    this.links_Disabled = this.links_Disabled - 1;
                }
                this.broadcaster.fireEvent(new FilePackageEvent(this, 1));
            }
        }
    }

    @Override
    public void onFilePackageEvent(FilePackageEvent filePackageEvent) {
        switch (filePackageEvent.getID()) {
            case 2: 
            case 3: {
                this.ListHoster = null;
                this.getHoster();
            }
        }
    }

    public void convert() {
        this.downloadLinkList = new ArrayList();
        this.downloadLinkList.addAll(this.getDownloadLinks());
        this.downloadLinks = null;
    }
}

