/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ImageIcon;
import jd.OptionalPluginWrapper;
import jd.config.Property;
import jd.controlling.LinkGrabberController;
import jd.nutils.io.JDIO;
import jd.plugins.DownloadLink;
import jd.plugins.LinkGrabberFilePackageBroadcaster;
import jd.plugins.LinkGrabberFilePackageEvent;
import jd.plugins.LinkGrabberFilePackageListener;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkGrabberFilePackage
extends Property
implements LinkGrabberFilePackageListener {
    private static final long serialVersionUID = 5865820033205069205L;
    private String downloadDirectory;
    private ArrayList<DownloadLink> downloadLinks = new ArrayList();
    private String name = "";
    private boolean extractAfterDownload = true;
    private boolean useSubDir = true;
    private String comment = "";
    private String password = "";
    private long size = -1L;
    private long lastSizeCalc = 0L;
    private int lastfail = 0;
    private long lastFailCount = 0L;
    private String hosts;
    private boolean ignorePackage = false;
    private transient LinkGrabberFilePackageBroadcaster broadcaster = new LinkGrabberFilePackageBroadcaster();
    private long lastEnabledCount = 0L;
    private int lastenabled = 0;
    private ImageIcon customIcon = null;
    private String customIconText = null;

    public boolean isIgnored() {
        return this.ignorePackage;
    }

    public void setIgnore(boolean bl) {
        this.ignorePackage = bl;
    }

    public LinkGrabberFilePackage() {
        this.downloadDirectory = JDUtilities.getDefaultDownloadDirectory();
        this.name = JDUtilities.removeEndingPoints(JDL.L("controller.packages.defaultname", "various"));
        this.useSubDir = JDUtilities.getConfiguration().getBooleanProperty("USE_PACKETNAME_AS_SUBFOLDER", false);
        OptionalPluginWrapper optionalPluginWrapper = JDUtilities.getOptionalPlugin("unrar");
        if (optionalPluginWrapper != null && optionalPluginWrapper.isEnabled()) {
            this.extractAfterDownload = optionalPluginWrapper.getPluginConfig().getBooleanProperty("ACTIVATED", true);
        }
        this.broadcaster = new LinkGrabberFilePackageBroadcaster();
        this.broadcaster.addListener(this);
    }

    public LinkGrabberFilePackage(String string, LinkGrabberFilePackageListener linkGrabberFilePackageListener) {
        this(string);
        this.broadcaster.addListener(linkGrabberFilePackageListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getDownloadSize(boolean bl) {
        if (!bl && System.currentTimeMillis() - this.lastSizeCalc < 5000L) {
            return this.size;
        }
        long l = 0L;
        ArrayList<DownloadLink> arrayList = this.downloadLinks;
        synchronized (arrayList) {
            for (DownloadLink downloadLink : this.downloadLinks) {
                l += downloadLink.getDownloadSize();
            }
        }
        this.lastSizeCalc = System.currentTimeMillis();
        this.size = l;
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int countFailedLinks(boolean bl) {
        if (!bl && System.currentTimeMillis() - this.lastFailCount < 5000L) {
            return this.lastfail;
        }
        int n = 0;
        ArrayList<DownloadLink> arrayList = this.downloadLinks;
        synchronized (arrayList) {
            for (DownloadLink downloadLink : this.downloadLinks) {
                if (!downloadLink.isAvailabilityStatusChecked() || downloadLink.isAvailable()) continue;
                ++n;
            }
        }
        this.lastFailCount = System.currentTimeMillis();
        this.lastfail = n;
        return this.lastfail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int countEnabledLinks(boolean bl) {
        if (!bl && System.currentTimeMillis() - this.lastEnabledCount < 5000L) {
            return this.lastenabled;
        }
        int n = 0;
        ArrayList<DownloadLink> arrayList = this.downloadLinks;
        synchronized (arrayList) {
            for (DownloadLink downloadLink : this.downloadLinks) {
                if (!downloadLink.isEnabled()) continue;
                ++n;
            }
        }
        this.lastEnabledCount = System.currentTimeMillis();
        this.lastenabled = n;
        return this.lastenabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keepHostersOnly(Set<String> set) {
        ArrayList<DownloadLink> arrayList = new ArrayList<DownloadLink>();
        ArrayList<DownloadLink> arrayList2 = this.downloadLinks;
        synchronized (arrayList2) {
            for (DownloadLink downloadLink : this.downloadLinks) {
                if (set.contains(downloadLink.getPlugin().getHost())) continue;
                arrayList.add(downloadLink);
            }
        }
        this.remove(arrayList);
        this.countFailedLinks(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(DownloadLink downloadLink) {
        ArrayList<DownloadLink> arrayList = this.downloadLinks;
        synchronized (arrayList) {
            return this.downloadLinks.indexOf(downloadLink);
        }
    }

    public String getDownloadDirectory() {
        return this.downloadDirectory;
    }

    public void setUseSubDir(boolean bl) {
        this.useSubDir = bl;
    }

    public boolean useSubDir() {
        return this.useSubDir;
    }

    public void setDownloadDirectory(String string) {
        this.downloadDirectory = JDUtilities.removeEndingPoints(string);
    }

    public LinkGrabberFilePackage(String string) {
        this();
        this.setName(string);
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(DownloadLink downloadLink) {
        if (downloadLink == null) {
            return;
        }
        Object object = LinkGrabberController.ControllerLock;
        synchronized (object) {
            ArrayList<DownloadLink> arrayList = this.downloadLinks;
            synchronized (arrayList) {
                if (!this.downloadLinks.contains(downloadLink)) {
                    LinkGrabberFilePackage linkGrabberFilePackage = LinkGrabberController.getInstance().getFPwithLink(downloadLink);
                    this.downloadLinks.add(downloadLink);
                    this.broadcaster.fireEvent(new LinkGrabberFilePackageEvent(this, 2, downloadLink));
                    if (linkGrabberFilePackage != null && linkGrabberFilePackage != this) {
                        linkGrabberFilePackage.remove(downloadLink);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOffline() {
        ArrayList<DownloadLink> arrayList = new ArrayList<DownloadLink>();
        ArrayList<DownloadLink> arrayList2 = this.downloadLinks;
        synchronized (arrayList2) {
            for (DownloadLink downloadLink : this.downloadLinks) {
                if (!downloadLink.isAvailabilityStatusChecked() || downloadLink.isAvailable()) continue;
                arrayList.add(downloadLink);
            }
        }
        this.remove(arrayList);
        this.countFailedLinks(true);
    }

    public void remove(ArrayList<DownloadLink> arrayList) {
        for (DownloadLink downloadLink : arrayList) {
            this.remove(downloadLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(int n, DownloadLink downloadLink, int n2) {
        if (downloadLink == null) {
            return n2;
        }
        Object object = LinkGrabberController.ControllerLock;
        synchronized (object) {
            ArrayList<DownloadLink> arrayList = this.downloadLinks;
            synchronized (arrayList) {
                boolean bl = false;
                LinkGrabberFilePackage linkGrabberFilePackage = null;
                if (this.downloadLinks.contains(downloadLink)) {
                    int n3 = this.indexOf(downloadLink);
                    if (n3 < n) {
                        n -= ++n2;
                    }
                    this.downloadLinks.remove(downloadLink);
                    if (n > this.downloadLinks.size() - 1) {
                        this.downloadLinks.add(downloadLink);
                    } else if (n < 0) {
                        this.downloadLinks.add(0, downloadLink);
                    } else {
                        this.downloadLinks.add(n, downloadLink);
                    }
                } else {
                    linkGrabberFilePackage = LinkGrabberController.getInstance().getFPwithLink(downloadLink);
                    if (n > this.downloadLinks.size() - 1) {
                        this.downloadLinks.add(downloadLink);
                    } else if (n < 0) {
                        this.downloadLinks.add(0, downloadLink);
                    } else {
                        this.downloadLinks.add(n, downloadLink);
                    }
                    bl = true;
                }
                if (bl) {
                    this.broadcaster.fireEvent(new LinkGrabberFilePackageEvent(this, 2, downloadLink));
                    if (linkGrabberFilePackage != null && linkGrabberFilePackage != this) {
                        linkGrabberFilePackage.remove(downloadLink);
                    }
                } else {
                    this.broadcaster.fireEvent(new LinkGrabberFilePackageEvent(this, 1));
                }
            }
        }
        return n2;
    }

    public void addAll(ArrayList<DownloadLink> arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            this.add(arrayList.get(n));
            ++n;
        }
    }

    public boolean isExtractAfterDownload() {
        return this.extractAfterDownload;
    }

    public void setExtractAfterDownload(boolean bl) {
        this.extractAfterDownload = bl;
    }

    public void addAllAt(ArrayList<DownloadLink> arrayList, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < arrayList.size()) {
            n2 = this.add(n + n3, arrayList.get(n3), n2);
            ++n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(DownloadLink downloadLink) {
        ArrayList<DownloadLink> arrayList = this.downloadLinks;
        synchronized (arrayList) {
            return this.downloadLinks.contains(downloadLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadLink get(int n) {
        ArrayList<DownloadLink> arrayList = this.downloadLinks;
        synchronized (arrayList) {
            try {
                return this.downloadLinks.get(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
        }
    }

    public ArrayList<DownloadLink> getDownloadLinks() {
        return this.downloadLinks;
    }

    public String getPassword() {
        return this.password != null ? this.password : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getPasswordAuto() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<DownloadLink> arrayList2 = this.downloadLinks;
        synchronized (arrayList2) {
            for (DownloadLink downloadLink : this.downloadLinks) {
                if (downloadLink.getSourcePluginPasswordList() == null) continue;
                for (String string : downloadLink.getSourcePluginPasswordList()) {
                    if (arrayList.contains(string)) continue;
                    arrayList.add(string);
                }
            }
        }
        return arrayList;
    }

    public String getComment() {
        return this.comment != null ? this.comment : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(DownloadLink downloadLink) {
        if (downloadLink == null) {
            return false;
        }
        Object object = LinkGrabberController.ControllerLock;
        synchronized (object) {
            ArrayList<DownloadLink> arrayList = this.downloadLinks;
            synchronized (arrayList) {
                boolean bl = this.downloadLinks.remove(downloadLink);
                if (bl) {
                    this.broadcaster.fireEvent(new LinkGrabberFilePackageEvent(this, 3, downloadLink));
                }
                if (this.downloadLinks.size() == 0) {
                    this.broadcaster.fireEvent(new LinkGrabberFilePackageEvent(this, 999));
                }
                return bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadLink remove(int n) {
        Object object = LinkGrabberController.ControllerLock;
        synchronized (object) {
            ArrayList<DownloadLink> arrayList = this.downloadLinks;
            synchronized (arrayList) {
                DownloadLink downloadLink;
                try {
                    downloadLink = this.downloadLinks.remove(n);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    downloadLink = null;
                }
                if (downloadLink != null) {
                    this.downloadLinks.remove(downloadLink);
                }
                if (downloadLink != null) {
                    this.broadcaster.fireEvent(new LinkGrabberFilePackageEvent(this, 3, downloadLink));
                }
                if (this.downloadLinks.size() == 0) {
                    this.broadcaster.fireEvent(new LinkGrabberFilePackageEvent(this, 999));
                }
                return downloadLink;
            }
        }
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void clear() {
        this.setDownloadLinks(new ArrayList<DownloadLink>());
    }

    public boolean isEmpty() {
        return this.getDownloadLinks().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDownloadLinks(ArrayList<DownloadLink> arrayList) {
        Object object = LinkGrabberController.ControllerLock;
        synchronized (object) {
            ArrayList<DownloadLink> arrayList2 = arrayList;
            synchronized (arrayList2) {
                this.downloadLinks = new ArrayList<DownloadLink>(arrayList);
                this.broadcaster.fireEvent(new LinkGrabberFilePackageEvent(this, 1));
                if (arrayList.size() == 0) {
                    this.broadcaster.fireEvent(new LinkGrabberFilePackageEvent(this, 999));
                }
            }
        }
    }

    public void setName(String string) {
        this.name = string == null || string.length() == 0 ? JDUtilities.removeEndingPoints(JDL.L("controller.packages.defaultname", "various")) : JDUtilities.removeEndingPoints(JDIO.validateFileandPathName((String)string));
    }

    public void setPassword(String string) {
        this.password = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ArrayList<DownloadLink> arrayList = this.downloadLinks;
        synchronized (arrayList) {
            return this.downloadLinks.size();
        }
    }

    public void addListener(LinkGrabberFilePackageListener linkGrabberFilePackageListener) {
        this.broadcaster.addListener(linkGrabberFilePackageListener);
    }

    public void removeListener(LinkGrabberFilePackageListener linkGrabberFilePackageListener) {
        this.broadcaster.removeListener(linkGrabberFilePackageListener);
    }

    public String getHoster() {
        if (this.hosts == null) {
            this.updateHosts();
        }
        return this.hosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHosts() {
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<DownloadLink> arrayList = this.downloadLinks;
        synchronized (arrayList) {
            for (DownloadLink downloadLink : this.downloadLinks) {
                hashSet.add(downloadLink.getHost());
            }
        }
        this.hosts = ((Object)hashSet).toString();
    }

    @Override
    public void handle_LinkGrabberFilePackageEvent(LinkGrabberFilePackageEvent linkGrabberFilePackageEvent) {
        switch (linkGrabberFilePackageEvent.getID()) {
            case 2: 
            case 3: {
                this.updateHosts();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<DownloadLink> getLinksListbyStatus(int n) {
        ArrayList<DownloadLink> arrayList = new ArrayList<DownloadLink>();
        ArrayList<DownloadLink> arrayList2 = this.downloadLinks;
        synchronized (arrayList2) {
            for (DownloadLink downloadLink : this.downloadLinks) {
                if (!downloadLink.getLinkStatus().hasStatus(n)) continue;
                arrayList.add(downloadLink);
            }
        }
        return arrayList;
    }

    public ImageIcon getCustomIcon() {
        return this.customIcon;
    }

    public String getCustomIconText() {
        return this.customIconText;
    }

    public void setCustomIcon(ImageIcon imageIcon, String string) {
        this.customIcon = imageIcon;
        this.customIconText = string;
    }

    public boolean hasCustomIcon() {
        return this.customIcon != null && this.customIconText != null;
    }
}

