/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import jd.PluginWrapper;
import jd.captcha.easy.load.LoadImage;
import jd.controlling.CaptchaController;
import jd.controlling.JDLogger;
import jd.controlling.LinkGrabberController;
import jd.controlling.ProgressController;
import jd.gui.swing.jdgui.menu.MenuAction;
import jd.http.Browser;
import jd.nutils.Formatter;
import jd.nutils.encoding.Encoding;
import jd.nutils.jobber.JDRunnable;
import jd.nutils.jobber.Jobber;
import jd.parser.Regex;
import jd.plugins.CryptedLink;
import jd.plugins.DecrypterException;
import jd.plugins.DownloadLink;
import jd.plugins.Plugin;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PluginForDecrypt
extends Plugin {
    private CryptedLink curcryptedLink = null;
    private static HashMap<Class<? extends PluginForDecrypt>, Long> LAST_STARTED_TIME = new HashMap();
    private Long WAIT_BETWEEN_STARTS = 0L;

    public PluginForDecrypt(PluginWrapper pluginWrapper) {
        super(pluginWrapper);
    }

    public synchronized long getLastTimeStarted() {
        if (!LAST_STARTED_TIME.containsKey(this.getClass())) {
            return 0L;
        }
        return Math.max(0L, LAST_STARTED_TIME.get(this.getClass()));
    }

    public synchronized void putLastTimeStarted(long l) {
        LAST_STARTED_TIME.put(this.getClass(), l);
    }

    public void setStartIntervall(long l) {
        this.WAIT_BETWEEN_STARTS = l;
    }

    @Override
    public String getVersion() {
        return this.getWrapper().getVersion();
    }

    public boolean waitForNextStartAllowed(CryptedLink cryptedLink) throws InterruptedException {
        String string = cryptedLink.getProgressController().getStatusText();
        long l = Math.max(0L, this.WAIT_BETWEEN_STARTS - (System.currentTimeMillis() - this.getLastTimeStarted()));
        if (l > 0L) {
            try {
                this.sleep(l, cryptedLink);
            }
            catch (InterruptedException interruptedException) {
                cryptedLink.getProgressController().setStatusText(string);
                throw interruptedException;
            }
            cryptedLink.getProgressController().setStatusText(string);
            return true;
        }
        cryptedLink.getProgressController().setStatusText(string);
        return false;
    }

    public void sleep(long l, CryptedLink cryptedLink) throws InterruptedException {
        String string = cryptedLink.getProgressController().getStatusText();
        while (l > 0L) {
            cryptedLink.getProgressController().setStatusText(String.valueOf(string) + " " + JDL.LF("gui.download.waittime_status2", "Wait %s", Formatter.formatSeconds((long)((l -= 1000L) / 1000L))));
            Thread.sleep(1000L);
        }
        cryptedLink.getProgressController().setStatusText(string);
    }

    protected DownloadLink createDownloadlink(String string) {
        DownloadLink downloadLink = new DownloadLink(null, null, this.getHost(), Encoding.urlDecode((String)string, (boolean)true), true);
        return downloadLink;
    }

    @Override
    public final ArrayList<MenuAction> createMenuitems() {
        return null;
    }

    public abstract ArrayList<DownloadLink> decryptIt(CryptedLink var1, ProgressController var2) throws Exception;

    public ArrayList<DownloadLink> decryptLink(CryptedLink cryptedLink) {
        this.curcryptedLink = cryptedLink;
        ProgressController progressController = new ProgressController("Decrypter: " + this.getLinkName());
        progressController.setStatusText("decrypt-" + this.getHost() + ": " + this.getLinkName());
        this.curcryptedLink.setProgressController(progressController);
        try {
            while (this.waitForNextStartAllowed(this.curcryptedLink)) {
            }
        }
        catch (InterruptedException interruptedException) {
            return new ArrayList<DownloadLink>();
        }
        this.putLastTimeStarted(System.currentTimeMillis());
        ArrayList<DownloadLink> arrayList = null;
        try {
            arrayList = this.decryptIt(this.curcryptedLink, progressController);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            progressController.setStatusText("Serverproblem?");
            progressController.setColor(Color.RED);
            progressController.doFinalize(15000L);
            return new ArrayList<DownloadLink>();
        }
        catch (UnknownHostException unknownHostException) {
            progressController.setStatusText("No InternetConnection?");
            progressController.setColor(Color.RED);
            progressController.doFinalize(15000L);
            return new ArrayList<DownloadLink>();
        }
        catch (DecrypterException decrypterException) {
            arrayList = new ArrayList();
            progressController.setStatusText(String.valueOf(this.getHost()) + ": " + decrypterException.getErrorMessage());
            progressController.setColor(Color.RED);
            progressController.doFinalize(15000L);
        }
        catch (InterruptedException interruptedException) {
            arrayList = new ArrayList();
        }
        catch (Exception exception) {
            progressController.doFinalize();
            JDLogger.exception(exception);
        }
        if (arrayList == null) {
            logger.severe("Decrypter out of date: " + this);
            logger.severe("Decrypter out of date: " + this.getVersion());
            progressController.setStatusText("Decrypter out of date: " + this.getHost());
            progressController.setColor(Color.RED);
            progressController.doFinalize(15000L);
            return new ArrayList<DownloadLink>();
        }
        if (arrayList.size() == 0) {
            progressController.doFinalize();
            return new ArrayList<DownloadLink>();
        }
        progressController.doFinalize();
        return arrayList;
    }

    protected String getCaptchaCode(String string, CryptedLink cryptedLink) throws IOException, DecrypterException {
        return this.getCaptchaCode(this.getHost(), string, cryptedLink);
    }

    protected String getCaptchaCode(LoadImage loadImage, CryptedLink cryptedLink) throws IOException, DecrypterException {
        return this.getCaptchaCode(this.getHost(), loadImage.file, cryptedLink);
    }

    protected String getCaptchaCode(String string, String string2, CryptedLink cryptedLink) throws IOException, DecrypterException {
        if (string2 == null) {
            logger.severe("Captcha Adresse nicht definiert");
            throw new DecrypterException(DecrypterException.CAPTCHA);
        }
        File file = this.getLocalCaptchaFile();
        Browser browser = this.br.cloneBrowser();
        try {
            browser.getDownload(file, string2);
        }
        catch (Exception exception) {
            logger.severe("Captcha Download fehlgeschlagen: " + string2);
            throw new DecrypterException(DecrypterException.CAPTCHA);
        }
        String string3 = this.getCaptchaCode(string, file, cryptedLink);
        String string4 = LoadImage.getFileType((String)string2, (String)browser.getHttpConnection().getContentType());
        file.renameTo(this.getLocalCaptchaFile(string4));
        return string3;
    }

    protected String getCaptchaCode(File file, CryptedLink cryptedLink) throws DecrypterException {
        return this.getCaptchaCode(this.getHost(), file, cryptedLink);
    }

    protected String getCaptchaCode(String string, File file, CryptedLink cryptedLink) throws DecrypterException {
        return this.getCaptchaCode(string, file, 0, cryptedLink, null, null);
    }

    protected String getCaptchaCode(String string, File file, int n, CryptedLink cryptedLink, String string2, String string3) throws DecrypterException {
        if (cryptedLink.getProgressController() != null) {
            cryptedLink.getProgressController().setStatusText(JDL.LF("gui.linkgrabber.waitinguserio", "Waiting for user input: %s", string));
        }
        String string4 = new CaptchaController(this.getHost(), string, file, string2, string3).getCode(n);
        if (cryptedLink.getProgressController() != null) {
            cryptedLink.getProgressController().setStatusText(null);
        }
        if (string4 == null) {
            throw new DecrypterException(DecrypterException.CAPTCHA);
        }
        return string4;
    }

    public ArrayList<DownloadLink> decryptLinks(CryptedLink[] cryptedLinkArray) {
        this.fireControlEvent(5, cryptedLinkArray);
        ArrayList<DownloadLink> arrayList = new ArrayList<DownloadLink>();
        Jobber jobber = new Jobber(4);
        int n = cryptedLinkArray.length - 1;
        while (n >= 0) {
            class DThread
            extends Thread
            implements JDRunnable {
                private CryptedLink decryptableLink = null;
                private PluginForDecrypt plg = null;
                private final /* synthetic */ ArrayList val$decryptedLinks;

                public DThread(CryptedLink cryptedLink, PluginForDecrypt pluginForDecrypt2, ArrayList arrayList) {
                    this.val$decryptedLinks = arrayList;
                    this.decryptableLink = cryptedLink;
                    this.plg = pluginForDecrypt2;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (LinkGrabberController.isFiltered(this.decryptableLink)) {
                        return;
                    }
                    ArrayList<DownloadLink> arrayList = this.plg.decryptLink(this.decryptableLink);
                    for (DownloadLink serializable2 : arrayList) {
                        serializable2.setBrowserUrl(this.decryptableLink.getCryptedUrl());
                    }
                    ArrayList arrayList2 = this.val$decryptedLinks;
                    synchronized (arrayList2) {
                        this.val$decryptedLinks.addAll(arrayList);
                    }
                }

                public void go() throws Exception {
                    this.run();
                }
            }
            DThread dThread = new DThread(cryptedLinkArray[n], (PluginForDecrypt)this.wrapper.getNewPluginInstance(), arrayList);
            jobber.add((JDRunnable)dThread);
            --n;
        }
        n = jobber.getJobsAdded();
        jobber.start();
        while (jobber.getJobsFinished() != n) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        jobber.stop();
        this.fireControlEvent(4, arrayList);
        return arrayList;
    }

    public CryptedLink[] getDecryptableLinks(String string) {
        String[] stringArray = new Regex(string, this.getSupportedLinks()).getColumn(-1);
        ArrayList<CryptedLink> arrayList = new ArrayList<CryptedLink>();
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length - 1;
            while (n >= 0) {
                String string2 = stringArray[n];
                string2 = string2.trim();
                while (string2.length() > 0 && string2.charAt(0) == '\"') {
                    string2 = string2.substring(1);
                }
                while (string2.length() > 0 && string2.charAt(string2.length() - 1) == '\"') {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                stringArray[n] = string2;
                --n;
            }
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string3 = stringArray2[n3];
                arrayList.add(new CryptedLink(string3));
                ++n3;
            }
        }
        return arrayList.toArray(new CryptedLink[arrayList.size()]);
    }

    protected void setBrowserExclusive() {
        this.br.setCookiesExclusive(true);
        this.br.clearCookies(this.getHost());
    }

    public String getLinkName() {
        if (this.curcryptedLink == null) {
            return "";
        }
        try {
            return new URL(this.curcryptedLink.toString()).toURI().getPath();
        }
        catch (Exception exception) {
            return "";
        }
    }
}

