/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import jd.PluginWrapper;
import jd.config.ConfigGroup;
import jd.config.SubConfiguration;
import jd.controlling.AccountController;
import jd.controlling.CaptchaController;
import jd.controlling.DownloadController;
import jd.controlling.JDLogger;
import jd.gui.UserIF;
import jd.gui.swing.components.linkbutton.JLink;
import jd.gui.swing.jdgui.actions.ActionController;
import jd.gui.swing.jdgui.actions.ToolBarAction;
import jd.gui.swing.jdgui.menu.MenuAction;
import jd.http.Browser;
import jd.http.URLConnectionAdapter;
import jd.nutils.Formatter;
import jd.nutils.JDImage;
import jd.nutils.encoding.Encoding;
import jd.parser.Regex;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.AccountMenuItemSyncer;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.Plugin;
import jd.plugins.PluginException;
import jd.plugins.download.DownloadInterface;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PluginForHost
extends Plugin {
    private static final String AGB_CHECKED = "AGB_CHECKED";
    private static final String CONFIGNAME = "pluginsForHost";
    private static int currentConnections = 0;
    public static final String PARAM_MAX_RETRIES = "MAX_RETRIES";
    protected DownloadInterface dl = null;
    private int maxConnections = 50;
    private static HashMap<String, Long> LAST_CONNECTION_TIME = new HashMap();
    private static HashMap<String, Long> LAST_STARTED_TIME = new HashMap();
    private Long WAIT_BETWEEN_STARTS = 0L;
    private boolean enablePremium = false;
    private boolean accountWithoutUsername = false;
    private String premiumurl = null;
    private ImageIcon hosterIcon;
    private MenuAction premiumAction;

    public PluginForHost(PluginWrapper pluginWrapper) {
        super(pluginWrapper);
        this.config.setIcon(this.getHosterIcon());
    }

    protected String getCaptchaCode(String string, DownloadLink downloadLink) throws IOException, PluginException {
        return this.getCaptchaCode(this.getHost(), string, downloadLink);
    }

    @Override
    public String getVersion() {
        return this.wrapper.getVersion();
    }

    protected String getCaptchaCode(String string, String string2, DownloadLink downloadLink) throws IOException, PluginException {
        if (string2 == null) {
            logger.severe("Captcha Adresse nicht definiert");
            throw new PluginException(8);
        }
        File file = this.getLocalCaptchaFile();
        try {
            Browser.download((File)file, (URLConnectionAdapter)this.br.cloneBrowser().openGetConnection(string2));
        }
        catch (Exception exception) {
            logger.severe("Captcha Download fehlgeschlagen: " + string2);
            throw new PluginException(8);
        }
        String string3 = this.getCaptchaCode(string, file, downloadLink);
        return string3;
    }

    protected String getCaptchaCode(File file, DownloadLink downloadLink) throws PluginException {
        return this.getCaptchaCode(this.getHost(), file, downloadLink);
    }

    protected String getCaptchaCode(String string, File file, DownloadLink downloadLink) throws PluginException {
        return this.getCaptchaCode(string, file, 0, downloadLink, null, null);
    }

    protected String getCaptchaCode(String string, File file, int n, DownloadLink downloadLink, String string2, String string3) throws PluginException {
        String string4 = downloadLink.getLinkStatus().getStatusText();
        try {
            Object object;
            downloadLink.getLinkStatus().addStatus(0x800000);
            downloadLink.getLinkStatus().setStatusText(JDL.L("gui.downloadview.statustext.jac", "Captcha recognition"));
            try {
                object = ImageIO.read(file);
                downloadLink.getLinkStatus().setStatusIcon(JDImage.getScaledImageIcon((BufferedImage)object, (int)16, (int)16));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            DownloadController.getInstance().fireDownloadLinkUpdate(downloadLink);
            object = new CaptchaController(this.getHost(), string, file, string2, string3).getCode(n);
            if (object == null) {
                throw new PluginException(8);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            downloadLink.getLinkStatus().removeStatus(0x800000);
            downloadLink.getLinkStatus().setStatusText(string4);
            downloadLink.getLinkStatus().setStatusIcon(null);
            DownloadController.getInstance().fireDownloadLinkUpdate(downloadLink);
        }
    }

    public boolean checkLinks(DownloadLink[] downloadLinkArray) {
        return false;
    }

    @Override
    public void clean() {
        this.dl = null;
        super.clean();
    }

    protected int waitForFreeConnection(DownloadLink downloadLink) throws InterruptedException {
        int n;
        while ((n = this.getMaxConnections() - PluginForHost.getCurrentConnections()) <= 0) {
            Thread.sleep(1000L);
            downloadLink.getLinkStatus().setStatusText(JDL.LF("download.system.waitForconnection", "Cur. %s/%s connections...waiting", String.valueOf(PluginForHost.getCurrentConnections()), String.valueOf(this.getMaxConnections())));
            downloadLink.requestGuiUpdate();
        }
        return n;
    }

    protected void setBrowserExclusive() {
        this.br.setCookiesExclusive(true);
        this.br.clearCookies(this.getHost());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getID() == 1) {
            UserIF.getInstance().requestPanel(UserIF.Panels.CONFIGPANEL, (Object)this.config);
            return;
        }
        if (actionEvent.getID() == 2) {
            UserIF.getInstance().requestPanel(UserIF.Panels.PREMIUMCONFIG, null);
            ActionController.getToolBarAction((String)"action.premiumview.addacc").actionPerformed(new ActionEvent(this, 0, "addaccount"));
            return;
        }
        if (actionEvent.getID() == 3) {
            UserIF.getInstance().requestPanel(UserIF.Panels.PREMIUMCONFIG, null);
            try {
                JLink.openURL((String)this.getBuyPremiumUrl());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        ArrayList<Account> arrayList = this.getPremiumAccounts();
        if (actionEvent.getID() >= 200) {
            int n = actionEvent.getID() - 200;
            Account account = arrayList.get(n);
            UserIF.getInstance().requestPanel(UserIF.Panels.PREMIUMCONFIG, (Object)account);
        } else if (actionEvent.getID() >= 100) {
            Account account;
            int n = actionEvent.getID() - 100;
            account.setEnabled(!(account = arrayList.get(n)).isEnabled());
        }
    }

    public AccountInfo fetchAccountInfo(Account account) throws Exception {
        account.setValid(true);
        return null;
    }

    public boolean getAccountwithoutUsername() {
        return this.accountWithoutUsername;
    }

    public void setAccountwithoutUsername(boolean bl) {
        this.accountWithoutUsername = bl;
    }

    @Override
    public ArrayList<MenuAction> createMenuitems() {
        MenuAction menuAction;
        if (!this.enablePremium) {
            return null;
        }
        ArrayList<MenuAction> arrayList = new ArrayList<MenuAction>();
        if (this.config != null && this.config.getEntries().size() > 0) {
            menuAction = new MenuAction("plugins.configs", 1);
            menuAction.setActionListener((ActionListener)this);
            arrayList.add(menuAction);
            arrayList.add(new MenuAction(ToolBarAction.Types.SEPARATOR));
        }
        if (this.config != null) {
            this.config.setGroup(new ConfigGroup(this.getHost(), this.getHosterIcon()));
        }
        if (this.premiumAction == null) {
            this.premiumAction = new MenuAction("accounts", 0);
            this.premiumAction.setType(ToolBarAction.Types.CONTAINER);
            ArrayList<Account> arrayList2 = this.getPremiumAccounts();
            int n = 1;
            int n2 = 0;
            for (Account account : arrayList2) {
                if (account == null) continue;
                try {
                    MenuAction menuAction2;
                    ++n2;
                    if (this.getAccountwithoutUsername()) {
                        if (account.getPass() == null || account.getPass().trim().length() == 0) continue;
                        menuAction2 = new MenuAction("account." + this.getHost() + "." + n, 0);
                        menuAction2.setTitle(String.valueOf(n++) + ". " + "Account " + (n - 1));
                        menuAction2.setType(ToolBarAction.Types.CONTAINER);
                    } else {
                        if (account.getUser() == null || account.getUser().trim().length() == 0) continue;
                        menuAction2 = new MenuAction("account." + this.getHost() + "." + n, 0);
                        menuAction2.setTitle(String.valueOf(n++) + ". " + account.getUser());
                        menuAction2.setType(ToolBarAction.Types.CONTAINER);
                    }
                    menuAction = AccountMenuItemSyncer.getInstance().get(account);
                    if (menuAction == null) {
                        menuAction = new MenuAction("plugins.PluginForHost.enable_premium", 100 + n2 - 1);
                    }
                    menuAction.setActionID(100 + n2 - 1);
                    menuAction.setSelected(account.isEnabled());
                    menuAction.setActionListener((ActionListener)this);
                    menuAction2.addMenuItem(menuAction);
                    AccountMenuItemSyncer.getInstance().map(account, menuAction);
                    menuAction = new MenuAction("plugins.PluginForHost.premiumInfo", 200 + n2 - 1);
                    menuAction.setActionListener((ActionListener)this);
                    menuAction2.addMenuItem(menuAction);
                    this.premiumAction.addMenuItem(menuAction2);
                }
                catch (Exception exception) {
                    JDLogger.exception(exception);
                }
            }
        }
        if (this.premiumAction.getSize() != 0) {
            arrayList.add(this.premiumAction);
        } else {
            menuAction = new MenuAction("plugins.menu.noaccounts", 2);
            arrayList.add(menuAction);
            menuAction.setActionListener((ActionListener)this);
        }
        menuAction = new MenuAction("plugins.menu.buyaccount", 3);
        arrayList.add(menuAction);
        menuAction.setActionListener((ActionListener)this);
        return arrayList;
    }

    public abstract String getAGBLink();

    protected void enablePremium() {
        this.enablePremium(null);
    }

    protected void enablePremium(String string) {
        this.premiumurl = string;
        this.enablePremium = true;
    }

    public static synchronized int getCurrentConnections() {
        return currentConnections;
    }

    public ArrayList<DownloadLink> getDownloadLinks(String string, FilePackage filePackage) {
        ArrayList<DownloadLink> arrayList = null;
        String[] stringArray = new Regex(string, this.getSupportedLinks()).getColumn(-1);
        if (stringArray != null && stringArray.length > 0) {
            arrayList = new ArrayList<DownloadLink>();
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                while (string2.charAt(0) == '\"') {
                    string2 = string2.substring(1);
                }
                while (string2.charAt(string2.length() - 1) == '\"') {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                try {
                    PluginForHost pluginForHost = (PluginForHost)this.wrapper.getNewPluginInstance();
                    DownloadLink downloadLink = new DownloadLink(pluginForHost, string2.substring(string2.lastIndexOf("/") + 1, string2.length()), this.getHost(), string2, true);
                    arrayList.add(downloadLink);
                    if (filePackage != null) {
                        downloadLink.setFilePackage(filePackage);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    JDLogger.exception(illegalArgumentException);
                }
                catch (SecurityException securityException) {
                    JDLogger.exception(securityException);
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public void correctDownloadLink(DownloadLink downloadLink) throws Exception {
    }

    public abstract DownloadLink.AvailableStatus requestFileInformation(DownloadLink var1) throws Exception;

    public String getFileInformationString(DownloadLink downloadLink) {
        return String.valueOf(downloadLink.getName()) + " (" + Formatter.formatReadable((long)downloadLink.getDownloadSize()) + ")";
    }

    public synchronized int getFreeConnections() {
        return Math.max(1, this.getMaxConnections() - currentConnections);
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getMaxRetries() {
        return SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty(PARAM_MAX_RETRIES, 3);
    }

    public int getMaxSimultanFreeDownloadNum() {
        return 1;
    }

    public int getMaxSimultanPremiumDownloadNum() {
        return -1;
    }

    public int getMaxSimultanDownloadNum() {
        int n = this.isPremiumDownload() ? this.getMaxSimultanPremiumDownloadNum() : this.getMaxSimultanFreeDownloadNum();
        if (n < 0) {
            return Integer.MAX_VALUE;
        }
        return n;
    }

    public boolean isPremiumDownload() {
        if (!this.enablePremium || !JDUtilities.getConfiguration().getBooleanProperty("USE_PREMIUM_V3", true).booleanValue()) {
            return false;
        }
        return AccountController.getInstance().getValidAccount(this) != null;
    }

    public synchronized long getLastTimeStarted() {
        if (!LAST_STARTED_TIME.containsKey(this.getHost())) {
            return 0L;
        }
        return Math.max(0L, LAST_STARTED_TIME.get(this.getHost()));
    }

    public synchronized void putLastTimeStarted(long l) {
        LAST_STARTED_TIME.put(this.getHost(), l);
    }

    public synchronized long getLastConnectionTime() {
        if (!LAST_CONNECTION_TIME.containsKey(this.getHost())) {
            return 0L;
        }
        return Math.max(0L, LAST_CONNECTION_TIME.get(this.getHost()));
    }

    public synchronized void putLastConnectionTime(long l) {
        LAST_CONNECTION_TIME.put(this.getHost(), l);
    }

    public void handlePremium(DownloadLink downloadLink, Account account) throws Exception {
        downloadLink.getLinkStatus().addStatus(0x400000);
        downloadLink.getLinkStatus().setErrorMessage(JDL.L("plugins.hoster.nopremiumsupport", "Plugin has no handlePremium Method!"));
    }

    public abstract void handleFree(DownloadLink var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(DownloadLink downloadLink) throws Exception {
        downloadLink.getTransferStatus().usePremium(false);
        downloadLink.getTransferStatus().setResumeSupport(false);
        try {
            while (this.waitForNextStartAllowed(downloadLink)) {
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.putLastTimeStarted(System.currentTimeMillis());
        if (!this.isAGBChecked()) {
            logger.severe("AGB not signed : " + this.getWrapper().getID());
            downloadLink.getLinkStatus().addStatus(65536);
            return;
        }
        Account account = null;
        if (this.enablePremium) {
            account = AccountController.getInstance().getValidAccount(this);
        }
        if (account != null) {
            long l = downloadLink.getDownloadCurrent();
            try {
                downloadLink.getTransferStatus().usePremium(true);
                this.handlePremium(downloadLink, account);
                if (this.dl != null && this.dl.getConnection() != null) {
                    try {
                        this.dl.getConnection().disconnect();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (PluginException pluginException) {
                pluginException.fillLinkStatus(downloadLink.getLinkStatus());
                logger.info(downloadLink.getLinkStatus().getLongErrorMessage());
            }
            long l2 = Math.max(0L, downloadLink.getDownloadCurrent() - l);
            boolean bl = false;
            Object object = AccountController.ACCOUNT_LOCK;
            synchronized (object) {
                AccountInfo accountInfo = account.getAccountInfo();
                if (l2 > 0L && accountInfo != null && !accountInfo.isUnlimitedTraffic()) {
                    long l3 = Math.max(0L, accountInfo.getTrafficLeft() - l2);
                    accountInfo.setTrafficLeft(l3);
                    if (l3 == 0L && accountInfo.isSpecialTraffic()) {
                        logger.severe("Premium Account " + account.getUser() + ": Traffic Limit could be reached, but SpecialTraffic might be available!");
                    } else if (l3 == 0L) {
                        logger.severe("Premium Account " + account.getUser() + ": Traffic Limit reached");
                        account.setTempDisabled(true);
                    }
                    bl = true;
                }
            }
            if (bl) {
                AccountController.getInstance().throwUpdateEvent(this, account);
            }
            if (downloadLink.getLinkStatus().hasStatus(256)) {
                if (downloadLink.getLinkStatus().getValue() == 0L) {
                    logger.severe("Premium Account " + account.getUser() + ": Traffic Limit reached");
                    account.setTempDisabled(true);
                    if (account.getAccountInfo() != null) {
                        account.getAccountInfo().setStatus(downloadLink.getLinkStatus().getErrorMessage());
                    }
                } else if (downloadLink.getLinkStatus().getValue() == 1L) {
                    account.setEnabled(false);
                    if (account.getAccountInfo() != null) {
                        account.getAccountInfo().setStatus(downloadLink.getLinkStatus().getErrorMessage());
                    }
                    logger.severe("Premium Account " + account.getUser() + ": expired:" + downloadLink.getLinkStatus().getLongErrorMessage());
                } else {
                    account.setEnabled(false);
                    if (account.getAccountInfo() != null) {
                        account.getAccountInfo().setStatus(downloadLink.getLinkStatus().getErrorMessage());
                    }
                    logger.severe("Premium Account " + account.getUser() + ":" + downloadLink.getLinkStatus().getLongErrorMessage());
                }
            } else if (account.getAccountInfo() != null) {
                account.getAccountInfo().setStatus(JDL.L("plugins.hoster.premium.status_ok", "Account is ok"));
            }
        } else {
            try {
                this.handleFree(downloadLink);
                if (this.dl != null && this.dl.getConnection() != null) {
                    try {
                        this.dl.getConnection().disconnect();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (PluginException pluginException) {
                pluginException.fillLinkStatus(downloadLink.getLinkStatus());
                logger.info(downloadLink.getLinkStatus().getLongErrorMessage());
            }
        }
    }

    public boolean isAGBChecked() {
        if (!this.getPluginConfig().hasProperty(AGB_CHECKED)) {
            this.getPluginConfig().setProperty(AGB_CHECKED, SubConfiguration.getConfig(CONFIGNAME).getBooleanProperty("AGBS_CHECKED_" + this.getPluginID(), false) != false || SubConfiguration.getConfig(CONFIGNAME).getBooleanProperty("AGB_CHECKED_" + this.getHost(), false) != false);
            this.getPluginConfig().save();
        }
        return this.getPluginConfig().getBooleanProperty(AGB_CHECKED, false);
    }

    public abstract void reset();

    public abstract void resetDownloadlink(DownloadLink var1);

    public void resetPluginGlobals() {
    }

    public void setAGBChecked(boolean bl) {
        this.getPluginConfig().setProperty(AGB_CHECKED, bl);
        this.getPluginConfig().save();
    }

    public static synchronized void setCurrentConnections(int n) {
        currentConnections = n;
    }

    public int getTimegapBetweenConnections() {
        return 50;
    }

    public void setStartIntervall(long l) {
        this.WAIT_BETWEEN_STARTS = l;
    }

    public boolean waitForNextStartAllowed(DownloadLink downloadLink) throws InterruptedException {
        long l = Math.max(0L, this.WAIT_BETWEEN_STARTS - (System.currentTimeMillis() - this.getLastTimeStarted()));
        if (l > 0L) {
            try {
                this.sleep(l, downloadLink);
            }
            catch (PluginException pluginException) {
                throw new InterruptedException();
            }
            return true;
        }
        return false;
    }

    public boolean waitForNextConnectionAllowed() throws InterruptedException {
        long l = Math.max(0L, (long)this.getTimegapBetweenConnections() - (System.currentTimeMillis() - this.getLastConnectionTime()));
        if (l > 0L) {
            Thread.sleep(l);
            return true;
        }
        return false;
    }

    public void setMaxConnections(int n) {
        this.maxConnections = n;
    }

    public void sleep(long l, DownloadLink downloadLink) throws PluginException {
        this.sleep(l, downloadLink, "");
    }

    public void sleep(long l, DownloadLink downloadLink, String string) throws PluginException {
        try {
            while (l > 0L && downloadLink.getDownloadLinkController() != null && !downloadLink.getDownloadLinkController().isAborted()) {
                downloadLink.getLinkStatus().setStatusText(String.valueOf(string) + JDL.LF("gui.download.waittime_status2", "Wait %s", Formatter.formatSeconds((long)((l -= 1000L) / 1000L))));
                downloadLink.requestGuiUpdate();
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new PluginException(1);
        }
        downloadLink.getLinkStatus().setStatusText(null);
    }

    public boolean isAborted(DownloadLink downloadLink) {
        return downloadLink.getDownloadLinkController() != null && downloadLink.getDownloadLinkController().isAborted();
    }

    public Browser getBrowser() {
        return this.br;
    }

    public void setDownloadInterface(DownloadInterface downloadInterface) {
        this.dl = downloadInterface;
    }

    public String getBuyPremiumUrl() {
        if (this.premiumurl != null) {
            return "http://jdownloader.org/r.php?u=" + Encoding.urlEncode((String)this.premiumurl);
        }
        return this.premiumurl;
    }

    public boolean isPremiumEnabled() {
        return this.enablePremium;
    }

    public ArrayList<Account> getPremiumAccounts() {
        return AccountController.getInstance().getAllAccounts(this);
    }

    public String getSessionInfo() {
        return "";
    }

    public ImageIcon getHosterIcon() {
        if (this.hosterIcon == null) {
            this.hosterIcon = this.initHosterIcon();
        }
        return this.hosterIcon;
    }

    private final ImageIcon initHosterIcon() {
        Image image = JDImage.getImage((String)("hosterlogos/" + this.getHost()));
        if (image == null) {
            image = this.createDefaultIcon();
        }
        if (image != null) {
            return new ImageIcon(image);
        }
        return null;
    }

    private final String cleanString(String string) {
        return string.replaceAll("[a-z0-9\\-\\.]", "");
    }

    private final Image createDefaultIcon() {
        int n = 16;
        int n2 = 16;
        int n3 = 9;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        String string = this.getHost();
        String string2 = this.cleanString(string);
        if (string2.length() < 2) {
            string2 = this.cleanString(this.getClass().getSimpleName());
        }
        if (string2.length() < 2) {
            string2 = string.toUpperCase();
        }
        if (string2.length() > 2) {
            string2 = string2.substring(0, 2);
        }
        graphics2D.setFont(new Font("Arial", 1, n3));
        int n4 = graphics2D.getFontMetrics().stringWidth(string2);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(1, 1, n - 2, n2 - 2);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawString(string2, (n - n4) / 2, 2 + n3);
        graphics2D.dispose();
        try {
            File file = JDUtilities.getResourceFile("jd/img/hosterlogos/" + this.getHost() + ".png", true);
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
        }
        return bufferedImage;
    }
}

