/*
 * Decompiled with CFR 0.152.
 */
package jd.router;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import jd.controlling.reconnect.HTTPLiveHeader;
import jd.nutils.io.JDIO;
import jd.router.RouterData;
import jd.router.RouterParser;
import jd.utils.JDUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertRouterData {
    private String cookie = null;
    private String ip = "            Host: %%%routerip%%%\r\n";
    private ArrayList<String[]> routerData = null;

    private static void convertXml(File file, File file2) {
        ConvertRouterData convertRouterData = new ConvertRouterData();
        RouterData[] routerDataArray = convertRouterData.readRouterDat(file);
        Vector<String[]> vector = new Vector<String[]>();
        RouterData[] routerDataArray2 = routerDataArray;
        int n = routerDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            RouterData routerData = routerDataArray2[n2];
            String[] stringArray = convertRouterData.toLiveHeader(routerData);
            if (stringArray != null) {
                vector.add(stringArray);
            } else {
                System.out.println(routerData.getRouterName());
            }
            ++n2;
        }
        convertRouterData.saveTolist(vector, file2);
    }

    public static void main(String[] stringArray) {
        File file = JDUtilities.getResourceFile("jd/Routers.xml");
        File file2 = JDUtilities.getResourceFile("jd/new.xml");
        ConvertRouterData.convertXml(file, file2);
    }

    private String convertUserPass(String string) {
        if (string != null) {
            return string.replaceAll("MD5PasswordL(%PASSWORD%)", "%%%MD5:::pass%%%").replaceAll("\\%USERNAME\\%", "%%%user%%%").replaceAll("\\%PASSWORD\\%", "%%%pass%%%");
        }
        return null;
    }

    private String defaultRequest(int n, String string, String string2, HashMap<String, String> hashMap) {
        if (string == null || string.matches("[\\s]*")) {
            if (n == 2) {
                return "";
            }
            string = "";
            if (string2 == null || string2.matches("[\\s]*")) {
                return "";
            }
        }
        String string3 = this.ip;
        String string4 = this.cookie;
        if (string.matches("http://.*")) {
            this.cookie = "";
            string = string.replaceFirst("http://", "");
            this.ip = "            Host: http://" + string.replaceFirst("/.*", "") + "\r\n";
            string = !string.matches(".*/.*") ? "/" : string.replaceFirst(".*/", "/");
        }
        string2 = this.convertUserPass(string2);
        if ((string = this.convertUserPass(string)).charAt(0) != '/') {
            string = "/" + string;
        }
        String string5 = "";
        string5 = String.valueOf(string5) + "    [[[STEP]]]\r\n        [[[REQUEST]]]\r\n            " + this.getType(n) + string + " HTTP/1.1\r\n" + this.ip + this.cookie;
        if (n == 3) {
            string5 = String.valueOf(string5) + this.getPoperties(hashMap) + (string2 != null ? "\r\n" + string2 + "\r\n" : "\r\n");
        }
        string5 = String.valueOf(string5) + "        [[[/REQUEST]]]\r\n    [[[/STEP]]]\r\n";
        this.ip = string3;
        this.cookie = string4;
        return string5;
    }

    private String getPoperties(HashMap<String, String> hashMap) {
        if (hashMap == null) {
            return "";
        }
        String string = "";
        for (Map.Entry<String, String> entry : hashMap.entrySet()) {
            string = String.valueOf(string) + entry.getKey() + ": " + entry.getValue() + "\n";
        }
        return string;
    }

    private String getType(int n) {
        if (n == 3) {
            return "POST ";
        }
        return "GET ";
    }

    private String[] getUserPass(String string) {
        if (this.routerData == null) {
            this.routerData = HTTPLiveHeader.getLHScripts();
        }
        int n = 0;
        while (n < this.routerData.size()) {
            String[] stringArray = this.routerData.get(n);
            if (stringArray[1].equals(string)) {
                return new String[]{stringArray[3], stringArray[4], stringArray[5]};
            }
            ++n;
        }
        return new String[3];
    }

    private RouterData[] readRouterDat(File file) {
        if (file != null) {
            RouterParser routerParser = new RouterParser();
            Vector<RouterData> vector = routerParser.parseXMLFile(file);
            return vector.toArray(new RouterData[vector.size()]);
        }
        return null;
    }

    private void saveTolist(Vector<String[]> vector, File file) {
        if (file.exists()) {
            vector.addAll((Collection)JDIO.loadObject(null, (File)file, (boolean)true));
            Collections.sort(vector, new Comparator<String[]>(){

                @Override
                public int compare(String[] stringArray, String[] stringArray2) {
                    return (String.valueOf(stringArray[0]) + " " + stringArray[1]).compareToIgnoreCase(String.valueOf(stringArray2[0]) + " " + stringArray2[1]);
                }
            });
        }
        JDIO.saveObject(null, vector, (File)file, null, null, (boolean)true);
    }

    private String[] toLiveHeader(RouterData routerData) {
        this.ip = routerData.getRouterIP();
        this.cookie = "";
        int n = routerData.getRouterPort();
        String string = "";
        if (n != 80) {
            string = ":" + n;
        }
        this.ip = this.ip == null || this.ip.matches("[\\s]*") || this.ip.matches("192.168.0.1") ? "            Host: %%%routerip%%%" + string + "\n" : "            Host: " + this.ip + string + "\r\n";
        String string2 = "[[[HSRC]]]\n";
        String string3 = this.defaultRequest(routerData.getLoginType(), routerData.getLogin(), routerData.getLoginPostParams(), routerData.getLoginRequestProperties());
        this.cookie = !string3.equals("") ? "            Cookie: %%%Set-Cookie%%%\r\n" : "            Authorization: Basic %%%basicauth%%%\r\n";
        string2 = String.valueOf(string2) + string3;
        String string4 = this.defaultRequest(routerData.getDisconnectType(), routerData.getDisconnect(), routerData.getDisconnectPostParams(), routerData.getDisconnectRequestProperties());
        if (string4.equals("")) {
            return null;
        }
        string2 = String.valueOf(string2) + string4;
        string2 = String.valueOf(string2) + "    [[[STEP]]][[[WAIT seconds=\"3\"/]]][[[/STEP]]]\r\n";
        string2 = String.valueOf(string2) + this.defaultRequest(routerData.getConnectType(), routerData.getConnect(), routerData.getConnectPostParams(), routerData.getConnectRequestProperties());
        string2 = String.valueOf(string2) + this.defaultRequest(2, routerData.getLogoff(), null, null);
        string2 = String.valueOf(string2) + "[[[/HSRC]]]";
        String string5 = routerData.getRouterName();
        String[] stringArray = this.getUserPass(string5);
        String string6 = "(?s).*" + string5.replaceFirst(" .*", "").toLowerCase() + ".*";
        if (stringArray[0] != null && !stringArray[0].matches("[\\s]*")) {
            string6 = stringArray[0];
        }
        return new String[]{string5.replaceFirst(" .*", ""), string5, string2, string6, stringArray[1], stringArray[2]};
    }
}

