/*
 * Decompiled with CFR 0.152.
 */
package jd.router;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JTextField;
import jd.controlling.JDLogger;
import jd.controlling.reconnect.Reconnecter;
import jd.gui.UserIO;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.dialog.ProgressDialog;
import jd.gui.swing.jdgui.settings.GUIConfigEntry;
import jd.gui.userio.DummyFrame;
import jd.http.Browser;
import jd.http.RequestHeader;
import jd.http.URLConnectionAdapter;
import jd.http.download.Broadcaster;
import jd.nutils.JDFlags;
import jd.nutils.Threader;
import jd.nutils.jobber.JDRunnable;
import jd.router.RInfo;
import jd.router.RouterInfoCollector;
import jd.router.SQLRouterData;
import jd.router.UPnPInfo;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetRouterInfo {
    private Threader threader = null;
    private Threader th2 = null;
    private boolean cancel = false;
    public InetAddress adress = null;
    public boolean testAll = false;
    private Logger logger = JDLogger.getLogger();
    public String password = null;
    private ProgressDialog progressBar;
    public String username = null;

    public static boolean isFritzbox(String string) {
        Browser browser = new Browser();
        try {
            String string2 = browser.getPage("http://" + string);
            if (string2.matches("(?is).*fritz.?box.*")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void cancel() {
        this.cancel = true;
        if (this.threader != null) {
            try {
                this.threader.interrupt();
            }
            catch (Exception exception) {}
        } else if (this.th2 != null) {
            try {
                this.th2.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean isUpnp(String string, String string2) {
        Browser browser = new Browser();
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("SoapAction", "urn:schemas-upnp-org:service:WANIPConnection:1#GetStatusInfo");
            hashMap.put("CONTENT-TYPE", "text/xml; charset=\"utf-8\"");
            browser.setHeaders(new RequestHeader(hashMap));
            URLConnectionAdapter uRLConnectionAdapter = browser.openPostConnection("http://" + string + ":" + string2 + "/upnp/control/WANIPConn1", "<?xml version='1.0' encoding='utf-8'?> <s:Envelope s:encodingStyle='http://schemas.xmlsoap.org/soap/encoding/' xmlns:s='http://schemas.xmlsoap.org/soap/envelope/'> <s:Body> <u:GetStatusInfo xmlns:u='urn:schemas-upnp-org:service:WANIPConnection:1' /> </s:Body> </s:Envelope>");
            if (uRLConnectionAdapter.getHeaderField(null).contains("200")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static ArrayList<InetAddress> getInterfaces() {
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            block2: while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue block2;
                    if (!inetAddress.getHostAddress().matches("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}")) continue;
                    arrayList.add(inetAddress);
                }
            }
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
        }
        return arrayList;
    }

    public GetRouterInfo(ProgressDialog progressDialog) {
        this.progressBar = progressDialog;
        if (this.progressBar != null) {
            this.progressBar.setMaximum(100);
        }
    }

    public static boolean checkport(String string, int n) {
        try {
            Socket socket = new Socket(string, n);
            socket.setSoTimeout(200);
            return true;
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static boolean checkport80(String string) {
        return GetRouterInfo.checkport(string, 80);
    }

    public static LinkedHashMap<RInfo, Integer> sortByIntegrety(Map<RInfo, Integer> map) {
        LinkedList<Map.Entry<RInfo, Integer>> linkedList = new LinkedList<Map.Entry<RInfo, Integer>>(map.entrySet());
        Collections.sort(linkedList, new Comparator<Map.Entry<RInfo, Integer>>(){

            @Override
            public int compare(Map.Entry<RInfo, Integer> entry, Map.Entry<RInfo, Integer> entry2) {
                if (entry.getValue().equals(entry2.getValue())) {
                    return entry2.getKey().compareTo(entry.getKey());
                }
                return entry.getValue().compareTo(entry2.getValue());
            }
        });
        LinkedHashMap<RInfo, Integer> linkedHashMap = new LinkedHashMap<RInfo, Integer>();
        for (Map.Entry entry : linkedList) {
            linkedHashMap.put((RInfo)entry.getKey(), (Integer)entry.getValue());
        }
        return linkedHashMap;
    }

    private RInfo checkrouters(HashMap<RInfo, Integer> hashMap) {
        int n = JDUtilities.getConfiguration().getIntegerProperty("RECONNECT_RETRIES2", 5);
        int n2 = JDUtilities.getConfiguration().getIntegerProperty("RECONNECT_WAITFORIPCHANGE2", 20);
        JDUtilities.getConfiguration().setProperty("RECONNECT_RETRIES2", 0);
        JDUtilities.getConfiguration().setProperty("RECONNECT_WAITFORIPCHANGE2", 10);
        JDUtilities.getConfiguration().setProperty("HTTPSEND_USER", this.username);
        JDUtilities.getConfiguration().setProperty("HTTPSEND_PASS", this.password);
        int n3 = hashMap.size();
        int n4 = 0;
        for (Map.Entry<RInfo, Integer> entry : hashMap.entrySet()) {
            if (this.cancel) {
                return null;
            }
            if (entry.getKey().getReconnectMethode() != null) {
                JDUtilities.getConfiguration().setProperty("RECONNECT_TYPE", 0);
                JDUtilities.getConfiguration().setProperty("HTTPSEND_REQUESTS", entry.getKey().getReconnectMethode());
            } else {
                if (entry.getKey().getReconnectMethodeClr() == null) continue;
                JDUtilities.getConfiguration().setProperty("RECONNECT_TYPE", 3);
                JDUtilities.getConfiguration().setProperty("HTTPSEND_REQUESTS_CLR", entry.getKey().getReconnectMethodeClr());
            }
            this.setProgressText(String.valueOf(JDL.L("gui.config.routeripfinder.status.testingrouter", "Testing router")) + " " + entry.getKey().getRouterName() + " ...");
            this.setProgress(n4++ * 100 / n3);
            JDUtilities.getConfiguration().save();
            if (!Reconnecter.waitForNewIP(1L, true)) continue;
            JDUtilities.getConfiguration().setProperty("RECONNECT_RETRIES2", n);
            JDUtilities.getConfiguration().setProperty("RECONNECT_WAITFORIPCHANGE2", n2);
            JDUtilities.getConfiguration().save();
            this.setProgress(100);
            return entry.getKey();
        }
        return null;
    }

    public Vector<RInfo> getRouterInfos() {
        this.setProgressText(JDL.L("gui.config.routeripfinder.status.collectingrouterinfo", "Collecting router informations..."));
        final RInfo rInfo = RouterInfoCollector.getRInfo(116);
        this.setProgress(25);
        rInfo.setReconnectMethode(null);
        rInfo.setReconnectMethodeClr(null);
        final Threader threader = new Threader();
        final Vector<RInfo> vector = new Vector<RInfo>();
        final class Isalvs {
            boolean isAlv = true;
            ArrayList<String> meths = null;
            HashMap<String, String> SCPDs = null;

            Isalvs() {
            }
        }
        final Isalvs isalvs = new Isalvs();
        final JDRunnable jDRunnable = new JDRunnable(){
            {
            }

            public void go() throws Exception {
                try {
                    UPnPInfo uPnPInfo = new UPnPInfo(InetAddress.getByName(rInfo.getRouterHost()));
                    if (uPnPInfo.met != null && uPnPInfo.met.size() != 0) {
                        isalvs.SCPDs = uPnPInfo.SCPDs;
                        isalvs.meths = uPnPInfo.met;
                    }
                    if (uPnPInfo.met != null) {
                        JDLogger.getLogger().info(uPnPInfo.met.toString());
                    }
                }
                catch (Exception exception) {
                    JDLogger.getLogger().info("NO UPNP");
                }
                isalvs.isAlv = false;
            }
        };
        Broadcaster broadcaster = threader.getBroadcaster();
        Threader threader2 = threader;
        threader2.getClass();
        broadcaster.addListener((Object)new Threader.WorkerListener(threader2){
            {
                super(threader3);
            }

            public void onThreadException(Threader threader2, JDRunnable jDRunnable2, Exception exception) {
            }

            public void onThreadFinished(Threader threader2, JDRunnable jDRunnable2) {
                if (jDRunnable2 == jDRunnable) {
                    isalvs.isAlv = false;
                    threader.notify();
                }
            }

            public void onThreadStarts(Threader threader2, JDRunnable jDRunnable2) {
            }
        });
        threader.add(jDRunnable);
        threader.add(new JDRunnable(){
            {
            }

            public void go() throws Exception {
                ArrayList arrayList;
                Object object222;
                HashMap<RInfo, Integer> hashMap = new HashMap<RInfo, Integer>();
                int n = 0;
                Browser browser = new Browser();
                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                if (rInfo.getRouterHost() != null) {
                    linkedHashMap.put("RouterHost", rInfo.getRouterHost());
                }
                if (rInfo.getRouterHost() != null) {
                    linkedHashMap.put("RouterMAC", rInfo.getRouterMAC());
                }
                if (rInfo.getPageHeader() != null) {
                    linkedHashMap.put("PageHeader", SQLRouterData.replaceTimeStamps(rInfo.getPageHeader()));
                }
                if (rInfo.getRouterErrorPage() != null) {
                    linkedHashMap.put("RouterErrorPage", SQLRouterData.replaceTimeStamps(rInfo.getRouterErrorPage()));
                }
                linkedHashMap.put("HTMLTagCount", "" + rInfo.countHtmlTags());
                try {
                    GetRouterInfo.this.setProgressText(JDL.L("gui.config.routeripfinder.status.downloadlingsimilarmethods", "Downloading similar router methods..."));
                    GetRouterInfo.this.setProgress(45);
                    object222 = browser.postPage("http://service.jdownloader.org/routerdb/getRouters.php", linkedHashMap);
                    GetRouterInfo.this.setProgress(70);
                    arrayList = (ArrayList)JDUtilities.xmlStringToObjekt((String)object222);
                }
                catch (Exception exception) {
                    return;
                }
                if (arrayList != null) {
                    GetRouterInfo.this.setProgressText(JDL.L("gui.config.routeripfinder.status.sortingmethods", "Sorting router methods..."));
                    for (Object object222 : arrayList) {
                        if (((RInfo)object222).isHaveUpnpReconnect()) {
                            ++n;
                        }
                        if (((RInfo)object222).getReconnectMethodeClr() != null) {
                            Integer exception = ((RInfo)object222).compare(rInfo);
                            ((RInfo)object222).setIntegrety(200);
                            hashMap.put((RInfo)object222, exception);
                            continue;
                        }
                        if (((RInfo)object222).getReconnectMethode() == null) continue;
                        Integer n2 = ((RInfo)object222).compare(rInfo);
                        if (((RInfo)object222).getIntegrety() <= 3) continue;
                        hashMap.put((RInfo)object222, n2);
                    }
                }
                GetRouterInfo.this.setProgress(80);
                hashMap = GetRouterInfo.sortByIntegrety(hashMap);
                object222 = new HashMap();
                Iterator<Object> iterator = hashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    RInfo rInfo2 = (RInfo)((HashMap)object222).get(((RInfo)entry.getKey()).getReconnectMethode());
                    if (rInfo2 != null) {
                        rInfo2.setIntegrety(rInfo2.getIntegrety() + ((RInfo)entry.getKey()).getIntegrety());
                        iterator.remove();
                        continue;
                    }
                    ((HashMap)object222).put(((RInfo)entry.getKey()).getReconnectMethode(), (RInfo)entry.getKey());
                }
                hashMap = GetRouterInfo.sortByIntegrety(hashMap);
                if (n > 0) {
                    GetRouterInfo.this.setProgressText(JDL.L("gui.config.routeripfinder.status.searchingforupnp", "Searching for UPnP..."));
                    while (isalvs.isAlv) {
                        try {
                            this.wait();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                GetRouterInfo.this.setProgress(90);
                if (isalvs.meths != null) {
                    for (String string : isalvs.meths) {
                        RInfo rInfo3 = new RInfo();
                        rInfo3.setRouterHost(rInfo.getRouterHost());
                        rInfo3.setRouterIP(rInfo.getRouterIP());
                        rInfo3.setUPnPSCPDs(isalvs.SCPDs);
                        rInfo3.setReconnectMethode(string);
                        rInfo3.setRouterName("UPNP:" + rInfo3.getRouterName());
                        vector.add(rInfo3);
                    }
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    vector.add((RInfo)entry.getKey());
                }
                GetRouterInfo.this.setProgress(100);
            }
        });
        threader.startAndWait();
        return vector;
    }

    public RInfo getRouterData() {
        this.setProgressText(JDL.L("gui.config.routeripfinder.status.collectingrouterinfo", "Collecting router information..."));
        final RInfo rInfo = RouterInfoCollector.getRInfo(116);
        rInfo.setReconnectMethode(null);
        rInfo.setReconnectMethodeClr(null);
        this.th2 = new Threader();
        final class Isalvs {
            boolean isAlv = true;
            ArrayList<String> meths = null;
            HashMap<String, String> SCPDs = null;

            Isalvs() {
            }
        }
        final Isalvs isalvs = new Isalvs();
        final JDRunnable jDRunnable = new JDRunnable(){
            {
            }

            public void go() throws Exception {
                try {
                    UPnPInfo uPnPInfo = new UPnPInfo(InetAddress.getByName(rInfo.getRouterHost()));
                    if (uPnPInfo.met != null && uPnPInfo.met.size() != 0) {
                        isalvs.SCPDs = uPnPInfo.SCPDs;
                        isalvs.meths = uPnPInfo.met;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                isalvs.isAlv = false;
            }
        };
        Broadcaster broadcaster = this.th2.getBroadcaster();
        Threader threader = this.th2;
        threader.getClass();
        broadcaster.addListener((Object)new Threader.WorkerListener(threader){
            {
                super(threader);
            }

            public void onThreadException(Threader threader, JDRunnable jDRunnable2, Exception exception) {
            }

            public void onThreadFinished(Threader threader, JDRunnable jDRunnable2) {
                if (jDRunnable2 == jDRunnable) {
                    isalvs.isAlv = false;
                    GetRouterInfo.this.th2.notify();
                }
            }

            public void onThreadStarts(Threader threader, JDRunnable jDRunnable2) {
            }
        });
        this.th2.add(jDRunnable);
        this.th2.add(new JDRunnable(){
            {
            }

            public void go() throws Exception {
                try {
                    Serializable serializable;
                    Object object;
                    ArrayList arrayList;
                    Serializable serializable222;
                    LinkedHashMap<RInfo, Integer> linkedHashMap = new LinkedHashMap<RInfo, Integer>();
                    int n = 0;
                    Browser browser = new Browser();
                    LinkedHashMap<String, String> linkedHashMap2 = new LinkedHashMap<String, String>();
                    if (rInfo.getRouterHost() != null) {
                        linkedHashMap2.put("RouterHost", rInfo.getRouterHost());
                    }
                    if (rInfo.getRouterHost() != null) {
                        linkedHashMap2.put("RouterMAC", rInfo.getRouterMAC());
                    }
                    if (rInfo.getPageHeader() != null) {
                        linkedHashMap2.put("PageHeader", SQLRouterData.replaceTimeStamps(rInfo.getPageHeader()));
                    }
                    if (rInfo.getRouterErrorPage() != null) {
                        linkedHashMap2.put("RouterErrorPage", SQLRouterData.replaceTimeStamps(rInfo.getRouterErrorPage()));
                    }
                    linkedHashMap2.put("HTMLTagCount", "" + rInfo.countHtmlTags());
                    try {
                        GetRouterInfo.this.setProgressText(JDL.L("gui.config.routeripfinder.status.downloadlingsimilarmethods", "Downloading similar router methods..."));
                        serializable222 = browser.postPage("http://service.jdownloader.org/routerdb/getRouters.php", linkedHashMap2);
                        arrayList = (ArrayList)JDUtilities.xmlStringToObjekt((String)((Object)serializable222));
                    }
                    catch (Exception exception) {
                        return;
                    }
                    GetRouterInfo.this.setProgressText(JDL.L("gui.config.routeripfinder.status.sortingmethods", "Sorting router methods..."));
                    for (Serializable serializable222 : arrayList) {
                        if (((RInfo)serializable222).isHaveUpnpReconnect()) {
                            ++n;
                        }
                        if (((RInfo)serializable222).getReconnectMethodeClr() != null) {
                            object = ((RInfo)serializable222).compare(rInfo);
                            ((RInfo)serializable222).setIntegrety(200);
                            linkedHashMap.put((RInfo)serializable222, (Integer)object);
                            continue;
                        }
                        if (((RInfo)serializable222).getReconnectMethode() == null) continue;
                        object = ((RInfo)serializable222).compare(rInfo);
                        if (((RInfo)serializable222).getIntegrety() <= 3) continue;
                        linkedHashMap.put((RInfo)serializable222, (Integer)object);
                    }
                    linkedHashMap = GetRouterInfo.sortByIntegrety(linkedHashMap);
                    serializable222 = new HashMap<String, RInfo>();
                    Iterator<Object> iterator = linkedHashMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        object = (Map.Entry)iterator.next();
                        serializable = (RInfo)serializable222.get(((RInfo)object.getKey()).getReconnectMethode());
                        if (serializable != null) {
                            ((RInfo)serializable).setIntegrety(((RInfo)serializable).getIntegrety() + ((RInfo)object.getKey()).getIntegrety());
                            iterator.remove();
                            continue;
                        }
                        serializable222.put(((RInfo)object.getKey()).getReconnectMethode(), (RInfo)object.getKey());
                    }
                    linkedHashMap = GetRouterInfo.sortByIntegrety(linkedHashMap);
                    if (n > 0) {
                        while (isalvs.isAlv) {
                            try {
                                this.wait();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (isalvs.meths == null) {
                            UserIO.setCountdownTime((int)600);
                            int n2 = UserIO.getInstance().requestConfirmDialog(0, null, JDL.LF("gui.config.liveHeader.warning.upnpinactive", "Bitte aktivieren sie fals vorhanden Upnp in den Netzwerkeinstellungen ihres Routers <br><a href=\"http://%s\">zum Router</a><br><a href=\"http://wiki.jdownloader.org/index.php?title=Router_Upnp\">Wikiartikel: Upnp Routern</a><br>dr\u00fccken sie Ok wenn sie Upnp aktiviert haben oder abbrechen wenn sie fortfahren wollen!", rInfo.getRouterHost()), UserIO.getInstance().getIcon(1), null, null);
                            UserIO.setCountdownTime((int)-1);
                            if (JDFlags.hasAllFlags((int)n2, (int[])new int[]{2})) {
                                try {
                                    GetRouterInfo.this.setProgressText(JDL.L("gui.config.routeripfinder.status.testingupnp", "Testing UPnP..."));
                                    int n3 = 0;
                                    while (n3 < 30 && !GetRouterInfo.this.cancel) {
                                        GetRouterInfo.this.setProgress(n3++ * 100 / 30);
                                        UPnPInfo object2 = new UPnPInfo(InetAddress.getByName(rInfo.getRouterHost()), 10000L);
                                        if (object2.met != null) {
                                            rInfo.setUPnPSCPDs(object2.SCPDs);
                                            if (object2.met != null && object2.met.size() != 0) {
                                                isalvs.SCPDs = object2.SCPDs;
                                                isalvs.meths = object2.met;
                                            }
                                            break;
                                        }
                                        ++n3;
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    JDUtilities.getConfiguration().setProperty("HTTPSEND_IP", rInfo.getRouterHost());
                    RInfo rInfo3 = null;
                    if (isalvs.meths != null) {
                        serializable = new HashMap();
                        for (String string : isalvs.meths) {
                            RInfo rInfo2 = new RInfo();
                            rInfo2.setRouterHost(rInfo.getRouterHost());
                            rInfo2.setRouterIP(rInfo.getRouterIP());
                            rInfo2.setUPnPSCPDs(isalvs.SCPDs);
                            rInfo2.setReconnectMethode(string);
                            rInfo2.setRouterName("UPNP:" + rInfo2.getRouterName());
                            ((HashMap)serializable).put(rInfo2, 1);
                        }
                        rInfo3 = GetRouterInfo.this.checkrouters((HashMap)serializable);
                    }
                    if (rInfo3 == null) {
                        rInfo3 = GetRouterInfo.this.checkrouters(linkedHashMap);
                    }
                    GetRouterInfo.this.setProgress(100);
                    if (rInfo3 != null) {
                        rInfo.setRouterName(rInfo3.getRouterName());
                        rInfo.setReconnectMethode(rInfo3.getReconnectMethode());
                        rInfo.setReconnectMethodeClr(rInfo3.getReconnectMethodeClr());
                    }
                }
                catch (Exception exception) {
                    JDLogger.exception(exception);
                }
                GetRouterInfo.this.setProgress(100);
            }
        });
        this.th2.startAndWait();
        if (rInfo.getReconnectMethode() != null || rInfo.getReconnectMethodeClr() != null) {
            return rInfo;
        }
        return null;
    }

    private void setProgress(final int n) {
        new GuiRunnable<Object>(){

            public Object runSave() {
                if (GetRouterInfo.this.progressBar != null) {
                    GetRouterInfo.this.progressBar.setValue(n);
                } else {
                    GetRouterInfo.this.logger.info(String.valueOf(n) + "%");
                }
                return null;
            }
        }.start();
    }

    private void setProgressText(String string) {
        if (this.progressBar != null) {
            this.progressBar.setString(string);
            this.progressBar.setStringPainted(true);
        } else {
            this.logger.info(string);
        }
    }

    public static void autoConfig(final Object object, final Object object2, final Object object3, final Object object4) {
        final ProgressDialog progressDialog = new ProgressDialog(DummyFrame.getDialogParent(), JDL.L("gui.config.liveHeader.progress.message", "jDownloader sucht nach Ihren Routereinstellungen"), null, false, true);
        final GetRouterInfo getRouterInfo = new GetRouterInfo(progressDialog);
        final Thread thread = new Thread(){

            public void run() {
                RInfo rInfo;
                String string = "";
                String string2 = "";
                String string3 = null;
                if (object instanceof GUIConfigEntry) {
                    string = (String)((GUIConfigEntry)object).getText();
                    string2 = (String)((GUIConfigEntry)object2).getText();
                    string3 = (String)((GUIConfigEntry)object3).getText();
                } else if (object instanceof JTextField) {
                    string = ((JTextField)object).getText();
                    string2 = ((JTextField)object2).getText();
                    string3 = ((JTextField)object3).getText();
                }
                if (string3 != null && !string3.matches("\\s*")) {
                    JDUtilities.getConfiguration().getStringProperty("HTTPSEND_IP", string3);
                }
                if (string2 != null && !string2.matches("[\\s]*")) {
                    getRouterInfo.username = string2;
                }
                if (string != null && !string.matches("[\\s]*")) {
                    getRouterInfo.password = string;
                }
                if ((rInfo = getRouterInfo.getRouterData()) == null) {
                    progressDialog.setVisible(false);
                    progressDialog.dispose();
                    UserIO.getInstance().requestMessageDialog(JDL.L("gui.config.liveHeader.warning.notFound", "jDownloader konnte ihre Routereinstellung nicht automatisch ermitteln."));
                    return;
                }
                if (object4 != null && object4 instanceof GUIConfigEntry) {
                    ((GUIConfigEntry)object4).setData((Object)rInfo.getReconnectMethode());
                    JDUtilities.getConfiguration().setProperty("PARAM_HTTPSEND_ROUTERNAME", rInfo.getRouterName());
                }
                JDUtilities.getConfiguration().setProperty("PARAM_HTTPSEND_ROUTERNAME", rInfo.getRouterName());
                progressDialog.setVisible(false);
                progressDialog.dispose();
                UserIO.getInstance().requestMessageDialog(String.valueOf(JDL.L("gui.config.liveHeader.warning.yourRouter", "Sie haben einen")) + " " + rInfo.getRouterName());
            }
        };
        thread.start();
        progressDialog.setThread(thread);
        progressDialog.setVisible(true);
        new Thread(new Runnable(){

            public void run() {
                while (thread.isAlive()) {
                    try {
                        thread.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                getRouterInfo.cancel();
            }
        }).start();
    }

    public static void main(String[] stringArray) {
        Vector<RInfo> vector = new GetRouterInfo(null).getRouterInfos();
        System.out.println(vector.size());
        for (RInfo rInfo : vector) {
            System.out.println(rInfo.getRouterName());
            System.out.println("\r\n\r\n" + rInfo.getReconnectMethode());
        }
        System.exit(0);
    }
}

