/*
 * Decompiled with CFR 0.152.
 */
package jd.router.reconnectrecorder;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Vector;
import java.util.regex.Pattern;
import jd.config.SubConfiguration;
import jd.controlling.JDLogger;
import jd.nutils.encoding.Encoding;
import jd.parser.Regex;
import jd.router.reconnectrecorder.ProxyThread;
import jd.router.reconnectrecorder.ReconnectRecorder;
import jd.utils.JDHexUtils;
import jd.utils.JDUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static String readline(BufferedInputStream bufferedInputStream) {
        StringBuilder stringBuilder;
        block6: {
            stringBuilder = new StringBuilder("");
            bufferedInputStream.mark(1);
            if (bufferedInputStream.read() != -1) break block6;
            return null;
        }
        try {
            int n;
            bufferedInputStream.reset();
            while ((n = bufferedInputStream.read()) >= 0) {
                if (n == 0 || n == 10 || n == 13) break;
                stringBuilder.append((char)n);
            }
            if (n == 13) {
                bufferedInputStream.mark(1);
                if (bufferedInputStream.read() != 10) {
                    bufferedInputStream.reset();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    public static ByteBuffer readheader(InputStream inputStream) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4096);
        byte[] byArray = new byte[1];
        boolean bl = false;
        try {
            int n;
            while ((n = inputStream.read(byArray)) >= 0) {
                if (byteBuffer.remaining() < 1) {
                    ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(byteBuffer.capacity() * 2);
                    byteBuffer.flip();
                    byteBuffer2.put(byteBuffer);
                    byteBuffer = byteBuffer2;
                }
                if (n > 0) {
                    byteBuffer.put(byArray);
                }
                if (byteBuffer.position() < 4) continue;
                int n2 = byteBuffer.position();
                bl = byteBuffer.get(n2 - 4) == 13;
                bl &= byteBuffer.get(n2 - 3) == 10;
                bl &= byteBuffer.get(n2 - 2) == 13;
                if (!(bl &= byteBuffer.get(n2 - 1) == 10)) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    public static InputStream newInputStream(final ByteBuffer byteBuffer) {
        return new InputStream(){

            public synchronized int read() throws IOException {
                if (!byteBuffer.hasRemaining()) {
                    return -1;
                }
                return byteBuffer.get();
            }

            public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
                if (!byteBuffer.hasRemaining()) {
                    return -1;
                }
                n2 = Math.min(n2, byteBuffer.remaining());
                byteBuffer.get(byArray, n, n2);
                return n2;
            }
        };
    }

    public static void createStep(LinkedHashMap<String, String> linkedHashMap, String string, Vector<String> vector, boolean bl, boolean bl2) {
        if (!new Regex(linkedHashMap.get(null), ".*?\\.(gif|jpg|png|bmp|ico|css).*?").matches()) {
            String string2 = "";
            String string3 = "";
            if (bl) {
                string2 = " https=\"true\"";
            }
            if (bl2) {
                string3 = " raw=\"true\"";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("    [[[STEP]]]\r\n");
            stringBuilder.append("        [[[REQUEST" + string2 + string3 + "]]]" + "\r\n");
            if (bl2) {
                for (String string4 : linkedHashMap.keySet()) {
                    if (string4 != null && string4.equalsIgnoreCase("referer")) continue;
                    if (string4 != null && string4.equalsIgnoreCase("host")) {
                        stringBuilder.append("        Host: %%%routerip%%%\r\n");
                        continue;
                    }
                    if (string4 == null) {
                        stringBuilder.append("        " + linkedHashMap.get(null) + "\r\n");
                        continue;
                    }
                    stringBuilder.append("        " + string4 + ": " + linkedHashMap.get(string4) + "\r\n");
                }
            } else {
                stringBuilder.append("        " + linkedHashMap.get(null) + "\r\n");
                stringBuilder.append("        Host: %%%routerip%%%\r\n");
                if (linkedHashMap.containsKey("authorization")) {
                    String string5 = new Regex(linkedHashMap.get("authorization"), "Basic (.+)").getMatch(0);
                    if (string5 != null) {
                        ReconnectRecorder.auth = Encoding.Base64Decode((String)string5.trim());
                    }
                    stringBuilder.append("        Authorization: Basic %%%basicauth%%%\r\n");
                }
            }
            if (linkedHashMap.get(null).contains("POST") && string != null) {
                stringBuilder.append("\r\n");
                stringBuilder.append(string.trim());
                stringBuilder.append("\r\n");
            }
            stringBuilder.append("        [[[/REQUEST]]]\r\n");
            stringBuilder.append("    [[[/STEP]]]\r\n");
            vector.add(stringBuilder.toString());
        }
    }

    public static void rewriteLocationHeader(ProxyThread proxyThread) {
        String string = JDHexUtils.toString(new Regex(proxyThread.buffer, Pattern.compile(String.valueOf(JDHexUtils.getHexString("Location: ")) + "(.*?)" + JDHexUtils.REGEX_HTTP_NEWLINE, 34)).getMatch(0));
        if (string != null && new Regex(string, "https?://(.*?)/?").getMatch(0) != null) {
            String string2 = string;
            string = new Regex(string, "https?://.*?/(.+)", 32).getMatch(0);
            string = !string2.startsWith("https") ? (string != null ? "http://localhost:" + SubConfiguration.getConfig("ReconnectRecorder").getIntegerProperty("PARAM_PORT", 8972) + "/" + string : "http://localhost:" + SubConfiguration.getConfig("ReconnectRecorder").getIntegerProperty("PARAM_PORT", 8972) + "/") : (string != null ? "https://localhost:" + SubConfiguration.getConfig("ReconnectRecorder").getIntegerProperty("PARAM_PORT", 8972) + "/" + string : "https://localhost:" + (SubConfiguration.getConfig("ReconnectRecorder").getIntegerProperty("PARAM_PORT", 8972) + 1) + "/");
            proxyThread.buffer = proxyThread.buffer.replaceAll(JDHexUtils.getHexString("Location: " + string2), JDHexUtils.getHexString("Location: " + string));
            proxyThread.renewbuffer = true;
        }
    }

    public static void rewriteHostHeader(ProxyThread proxyThread) {
        String string = JDHexUtils.toString(new Regex(proxyThread.buffer, Pattern.compile(String.valueOf(JDHexUtils.getHexString("Host: ")) + "(.*?)" + JDHexUtils.REGEX_HTTP_NEWLINE, 34)).getMatch(0));
        if (string != null && new Regex(string, "(.*?):?").getMatch(0) != null) {
            String string2 = string;
            string = JDUtilities.getConfiguration().getStringProperty("HTTPSEND_IP", null);
            proxyThread.buffer = proxyThread.buffer.replaceAll(JDHexUtils.getHexString("Host: " + string2), JDHexUtils.getHexString("Host: " + string));
            proxyThread.renewbuffer = true;
        }
    }

    public static void rewriteConnectionHeader(ProxyThread proxyThread) {
        String string;
        String string2 = JDHexUtils.toString(new Regex(proxyThread.buffer, Pattern.compile(String.valueOf(JDHexUtils.getHexString("Connection: ")) + "(.*?)" + JDHexUtils.REGEX_HTTP_NEWLINE, 34)).getMatch(0));
        if (string2 != null && (string = new Regex(string2, "(.+)").getMatch(0)) != null && !string.equalsIgnoreCase("close")) {
            String string3 = string2;
            string2 = "close";
            proxyThread.buffer = proxyThread.buffer.replaceAll(JDHexUtils.getHexString("Connection: " + string3), JDHexUtils.getHexString("Connection: " + string2));
            proxyThread.renewbuffer = true;
        }
    }

    public static void rewriteRefererHeader(ProxyThread proxyThread) {
        String string = JDHexUtils.toString(new Regex(proxyThread.buffer, Pattern.compile(String.valueOf(JDHexUtils.getHexString("Referer: ")) + "(.*?)" + JDHexUtils.REGEX_HTTP_NEWLINE, 34)).getMatch(0));
        if (string != null && new Regex(string, "https?://(.*?)/?").getMatch(0) != null) {
            String string2 = string;
            String string3 = new Regex(string, "https?://.*?/(.+)", 32).getMatch(0);
            string = !string2.startsWith("https") ? (string3 != null ? "http://" + JDUtilities.getConfiguration().getStringProperty("HTTPSEND_IP", null) + "/" + string3.trim() : (new Regex(string, "https?://.*?/", 32).matches() ? "http://" + JDUtilities.getConfiguration().getStringProperty("HTTPSEND_IP", null) + "/" : "http://" + JDUtilities.getConfiguration().getStringProperty("HTTPSEND_IP", null))) : (string3 != null ? "https://" + JDUtilities.getConfiguration().getStringProperty("HTTPSEND_IP", null) + "/" + string3.trim() : (new Regex(string, "https?://.*?/", 32).matches() ? "https://" + JDUtilities.getConfiguration().getStringProperty("HTTPSEND_IP", null) + "/" : "https://" + JDUtilities.getConfiguration().getStringProperty("HTTPSEND_IP", null)));
            proxyThread.buffer = proxyThread.buffer.replaceAll(JDHexUtils.getHexString("Referer: " + string2), JDHexUtils.getHexString("Referer: " + string));
            proxyThread.renewbuffer = true;
        }
    }
}

