/*
 * Decompiled with CFR 0.152.
 */
package jd.update;

import java.io.File;
import java.util.ArrayList;
import jd.event.JDBroadcaster;
import jd.event.MessageEvent;
import jd.event.MessageListener;
import jd.http.Browser;
import jd.http.URLConnectionAdapter;
import jd.nutils.JDHash;
import jd.parser.Regex;
import jd.update.Server;
import jd.utils.JDUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUpdate {
    public static final int DOWNLOAD_SOURCE = 1;
    public static final int ERROR = 2;
    public static final int SERVER_STATS = 3;
    public static final int SUCCESS = 4;
    public static long WAITTIME_ON_ERROR = 15000L;
    private String localPath;
    private String url;
    private String hash;
    private ArrayList<Server> serverList;
    private Server currentServer;
    private String relURL;
    private File workingDir;
    private JDBroadcaster<MessageListener, MessageEvent> broadcaster;

    public FileUpdate(String string, String string2) {
        this.hash = string2;
        string = string.replace("http://78.143.20.68/update/jd/", "");
        String[] stringArray = new Regex(string, "(.*)\\?(.*)").getRow(0);
        this.relURL = string;
        if (stringArray == null) {
            this.localPath = string;
        } else {
            this.localPath = stringArray[0];
            this.url = stringArray[1];
        }
        this.initBroadcaster();
    }

    public FileUpdate(String string, String string2, File file) {
        this(string, string2);
        this.workingDir = file;
        this.relURL = string;
        this.initBroadcaster();
    }

    private void initBroadcaster() {
        this.broadcaster = new JDBroadcaster<MessageListener, MessageEvent>(){

            @Override
            protected void fireEvent(MessageListener messageListener, MessageEvent messageEvent) {
                messageListener.onMessage(messageEvent);
            }
        };
    }

    public JDBroadcaster<MessageListener, MessageEvent> getBroadcaster() {
        return this.broadcaster;
    }

    public String toString() {
        return this.localPath;
    }

    public String getRelURL() {
        return this.relURL;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public String getRawUrl() {
        return this.url;
    }

    public String getRemoteHash() {
        return this.hash;
    }

    public boolean exists() {
        return this.getLocalFile().exists() || this.getLocalTmpFile().exists();
    }

    public boolean equals() {
        if (!this.exists()) {
            return false;
        }
        String string = this.getLocalHash();
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase(this.hash);
    }

    private String getLocalHash() {
        if (this.getLocalTmpFile().exists()) {
            return JDHash.getMD5((File)this.getLocalTmpFile());
        }
        return JDHash.getMD5((File)this.getLocalFile());
    }

    public File getLocalFile() {
        if (this.workingDir != null) {
            return new File(this.workingDir + this.getLocalPath());
        }
        return JDUtilities.getResourceFile(this.getLocalPath());
    }

    public void reset(ArrayList<Server> arrayList) {
        this.serverList = new ArrayList();
        this.serverList.addAll(arrayList);
    }

    public boolean hasServer() {
        return this.serverList.size() > 0;
    }

    public boolean update(ArrayList<Server> arrayList) {
        Browser browser = new Browser();
        browser.setReadTimeout(20000);
        browser.setConnectTimeout(10000);
        int n = 0;
        while (n < 3) {
            if (arrayList == null || arrayList.size() == 0) {
                System.err.println("no downloadsource available!");
                return false;
            }
            this.reset(arrayList);
            while (this.hasServer()) {
                String string = this.getURL();
                File file = this.workingDir != null ? new File(this.workingDir + this.getLocalPath() + ".tmp") : JDUtilities.getResourceFile(String.valueOf(this.getLocalPath()) + ".tmp");
                file.delete();
                File file2 = this.getLocalTmpFile();
                if (file2.exists() && JDHash.getMD5((File)file2).equals(this.hash)) {
                    return true;
                }
                this.getLocalTmpFile().delete();
                string = string.contains("?") ? String.valueOf(string) + "&r=" + System.currentTimeMillis() : String.valueOf(string) + "?r=" + System.currentTimeMillis();
                this.broadcaster.fireEvent(new MessageEvent((Object)this, 1, "Downloadsource: " + string));
                long l = System.currentTimeMillis();
                Object object = null;
                int n2 = -1;
                try {
                    object = browser.openGetConnection(string);
                    long l2 = System.currentTimeMillis();
                    n2 = object.getResponseCode();
                    this.currentServer.setRequestTime(l2 - l);
                }
                catch (Exception exception) {
                    this.broadcaster.fireEvent(new MessageEvent((Object)this, 2, "Error. Connection error"));
                    this.currentServer.setRequestTime(100000L);
                    try {
                        object.disconnect();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    this.errorWait();
                    continue;
                }
                if (n2 != 200) {
                    this.broadcaster.fireEvent(new MessageEvent((Object)this, 2, "Error. Connection error " + (int)n2));
                    this.currentServer.setRequestTime(500000L);
                    try {
                        object.disconnect();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.errorWait();
                    continue;
                }
                try {
                    Browser.download((File)file, (URLConnectionAdapter)object);
                }
                catch (Exception exception) {
                    this.broadcaster.fireEvent(new MessageEvent((Object)this, 2, "Error. Connection broken"));
                    this.currentServer.setRequestTime(100000L);
                    try {
                        object.disconnect();
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                    this.errorWait();
                    continue;
                }
                try {
                    object.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.broadcaster.fireEvent(new MessageEvent((Object)this, 3, this.currentServer + " requesttimeAVG=" + this.currentServer.getRequestTime()));
                object = JDHash.getMD5((File)file);
                if (object != null && ((String)object).equalsIgnoreCase(this.hash)) {
                    this.broadcaster.fireEvent(new MessageEvent((Object)this, 4, "Hash OK"));
                    this.getLocalTmpFile().delete();
                    if (file.getName().startsWith("tinyupdate")) {
                        this.getLocalFile().delete();
                        n2 = file.renameTo(this.getLocalFile()) ? 1 : 0;
                    } else {
                        n2 = file.renameTo(this.getLocalTmpFile()) ? 1 : 0;
                    }
                    if (n2) {
                        return n2;
                    }
                    this.getLocalTmpFile().getParentFile().mkdirs();
                    n2 = file.renameTo(this.getLocalTmpFile());
                    if (!n2) {
                        this.broadcaster.fireEvent(new MessageEvent((Object)this, 2, "Error. Rename failed"));
                        this.errorWait();
                        continue;
                    }
                    return n2;
                }
                this.broadcaster.fireEvent(new MessageEvent((Object)this, 2, "Hash Failed"));
                this.currentServer.setRequestTime(100000L);
                if (this.hasServer()) {
                    this.broadcaster.fireEvent(new MessageEvent((Object)this, 2, "Error. Retry"));
                } else {
                    this.broadcaster.fireEvent(new MessageEvent((Object)this, 2, "Error. Updateserver down"));
                }
                file.delete();
                this.errorWait();
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n;
        }
        return false;
    }

    private void errorWait() {
        try {
            this.broadcaster.fireEvent(new MessageEvent((Object)this, 2, "Server Busy. Wait " + WAITTIME_ON_ERROR / 1000L + " Seconds"));
            Thread.sleep(WAITTIME_ON_ERROR);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public File getLocalTmpFile() {
        if (this.workingDir != null) {
            return new File(new File(this.workingDir, "update") + this.getLocalPath());
        }
        return new File(JDUtilities.getResourceFile("update") + this.getLocalPath());
    }

    private String mergeUrl(String string, String string2) {
        String string3 = "";
        string3 = string.endsWith("/") || string2.startsWith("/") ? String.valueOf(string) + string2 : String.valueOf(string) + "/" + string2;
        string3 = string3.replaceAll("//", "/");
        return string3.replaceAll("http:/", "http://");
    }

    private String getURL() {
        Server server;
        if (this.url == null || this.url.trim().length() == 0) {
            Server server2;
            this.currentServer = server2 = Server.selectServer(this.serverList);
            this.serverList.remove(server2);
            return this.mergeUrl(server2.getPath(), this.relURL);
        }
        if (this.url.toLowerCase().startsWith("http://")) {
            return this.url;
        }
        this.currentServer = server = Server.selectServer(this.serverList);
        this.serverList.remove(server);
        return this.mergeUrl(server.getPath(), this.url);
    }

    public boolean needsRestart() {
        String string = JDHash.getMD5((File)this.getLocalTmpFile());
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase(string);
    }
}

