/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import jd.config.CFGConfig;
import jd.http.Browser;
import jd.nutils.JDHash;
import jd.nutils.SimpleFTP;
import jd.nutils.io.JDIO;
import jd.nutils.svn.Subversion;
import jd.nutils.zip.Zip;
import jd.parser.Regex;
import jd.update.WebUpdater;
import jd.utils.JDUtilities;
import jd.utils.RSYNCServer;
import org.tmatesoft.svn.core.SVNException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Updater {
    private File pluginsDir;
    private File workingDir = new File(".").getCanonicalFile();
    private JFrame frame;
    private static String UPDATE_SUB_DIR = "exclude_jd_update";
    private File updateDir = new File(this.workingDir, UPDATE_SUB_DIR);
    private File jars;
    private ArrayList<File> packedFiles;
    public static final String BRANCH = "NIGHTLY";
    public static ArrayList<Server> SERVERLIST = new ArrayList();
    public static Server UPDATE0 = new RSYNCServer(-1, "http://update0.jdownloader.org/branches/NIGHTLY/", "update0.jdownloader.org", 2121, "/home/www/update/http/branches/NIGHTLY/", false);
    public static Server UPDATE1 = new RSYNCServer(-1, "http://update1.jdownloader.org/branches/NIGHTLY/", "update1.jdownloader.org", 2121, "/home/www/update/http/branches/NIGHTLY/", false);
    public static Server UPDATE2 = new RSYNCServer(-1, "http://update2.jdownloader.org/branches/NIGHTLY/", "update2.jdownloader.org", 2121, "/home/www/update/http/branches/NIGHTLY/", false);

    static {
        SERVERLIST.add(UPDATE0);
        SERVERLIST.add(UPDATE2);
        SERVERLIST.add(UPDATE1);
        SERVERLIST.add(new RSYNCServer(-1, "http://update4ex.jdownloader.org/branches/NIGHTLY/", "rsync://update4ex.jdownloader.org", 0, "/jd-mirror/branches/NIGHTLY/", false));
    }

    public static void main(String[] stringArray) throws Exception {
        Browser.setGlobalConnectTimeout((int)500000);
        Browser.setGlobalReadTimeout((int)500000);
        Updater updater = new Updater();
        WebUpdater.getConfig("WEBUPDATE").save();
        System.out.println("STATUS: move plugins");
        updater.movePlugins(Updater.getCFG("plugins_dir"));
        updater.moveJars(Updater.getCFG("dist_dir"));
        updater.removeFileOverhead();
        updater.cleanUp();
        JOptionPane.showConfirmDialog(updater.frame, "Check " + updater.updateDir + " and remove files you do NOT want to update.");
        updater.merge();
        updater.pack();
        ArrayList<File> arrayList = updater.getLocalFileList(updater.workingDir, false);
        arrayList.remove(0);
        for (Server server : SERVERLIST) {
            if (server.isManuelUpload()) continue;
            updater.upload(arrayList, server);
        }
        updater.uploadHashList();
        for (Server server : SERVERLIST) {
            if (!server.isManuelUpload()) continue;
            System.err.println("Upload files to: ftp://" + server.getUser() + ":" + server.getPass() + "@" + server.getIp() + ":" + server.getPort() + server.getFTPPath());
        }
        System.exit(0);
    }

    private void pack() {
        this.packedFiles = new ArrayList();
        if (this.ask("Update Captchamethods ?")) {
            this.packedFiles.addAll(this.pack(new File(this.workingDir, "jd/captcha")));
        }
        if (this.ask("Update Routerscripts ?")) {
            this.packedFiles.addAll(this.pack(new File(this.workingDir, "jd/router")));
        }
        if (this.ask("Update Images ?")) {
            this.packedFiles.addAll(this.pack(new File(this.workingDir, "jd/img")));
        }
        if (this.ask("Update Licenses ?")) {
            this.packedFiles.addAll(this.pack(new File(this.workingDir, "licenses")));
        }
        if (this.ask("Update languages ?")) {
            this.packedFiles.addAll(this.pack(new File(this.workingDir, "jd/languages")));
        }
        JDIO.FileSelector fileSelector = new JDIO.FileSelector(){

            public boolean doIt(File file) {
                return !file.getName().endsWith(".extract");
            }
        };
        JDIO.removeRekursive((File)new File(this.workingDir, "jd/captcha"), (JDIO.FileSelector)fileSelector);
        JDIO.removeRekursive((File)new File(this.workingDir, "jd/router"), (JDIO.FileSelector)fileSelector);
        JDIO.removeRekursive((File)new File(this.workingDir, "jd/img"), (JDIO.FileSelector)fileSelector);
        JDIO.removeRekursive((File)new File(this.workingDir, "licenses"), (JDIO.FileSelector)fileSelector);
        JDIO.removeRekursive((File)new File(this.workingDir, "jd/languages"), (JDIO.FileSelector)fileSelector);
    }

    private boolean ask(String string) {
        return JOptionPane.showConfirmDialog(this.frame, string) == 0;
    }

    private void cleanUp() {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3 = stringArray2 = Regex.getLines(JDIO.readFileToString((File)new File(this.workingDir, "outdated.dat")));
        int n = stringArray2.length;
        int n2 = 0;
        while (n2 < n) {
            stringArray = stringArray3[n2];
            if (stringArray.trim().length() != 0) {
                if (new File(this.workingDir, (String)stringArray).exists()) {
                    JDIO.removeDirectoryOrFile((File)new File(this.workingDir, (String)stringArray));
                    System.err.println(" CLEAN UP: " + new File(this.workingDir, (String)stringArray).getAbsolutePath());
                }
                if (new File(this.updateDir, (String)stringArray).exists()) {
                    JDIO.removeDirectoryOrFile((File)new File(this.updateDir, (String)stringArray));
                    System.err.println(" CLEAN UP: " + new File(this.updateDir, (String)stringArray).getAbsolutePath());
                }
            }
            ++n2;
        }
        String[] stringArray4 = stringArray = new String[]{"windows_createlog.bat~", ".junique", "info.txt", "jd/img/default/flags", "plugins/JDPremium.jar", "tools/Windows/recycle.exe", "tools/Windows/recycle.cpp", "jd/img/screenshots", "jd/img/synthetica", "updateLog.txt", "jdupdate.jar"};
        int n3 = stringArray.length;
        n = 0;
        while (n < n3) {
            String string = stringArray4[n];
            if (new File(this.workingDir, string).exists()) {
                JDIO.removeDirectoryOrFile((File)new File(this.workingDir, string));
                System.err.println(" CLEAN UP: " + new File(this.workingDir, string).getAbsolutePath());
            }
            if (new File(this.updateDir, string).exists()) {
                JDIO.removeDirectoryOrFile((File)new File(this.updateDir, string));
                System.err.println(" CLEAN UP: " + new File(this.updateDir, string).getAbsolutePath());
            }
            ++n;
        }
    }

    public Updater() throws IOException, SVNException {
        this.updateDir.mkdirs();
        this.initGUI();
    }

    public static String getCFG(String string) {
        CFGConfig cFGConfig = CFGConfig.getConfig("LOCALCONFIG");
        String string2 = cFGConfig.getStringProperty(string);
        if (string2 == null) {
            JFrame jFrame = new JFrame();
            jFrame.setAlwaysOnTop(true);
            jFrame.setVisible(true);
            string2 = JOptionPane.showInputDialog(jFrame, (Object)("get Config: " + string));
            cFGConfig.setProperty(string, string2);
            cFGConfig.save();
        }
        return string2;
    }

    private void moveJars(String string) throws IOException {
        Object object;
        this.jars = new File(string);
        boolean bl = false;
        if (this.ask("Update Binaries (jars)?")) {
            bl = true;
            this.copyDirectory(new File(this.jars, "libs"), new File(this.updateDir, "libs"));
        }
        if (bl) {
            this.copyFile(new File(this.jars, "JDownloader.jar"), new File(this.updateDir, "JDownloader.jar"));
        }
        if (this.ask("Update Version number?")) {
            try {
                object = new Subversion("svn://svn.jdownloader.org/jdownloader");
                long l = object.latestRevision();
                new File(this.updateDir, "config").mkdirs();
                JDIO.saveToFile((File)new File(this.updateDir, "config/version.cfg"), (byte[])String.valueOf(l).getBytes());
            }
            catch (SVNException sVNException) {
                sVNException.printStackTrace();
            }
        }
        if (bl) {
            this.copyFile(new File(this.jars, "tinyupdate.jar"), new File(this.updateDir, "tools/tinyupdate.jar"));
        }
        this.copyFile(new File(this.jars.getParentFile(), "ressourcen/outdated.dat"), new File(this.updateDir, "outdated.dat"));
        if (this.ask("Update Addons ?")) {
            File[] fileArray = new File(this.jars.getParentFile(), "ressourcen/pluginressourcen").listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = fileArray[n2];
                this.copyDirectory((File)object, this.updateDir);
                ++n2;
            }
            fileArray = new File(this.jars, "pluginressourcen").listFiles();
            n = fileArray.length;
            n2 = 0;
            while (n2 < n) {
                object = fileArray[n2];
                this.copyDirectory((File)object, this.updateDir);
                ++n2;
            }
        }
        this.copyDirectory(new File(this.jars.getParentFile(), "ressourcen/licenses"), new File(this.updateDir, "licenses"));
        this.copyDirectory(new File(this.jars.getParentFile(), "ressourcen/jd"), new File(this.updateDir, "jd"));
        this.copyDirectory(new File(this.jars.getParentFile(), "ressourcen/tools"), new File(this.updateDir, "tools"));
        if (bl) {
            this.copyDirectory(new File(this.jars.getParentFile(), "ressourcen/libs"), new File(this.updateDir, "libs"));
        }
    }

    private ArrayList<File> pack(File file) {
        new File(file, String.valueOf(file.getName()) + ".extract").delete();
        Zip zip = new Zip(file.listFiles(), new File(file, String.valueOf(file.getName()) + ".extract"));
        zip.setDeleteAfterPack(true);
        zip.setExcludeFilter(Pattern.compile(".+/.extract", 2));
        try {
            return zip.zip();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void uploadHashList() throws Exception {
        LinkedHashMap<String, String> linkedHashMap = this.createHashList(this.workingDir);
        Browser browser = new Browser();
        browser.forceDebug(true);
        String string = this.createServerList();
        File file = new File("NIGHTLY_server.list");
        JDIO.writeLocalFile((File)file, (String)string);
        SimpleFTP.upload((String)UPDATE0.getIp(), (int)UPDATE0.getPort(), (String)UPDATE0.getUser(), (String)UPDATE0.getPass(), (String)"/http/", (File[])new File[]{file});
        SimpleFTP.upload((String)UPDATE1.getIp(), (int)UPDATE1.getPort(), (String)UPDATE1.getUser(), (String)UPDATE1.getPass(), (String)"/http/", (File[])new File[]{file});
        SimpleFTP.upload((String)UPDATE2.getIp(), (int)UPDATE2.getPort(), (String)UPDATE2.getUser(), (String)UPDATE2.getPass(), (String)"/http/", (File[])new File[]{file});
        file.delete();
        String string2 = browser.postPage("http://update1.jdownloader.org/update.php?pass=" + Updater.getCFG("updateHashPW2") + "&branch=" + BRANCH, linkedHashMap);
        file = new File("hashlist.lst");
        JDIO.writeLocalFile((File)file, (String)string2);
        Zip zip = new Zip(file, new File("NIGHTLY_update.zip"));
        zip.setDeleteAfterPack(true);
        try {
            zip.zip();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JDIO.writeLocalFile((File)new File("NIGHTLY_update.md5"), (String)JDHash.getMD5((File)new File("NIGHTLY_update.zip")));
        SimpleFTP.upload((String)UPDATE0.getIp(), (int)UPDATE0.getPort(), (String)UPDATE0.getUser(), (String)UPDATE0.getPass(), (String)"/http/", (File[])new File[]{new File("NIGHTLY_update.zip")});
        SimpleFTP.upload((String)UPDATE1.getIp(), (int)UPDATE1.getPort(), (String)UPDATE1.getUser(), (String)UPDATE1.getPass(), (String)"/http/", (File[])new File[]{new File("NIGHTLY_update.zip")});
        SimpleFTP.upload((String)UPDATE2.getIp(), (int)UPDATE2.getPort(), (String)UPDATE2.getUser(), (String)UPDATE2.getPass(), (String)"/http/", (File[])new File[]{new File("NIGHTLY_update.zip")});
        SimpleFTP.upload((String)UPDATE0.getIp(), (int)UPDATE0.getPort(), (String)UPDATE0.getUser(), (String)UPDATE0.getPass(), (String)"/http/", (File[])new File[]{new File("NIGHTLY_update.md5")});
        SimpleFTP.upload((String)UPDATE1.getIp(), (int)UPDATE1.getPort(), (String)UPDATE1.getUser(), (String)UPDATE1.getPass(), (String)"/http/", (File[])new File[]{new File("NIGHTLY_update.md5")});
        SimpleFTP.upload((String)UPDATE2.getIp(), (int)UPDATE2.getPort(), (String)UPDATE2.getUser(), (String)UPDATE2.getPass(), (String)"/http/", (File[])new File[]{new File("NIGHTLY_update.md5")});
        new File("NIGHTLY_update.md5").delete();
        new File("NIGHTLY_update.zip").delete();
    }

    private String createServerList() {
        String string = "";
        for (Server server : SERVERLIST) {
            string = String.valueOf(string) + server.getPriority() + ":" + server.getHttppath() + "\r\n";
        }
        return string.trim();
    }

    private LinkedHashMap<String, String> createHashList(File file) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        ArrayList<File> arrayList = this.getLocalFileList(file, false);
        for (File file2 : arrayList) {
            String string = file2.getAbsolutePath().replace(file.getAbsolutePath(), "");
            if ((string = string.replace("/", "/")).trim().length() == 0 || file2.isDirectory() || file2.getName().startsWith(".") || file2.getName().endsWith("~")) continue;
            String string2 = JDHash.getMD5((File)file2);
            int n = 1;
            String string3 = string2;
            while (linkedHashMap.containsKey(string3)) {
                string3 = String.valueOf(string2) + "_" + n;
                ++n;
            }
            linkedHashMap.put(string3, string);
        }
        return linkedHashMap;
    }

    private void merge() throws IOException {
        this.copyDirectory(this.updateDir, this.workingDir);
        JDIO.removeDirectoryOrFile((File)this.updateDir);
    }

    private boolean upload(ArrayList<File> arrayList, Server server) throws IOException {
        if (server instanceof RSYNCServer) {
            if (server.getIp().startsWith("rsync://")) {
                System.out.println(JDUtilities.runCommand("rsync", new String[]{"-c", "-av", String.valueOf(this.workingDir.getAbsolutePath()) + "/", String.valueOf(server.getIp()) + server.getFTPPath()}, null, 999999));
            } else {
                System.out.println(JDUtilities.runCommand("rsync", new String[]{"-c", "-av", String.valueOf(this.workingDir.getAbsolutePath()) + "/", "-e", "ssh -p 31261", String.valueOf(Updater.getCFG(this + "_rsync_user3")) + "@" + server.getIp() + ":" + server.getFTPPath()}, null, 999999));
            }
        } else {
            SimpleFTP.uploadSecure((String)server.getIp(), (int)server.getPort(), (String)server.getUser(), (String)server.getPass(), (String)server.getFTPPath(), (File)this.workingDir, (File[])arrayList.toArray(new File[0]));
        }
        return true;
    }

    private void movePlugins(String string) throws IOException {
        if (!this.ask("Update plugins?")) {
            return;
        }
        if (string == null) {
            return;
        }
        this.pluginsDir = new File(string);
        File file = new File(this.updateDir, "jd/plugins/hoster");
        JDIO.removeDirectoryOrFile((File)file);
        this.copyDirectory(new File(this.pluginsDir, "hoster"), file);
        System.out.println("Updated BIN->" + file);
        file = new File(this.updateDir, "jd/plugins/decrypter");
        JDIO.removeDirectoryOrFile((File)file);
        this.copyDirectory(new File(this.pluginsDir, "decrypter"), file);
        System.out.println("Updated BIN->" + file);
        file = new File(this.updateDir, "jd/dynamics");
        JDIO.removeDirectoryOrFile((File)file);
        this.copyDirectory(new File(this.pluginsDir.getParentFile(), "dynamics"), file);
        System.out.println("Updated BIN->" + file);
    }

    public void copyDirectory(File file, File file2) throws IOException {
        if (file.getAbsolutePath().contains(".svn")) {
            return;
        }
        if (file.isDirectory()) {
            String[] stringArray;
            if (!file2.exists()) {
                System.out.println("Create Dir" + file2);
                file2.mkdir();
            }
            String[] stringArray2 = stringArray = file.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                this.copyDirectory(new File(file, string), new File(file2, string));
                ++n2;
            }
        } else {
            this.copyFile(file, file2);
        }
    }

    private void copyFile(File file, File file2) throws IOException {
        String string = JDHash.getMD5((File)file2);
        String string2 = JDHash.getMD5((File)file);
        if (file.getAbsolutePath().contains(".svn")) {
            return;
        }
        if (!file.exists()) {
            System.out.println("File or directory does not exist.");
            System.exit(0);
        } else {
            int n;
            if (string2.equalsIgnoreCase(string)) {
                return;
            }
            if (file2.exists()) {
                file2.delete();
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            file2.getParentFile().mkdirs();
            file2.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
            System.out.println("        Copy File " + file + " -> " + file2);
        }
    }

    private void removeFileOverhead() throws Exception {
        ArrayList<File> arrayList = this.getLocalFileList(this.workingDir, false);
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList arrayList2 = new ArrayList();
        File file = new File(this.updateDir, "/tmp/");
        JDIO.removeDirectoryOrFile((File)file);
        file.mkdirs();
        file = new File(this.updateDir, "/config/");
        file.mkdirs();
        file = new File(this.updateDir, "/backup/");
        JDIO.removeDirectoryOrFile((File)file);
        file.mkdirs();
        file = new File(this.workingDir, "/tmp/");
        JDIO.removeDirectoryOrFile((File)file);
        file.mkdirs();
        file = new File(this.workingDir, "/config/");
        file.mkdirs();
        JDIO.removeRekursive((File)file, (JDIO.FileSelector)new JDIO.FileSelector(){

            public boolean doIt(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return !file.getName().endsWith("version.cfg");
            }
        });
        file = new File(this.workingDir, "/backup/");
        JDIO.removeDirectoryOrFile((File)file);
        file.mkdirs();
    }

    private void initGUI() {
        this.frame = new JFrame();
        this.frame.setTitle("Updater");
        this.frame.setAlwaysOnTop(true);
        this.frame.setVisible(true);
    }

    private ArrayList<File> getLocalFileList(File file, boolean bl) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (!bl && (file.getAbsolutePath().contains("addonlist.lst") || file.getAbsolutePath().contains(UPDATE_SUB_DIR))) {
            return arrayList;
        }
        arrayList.add(file);
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray[n2];
            if (file2.isDirectory()) {
                arrayList.addAll(this.getLocalFileList(file2, bl));
            } else if (bl || !file2.getAbsolutePath().contains("addonlist.lst") && !file2.getAbsolutePath().contains(UPDATE_SUB_DIR)) {
                arrayList.add(file2);
            }
            ++n2;
        }
        return arrayList;
    }

    static class Server {
        private int priority;
        private String ftpPath;
        private String httppath;
        private String ip;
        private int port;
        private boolean manuelUpload;

        public int getPriority() {
            return this.priority;
        }

        public String getPass() {
            return Updater.getCFG(this + "ftp_pass3");
        }

        public String getUser() {
            return Updater.getCFG(this + "_ftp_user3");
        }

        public String getFTPPath() {
            return this.ftpPath;
        }

        public String getHttppath() {
            return this.httppath;
        }

        public String getIp() {
            return this.ip;
        }

        public int getPort() {
            return this.port;
        }

        public boolean isManuelUpload() {
            return this.manuelUpload;
        }

        public Server(int n, String string, String string2, int n2, String string3, boolean bl) {
            this.priority = n;
            this.httppath = string;
            this.ip = string2;
            this.port = n2;
            this.ftpPath = string3;
            this.manuelUpload = bl;
        }

        public String toString() {
            return this.ip;
        }
    }
}

