/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

import java.awt.Color;
import java.awt.HeadlessException;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import jd.HostPluginWrapper;
import jd.JDInitFlags;
import jd.config.SubConfiguration;
import jd.controlling.DownloadController;
import jd.controlling.JDController;
import jd.controlling.JDLogger;
import jd.controlling.ProgressController;
import jd.event.MessageEvent;
import jd.event.MessageListener;
import jd.gui.UserIO;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.SwingGui;
import jd.gui.swing.components.Balloon;
import jd.gui.swing.jdgui.GUIUtils;
import jd.http.Browser;
import jd.http.URLConnectionAdapter;
import jd.nutils.JDFlags;
import jd.nutils.JDHash;
import jd.nutils.nativeintegration.LocalBrowser;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.update.FileUpdate;
import jd.update.JDUpdateUtils;
import jd.update.WebUpdater;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebUpdate {
    private static Logger logger = JDLogger.getLogger();
    protected ArrayList<FileUpdate> unfilteredList;
    private static boolean DYNAMIC_PLUGINS_FINISHED = false;
    private static boolean UPDATE_IN_PROGRESS = false;

    public static void DynamicPluginsFinished() {
        DYNAMIC_PLUGINS_FINISHED = true;
    }

    private static String getUpdaterMD5(int n) {
        return String.valueOf(WebUpdater.UPDATE_MIRROR[n % WebUpdater.UPDATE_MIRROR.length]) + "jdupdate.jar.md5";
    }

    private static String getUpdater(int n) {
        return String.valueOf(WebUpdater.UPDATE_MIRROR[n % WebUpdater.UPDATE_MIRROR.length]) + "jdupdate.jar";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean updateUpdater() {
        final ProgressController progressController = new ProgressController(JDL.L("wrapper.webupdate.updatenewupdater", "Downloading new jdupdate.jar"));
        progressController.increase(1L);
        Thread thread = new Thread(){

            public void run() {
                while (true) {
                    try {
                        1.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                    if (progressController.getValue() > 95L) {
                        progressController.setStatus(10L);
                    }
                    progressController.increase(1L);
                }
            }
        };
        WebUpdater.randomizeMirrors();
        thread.start();
        Browser browser = new Browser();
        browser.setReadTimeout(20000);
        browser.setConnectTimeout(10000);
        File file = JDUtilities.getResourceFile("jdupdate.jar");
        String string = JDHash.getMD5((File)file);
        String string2 = null;
        int n = 0;
        while (n < 10) {
            block14: {
                if (string2 == null) {
                    try {
                        string2 = browser.getPage(String.valueOf(WebUpdate.getUpdaterMD5(n)) + "?t=" + System.currentTimeMillis()).trim();
                    }
                    catch (Exception exception) {
                        string2 = null;
                        WebUpdate.errorWait();
                        break block14;
                    }
                }
                if (string != null && string2 != null && string2.equalsIgnoreCase(string)) {
                    thread.interrupt();
                    progressController.doFinalize();
                    logger.info("Updater is still up2date!");
                    return true;
                }
                if (string == null || !string2.equalsIgnoreCase(string)) {
                    logger.info("Download " + file.getAbsolutePath());
                    URLConnectionAdapter uRLConnectionAdapter = null;
                    try {
                        uRLConnectionAdapter = browser.openGetConnection(String.valueOf(WebUpdate.getUpdater(n)) + "?t=" + System.currentTimeMillis());
                        if (uRLConnectionAdapter.isOK()) {
                            File file2 = new File(String.valueOf(file.getAbsolutePath()) + ".tmp");
                            Browser.download((File)file2, (URLConnectionAdapter)uRLConnectionAdapter);
                            string = JDHash.getMD5((File)file2);
                            if (string2.equalsIgnoreCase(string)) {
                                if ((!file.exists() || file.delete()) && file2.renameTo(file)) {
                                    thread.interrupt();
                                    progressController.doFinalize(2000L);
                                    logger.info("Update of " + file.getAbsolutePath() + " successfull");
                                    return true;
                                }
                                thread.interrupt();
                                logger.severe("Rename error: jdupdate.jar");
                                progressController.setColor(Color.RED);
                                progressController.setStatusText(JDL.LF("wrapper.webupdate.updateUpdater.error_rename", "Could not rename jdupdate.jar.tmp to jdupdate.jar", new Object[0]));
                                progressController.doFinalize(5000L);
                                return false;
                            }
                            logger.severe("CRC Error while downloading jdupdate.jar");
                        } else {
                            uRLConnectionAdapter.disconnect();
                        }
                    }
                    catch (Exception exception) {
                        try {
                            uRLConnectionAdapter.disconnect();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                    new File(String.valueOf(file.getAbsolutePath()) + ".tmp").delete();
                }
            }
            ++n;
        }
        thread.interrupt();
        progressController.setColor(Color.RED);
        progressController.setStatusText(JDL.LF("wrapper.webupdate.updateUpdater.error_reqeust2", "Could not download new jdupdate.jar", new Object[0]));
        progressController.doFinalize(5000L);
        logger.info("Update of " + file.getAbsolutePath() + " failed");
        return false;
    }

    private static void errorWait() {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public synchronized void doUpdateCheck(final boolean bl) {
        ArrayList<FileUpdate> arrayList;
        ProgressController progressController;
        if (UPDATE_IN_PROGRESS) {
            logger.info("Update is already running");
            Balloon.show((String)JDL.L("jd.utils.webupdate.ballon.title", "Update"), (ImageIcon)UserIO.getInstance().getIcon(1), (String)JDL.L("jd.utils.webupdate.ballon.message.updateinprogress", "There is already an update in progress."));
            return;
        }
        if (bl) {
            progressController = new ProgressController(JDL.L("init.webupdate.progress.0_title", "Webupdate"), 9L);
            progressController.setStatus(3L);
        } else {
            progressController = null;
        }
        UPDATE_IN_PROGRESS = true;
        final String string = JDController.requestDelayExit("doUpdateCheck");
        final WebUpdater webUpdater = new WebUpdater();
        webUpdater.ignorePlugins(false);
        logger.finer("Checking for available updates");
        try {
            arrayList = webUpdater.getAvailableFiles();
            if (webUpdater.sum.length > 100) {
                SubConfiguration.getConfig("apckage").setProperty(new String(new byte[]{97, 112, 99, 107, 97, 103, 101}), webUpdater.sum);
                SubConfiguration.getConfig("apckage").save();
            }
        }
        catch (Exception exception) {
            UPDATE_IN_PROGRESS = false;
            JDController.releaseDelayExit(string);
            return;
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object;
                Object object2;
                int n;
                MessageListener messageListener = null;
                if (arrayList != null) {
                    Object object322;
                    webUpdater.filterAvailableUpdates(arrayList);
                    n = 1;
                    object2 = new ArrayList();
                    object = new HashMap<String, Object>();
                    for (Object object322 : arrayList) {
                        if (((FileUpdate)object322).getLocalFile().equals(JDUtilities.getResourceFile("JDownloader.jar"))) {
                            n = 0;
                        }
                        if (!((FileUpdate)object322).getLocalFile().getName().endsWith(".class")) continue;
                        ((ArrayList)object2).add(object322);
                        ((HashMap)object).put(((FileUpdate)object322).getLocalFile().getName().substring(0, ((FileUpdate)object322).getLocalFile().getName().length() - 6), object322);
                    }
                    object322 = DownloadController.getInstance();
                    Object object4 = ((DownloadController)object322).getPackages();
                    synchronized (object4) {
                        for (FilePackage object5 : ((DownloadController)object322).getPackages()) {
                            ArrayList<DownloadLink> arrayList2 = object5.getDownloadLinkList();
                            synchronized (arrayList2) {
                                for (DownloadLink downloadLink : object5.getDownloadLinkList()) {
                                    if (!((HashMap)object).containsKey(downloadLink.getPlugin().getClass().getSimpleName())) continue;
                                    n = 0;
                                }
                            }
                        }
                    }
                    if (n != 0) {
                        WebUpdate.doPluginUpdate(webUpdater, (ArrayList)object2);
                        Iterator iterator = ((ArrayList)object2).iterator();
                        while (iterator.hasNext()) {
                            object4 = (FileUpdate)iterator.next();
                            if (!((FileUpdate)object4).equals()) continue;
                            arrayList.remove(object4);
                        }
                    }
                    JDUtilities.getController().setWaitingUpdates(arrayList);
                    if (arrayList.size() > 0) {
                        new GuiRunnable<Object>(){

                            public Object runSave() {
                                SwingGui.getInstance().getMainFrame().setTitle(JDUtilities.getJDTitle());
                                if (progressController != null) {
                                    progressController.setStatus(9L);
                                    progressController.doFinalize(3000L);
                                }
                                return null;
                            }
                        }.start();
                    } else if (progressController != null) {
                        progressController.setStatus(9L);
                        progressController.setColor(Color.RED);
                        progressController.setStatusText(JDL.L("jd.utils.WebUpdate.doUpdateCheck.noupdates", "No Updates available"));
                        progressController.doFinalize(3000L);
                    }
                }
                if (HostPluginWrapper.getHostWrapper().size() > 50 && !JDInitFlags.SWITCH_RETURNED_FROM_UPDATE && !bl && SubConfiguration.getConfig("WEBUPDATE").getBooleanProperty("WEBUPDATE_DISABLE", false).booleanValue()) {
                    logger.severe("Webupdater disabled");
                    if (GUIUtils.getConfig().getBooleanProperty("START_DOWNLOADS_AFTER_START", false).booleanValue() && JDUtilities.getConfiguration().getBooleanProperty("WEBUPDATE_AUTO_RESTART", false).booleanValue()) {
                        JDController.getInstance().autostartDownloadsonStartup();
                    }
                    JDController.releaseDelayExit(string);
                    UPDATE_IN_PROGRESS = false;
                    return;
                }
                if (arrayList == null || arrayList.size() == 0) {
                    int n2;
                    File[] fileArray = JDUtilities.getResourceFile("update").listFiles();
                    if (fileArray != null && fileArray.length > 0 && JDFlags.hasAllFlags((int)(n2 = UserIO.getInstance().requestConfirmDialog(544, JDL.L("jd.update.Main.error.title.old", "Updates found!"), JDL.L("jd.update.Main.error.message.old", "There are uninstalled updates. Install them now?"), null, null, null)), (int[])new int[]{2})) {
                        JDController.releaseDelayExit(string);
                        JDUtilities.restartJDandWait();
                        return;
                    }
                    if (webUpdater.getBetaBranch() != null && !SubConfiguration.getConfig("WEBUPDATE").getBooleanProperty(webUpdater.getBetaBranch(), false).booleanValue()) {
                        SubConfiguration.getConfig("WEBUPDATE").setProperty(webUpdater.getBetaBranch(), true);
                        SubConfiguration.getConfig("WEBUPDATE").save();
                        int n3 = UserIO.getInstance().requestConfirmDialog(32, JDL.L("updater.newbeta.title", "New BETA available"), JDL.L("updater.newbeta.message", "Do you want to try the new BETA?\r\nClick OK to get more Information."));
                        if (UserIO.isOK((int)n3)) {
                            try {
                                LocalBrowser.openDefaultURL((URL)new URL("http://jdownloader.org/beta"));
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                    logger.severe("Webupdater offline or nothing to update");
                    if (GUIUtils.getConfig().getBooleanProperty("START_DOWNLOADS_AFTER_START", false).booleanValue() && JDUtilities.getConfiguration().getBooleanProperty("WEBUPDATE_AUTO_RESTART", false).booleanValue()) {
                        JDController.getInstance().autostartDownloadsonStartup();
                    }
                    JDController.releaseDelayExit(string);
                    UPDATE_IN_PROGRESS = false;
                    return;
                }
                if (arrayList.size() > 0) {
                    object2 = new ProgressController(JDL.L("init.webupdate.progress.0_title", "Webupdate"), 100L);
                    messageListener = new MessageListener((ProgressController)object2){
                        private final /* synthetic */ ProgressController val$progress;
                        {
                            this.val$progress = progressController;
                        }

                        public void onMessage(MessageEvent messageEvent) {
                            this.val$progress.setStatusText(messageEvent.getSource() + ": " + messageEvent.getMessage());
                        }
                    };
                    webUpdater.getBroadcaster().addListener(messageListener);
                    n = arrayList.size();
                    ((ProgressController)object2).setRange(n);
                    ((ProgressController)object2).setStatusText(JDL.L("init.webupdate.progress.1_title", "Update Check"));
                    ((ProgressController)object2).setStatus(n - arrayList.size());
                    logger.finer(String.valueOf(webUpdater.getBranch()));
                    logger.finer("Files to update: " + arrayList);
                    if (JDUtilities.getConfiguration().getBooleanProperty("WEBUPDATE_AUTO_RESTART", false).booleanValue()) {
                        UserIO.setCountdownTime((int)5);
                        int n4 = UserIO.getInstance().requestConfirmDialog(128, JDL.L("init.webupdate.auto.countdowndialog2", "Automatic update."), JDL.LF("jd.utils.webupdate.message", "<font size=\"2\" face=\"Verdana, Arial, Helvetica, sans-serif\">%s update(s) available. Install now?</font>", arrayList.size()), JDTheme.II("gui.splash.update", 32, 32), null, null);
                        UserIO.setCountdownTime((int)-1);
                        if (JDFlags.hasSomeFlags((int)n4, (int[])new int[]{2, 32})) {
                            WebUpdate.this.doUpdate(webUpdater, arrayList);
                        } else {
                            UPDATE_IN_PROGRESS = false;
                        }
                    } else {
                        try {
                            object = JDL.L("jd.utils.webupdate.whatchangedlink", "<hr/><a href='http://jdownloader.org/latestchanges'>What has changed?</a>");
                            int n5 = UserIO.getInstance().requestConfirmDialog(128, JDL.L("system.dialogs.update", "Updates available"), String.valueOf(JDL.LF("jd.utils.webupdate.message2", "<font size=\"4\" face=\"Verdana, Arial, Helvetica, sans-serif\">%s update(s) available. Install now?</font>", arrayList.size())) + (String)object, JDTheme.II("gui.splash.update", 32, 32), null, null);
                            if (JDFlags.hasAllFlags((int)n5, (int[])new int[]{2})) {
                                WebUpdate.this.doUpdate(webUpdater, arrayList);
                            } else {
                                UPDATE_IN_PROGRESS = false;
                            }
                        }
                        catch (HeadlessException headlessException) {
                            JDLogger.exception(headlessException);
                            UPDATE_IN_PROGRESS = false;
                        }
                    }
                    ((ProgressController)object2).doFinalize();
                }
                if (messageListener != null) {
                    webUpdater.getBroadcaster().removeListener(messageListener);
                }
                if (GUIUtils.getConfig().getBooleanProperty("START_DOWNLOADS_AFTER_START", false).booleanValue() && JDUtilities.getConfiguration().getBooleanProperty("WEBUPDATE_AUTO_RESTART", false).booleanValue()) {
                    JDController.getInstance().autostartDownloadsonStartup();
                }
                JDController.releaseDelayExit(string);
            }
        }.start();
    }

    private static void doPluginUpdate(WebUpdater webUpdater, ArrayList<FileUpdate> arrayList) {
        final ProgressController progressController = new ProgressController("", arrayList.size());
        try {
            webUpdater.getBroadcaster().addListener(new MessageListener(){

                public void onMessage(MessageEvent messageEvent) {
                    progressController.setStatusText(String.valueOf(messageEvent.getMessage()) + " " + JDL.L("jd.utils.WebUpdate.doPluginUpdate", "[Restart on plugin out of date errors]"));
                }
            });
            System.out.println("Update: " + arrayList);
            webUpdater.updateFiles(arrayList, progressController);
            boolean bl = false;
            for (FileUpdate fileUpdate : arrayList) {
                if (fileUpdate.getLocalFile().exists() && !fileUpdate.getLocalFile().delete() || !fileUpdate.getLocalTmpFile().renameTo(fileUpdate.getLocalFile())) {
                    bl = true;
                    continue;
                }
                File file = fileUpdate.getLocalTmpFile().getParentFile();
                while (file.listFiles() != null && file.listFiles().length < 1) {
                    file.delete();
                    file = file.getParentFile();
                }
            }
            if (bl) {
                Balloon.show((String)JDL.L("jd.utils.WebUpdate.doPluginUpdate.title", "Restart recommended"), null, (String)JDL.L("jd.utils.WebUpdate.doPluginUpdate.message", "Some Plugins have been updated\r\nYou should restart JDownloader."));
            }
        }
        catch (Exception exception) {
            System.err.println("EXCEPTION");
            JDLogger.exception(exception);
            exception.printStackTrace();
        }
        progressController.doFinalize();
    }

    private void doUpdate(final WebUpdater webUpdater, final ArrayList<FileUpdate> arrayList) {
        new Thread(){

            public void run() {
                String string = JDController.requestDelayExit("doUpdate");
                try {
                    int n = 0;
                    while (!DYNAMIC_PLUGINS_FINISHED) {
                        try {
                            Thread.sleep(1000L);
                            logger.severe("Waiting on DynamicPlugins since " + ++n + " secs!");
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    DownloadController downloadController = DownloadController.getInstance();
                    if (downloadController != null) {
                        JDUpdateUtils.backupDataBase();
                    } else {
                        logger.severe("Could not backup. downloadcontroller=null");
                    }
                    WebUpdate.updateUpdater();
                    final ProgressController progressController = new ProgressController(JDL.L("jd.utils.webupdate.progresscontroller.text", "Update is running"), 10L);
                    try {
                        webUpdater.getBroadcaster().addListener(new MessageListener(){

                            public void onMessage(MessageEvent messageEvent) {
                                progressController.setStatusText(String.valueOf(messageEvent.getSource().toString()) + ": " + messageEvent.getMessage());
                            }
                        });
                        progressController.increase(10L);
                        System.out.println("Update: " + arrayList);
                        webUpdater.cleanUp();
                        webUpdater.updateFiles(arrayList, progressController);
                        if (webUpdater.getErrors() > 0) {
                            System.err.println("ERRO");
                            int n2 = UserIO.getInstance().requestConfirmDialog(548, JDL.L("jd.update.Main.error.title", "Errors occured"), JDL.LF("jd.update.Main.error.message", "Errors occured!\r\nThere were %s error(s) while updating. Do you want to update anyway?", webUpdater.getErrors()), UserIO.getInstance().getIcon(1), null, null);
                            if (JDFlags.hasAllFlags((int)n2, (int[])new int[]{2})) {
                                JDController.releaseDelayExit(string);
                                JDUtilities.restartJDandWait();
                            }
                        } else {
                            System.err.println("OK RESTART");
                            JDController.releaseDelayExit(string);
                            JDUtilities.restartJDandWait();
                        }
                    }
                    catch (Exception exception) {
                        System.err.println("EXCEPTION");
                        JDLogger.exception(exception);
                        exception.printStackTrace();
                    }
                    progressController.doFinalize();
                }
                finally {
                    JDController.releaseDelayExit(string);
                    UPDATE_IN_PROGRESS = false;
                }
            }
        }.start();
    }
}

