/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.interfaces;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import jd.controlling.JDLogger;
import jd.plugins.optional.interfaces.Handler;
import jd.plugins.optional.interfaces.RequestHandler;

public class HttpServer
extends Thread {
    private ServerSocket ssocket;
    private Socket csocket;
    private Handler handler;
    private boolean running = true;
    private Thread run;
    private int port;
    private boolean uselocalhost = false;

    public HttpServer(int port, Handler handler) throws IOException {
        super("HTTP-Server");
        this.handler = handler;
        this.port = port;
        this.uselocalhost = false;
    }

    public HttpServer(int port, Handler handler, boolean localhost) throws IOException {
        super("HTTP-Server");
        this.handler = handler;
        this.port = port;
        this.uselocalhost = localhost;
    }

    public void sstop() throws IOException {
        this.running = false;
        this.run = null;
    }

    public void start() {
        this.running = true;
        try {
            InetAddress localhost = HttpServer.getLocalHost();
            this.ssocket = localhost != null && this.uselocalhost ? new ServerSocket(this.port, 5, localhost) : new ServerSocket(this.port, 5);
        }
        catch (IOException e) {
            JDLogger.exception((Throwable)e);
        }
        this.run = new Thread((Runnable)this, "Http-Server Consumer");
        this.run.start();
    }

    public static InetAddress getLocalHost() {
        InetAddress localhost = null;
        try {
            localhost = InetAddress.getByName(null);
        }
        catch (UnknownHostException e1) {
            JDLogger.getLogger().severe("could not find localhost!");
        }
        return localhost;
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.run == thisThread && this.running) {
            if (this.ssocket == null) {
                return;
            }
            try {
                this.csocket = this.ssocket.accept();
                new RequestHandler(this.csocket, this.handler).run();
                Thread.sleep(100L);
            }
            catch (Exception e) {
                JDLogger.exception((Throwable)e);
            }
        }
        try {
            this.ssocket.close();
        }
        catch (IOException e) {
            JDLogger.exception((Throwable)e);
        }
    }

    public boolean isStarted() {
        return this.running;
    }
}

