/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.interfaces;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.security.Key;
import java.util.ArrayList;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import jd.Installer;
import jd.PluginWrapper;
import jd.config.ConfigEntry;
import jd.config.ConfigGroup;
import jd.config.SubConfiguration;
import jd.controlling.DistributeData;
import jd.controlling.JDLogger;
import jd.controlling.LinkGrabberController;
import jd.gui.UserIO;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.SwingGui;
import jd.gui.swing.jdgui.menu.MenuAction;
import jd.nutils.JDFlags;
import jd.nutils.encoding.Base64;
import jd.nutils.encoding.Encoding;
import jd.nutils.io.JDIO;
import jd.parser.Regex;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.OptionalPlugin;
import jd.plugins.Plugin;
import jd.plugins.PluginForHost;
import jd.plugins.PluginOptional;
import jd.plugins.optional.interfaces.Handler;
import jd.plugins.optional.interfaces.HttpServer;
import jd.plugins.optional.interfaces.Request;
import jd.plugins.optional.interfaces.Response;
import jd.utils.JDHexUtils;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.WebUpdate;
import jd.utils.locale.JDL;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@OptionalPlugin(rev="$Revision: 10459 $", defaultEnabled=true, id="externinterface", interfaceversion=5)
public class JDExternInterface
extends PluginOptional {
    private RequestHandler handler = new RequestHandler();
    private HttpServer server = null;
    private static String jdpath = String.valueOf(JDUtilities.getJDHomeDirectoryFromEnvironment().getAbsolutePath()) + "/JDownloader.jar";

    public JDExternInterface(PluginWrapper wrapper) {
        super(wrapper);
    }

    public static String decrypt(byte[] b, byte[] key) {
        try {
            IvParameterSpec ivSpec = new IvParameterSpec(key);
            SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            cipher.init(2, (Key)skeySpec, ivSpec);
            return new String(cipher.doFinal(b));
        }
        catch (Exception e) {
            JDLogger.exception((Throwable)e);
            return null;
        }
    }

    public static void decrypt(String crypted, String jk, String k, String password, String source) {
        byte[] key;
        if (jk != null) {
            Context cx = Context.enter();
            ScriptableObject scope = cx.initStandardObjects();
            String fun = String.valueOf(jk) + "  f()";
            Object result = cx.evaluateString((Scriptable)scope, fun, "<cmd>", 1, null);
            key = JDHexUtils.getByteArray((String)Context.toString((Object)result));
            Context.exit();
        } else {
            key = JDHexUtils.getByteArray((String)k);
        }
        byte[] baseDecoded = Base64.decode((String)crypted);
        String decryted = JDExternInterface.decrypt(baseDecoded, key).trim();
        String[] passwords = Regex.getLines((String)password);
        ArrayList links = new DistributeData(Encoding.htmlDecode((String)decryted)).findLinks();
        for (DownloadLink link : links) {
            link.addSourcePluginPasswords(passwords);
        }
        for (DownloadLink l : links) {
            if (source == null) continue;
            l.setBrowserUrl(source);
        }
        LinkGrabberController.getInstance().addLinks(links, false, false);
    }

    public String getIconKey() {
        return "gui.images.flashgot";
    }

    private void initConfigEntries() {
        this.config.setGroup(new ConfigGroup(JDL.L((String)"jd.plugins.optional.interfaces.JDExternInterface.flashgot.configgroup", (String)"Install FlashGot Firefox Addon"), JDTheme.II((String)"gui.images.flashgot", (int)32, (int)32)));
        this.config.addEntry(new ConfigEntry(2, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Installer.installFirefoxAddon();
            }
        }, JDL.L((String)"jd.plugins.optional.interfaces.JDExternInterface.flashgot", (String)"Install"), JDL.L((String)"jd.plugins.optional.interfaces.JDExternInterface.flashgot.long", (String)"Install Firefox integration"), JDTheme.II((String)"gui.images.flashgot", (int)16, (int)16)));
    }

    public boolean initAddon() {
        logger.info("Extern Interface API initialized on port 9666");
        this.initConfigEntries();
        if (!SubConfiguration.getConfig((String)"FLASHGOT").getBooleanProperty("ASKED_TO_INSTALL_FLASHGOT", false).booleanValue()) {
            Installer.askInstallFlashgot();
        }
        try {
            this.server = new HttpServer(this.getPluginConfig().getIntegerProperty("INTERFACE_PORT", 9666), this.handler, true);
            this.server.start();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void onExit() {
        try {
            if (this.server != null) {
                this.server.sstop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server = null;
    }

    public ArrayList<MenuAction> createMenuitems() {
        return null;
    }

    class RequestHandler
    implements Handler {
        private String namespace;
        private String[] splitPath;

        RequestHandler() {
        }

        public void handle(Request request, Response response) {
            this.splitPath = request.getRequestUrl().substring(1).split("[/|\\\\]");
            this.namespace = this.splitPath[0];
            JDLogger.getLogger().finer(request.toString());
            JDLogger.getLogger().finer(request.getParameters().toString());
            try {
                if (this.namespace.equalsIgnoreCase("update")) {
                    String branch = request.getParameters().get("branch");
                    String ref = request.getHeader("referer");
                    if (!ref.equalsIgnoreCase("http://jdownloader.org/beta") && !ref.equalsIgnoreCase("http://jdownloader.net:8081/beta")) {
                        return;
                    }
                    new GuiRunnable<Object>(){

                        public Object runSave() {
                            SwingGui.getInstance().getMainFrame().toFront();
                            SwingGui.getInstance().getMainFrame().setExtendedState(6);
                            return null;
                        }
                    }.waitForEDT();
                    if (UserIO.isOK((int)UserIO.getInstance().requestConfirmDialog(36, JDL.L((String)"updater.beta.rlyupdate.title", (String)"Update to beta now?"), JDL.LF((String)"updater.beta.rlyupdate.message", (String)"Do you want to update to JD-%s", (Object[])new Object[]{branch})))) {
                        SubConfiguration.getConfig((String)"WEBUPDATE").setProperty("BRANCH", (Object)branch);
                        SubConfiguration.getConfig((String)"WEBUPDATE").setProperty("BRANCHINUSE", (Object)branch);
                        SubConfiguration.getConfig((String)"WEBUPDATE").save();
                        WebUpdate.doUpdateCheck((boolean)false);
                    }
                } else if (this.namespace.equalsIgnoreCase("flash")) {
                    if (this.splitPath.length > 1 && this.splitPath[1].equalsIgnoreCase("add")) {
                        this.askPermission(request);
                        String[] urls = Regex.getLines((String)Encoding.htmlDecode((String)request.getParameters().get("urls")));
                        String[] passwords = Regex.getLines((String)Encoding.htmlDecode((String)request.getParameters().get("passwords")));
                        String source = Encoding.urlDecode((String)request.getParameters().get("source"), (boolean)false);
                        if (urls.length != 0) {
                            ArrayList links = new DistributeData(Encoding.htmlDecode((String)request.getParameters().get("urls"))).findLinks();
                            for (DownloadLink link : links) {
                                link.addSourcePluginPasswords(passwords);
                                if (source == null) continue;
                                link.setBrowserUrl(source);
                            }
                            LinkGrabberController.getInstance().addLinks(links, false, false);
                            new GuiRunnable<Object>(){

                                public Object runSave() {
                                    SwingGui.getInstance().getMainFrame().toFront();
                                    return null;
                                }
                            }.waitForEDT();
                            response.addContent("success\r\n");
                        } else {
                            response.addContent("failed\r\n");
                        }
                    } else if (this.splitPath.length > 1 && this.splitPath[1].equalsIgnoreCase("addcrypted")) {
                        this.askPermission(request);
                        String dlc = Encoding.htmlDecode((String)request.getParameters().get("crypted")).trim().replace(" ", "+");
                        File tmp = JDUtilities.getResourceFile((String)("tmp/jd_" + System.currentTimeMillis() + ".dlc"), (boolean)true);
                        tmp.deleteOnExit();
                        JDIO.saveToFile((File)tmp, (byte[])dlc.getBytes());
                        ArrayList links = JDUtilities.getController().getContainerLinks(tmp);
                        LinkGrabberController.getInstance().addLinks(links, false, false);
                        new GuiRunnable<Object>(){

                            public Object runSave() {
                                SwingGui.getInstance().getMainFrame().toFront();
                                return null;
                            }
                        }.waitForEDT();
                        response.addContent("success\r\n");
                    } else if (this.splitPath.length > 1 && this.splitPath[1].equalsIgnoreCase("addcrypted2")) {
                        this.askPermission(request);
                        String crypted = Encoding.htmlDecode((String)request.getParameters().get("crypted")).trim().replace(" ", "+");
                        String jk = Encoding.urlDecode((String)request.getParameters().get("jk"), (boolean)false);
                        String k = Encoding.urlDecode((String)request.getParameters().get("k"), (boolean)false);
                        String passwords = Encoding.urlDecode((String)request.getParameters().get("passwords"), (boolean)false);
                        String source = Encoding.urlDecode((String)request.getParameters().get("source"), (boolean)false);
                        try {
                            JDExternInterface.decrypt(crypted, jk, k, passwords, source);
                            response.addContent("success\r\n");
                            new GuiRunnable<Object>(){

                                public Object runSave() {
                                    SwingGui.getInstance().getMainFrame().toFront();
                                    return null;
                                }
                            }.waitForEDT();
                        }
                        catch (Exception e) {
                            JDLogger.exception((Throwable)e);
                            response.addContent("failed " + e.getMessage() + "\r\n");
                        }
                    } else {
                        response.addContent(String.valueOf(JDUtilities.getJDTitle()) + "\r\n");
                    }
                } else if (request.getRequestUrl().equalsIgnoreCase("/jdcheck.js")) {
                    response.addContent("jdownloader=true;\r\n");
                    response.addContent("var version='" + JDUtilities.getRevision() + "';\r\n");
                } else if (request.getRequestUrl().equalsIgnoreCase("/crossdomain.xml")) {
                    response.addContent("<?xml version=\"1.0\"?>\r\n");
                    response.addContent("<!DOCTYPE cross-domain-policy SYSTEM \"http://www.macromedia.com/xml/dtds/cross-domain-policy.dtd\">\r\n");
                    response.addContent("<cross-domain-policy>\r\n");
                    response.addContent("<allow-access-from domain=\"*\" />\r\n");
                    response.addContent("</cross-domain-policy>\r\n");
                } else if (this.namespace.equalsIgnoreCase("flashgot")) {
                    response.addContent(String.valueOf(jdpath) + "\r\n");
                    response.addContent("java -Xmx512m -jar " + jdpath + "\r\n");
                    if (request.getHeader("referer") == null || !request.getHeader("referer").equalsIgnoreCase("http://localhost:" + JDExternInterface.this.getPluginConfig().getIntegerProperty("INTERFACE_PORT", 9666) + "/flashgot") && !request.getHeader("referer").equalsIgnoreCase("http://127.0.0.1:" + JDExternInterface.this.getPluginConfig().getIntegerProperty("INTERFACE_PORT", 9666) + "/flashgot")) {
                        this.askPermission(request);
                    } else {
                        JDLogger.getLogger().info("Valid FlashGot Referer found, skipping AskPermission");
                    }
                    String[] urls = Regex.getLines((String)Encoding.urlDecode((String)request.getParameters().get("urls"), (boolean)false));
                    String[] desc = Regex.getLines((String)Encoding.urlDecode((String)request.getParameters().get("descriptions"), (boolean)false));
                    String dir = null;
                    FilePackage fp = FilePackage.getInstance();
                    fp.setName("FlashGot");
                    fp.setProperty("dontforcename", (Object)"yes");
                    if (request.getParameters().get("dir") != null) {
                        dir = Encoding.urlDecode((String)request.getParameters().get("dir"), (boolean)false).trim();
                        fp.setDownloadDirectory(dir);
                    }
                    String cookies = null;
                    if (request.getParameters().get("cookies") != null) {
                        cookies = Encoding.urlDecode((String)request.getParameters().get("cookies"), (boolean)false);
                    }
                    String post = null;
                    if (request.getParameters().get("postData") != null) {
                        post = Encoding.urlDecode((String)request.getParameters().get("postData"), (boolean)false);
                    }
                    boolean autostart = false;
                    if (request.getParameters().get("autostart") != null && request.getParameter("autostart").startsWith("1")) {
                        autostart = true;
                    }
                    String referer = Encoding.urlDecode((String)request.getParameter("referer"), (boolean)false);
                    ArrayList<DownloadLink> links = new ArrayList<DownloadLink>();
                    if (urls.length != 0) {
                        int i = 0;
                        while (i < urls.length) {
                            String url = urls[i];
                            DistributeData dt = new DistributeData(url);
                            dt.setFilterNormalHTTP(true);
                            ArrayList foundlinks = dt.findLinks();
                            if (foundlinks.size() > 0) {
                                for (DownloadLink dl : foundlinks) {
                                    if (!dl.gotBrowserUrl()) {
                                        dl.setBrowserUrl(referer);
                                    }
                                    if (i >= desc.length) continue;
                                    dl.setSourcePluginComment(desc[i]);
                                }
                                links.addAll(foundlinks);
                            } else {
                                PluginForHost plg = JDUtilities.getNewPluginForHostInstance((String)"DirectHTTP");
                                String name = Plugin.getFileNameFromURL((URL)new URL(url));
                                DownloadLink direct = new DownloadLink(plg, name, "DirectHTTP", url, true);
                                direct.setBrowserUrl(referer);
                                if (i < desc.length) {
                                    direct.setSourcePluginComment(desc[i]);
                                }
                                direct.setProperty("cookies", (Object)cookies);
                                direct.setProperty("post", (Object)post);
                                direct.setProperty("referer", (Object)referer);
                                plg.correctDownloadLink(direct);
                                links.add(direct);
                            }
                            ++i;
                        }
                        fp.addLinks(links);
                        LinkGrabberController.getInstance().addLinks(links, autostart, autostart);
                        new GuiRunnable<Object>(){

                            public Object runSave() {
                                SwingGui.getInstance().getMainFrame().toFront();
                                return null;
                            }
                        }.waitForEDT();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void askPermission(Request request) throws Exception {
            String app = "unknown application";
            if (request.getHeader("user-agent") != null) {
                app = request.getHeader("user-agent").replaceAll("\\(.*\\)", "");
            }
            JDLogger.getLogger().warning("\r\n\r\n-----------------------External request---------------------");
            JDLogger.getLogger().warning("An external tool adds links to JDownloader. Request details:");
            JDLogger.getLogger().warning(request.toString());
            JDLogger.getLogger().warning(request.getParameters().toString());
            JDLogger.getLogger().warning("\r\n-----------------------External request---------------------");
            String url = request.getHeader("referer");
            if (url == null) {
                url = request.getHeader("referrer");
            }
            if (url == null) {
                url = request.getHeader("source");
            }
            String string = app = url != null ? new URL(url).getHost() : app;
            if (!JDFlags.hasAllFlags((int)UserIO.getInstance().requestConfirmDialog(32, JDL.LF((String)"jd.plugins.optional.interfaces.jdflashgot.security.title", (String)"External request from %s to %s interface!", (Object[])new Object[]{app, this.namespace}), JDL.L((String)"jd.plugins.optional.interfaces.jdflashgot.security.message", (String)"An external application tries to add links. See Log for details."), UserIO.getInstance().getIcon(1), JDL.L((String)"jd.plugins.optional.interfaces.jdflashgot.security.btn_allow", (String)"Allow it!"), JDL.L((String)"jd.plugins.optional.interfaces.jdflashgot.security.btn_deny", (String)"Deny access!")), (int[])new int[]{2})) {
                JDLogger.getLogger().warning("Denied access.");
                throw new Exception("User denied access");
            }
        }
    }
}

