/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.htmlcleaner.BrowserCompactXmlSerializer;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CompactXmlSerializer;
import org.htmlcleaner.ConfigFileTagProvider;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.PrettyXmlSerializer;
import org.htmlcleaner.SimpleXmlSerializer;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.XPatherException;

public class HtmlCleanerForAnt
extends Task {
    private String text;
    private String src;
    private String dest;
    private String incharset = HtmlCleaner.DEFAULT_CHARSET;
    private String outcharset = HtmlCleaner.DEFAULT_CHARSET;
    private String taginfofile = null;
    private String outputtype = "simple";
    private boolean advancedxmlescape = true;
    private boolean usecdata = true;
    private boolean specialentities = true;
    private boolean unicodechars = true;
    private boolean omitunknowntags = false;
    private boolean treatunknowntagsascontent = false;
    private boolean omitdeprtags = false;
    private boolean treatdeprtagsascontent = false;
    private boolean omitcomments = false;
    private boolean omitxmldecl = false;
    private boolean omitdoctypedecl = true;
    private boolean omithtmlenvelope = false;
    private boolean useemptyelementtags = true;
    private boolean allowmultiwordattributes = true;
    private boolean allowhtmlinsideattributes = false;
    private boolean ignoreqe = false;
    private boolean namespacesaware = true;
    private String hyphenreplacement = "=";
    private String prunetags = "";
    private String booleanatts = "self";
    private String nodebyxpath = null;

    public void setText(String string) {
        this.text = string;
    }

    public void setSrc(String string) {
        this.src = string;
    }

    public void setDest(String string) {
        this.dest = string;
    }

    public void setIncharset(String string) {
        this.incharset = string;
    }

    public void setOutcharset(String string) {
        this.outcharset = string;
    }

    public void setTaginfofile(String string) {
        this.taginfofile = string;
    }

    public void setOutputtype(String string) {
        this.outputtype = string;
    }

    public void setAdvancedxmlescape(boolean bl) {
        this.advancedxmlescape = bl;
    }

    public void setUsecdata(boolean bl) {
        this.usecdata = bl;
    }

    public void setSpecialentities(boolean bl) {
        this.specialentities = bl;
    }

    public void setUnicodechars(boolean bl) {
        this.unicodechars = bl;
    }

    public void setOmitunknowntags(boolean bl) {
        this.omitunknowntags = bl;
    }

    public void setTreatunknowntagsascontent(boolean bl) {
        this.treatunknowntagsascontent = bl;
    }

    public void setOmitdeprtags(boolean bl) {
        this.omitdeprtags = bl;
    }

    public void setTreatdeprtagsascontent(boolean bl) {
        this.treatdeprtagsascontent = bl;
    }

    public void setOmitcomments(boolean bl) {
        this.omitcomments = bl;
    }

    public void setOmitxmldecl(boolean bl) {
        this.omitxmldecl = bl;
    }

    public void setOmitdoctypedecl(boolean bl) {
        this.omitdoctypedecl = bl;
    }

    public void setOmithtmlenvelope(boolean bl) {
        this.omithtmlenvelope = bl;
    }

    public void setUseemptyelementtags(boolean bl) {
        this.useemptyelementtags = bl;
    }

    public void setAllowmultiwordattributes(boolean bl) {
        this.allowmultiwordattributes = bl;
    }

    public void setAllowhtmlinsideattributes(boolean bl) {
        this.allowhtmlinsideattributes = bl;
    }

    public void setIgnoreqe(boolean bl) {
        this.ignoreqe = bl;
    }

    public void setNamespacesaware(boolean bl) {
        this.namespacesaware = bl;
    }

    public void setHyphenreplacement(String string) {
        this.hyphenreplacement = string;
    }

    public void setPrunetags(String string) {
        this.prunetags = string;
    }

    public void setBooleanatts(String string) {
        this.booleanatts = string;
    }

    public void setNodebyxpath(String string) {
        this.nodebyxpath = string;
    }

    public void addText(String string) {
        this.text = string;
    }

    public void execute() throws BuildException {
        HtmlCleaner htmlCleaner = this.taginfofile != null ? new HtmlCleaner(new ConfigFileTagProvider(new File(this.taginfofile))) : new HtmlCleaner();
        if (this.text == null && this.src == null) {
            throw new BuildException("Eather attribute 'src' or text body containing HTML must be specified!");
        }
        CleanerProperties cleanerProperties = htmlCleaner.getProperties();
        cleanerProperties.setAdvancedXmlEscape(this.advancedxmlescape);
        cleanerProperties.setUseCdataForScriptAndStyle(this.usecdata);
        cleanerProperties.setTranslateSpecialEntities(this.specialentities);
        cleanerProperties.setRecognizeUnicodeChars(this.unicodechars);
        cleanerProperties.setOmitUnknownTags(this.omitunknowntags);
        cleanerProperties.setTreatUnknownTagsAsContent(this.treatunknowntagsascontent);
        cleanerProperties.setOmitDeprecatedTags(this.omitdeprtags);
        cleanerProperties.setTreatDeprecatedTagsAsContent(this.treatdeprtagsascontent);
        cleanerProperties.setOmitComments(this.omitcomments);
        cleanerProperties.setOmitXmlDeclaration(this.omitxmldecl);
        cleanerProperties.setOmitDoctypeDeclaration(this.omitdoctypedecl);
        cleanerProperties.setOmitHtmlEnvelope(this.omithtmlenvelope);
        cleanerProperties.setUseEmptyElementTags(this.useemptyelementtags);
        cleanerProperties.setAllowMultiWordAttributes(this.allowmultiwordattributes);
        cleanerProperties.setAllowHtmlInsideAttributes(this.allowhtmlinsideattributes);
        cleanerProperties.setIgnoreQuestAndExclam(this.ignoreqe);
        cleanerProperties.setNamespacesAware(this.namespacesaware);
        cleanerProperties.setHyphenReplacementInComment(this.hyphenreplacement);
        cleanerProperties.setPruneTags(this.prunetags);
        cleanerProperties.setBooleanAttributeValues(this.booleanatts);
        try {
            Object object;
            TagNode tagNode;
            try {
                tagNode = this.src != null && (this.src.startsWith("http://") || this.src.startsWith("https://")) ? htmlCleaner.clean(new URL(this.src), this.incharset) : (this.src != null ? htmlCleaner.clean(new File(this.src), this.incharset) : htmlCleaner.clean(this.text));
            }
            catch (IOException iOException) {
                throw new BuildException((Throwable)iOException);
            }
            if (this.nodebyxpath != null) {
                object = tagNode.evaluateXPath(this.nodebyxpath);
                for (int i = 0; i < ((Object[])object).length; ++i) {
                    if (!(object[i] instanceof TagNode)) continue;
                    tagNode = (TagNode)object[i];
                    break;
                }
            }
            object = this.dest == null || "".equals(this.dest.trim()) ? System.out : new FileOutputStream(this.dest);
            if ("compact".equals(this.outputtype)) {
                new CompactXmlSerializer(cleanerProperties).writeXmlToStream(tagNode, (OutputStream)object, this.outcharset);
            } else if ("browser-compact".equals(this.outputtype)) {
                new BrowserCompactXmlSerializer(cleanerProperties).writeXmlToStream(tagNode, (OutputStream)object, this.outcharset);
            } else if ("pretty".equals(this.outputtype)) {
                new PrettyXmlSerializer(cleanerProperties).writeXmlToStream(tagNode, (OutputStream)object, this.outcharset);
            } else {
                new SimpleXmlSerializer(cleanerProperties).writeXmlToStream(tagNode, (OutputStream)object, this.outcharset);
            }
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
        catch (XPatherException xPatherException) {
            throw new BuildException((Throwable)xPatherException);
        }
    }
}

