/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.hjsplit;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import jd.nutils.io.JDIO;
import jd.parser.Regex;
import jd.plugins.optional.hjsplit.Signature;
import jd.utils.JDUtilities;

public class FileSignatures {
    private static final Signature SIG_TXT = new Signature("TXTfile", null, "Plaintext", ".*\\.(txt|doc|nfo|html|htm|xml)");
    private static Signature[] SIGNATURES;

    public static Signature getFileSignature(File f) throws IOException {
        return FileSignatures.getSignature(FileSignatures.readFileSignature(f));
    }

    public static String readFileSignature(File f) throws IOException {
        FileInputStream reader = new FileInputStream(f);
        StringBuilder sig = new StringBuilder();
        int i = 0;
        while (i < 10) {
            int h = reader.read();
            String s = Integer.toHexString(h);
            if (s.length() < 2) {
                sig.append('0');
            }
            sig.append(s);
            ++i;
        }
        reader.close();
        return sig.toString();
    }

    public static Signature[] getSignatureList() {
        if (SIGNATURES != null) {
            return SIGNATURES;
        }
        String[] m = Regex.getLines((String)JDIO.readFileToString((File)JDUtilities.getResourceFile((String)"jd/mime.type")));
        SIGNATURES = new Signature[m.length];
        int i = 0;
        String[] stringArray = m;
        int n = m.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            String[] entry = e.split(":::");
            if (entry.length >= 4) {
                FileSignatures.SIGNATURES[i++] = new Signature(entry[0], entry[1], entry[2], entry[3]);
            } else {
                System.err.println("Signature " + e + " invalid!");
            }
            ++n2;
        }
        return SIGNATURES;
    }

    public static Signature getSignature(String sig) {
        Signature[] db;
        Signature[] signatureArray = db = FileSignatures.getSignatureList();
        int n = db.length;
        int n2 = 0;
        while (n2 < n) {
            Signature entry = signatureArray[n2];
            if (entry.matches(sig)) {
                return entry;
            }
            ++n2;
        }
        return FileSignatures.checkTxt(sig);
    }

    public static Signature checkTxt(String sig) {
        int i = 0;
        while (i < sig.length()) {
            if (i + 2 > sig.length()) {
                return null;
            }
            String b = sig.substring(i, i + 2);
            int ch = Integer.parseInt(b, 16);
            if (ch < 32 || ch > 126) {
                return null;
            }
            i += 2;
        }
        return SIG_TXT;
    }
}

