/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.hjsplit.jaxe;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import jd.plugins.optional.hjsplit.jaxe.AxeWriterWorker;
import jd.plugins.optional.hjsplit.jaxe.CountingInputStream;
import jd.plugins.optional.hjsplit.jaxe.JobEndEvent;
import jd.plugins.optional.hjsplit.jaxe.JobErrorEvent;
import jd.plugins.optional.hjsplit.jaxe.SplitFileFilter;

public class JAxeJoiner
extends AxeWriterWorker {
    protected final int BUFFER_SIZE = 1024;
    private boolean bZipped = false;
    protected final int CHUNK_UNIT = 1024;
    protected String sDestDir;
    protected String sFileToJoin;
    protected String sJoinedFile;
    protected boolean successfull = false;

    public JAxeJoiner(String sFile) {
        this.sFileToJoin = sFile;
        this.sDestDir = new File(sFile).getParent();
    }

    public JAxeJoiner(String sFile, String sDir) {
        this.sFileToJoin = sFile;
        this.sDestDir = sDir;
    }

    protected boolean checkNoOverwrite(File f) {
        File fTemp = new File(this.sJoinedFile);
        return !fTemp.exists();
    }

    protected void computeJobSize() {
        File fTemp;
        long lReturn = 0L;
        int i = 1;
        do {
            fTemp = new File(i == 1 ? this.sFileToJoin : String.valueOf(this.sJoinedFile) + "." + this.formatWidth(i, 3) + (this.bZipped ? ".zip" : ""));
            lReturn += fTemp.length();
            ++i;
        } while (fTemp.exists());
        this.lJobSize = lReturn;
    }

    protected void doCleanup() {
        new File(this.sJoinedFile).delete();
    }

    public boolean wasSuccessfull() {
        return this.successfull;
    }

    /*
     * Loose catch block
     */
    public void run() {
        BufferedOutputStream bos;
        File fTemp = null;
        InputStream is = null;
        CountingInputStream cis = null;
        int i = 1;
        byte[] ba = new byte[1024];
        this.bStopped = false;
        File fToJoin = new File(this.sFileToJoin);
        if (!SplitFileFilter.isSplitFile(this.sFileToJoin) && !SplitFileFilter.isZippedSplitFile(this.sFileToJoin)) {
            this.dispatchEvent(new JobErrorEvent(this, "File to join does not seem a split file"));
            return;
        }
        this.sJoinedFile = SplitFileFilter.getJoinedFileName(this.sFileToJoin);
        if (!fToJoin.exists() || fToJoin.isDirectory()) {
            this.dispatchEvent(new JobErrorEvent(this, "File to join does not exist or is a directory"));
            return;
        }
        if (!this.checkNoOverwrite(fToJoin)) {
            this.dispatchEvent(new JobErrorEvent(this, "Error: destination file already exists!"));
            return;
        }
        this.bZipped = SplitFileFilter.isZippedSplitFile(this.sFileToJoin);
        try {
            bos = new BufferedOutputStream(new FileOutputStream(this.sJoinedFile));
        }
        catch (FileNotFoundException fnfe) {
            this.dispatchEvent(new JobErrorEvent(this, "Error while opening: " + this.sJoinedFile + " (" + fnfe.getMessage() + ")"));
            return;
        }
        this.computeJobSize();
        this.initProgress();
        i = 1;
        try {
            try {
                do {
                    if (is == null) {
                        fTemp = i == 1 ? new File(this.sFileToJoin) : new File(String.valueOf(this.sJoinedFile) + "." + this.formatWidth(i, 3) + (this.bZipped ? ".zip" : ""));
                        if (!fTemp.exists()) {
                            break;
                        }
                        if (!this.bZipped) {
                            is = new BufferedInputStream(new FileInputStream(fTemp));
                        } else {
                            ZipEntry ze;
                            cis = new CountingInputStream(new FileInputStream(fTemp));
                            cis.setTotal(fTemp.length());
                            ZipInputStream zis = new ZipInputStream(cis);
                            while ((ze = zis.getNextEntry()) != null && !ze.getName().endsWith("." + this.formatWidth(i, 3))) {
                            }
                            if (ze != null) {
                                is = zis;
                            } else {
                                throw new ZipException("Unable to find split entry in zip file");
                            }
                        }
                    }
                    if (this.bStopped) continue;
                    int nLength = is.read(ba, 0, 1024);
                    if (nLength > 0) {
                        bos.write(ba, 0, nLength);
                        this.lCurrent += (long)(this.bZipped ? cis.getLastReadAndReset() : nLength);
                        this.dispatchProgress();
                        continue;
                    }
                    ++i;
                    is.close();
                    is = null;
                    if (!this.bZipped) continue;
                    this.dispatchIncrementalProgress(cis.getDiff());
                } while (!this.bStopped);
            }
            catch (FileNotFoundException fnfe) {
                this.dispatchEvent(new JobErrorEvent(this, "Error while opening: " + fTemp.getName()));
                try {
                    bos.close();
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            catch (ZipException zex) {
                this.dispatchEvent(new JobErrorEvent(this, "Zip error with file " + fTemp.getName() + " (" + zex.getMessage() + ")"));
                try {
                    bos.close();
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            catch (IOException ioe) {
                this.dispatchEvent(new JobErrorEvent(this, "I/O error with file " + fTemp.getName() + " (" + ioe.getMessage() + ")"));
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    bos.close();
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
        }
        finally {
            try {
                bos.close();
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (this.bStopped) {
            this.doCleanup();
            this.dispatchEvent(new JobEndEvent(this, "Join stopped by user."));
        } else {
            this.successfull = true;
            this.dispatchProgress(this.lJobSize);
            this.dispatchEvent(new JobEndEvent(this, "Join terminated."));
        }
    }
}

