/*
 * Decompiled with CFR 0.152.
 */
package jd.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import jd.controlling.JDLogger;
import jd.http.Cookie;
import jd.http.Cookies;
import jd.http.JDProxy;
import jd.http.Request;
import jd.http.RequestHeader;
import jd.http.URLConnectionAdapter;
import jd.http.XTrustProvider;
import jd.http.requests.FormData;
import jd.http.requests.GetRequest;
import jd.http.requests.PostFormDataRequest;
import jd.http.requests.PostRequest;
import jd.http.requests.RequestVariable;
import jd.nutils.encoding.Encoding;
import jd.parser.Regex;
import jd.parser.html.Form;
import jd.parser.html.InputField;
import jd.parser.html.XPath;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrapFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Browser {
    private static JDProxy GLOBAL_PROXY = null;
    private static Logger LOGGER;
    private static HashMap<String, Cookies> COOKIES;
    private HashMap<String, Cookies> cookies = new HashMap();
    private boolean debug = false;
    private static HashMap<URL, Browser> URL_LINK_MAP;
    private HashMap<String, String[]> logins = new HashMap();
    private String acceptLanguage = "de, en-gb;q=0.9, en;q=0.8";
    private int connectTimeout = -1;
    private URL currentURL;
    private boolean doRedirects = false;
    private RequestHeader headers;
    private int limit = 0x100000;
    private int readTimeout = -1;
    private Request request;
    private String customCharset = null;
    private boolean cookiesExclusive = true;
    private JDProxy proxy;
    private HashMap<String, Integer> requestIntervalLimitMap;
    private HashMap<String, Long> requestTimeMap;
    private static HashMap<String, Integer> REQUEST_INTERVAL_LIMIT_MAP;
    private static HashMap<String, Long> REQUESTTIME_MAP;
    private static boolean VERBOSE;
    private static int TIMEOUT_READ;
    private static int TIMEOUT_CONNECT;
    private static final Authenticator AUTHENTICATOR;

    static {
        COOKIES = new HashMap();
        URL_LINK_MAP = new HashMap();
        VERBOSE = false;
        AUTHENTICATOR = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                Browser br = Browser.getAssignedBrowserInstance(this.getRequestingURL());
                if (br == null) {
                    if (LOGGER != null) {
                        LOGGER.warning("Browser Auth Error!");
                    }
                    return null;
                }
                return br.getPasswordAuthentication(this.getRequestingHost(), this.getRequestingPort());
            }
        };
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public static void setLogger(Logger logger) {
        LOGGER = logger;
    }

    public static void setGlobalProxy(JDProxy p) {
        if (LOGGER != null) {
            LOGGER.info("Use global proxy: " + p);
        }
        GLOBAL_PROXY = p;
    }

    public static JDProxy getGlobalProxy() {
        return GLOBAL_PROXY;
    }

    public void clearCookies(String url) {
        String host = Browser.getHost(url);
        Iterator<String> it = this.getCookies().keySet().iterator();
        String check = null;
        while (it.hasNext()) {
            check = it.next();
            if (!check.contains(host)) continue;
            this.cookies.get(check).clear();
            break;
        }
    }

    public void forwardCookies(Request request) throws MalformedURLException {
        if (request == null) {
            return;
        }
        String host = Browser.getHost(request.getUrl());
        Cookies cookies = this.getCookies().get(host);
        if (cookies == null) {
            return;
        }
        for (Cookie cookie : cookies.getCookies()) {
            if (cookie.isExpired()) continue;
            request.getCookies().add(cookie);
        }
    }

    public void forwardCookies(URLConnectionAdapter con) throws MalformedURLException {
        if (con == null) {
            return;
        }
        String host = Browser.getHost(con.getURL().toString());
        Cookies cookies = this.getCookies().get(host);
        String cs = Request.getCookieString(cookies);
        if (cs != null && cs.trim().length() > 0) {
            con.setRequestProperty("Cookie", cs);
        }
    }

    public String getCookie(String url, String string) throws MalformedURLException {
        String host = Browser.getHost(url);
        Cookies cookies = this.getCookies(host);
        Cookie cookie = cookies.get(string);
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }

    private HashMap<String, Cookies> getCookies() {
        if (this.cookiesExclusive) {
            return this.cookies;
        }
        return COOKIES;
    }

    public Cookies getCookies(String url) {
        String host = Browser.getHost(url);
        Cookies cookies2 = this.getCookies().get(host);
        if (cookies2 == null) {
            cookies2 = new Cookies();
            this.getCookies().put(host, cookies2);
        }
        return cookies2;
    }

    public void setCookie(String url, String key, String value) throws MalformedURLException {
        Cookies cookies;
        String host = Browser.getHost(url);
        if (!this.getCookies().containsKey(host) || (cookies = this.getCookies().get(host)) == null) {
            cookies = new Cookies();
            this.getCookies().put(host, cookies);
        }
        Cookie cookie = new Cookie();
        cookie.setHost(host);
        cookie.setKey(key);
        cookie.setValue(value);
        cookies.add(cookie);
    }

    public static String getHost(URL url) {
        return Browser.getHost(url.getHost());
    }

    public static String getHost(String url) {
        String ret = url;
        try {
            ret = new URL(String.valueOf(url)).getHost();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int id = 0;
        while ((id = ret.indexOf(".")) != ret.lastIndexOf(".")) {
            ret = ret.substring(id + 1);
        }
        return ret;
    }

    public void updateCookies(Request request) throws MalformedURLException {
        if (request == null) {
            return;
        }
        String host = Browser.getHost(request.getUrl());
        Cookies cookies = this.getCookies().get(host);
        if (cookies == null) {
            cookies = new Cookies();
            this.getCookies().put(host, cookies);
        }
        cookies.add(request.getCookies());
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public int getConnectTimeout() {
        return this.connectTimeout <= 0 ? this.connectTimeout : TIMEOUT_CONNECT;
    }

    public Form[] getForms() {
        return Form.getForms((Object)this);
    }

    public void setCustomCharset(String charset) {
        this.customCharset = charset;
    }

    public Form getFormBySubmitvalue(String name) {
        Form[] formArray = this.getForms();
        int n = formArray.length;
        int n2 = 0;
        while (n2 < n) {
            Form f = formArray[n2];
            try {
                f.setPreferredSubmit(name);
                return f;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ++n2;
            }
        }
        return null;
    }

    public Form getFormbyProperty(String property, String name) {
        Form[] formArray = this.getForms();
        int n = formArray.length;
        int n2 = 0;
        while (n2 < n) {
            Form f = formArray[n2];
            if (f.getStringProperty(property) != null && f.getStringProperty(property).equalsIgnoreCase(name)) {
                return f;
            }
            ++n2;
        }
        return null;
    }

    public RequestHeader getHeaders() {
        if (this.headers == null) {
            this.headers = new RequestHeader();
        }
        return this.headers;
    }

    public String getPage(String string) throws IOException {
        this.openRequestConnection(this.createGetRequest(string));
        return this.loadConnection(null);
    }

    public void connect(Request request) throws IOException {
        this.request = request;
        try {
            Browser.waitForPageAccess(this, request);
        }
        catch (InterruptedException e) {
            throw new IOException("requestIntervalTime Exception");
        }
        try {
            Browser.assignURLToBrowserInstance(request.getJDPUrl(), this);
            request.connect();
        }
        finally {
            Browser.assignURLToBrowserInstance(request.getJDPUrl(), null);
            Browser.assignURLToBrowserInstance(request.getHttpConnection().getURL(), null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized void waitForPageAccess(Browser browser, Request request) throws InterruptedException {
        try {
            long dif;
            Integer localLimit = null;
            Integer globalLimit = null;
            Long localLastRequest = null;
            Long globalLastRequest = null;
            if (browser.requestIntervalLimitMap != null) {
                localLimit = browser.requestIntervalLimitMap.get(request.getUrl().getHost());
                localLastRequest = browser.requestTimeMap.get(request.getUrl().getHost());
            }
            if (REQUEST_INTERVAL_LIMIT_MAP != null) {
                globalLimit = REQUEST_INTERVAL_LIMIT_MAP.get(request.getUrl().getHost());
                globalLastRequest = REQUESTTIME_MAP.get(request.getUrl().getHost());
            }
            if (localLimit == null && globalLimit == null) {
                return;
            }
            if (localLastRequest == null && globalLastRequest == null) {
                return;
            }
            if (localLimit != null && localLastRequest == null) {
                return;
            }
            if (globalLimit != null && globalLastRequest == null) {
                return;
            }
            if (globalLimit == null) {
                globalLimit = 0;
            }
            if (localLimit == null) {
                localLimit = 0;
            }
            if (localLastRequest == null) {
                localLastRequest = System.currentTimeMillis();
            }
            if (globalLastRequest == null) {
                globalLastRequest = System.currentTimeMillis();
            }
            if ((dif = Math.max((long)localLimit.intValue() - (System.currentTimeMillis() - localLastRequest), (long)globalLimit.intValue() - (System.currentTimeMillis() - globalLastRequest))) <= 0L) return;
            Thread.sleep(dif);
            return;
        }
        finally {
            if (browser.requestTimeMap != null) {
                browser.requestTimeMap.put(request.getUrl().getHost(), System.currentTimeMillis());
            }
            if (REQUESTTIME_MAP != null) {
                REQUESTTIME_MAP.put(request.getUrl().getHost(), System.currentTimeMillis());
            }
        }
    }

    private static void assignURLToBrowserInstance(URL url, Browser browser) {
        if (browser == null) {
            URL_LINK_MAP.remove(url);
        } else {
            URL_LINK_MAP.put(url, browser);
        }
    }

    public static URL reAssignUrlToBrowserInstance(URL url1, URL url2) {
        Browser.assignURLToBrowserInstance(url2, Browser.getAssignedBrowserInstance(url1));
        URL_LINK_MAP.remove(url1);
        return url2;
    }

    public static Browser getAssignedBrowserInstance(URL url) {
        return URL_LINK_MAP.get(url);
    }

    private void checkContentLengthLimit(Request request) throws BrowserException {
        if (request == null || request.getHttpConnection() == null || request.getHttpConnection().getHeaderField("Content-Length") == null) {
            return;
        }
        if (Long.parseLong(request.getHttpConnection().getHeaderField("Content-Length")) > (long)this.limit) {
            if (LOGGER != null) {
                LOGGER.severe(request.printHeaders());
            }
            throw new BrowserException("Content-length too big", request.getHttpConnection());
        }
    }

    public int getReadTimeout() {
        return this.readTimeout <= 0 ? TIMEOUT_READ : this.readTimeout;
    }

    public String getRedirectLocation() {
        if (this.request == null) {
            return null;
        }
        return this.request.getLocation();
    }

    public Request getRequest() {
        return this.request;
    }

    public URLConnectionAdapter openFormConnection(Form form) throws Exception {
        return this.openRequestConnection(this.createFormRequest(form));
    }

    public Request createFormRequest(Form form) throws Exception {
        String base = null;
        if (this.request != null) {
            base = this.request.getUrl().toString();
        }
        try {
            String sourceBase = this.getRegex("<base.*?href=\"(.+?)\"").getMatch(0).trim();
            new URL(sourceBase);
            base = sourceBase;
        }
        catch (Throwable sourceBase) {
            // empty catch block
        }
        String action = form.getAction(base);
        switch (form.getMethod()) {
            case GET: {
                String varString = form.getPropertyString();
                if (varString != null && !varString.matches("[\\s]*")) {
                    if (action.matches(".*\\?.+")) {
                        action = String.valueOf(action) + "&";
                    } else if (action.matches("[^\\?]*")) {
                        action = String.valueOf(action) + "?";
                    }
                    action = String.valueOf(action) + varString;
                }
                return this.createGetRequest(action);
            }
            case POST: {
                if (form.getEncoding() == null || !form.getEncoding().toLowerCase().endsWith("form-data")) {
                    return this.createPostRequest(action, form.getRequestVariables());
                }
                PostFormDataRequest request = (PostFormDataRequest)this.createPostFormDataRequest(action);
                if (form.getEncoding() != null) {
                    request.setEncodeType(form.getEncoding());
                }
                int i = 0;
                while (i < form.getInputFields().size()) {
                    InputField entry = (InputField)form.getInputFields().get(i);
                    if (entry.getValue() != null) {
                        if (entry.getType() != null && entry.getType().equalsIgnoreCase("image")) {
                            request.addFormData(new FormData(String.valueOf(entry.getKey()) + ".x", String.valueOf(entry.getIntegerProperty("x", (int)(Math.random() * 100.0)))));
                            request.addFormData(new FormData(String.valueOf(entry.getKey()) + ".y", String.valueOf(entry.getIntegerProperty("y", (int)(Math.random() * 100.0)))));
                        } else if (entry.getType() != null && entry.getType().equalsIgnoreCase("file")) {
                            request.addFormData(new FormData(entry.getKey(), entry.getFileToPost().getName(), entry.getFileToPost()));
                        } else if (entry.getKey() != null && entry.getValue() != null) {
                            request.addFormData(new FormData(entry.getKey(), entry.getValue()));
                        }
                    }
                    ++i;
                }
                return request;
            }
        }
        return null;
    }

    public URLConnectionAdapter openGetConnection(String string) throws IOException {
        return this.openRequestConnection(this.createGetRequest(string));
    }

    public URLConnectionAdapter openRequestConnection(Request request) throws IOException {
        this.connect(request);
        if (this.isDebug() && LOGGER != null) {
            LOGGER.finest("\r\n" + request.printHeaders());
        }
        this.updateCookies(request);
        this.request = request;
        if (this.doRedirects && request.getLocation() != null) {
            if (request.getLocation().toLowerCase().startsWith("ftp://")) {
                throw new BrowserException("Cannot redirect to FTP");
            }
            this.openGetConnection(null);
        } else {
            this.currentURL = request.getUrl();
        }
        return this.request.getHttpConnection();
    }

    public Request createGetRequest(String string) throws IOException {
        string = this.getURL(string);
        boolean sendref = true;
        if (this.currentURL == null) {
            sendref = false;
            this.currentURL = new URL(string);
        }
        GetRequest request = new GetRequest(string);
        request.setCustomCharset(this.customCharset);
        if (this.selectProxy() != null) {
            request.setProxy(this.selectProxy());
        }
        if (this.connectTimeout > 0) {
            request.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout > 0) {
            request.setReadTimeout(this.readTimeout);
        }
        request.getHeaders().put("Accept-Language", this.acceptLanguage);
        this.forwardCookies(request);
        if (sendref) {
            request.getHeaders().put("Referer", this.currentURL.toString());
        }
        if (this.headers != null) {
            this.mergeHeaders(request);
        }
        return request;
    }

    private void mergeHeaders(Request request) {
        if (this.headers.isDominant()) {
            request.getHeaders().clear();
        }
        int i = 0;
        while (i < this.headers.size()) {
            if (this.headers.getValue(i) == null) {
                request.getHeaders().remove(this.headers.getKey(i));
            } else {
                request.getHeaders().put(this.headers.getKey(i), this.headers.getValue(i));
            }
            ++i;
        }
    }

    private JDProxy selectProxy() {
        if (this.proxy != null) {
            if (this.proxy == JDProxy.NO_PROXY) {
                return null;
            }
            return this.proxy;
        }
        return GLOBAL_PROXY;
    }

    public Request createGetRequestRedirectedRequest(Request oldrequest) throws IOException {
        String string = this.getURL(oldrequest.getLocation());
        boolean sendref = true;
        if (this.currentURL == null) {
            sendref = false;
            this.currentURL = new URL(string);
        }
        GetRequest request = new GetRequest(string);
        request.setCustomCharset(this.customCharset);
        if (this.selectProxy() != null) {
            request.setProxy(this.selectProxy());
        }
        request.setCookies(oldrequest.getCookies());
        if (this.connectTimeout > 0) {
            request.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout > 0) {
            request.setReadTimeout(this.readTimeout);
        }
        request.getHeaders().put("Accept-Language", this.acceptLanguage);
        this.forwardCookies(request);
        if (sendref) {
            request.getHeaders().put("Referer", this.currentURL.toString());
        }
        if (this.headers != null) {
            this.mergeHeaders(request);
        }
        return request;
    }

    public String getURL(String string) throws BrowserException {
        if (string == null) {
            string = this.getRedirectLocation();
        }
        if (string == null) {
            throw new BrowserException("Null URL");
        }
        try {
            new URL(string);
        }
        catch (Exception e) {
            if (this.request == null || this.request.getHttpConnection() == null) {
                return string;
            }
            String base = this.getBase(string);
            if (string.startsWith("/") || string.startsWith("\\")) {
                try {
                    URL bUrl = new URL(base);
                    if (bUrl.getPort() != 80 && bUrl.getPort() > 0) {
                        string = "http://" + new URL(base).getHost() + ":" + bUrl.getPort() + string;
                    }
                    string = "http://" + new URL(base).getHost() + string;
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
            }
            string = String.valueOf(base) + string;
        }
        return Browser.correctURL(Encoding.urlEncode_light((String)string));
    }

    private String getBase(String string) {
        if (string == null) {
            return "";
        }
        String base = this.getRegex("<base\\s*href=\"(.*?)\">").getMatch(0);
        if (base != null) {
            return base;
        }
        String path = this.request.getHttpConnection().getURL().getPath();
        int id = path.lastIndexOf("/");
        if (id >= 0) {
            path = path.substring(0, id);
        }
        string = this.request.getHttpConnection().getURL().getPort() != 80 && this.request.getHttpConnection().getURL().getPort() > 0 ? "http://" + this.request.getHttpConnection().getURL().getHost() + ":" + this.request.getHttpConnection().getURL().getPort() + path + "/" : "http://" + this.request.getHttpConnection().getURL().getHost() + path + "/";
        return string;
    }

    public URLConnectionAdapter openPostConnection(String url, LinkedHashMap<String, String> post) throws IOException {
        return this.openRequestConnection(this.createPostRequest(url, post));
    }

    public Request createPostRequestfromRedirectedRequest(Request oldrequest, String postdata) throws IOException {
        String url = this.getURL(oldrequest.getLocation());
        boolean sendref = true;
        if (this.currentURL == null) {
            sendref = false;
            this.currentURL = new URL(url);
        }
        LinkedHashMap<String, String> post = Request.parseQuery(postdata);
        PostRequest request = new PostRequest(url);
        request.setCustomCharset(this.customCharset);
        if (this.selectProxy() != null) {
            request.setProxy(this.selectProxy());
        }
        request.setCookies(oldrequest.getCookies());
        request.getHeaders().put("Accept-Language", this.acceptLanguage);
        if (this.connectTimeout > 0) {
            request.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout > 0) {
            request.setReadTimeout(this.readTimeout);
        }
        this.forwardCookies(request);
        if (sendref) {
            request.getHeaders().put("Referer", this.currentURL.toString());
        }
        if (post != null) {
            request.addAll(post);
        }
        if (this.headers != null) {
            this.mergeHeaders(request);
        }
        return request;
    }

    public Request createPostFormDataRequest(String url) throws IOException {
        url = this.getURL(url);
        boolean sendref = true;
        if (this.currentURL == null) {
            sendref = false;
            this.currentURL = new URL(url);
        }
        PostFormDataRequest request = new PostFormDataRequest(url);
        request.setCustomCharset(this.customCharset);
        if (this.selectProxy() != null) {
            request.setProxy(this.selectProxy());
        }
        request.getHeaders().put("Accept-Language", this.acceptLanguage);
        if (this.connectTimeout > 0) {
            request.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout > 0) {
            request.setReadTimeout(this.readTimeout);
        }
        this.forwardCookies(request);
        if (sendref) {
            request.getHeaders().put("Referer", this.currentURL.toString());
        }
        if (this.headers != null) {
            this.mergeHeaders(request);
        }
        return request;
    }

    public Request createPostRequest(String url, LinkedHashMap<String, String> post) throws IOException {
        return this.createPostRequest(url, PostRequest.variableMaptoArray(post));
    }

    private Request createPostRequest(String url, ArrayList<RequestVariable> post) throws IOException {
        url = this.getURL(url);
        boolean sendref = true;
        if (this.currentURL == null) {
            sendref = false;
            this.currentURL = new URL(url);
        }
        PostRequest request = new PostRequest(url);
        request.setCustomCharset(this.customCharset);
        if (this.selectProxy() != null) {
            request.setProxy(this.selectProxy());
        }
        request.getHeaders().put("Accept-Language", this.acceptLanguage);
        if (this.connectTimeout > 0) {
            request.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout > 0) {
            request.setReadTimeout(this.readTimeout);
        }
        this.forwardCookies(request);
        if (sendref) {
            request.getHeaders().put("Referer", this.currentURL.toString());
        }
        if (post != null) {
            request.addAll(post);
        }
        if (this.headers != null) {
            this.mergeHeaders(request);
        }
        return request;
    }

    public Request createPostRequest(String url, String post) throws MalformedURLException, IOException {
        return this.createPostRequest(url, Request.parseQuery(post));
    }

    public URLConnectionAdapter openPostConnection(String url, String post) throws IOException {
        return this.openPostConnection(url, Request.parseQuery(post));
    }

    public String postPage(String url, LinkedHashMap<String, String> post) throws IOException {
        this.openPostConnection(url, post);
        return this.loadConnection(null);
    }

    public String postPage(String url, String post) throws IOException {
        return this.postPage(url, Request.parseQuery(post));
    }

    public String postPageRaw(String url, String post) throws IOException {
        PostRequest request = (PostRequest)this.createPostRequest(url, new ArrayList<RequestVariable>());
        request.setCustomCharset(this.customCharset);
        if (post != null) {
            request.setPostDataString(post);
        }
        this.openRequestConnection(request);
        return this.loadConnection(null);
    }

    public void setAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setCurrentURL(String string) throws MalformedURLException {
        this.currentURL = new URL(string);
    }

    public void setFollowRedirects(boolean b) {
        this.doRedirects = b;
    }

    public boolean isFollowingRedirects() {
        return this.doRedirects;
    }

    public void setHeaders(RequestHeader h) {
        this.headers = h;
    }

    public void setLoadLimit(int i) {
        this.limit = i;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getBaseURL() {
        if (this.request == null) {
            return null;
        }
        String base = this.request.getUrl().toString();
        if (base.matches("http://.*/.*")) {
            return String.valueOf(base.substring(0, base.lastIndexOf("/"))) + "/";
        }
        return String.valueOf(base) + "/";
    }

    public String submitForm(Form form) throws Exception {
        this.openFormConnection(form);
        this.checkContentLengthLimit(this.request);
        return this.request.read();
    }

    public String toString() {
        if (this.request == null) {
            return "Browser. no request yet";
        }
        return this.request.toString();
    }

    public Regex getRegex(String string) {
        return new Regex((Object)this, string);
    }

    public Regex getRegex(Pattern compile) {
        return new Regex((Object)this, compile);
    }

    public boolean containsHTML(String regex) {
        return new Regex((Object)this, regex).matches();
    }

    public String loadConnection(URLConnectionAdapter con) throws IOException {
        String ret = null;
        try {
            if (con == null) {
                this.checkContentLengthLimit(this.request);
                con = this.request.getHttpConnection();
                ret = this.request.read();
            } else {
                ret = Request.read(con);
            }
        }
        catch (BrowserException e) {
            throw e;
        }
        catch (IOException e) {
            throw new BrowserException(e.getMessage(), con, e).closeConnection();
        }
        if (Browser.isVerbose() && LOGGER != null) {
            LOGGER.finest("\r\n" + ret + "\r\n");
        }
        return ret;
    }

    public URLConnectionAdapter getHttpConnection() {
        if (this.request == null) {
            return null;
        }
        return this.request.getHttpConnection();
    }

    public static void download(File file, URLConnectionAdapter con) throws IOException {
        int len;
        if (file.isFile() && !file.delete()) {
            System.out.println("Konnte Datei nicht l\u00f6schen " + file);
            throw new IOException("Could not overwrite file: " + file);
        }
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        file.createNewFile();
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file, true));
        BufferedInputStream input = con.getHeaderField("Content-Encoding") != null && con.getHeaderField("Content-Encoding").equalsIgnoreCase("gzip") ? new BufferedInputStream(new GZIPInputStream(con.getInputStream())) : new BufferedInputStream(con.getInputStream());
        byte[] b = new byte[1024];
        while ((len = input.read(b)) != -1) {
            output.write(b, 0, len);
        }
        output.close();
        input.close();
    }

    public void getDownload(File file, String urlString) throws IOException {
        urlString = URLDecoder.decode(urlString, "UTF-8");
        URLConnectionAdapter con = this.openGetConnection(urlString);
        con.setInstanceFollowRedirects(true);
        Browser.download(file, con);
    }

    public void downloadConnection(File file, URLConnectionAdapter con) throws IOException {
        if (con == null) {
            con = this.request.getHttpConnection();
        }
        con.setInstanceFollowRedirects(true);
        Browser.download(file, con);
    }

    public static void download(File file, String url) throws IOException {
        new Browser().getDownload(file, url);
    }

    public Form getForm(int i) {
        Form[] forms = this.getForms();
        if (forms.length <= i) {
            return null;
        }
        return forms[i];
    }

    public String getHost() {
        if (this.request == null) {
            return null;
        }
        return this.request.getUrl().getHost();
    }

    public Browser cloneBrowser() {
        Browser br = new Browser();
        br.requestIntervalLimitMap = this.requestIntervalLimitMap;
        br.requestTimeMap = this.requestTimeMap;
        br.acceptLanguage = this.acceptLanguage;
        br.connectTimeout = this.connectTimeout;
        br.currentURL = this.currentURL;
        br.doRedirects = this.doRedirects;
        br.setCustomCharset(this.customCharset);
        br.getHeaders().putAll(this.getHeaders());
        br.limit = this.limit;
        br.readTimeout = this.readTimeout;
        br.request = this.request;
        br.cookies = this.cookies;
        br.logins = new HashMap();
        br.logins.putAll(this.logins);
        br.cookiesExclusive = this.cookiesExclusive;
        br.debug = this.debug;
        br.proxy = this.proxy;
        return br;
    }

    public Form[] getForms(String downloadURL) throws IOException {
        this.getPage(downloadURL);
        return this.getForms();
    }

    public URLConnectionAdapter openFormConnection(int i) throws Exception {
        return this.openFormConnection(this.getForm(i));
    }

    public String getMatch(String string) {
        return this.getRegex(string).getMatch(0);
    }

    public String getURL() {
        if (this.request == null) {
            return null;
        }
        return this.request.getUrl().toString();
    }

    public void setCookiesExclusive(boolean b) {
        if (this.cookiesExclusive == b) {
            return;
        }
        this.cookiesExclusive = b;
        if (b) {
            this.cookies.clear();
            for (Map.Entry<String, Cookies> next : COOKIES.entrySet()) {
                Cookies tmp = new Cookies();
                this.cookies.put(next.getKey(), tmp);
                tmp.add(next.getValue());
            }
        } else {
            this.cookies.clear();
        }
    }

    public boolean isCookiesExclusive() {
        return this.cookiesExclusive;
    }

    public String followConnection() throws IOException {
        String ret = null;
        if (this.request.getHtmlCode() != null) {
            if (LOGGER != null) {
                LOGGER.warning("Request has already been read");
            }
            return null;
        }
        this.checkContentLengthLimit(this.request);
        ret = this.request.read();
        return ret;
    }

    public boolean isDebug() {
        return this.debug || VERBOSE;
    }

    public void setDebug(boolean debug) {
        String caller = "" + Thread.currentThread().getContextClassLoader().getResource("jd");
        if (!caller.matches("jar\\:.*\\.jar\\!.*")) {
            this.debug = debug;
        }
    }

    public void setAuth(String domain, String user, String pass) {
        if ((domain = domain.trim()).indexOf(":") <= 0) {
            domain = String.valueOf(domain) + ":80";
        }
        this.logins.put(domain, new String[]{user, pass});
    }

    public String[] getAuth(String domain) {
        String[] ret;
        if ((domain = domain.trim()).indexOf(":") <= 0) {
            domain = String.valueOf(domain) + ":80";
        }
        if ((ret = this.logins.get(domain)) == null && this.selectProxy() != null && (String.valueOf(this.selectProxy().getHost()) + ":" + this.selectProxy().getPort()).equalsIgnoreCase(domain)) {
            ret = new String[]{this.selectProxy().getUser(), this.selectProxy().getPass()};
        }
        return ret;
    }

    public String submitForm(String formname) throws Exception {
        return this.submitForm(this.getFormBySubmitvalue(formname));
    }

    public String getPage(URL url) throws IOException {
        return this.getPage("" + url);
    }

    public void setRequest(Request request) throws MalformedURLException {
        if (request == null) {
            return;
        }
        this.updateCookies(request);
        this.request = request;
        this.currentURL = request.getUrl();
    }

    public Request createRequest(Form form) throws Exception {
        return this.createFormRequest(form);
    }

    public Request createRequest(String downloadURL) throws Exception {
        return this.createGetRequest(downloadURL);
    }

    public String getXPathElement(String xPath) {
        return new XPath(this.toString(), xPath, false).getFirstMatch();
    }

    public void setProxy(JDProxy proxy) {
        if (this.debug && LOGGER != null) {
            LOGGER.info("Use local proxy: " + proxy);
        }
        if (proxy == null) {
            System.err.println("Browser:No proxy");
            this.proxy = null;
            return;
        }
        this.proxy = proxy;
    }

    public JDProxy getProxy() {
        return this.proxy;
    }

    public void forceDebug(boolean b) {
        this.debug = b;
    }

    public PasswordAuthentication getPasswordAuthentication(String host, int port) {
        String[] auth;
        if (port <= 0) {
            port = 80;
        }
        if ((auth = this.getAuth(String.valueOf(host) + ":" + port)) == null) {
            return null;
        }
        if (LOGGER != null) {
            LOGGER.finest("Use Authentication for: " + host + ":" + port + ": " + auth[0] + " - " + auth[1]);
        }
        return new PasswordAuthentication(auth[0], auth[1].toCharArray());
    }

    public static void init() {
        try {
            ContextFactory.initGlobal((ContextFactory)new SandboxContextFactory());
            JDLogger.getLogger().warning("Installed JS Hotfix");
        }
        catch (Throwable e) {
            JDLogger.getLogger().warning("Installed JS Hotfix failed");
            e.printStackTrace();
        }
        Authenticator.setDefault(AUTHENTICATOR);
        CookieHandler.setDefault(null);
        XTrustProvider.install();
        HostnameVerifier hv = new HostnameVerifier(){

            public boolean verify(String arg0, SSLSession arg1) {
                return false;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
    }

    public void setRequestIntervalLimit(String host, int i) {
        if (this.requestIntervalLimitMap == null) {
            this.requestTimeMap = new HashMap();
            this.requestIntervalLimitMap = new HashMap();
        }
        this.requestIntervalLimitMap.put(host, i);
    }

    public static synchronized void setRequestIntervalLimitGlobal(String host, int i) {
        if (REQUEST_INTERVAL_LIMIT_MAP == null) {
            REQUEST_INTERVAL_LIMIT_MAP = new HashMap();
            REQUESTTIME_MAP = new HashMap();
        }
        REQUEST_INTERVAL_LIMIT_MAP.put(host, i);
    }

    public static boolean isVerbose() {
        return VERBOSE;
    }

    public static void setVerbose(boolean b) {
        VERBOSE = b;
    }

    public static void setGlobalReadTimeout(int valueMS) {
        TIMEOUT_READ = valueMS;
    }

    public static int getGlobalReadTimeout() {
        return TIMEOUT_READ;
    }

    public static void setGlobalConnectTimeout(int valueMS) {
        TIMEOUT_CONNECT = valueMS;
    }

    public static int getGlobalConnectTimeout() {
        return TIMEOUT_CONNECT;
    }

    public Form getFormbyKey(String key) {
        Form[] formArray = this.getForms();
        int n = formArray.length;
        int n2 = 0;
        while (n2 < n) {
            Form f = formArray[n2];
            if (f.hasInputFieldByName(key)) {
                return f;
            }
            ++n2;
        }
        return null;
    }

    public static String correctURL(String url) {
        int begin = url.indexOf("://");
        if (url == null || begin > 0 && !url.substring(begin).contains("//") || !url.contains("./")) {
            return url;
        }
        String ret = url;
        String end = null;
        String tmp = null;
        boolean endisslash = false;
        begin = url.startsWith("http://") ? 8 : (url.startsWith("https://") ? 9 : 0);
        int first = url.indexOf("/", begin);
        if (first < 0) {
            return ret;
        }
        ret = url.substring(0, first);
        int endp = url.indexOf("?", first);
        if (endp > 0) {
            end = url.substring(endp);
            tmp = url.substring(first, endp);
        } else {
            tmp = url.substring(first);
        }
        endisslash = tmp.endsWith("/");
        tmp = tmp.replaceAll("/+", "/");
        String[] parts = tmp.split("/");
        int i = 0;
        while (i < parts.length) {
            if (parts[i].equalsIgnoreCase(".")) {
                parts[i] = "";
            } else if (parts[i].equalsIgnoreCase("..")) {
                if (i > 0) {
                    int j = i - 1;
                    while (j > 0) {
                        if (parts[j].length() > 0) {
                            parts[j] = "";
                            break;
                        }
                        --j;
                    }
                }
                parts[i] = "";
            }
            ++i;
        }
        tmp = "";
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (part.length() > 0) {
                tmp = String.valueOf(tmp) + "/" + part;
            }
            ++n2;
        }
        if (endisslash) {
            tmp = String.valueOf(tmp) + "/";
        }
        ret = String.valueOf(ret) + tmp + (end != null ? end : "");
        return ret;
    }

    public class BrowserException
    extends IOException {
        private static final long serialVersionUID = 1509988898224037320L;
        private URLConnectionAdapter connection;
        private Exception e;

        public BrowserException(String string) {
            super(string);
            this.e = null;
        }

        public BrowserException(String string, Exception e) {
            this(string);
            this.e = e;
        }

        public BrowserException(String message, URLConnectionAdapter con) {
            this(message);
            this.connection = con;
        }

        public BrowserException(String message, URLConnectionAdapter con, Exception e) {
            this(message, con);
            this.e = e;
        }

        public BrowserException closeConnection() {
            if (this.connection != null && this.connection.isConnected()) {
                this.connection.disconnect();
            }
            return this;
        }

        public URLConnectionAdapter getConnection() {
            return this.connection;
        }

        public Exception getException() {
            return this.e;
        }
    }

    public static class SandboxContextFactory
    extends ContextFactory {
        protected Context makeContext() {
            Context cx = super.makeContext();
            cx.setWrapFactory((WrapFactory)new SandboxWrapFactory());
            cx.setClassShutter(new ClassShutter(){

                public boolean visibleToScripts(String className) {
                    if (className.startsWith("adapter")) {
                        return true;
                    }
                    if (className.equals("org.mozilla.javascript.EcmaError")) {
                        JDLogger.getLogger().severe("Javascript error occured");
                        return true;
                    }
                    throw new RuntimeException("Security Violation " + className);
                }
            });
            return cx;
        }
    }

    public static class SandboxNativeJavaObject
    extends NativeJavaObject {
        private static final long serialVersionUID = -2783084485265910840L;

        public SandboxNativeJavaObject(Scriptable scope, Object javaObject, Class staticType) {
            super(scope, javaObject, staticType);
        }

        public Object get(String name, Scriptable start) {
            JDLogger.getLogger().severe("JS Security Exception");
            return NOT_FOUND;
        }
    }

    public static class SandboxWrapFactory
    extends WrapFactory {
        public Scriptable wrapAsJavaObject(Context cx, Scriptable scope, Object javaObject, Class staticType) {
            return new SandboxNativeJavaObject(scope, javaObject, staticType);
        }
    }
}

