/*
 * Decompiled with CFR 0.152.
 */
package jd.http;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import jd.controlling.JDLogger;
import jd.parser.Regex;

public class JDProxy
extends Proxy {
    private String user = null;
    private String pass = null;
    private int port = 80;
    private String host;
    private boolean direct = false;
    public static JDProxy NO_PROXY = new JDProxy();

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public int getPort() {
        return this.port;
    }

    public JDProxy(Proxy.Type type, SocketAddress sa) {
        super(type, sa);
        this.host = new Regex(sa.toString(), "(.*)\\/").getMatch(0);
    }

    public JDProxy(Proxy.Type type, String host, int port) {
        super(type, new InetSocketAddress(JDProxy.getInfo(host, "" + port)[0], port));
        this.port = port;
        this.host = JDProxy.getInfo(host, "" + port)[0];
    }

    private static String[] getInfo(String host, String port) {
        String[] info = new String[2];
        if (host == null) {
            return info;
        }
        String tmphost = host.replaceFirst("http://", "").replaceFirst("https://", "");
        String tmpport = new Regex(host, ".*?:(\\d+)").getMatch(0);
        if (tmpport != null) {
            info[1] = tmpport;
        } else {
            if (port != null) {
                tmpport = new Regex(port, "(\\d+)").getMatch(0);
            }
            if (tmpport != null) {
                info[1] = tmpport;
            } else {
                JDLogger.getLogger().severe("No proxyport defined, using default 8080");
                info[1] = "8080";
            }
        }
        info[0] = new Regex(tmphost, "(.*?)(:|/|$)").getMatch(0);
        return info;
    }

    public JDProxy(String hostAndPort) {
        super(Proxy.Type.HTTP, new InetSocketAddress(JDProxy.getInfo(hostAndPort, null)[0], Integer.parseInt(JDProxy.getInfo(hostAndPort, null)[1])));
        this.port = Integer.parseInt(JDProxy.getInfo(hostAndPort, null)[1]);
        this.host = JDProxy.getInfo(hostAndPort, null)[0];
    }

    public JDProxy(String host, int port, String user, String pass) {
        super(Proxy.Type.HTTP, new InetSocketAddress(JDProxy.getInfo(host, "" + port)[0], port));
        this.port = port;
        this.user = user;
        this.pass = pass;
        this.host = JDProxy.getInfo(host, "" + port)[0];
    }

    private JDProxy() {
        super(Proxy.Type.HTTP, new InetSocketAddress(80));
        this.direct = true;
    }

    public Proxy.Type type() {
        if (this.direct) {
            return Proxy.Type.DIRECT;
        }
        return super.type();
    }

    public String getHost() {
        return this.host;
    }

    public String toString() {
        return "JDProxy: " + super.toString();
    }
}

