/*
 * Decompiled with CFR 0.152.
 */
package jd.http.download;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class HDWriter
extends Thread {
    private static HDWriter WRITER = null;
    private STATUS currentStatus = STATUS.FREE;
    private ByteBuffer buffer;
    private FileChannel channel;
    private long position;
    private Exception exception;

    private HDWriter() {
    }

    public static synchronized HDWriter getWriter() {
        if (WRITER == null || !WRITER.isAlive()) {
            WRITER = new HDWriter();
            WRITER.start();
        }
        return WRITER;
    }

    public void run() {
        while (!this.isInterrupted()) {
            try {
                this.write();
            }
            catch (Exception e) {
                this.exception = e;
            }
        }
    }

    private synchronized void write() throws IOException, InterruptedException {
        while (this.currentStatus != STATUS.WRITING_IN_PROGRESS) {
            this.wait();
        }
        this.buffer.flip();
        this.channel.position(this.position);
        System.out.println("Write " + this.position + "-" + (this.position + (long)this.buffer.limit()) + " :  " + this.buffer.limit());
        this.channel.write(this.buffer);
        this.currentStatus = STATUS.FREE;
        this.notifyAll();
    }

    public synchronized void writeAndWait(ByteBuffer buffer, FileChannel outputChannel, long writePosition) throws Exception {
        while (this.currentStatus != STATUS.FREE) {
            this.wait();
        }
        this.buffer = buffer;
        this.channel = outputChannel;
        this.position = writePosition;
        this.currentStatus = STATUS.WRITING_IN_PROGRESS;
        this.notifyAll();
        this.waitForWriting();
    }

    private synchronized void waitForWriting() throws Exception {
        while (this.currentStatus != STATUS.FREE) {
            this.wait();
        }
        if (this.exception != null) {
            try {
                throw this.exception;
            }
            catch (Throwable throwable) {
                this.exception = null;
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum STATUS {
        FREE,
        WRITING_IN_PROGRESS;

    }
}

