/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha;

import com.jhlabs.image.PosterizeFilter;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.util.ArrayList;
import jd.captcha.JAntiCaptcha;
import jd.captcha.LetterComperator;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelgrid.PixelGrid;
import jd.captcha.pixelobject.PixelObject;
import jd.nutils.Colors;

public class ColorLetterComperator {
    private Letter a;
    private Letter b;
    private PixelObject[] aLayers;
    private PixelObject[] bLayers;
    private Captcha ca;
    private Captcha cb;
    private JAntiCaptcha owner;
    public int lettersPerfect = 2;
    public int lettersPerfectPercent = 20;
    public int maxColorDifference = 30;
    protected double valityPercent = 10000.0;
    public int colorLevels = 2;

    public ColorLetterComperator(Letter a, Letter b) {
        this.a = a;
        this.b = b;
        if (a.owner != null) {
            this.owner = a.owner;
        } else if (b.owner != null) {
            this.owner = b.owner;
        }
    }

    public void setLetterA(Letter a) {
        this.a = a;
        this.ca = null;
        this.aLayers = null;
    }

    public void setLetterB(Letter b) {
        this.b = b;
        this.cb = null;
        this.bLayers = null;
    }

    private Letter getSWLetter(PixelObject obj) {
        int[][] lgrid = new int[obj.getWidth()][obj.getHeight()];
        int x = 0;
        while (x < obj.getWidth()) {
            int y = 0;
            while (y < obj.getHeight()) {
                lgrid[x][y] = 0xFFFFFF;
                ++y;
            }
            ++x;
        }
        int w = 0;
        int d = 0;
        while (d < obj.getSize()) {
            ++w;
            int[] akt = obj.elementAt(d);
            lgrid[akt[0] - obj.getXMin()][akt[1] - obj.getYMin()] = 0;
            ++d;
        }
        if (obj.getArea() / 2 < w) {
            int x2 = 0;
            while (x2 < obj.getWidth()) {
                int y = 0;
                while (y < obj.getHeight()) {
                    lgrid[x2][y] = lgrid[x2][y] == 0xFFFFFF ? 0 : 0xFFFFFF;
                    ++y;
                }
                ++x2;
            }
        }
        Letter l = obj.owner.createLetter();
        l.setElementPixel(obj.getSize());
        l.setLocation(new int[]{obj.getXMin(), obj.getYMin()});
        l.setGrid(lgrid);
        l.detected = obj.detected;
        return l;
    }

    public double run() {
        if (this.aLayers != null && this.bLayers != null) {
            return this.valityPercent;
        }
        if (this.a.getArea() / 5 > this.b.getArea() || this.b.getArea() / 5 > this.a.getArea()) {
            this.valityPercent = 10000.0;
            return this.valityPercent;
        }
        if (this.ca == null) {
            this.ca = this.reduceColors(this.a);
        }
        if (this.cb == null) {
            this.cb = this.reduceColors(this.b);
        }
        if (this.aLayers == null) {
            this.aLayers = ColorLetterComperator.getObjects(this.ca);
        }
        if (this.bLayers == null) {
            this.bLayers = ColorLetterComperator.getObjects(this.cb);
        }
        double ret = 0.0;
        int minl = Math.min(this.aLayers.length, this.bLayers.length);
        int perf = 0;
        int maxl = Math.max(this.aLayers.length, this.bLayers.length);
        boolean minla = this.aLayers.length == minl;
        PixelObject[][] bestarray = new PixelObject[minl][2];
        int i = 0;
        while (i < minl) {
            double best = Double.MAX_VALUE;
            PixelObject[] bestobj = null;
            int j = maxl - i - 1;
            while (j >= 0) {
                double value = 0.0;
                int a = j;
                int b = i;
                if (minla) {
                    a = i;
                    b = j;
                }
                if ((value = Colors.getColorDifference((int)this.aLayers[a].getAverage(), (int)this.bLayers[b].getAverage())) == 0.0) {
                    bestobj = new PixelObject[]{this.aLayers[a], this.bLayers[b]};
                    break;
                }
                if (value < best) {
                    best = value;
                    bestobj = new PixelObject[]{this.aLayers[a], this.bLayers[b]};
                }
                --j;
            }
            bestarray[i] = bestobj;
            ++i;
        }
        i = 0;
        while (i < bestarray.length) {
            if (Colors.getColorDifference((int)bestarray[i][0].getAverage(), (int)bestarray[i][1].getAverage()) > (double)this.maxColorDifference) {
                ret += 100.0;
            } else {
                LetterComperator lc;
                block17: {
                    Letter leta = this.getSWLetter(bestarray[i][0]);
                    lc = new LetterComperator(leta, this.getSWLetter(bestarray[i][1]));
                    lc.setOwner(this.getJac());
                    bestarray[i][0].detected = lc;
                    lc.run();
                    double vall = lc.getValityPercent();
                    if (!(vall < (double)this.lettersPerfectPercent)) break block17;
                    this.valityPercent = 0.0;
                    if (++perf != this.lettersPerfect) break block17;
                    return 0.0;
                }
                try {
                    ret += lc.getValityPercent();
                }
                catch (Exception e) {
                    ret += ret / (double)i;
                }
            }
            ++i;
        }
        this.valityPercent = (ret += (double)((maxl - minl) * 100)) / (double)maxl;
        return this.valityPercent;
    }

    private JAntiCaptcha getJac() {
        if (this.owner != null) {
            return this.owner;
        }
        String hoster = "EasyCaptcha";
        this.owner = new JAntiCaptcha(hoster);
        return this.owner;
    }

    public static PixelObject[] getObjects(PixelGrid grid) {
        ArrayList<PixelObject> ret = new ArrayList<PixelObject>();
        int x = 0;
        while (x < grid.getWidth()) {
            int y = 0;
            while (y < grid.getHeight()) {
                PixelObject n = new PixelObject(grid);
                n.add(x, y, grid.getGrid()[x][y]);
                ArrayList<PixelObject> merge = new ArrayList<PixelObject>();
                for (PixelObject o : ret) {
                    if (grid.getGrid()[x][y] != o.getAverage()) continue;
                    merge.add(o);
                }
                if (merge.size() == 0) {
                    ret.add(n);
                } else if (merge.size() == 1) {
                    ((PixelObject)merge.get(0)).add(n);
                } else {
                    for (PixelObject po : merge) {
                        ret.remove(po);
                        n.add(po);
                    }
                    ret.add(n);
                }
                ++y;
            }
            ++x;
        }
        return ret.toArray(new PixelObject[0]);
    }

    private Captcha reduceColors(Letter letter) {
        PosterizeFilter qf = new PosterizeFilter();
        BufferedImage image = letter.getImage();
        BufferedImage dest = qf.createCompatibleDestImage(image, ColorModel.getRGBdefault());
        qf.setNumLevels(this.colorLevels);
        qf.filter(image, dest);
        return this.getJac().createCaptcha(dest);
    }
}

