/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import jd.captcha.JAntiCaptcha;
import jd.captcha.utils.Utilities;
import jd.gui.swing.components.BrowseFile;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;

public class JACController {
    private static BrowseFile chooser;
    private static JComboBox methods;
    private JAntiCaptcha jac;
    private File path;

    public static void showDialog(final boolean isTrain) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setLayout((LayoutManager)new MigLayout("wrap 2"));
        if (isTrain) {
            frame.setTitle(JDL.L((String)"train.chooser.title", (String)"jDownloader :: TrainAll"));
        } else {
            frame.setTitle(JDL.L((String)"showcaptcha.chooser.title", (String)"jDownloader :: Show Captcha"));
        }
        frame.setAlwaysOnTop(true);
        frame.setLocation(20, 20);
        File[] meths = new File(Utilities.getMethodDir()).listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        methods = new JComboBox<File>(meths);
        chooser = new BrowseFile();
        if (isTrain) {
            chooser.setFileSelectionMode(1);
        }
        chooser.setEditable(true);
        String chooserText = "";
        chooserText = isTrain ? JDL.L((String)"train.choose.folder", (String)"W\u00e4hlen sie einen Ordner aus") : JDL.L((String)"showcaptcha.choose.file", (String)"W\u00e4hlen sie eine Bilddatei aus");
        frame.add(new JLabel(JDL.L((String)"train.method", (String)"W\u00e4hlen sie eine Methode aus:")));
        frame.add((Component)methods, "growx, spanx");
        frame.add(new JLabel(chooserText));
        frame.add((Component)chooser, "growx, spanx");
        JButton btnOK = new JButton(JDL.L((String)"gui.btn_ok", (String)"OK"));
        btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Thread(new Runnable(){

                    public void run() {
                        JACController jacc = new JACController(new File(chooser.getText()), ((File)methods.getSelectedItem()).getName());
                        if (isTrain) {
                            jacc.train();
                        } else {
                            jacc.showCaptcha();
                        }
                    }
                }).start();
            }
        });
        frame.add((Component)btnOK, "span, right");
        frame.pack();
        frame.setResizable(false);
        frame.setVisible(true);
    }

    public JACController(File path, String methode) {
        this.path = path;
        this.jac = new JAntiCaptcha(methode);
    }

    public void showCaptcha() {
        this.jac.showPreparedCaptcha(this.path);
    }

    public void train() {
        this.jac.trainAllCaptchas(this.path.getAbsolutePath());
        this.jac.saveMTHFile();
    }
}

