/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;
import jd.controlling.JDLogger;
import jd.nutils.OSDetector;
import jd.nutils.io.JDIO;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JACMethod
implements Comparable<JACMethod> {
    private static Logger logger = JDLogger.getLogger();
    private static ArrayList<JACMethod> methods = null;
    private String filename;
    private String servicename;
    private String author;

    public static String forServiceName(String service) {
        for (JACMethod method : JACMethod.getMethods()) {
            if (!service.equalsIgnoreCase(method.getServiceName())) continue;
            logger.info("Found JAC method for the service " + service + " in directory " + method.getFileName());
            return method.getFileName();
        }
        logger.info("There is no JAC method for the service " + service);
        return service;
    }

    public static ArrayList<JACMethod> getMethods() {
        if (methods != null) {
            return methods;
        }
        ArrayList<JACMethod> methods = new ArrayList<JACMethod>();
        File[] fileArray = JACMethod.getMethodDirs();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File methodDir = fileArray[n2];
            ArrayList<JACMethod> meths = JACMethod.parseJACInfo(methodDir);
            if (meths != null) {
                methods.addAll(meths);
            }
            ++n2;
        }
        Collections.sort(methods);
        JACMethod.methods = methods;
        return methods;
    }

    private static File[] getMethodDirs() {
        File dir = JDUtilities.getResourceFile((String)JDUtilities.getJACMethodsDirectory());
        if (dir == null || !dir.exists()) {
            logger.severe("Konnte Methodenordner nicht finden: " + dir);
            return new File[0];
        }
        File[] entries = dir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                if (!pathname.isDirectory()) {
                    return false;
                }
                File method = new File(pathname.getAbsoluteFile() + "/jacinfo.xml");
                return method.exists() && JACMethod.isAvailableExternMethod(method);
            }
        });
        return entries;
    }

    private static ArrayList<JACMethod> parseJACInfo(File dir) {
        String filecontent = JDIO.readFileToString((File)new File(String.valueOf(dir.getAbsolutePath()) + "/jacinfo.xml"));
        Document doc = JDUtilities.parseXmlString((String)filecontent, (boolean)false);
        if (doc == null) {
            return null;
        }
        String[] services = null;
        String author = null;
        NodeList nl = doc.getFirstChild().getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node childNode = nl.item(i);
            if (childNode.getNodeName().equals("method")) {
                String servicelist = JDUtilities.getAttribute((Node)childNode, (String)"services");
                services = servicelist != null ? servicelist.split(";") : new String[]{JDUtilities.getAttribute((Node)childNode, (String)"name")};
                String extern = JDUtilities.getAttribute((Node)childNode, (String)"type");
                if (extern != null && extern.equalsIgnoreCase("extern")) {
                    author = JDL.L((String)"gui.config.jac.extern", (String)"Externe Methode");
                    break;
                }
                author = JDUtilities.getAttribute((Node)childNode, (String)"author");
                break;
            }
            ++i;
        }
        ArrayList<JACMethod> methods = new ArrayList<JACMethod>();
        if (services != null) {
            String[] stringArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                String service = stringArray[n2];
                methods.add(new JACMethod(dir.getName(), service, author));
                ++n2;
            }
        }
        return methods;
    }

    public static boolean hasMethod(String service) {
        if (service == null) {
            return false;
        }
        String methodName = JACMethod.forServiceName(service);
        File method = JDUtilities.getResourceFile((String)(String.valueOf(JDUtilities.getJACMethodsDirectory()) + "/" + methodName + "/jacinfo.xml"));
        return method.exists() && JACMethod.isAvailableExternMethod(method);
    }

    private static boolean isAvailableExternMethod(File jacinfo) {
        return JACMethod.isAvailableExternMethod(JDIO.readFileToString((File)jacinfo));
    }

    private static boolean isAvailableExternMethod(String content) {
        if (content != null && content.contains("extern")) {
            if (OSDetector.isLinux() && !content.contains("linux")) {
                return false;
            }
            if (OSDetector.isMac() && !content.contains("mac")) {
                return false;
            }
            if (OSDetector.isWindows() && !content.contains("windows")) {
                return false;
            }
        }
        return true;
    }

    public JACMethod(String filename, String servicename, String author) {
        this.filename = filename;
        if (servicename != null) {
            this.servicename = servicename.toLowerCase();
        }
        this.author = author;
    }

    public String getFileName() {
        return this.filename;
    }

    public String getServiceName() {
        return this.servicename;
    }

    public String getAuthor() {
        return this.author;
    }

    @Override
    public int compareTo(JACMethod o) {
        return (String.valueOf(this.servicename) + " " + this.filename).compareToIgnoreCase(String.valueOf(o.getServiceName()) + " " + o.getFileName());
    }
}

