/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import jd.captcha.JACMethod;
import jd.captcha.LetterComperator;
import jd.captcha.configuration.JACScript;
import jd.captcha.gui.BasicWindow;
import jd.captcha.gui.ImageComponent;
import jd.captcha.gui.ScrollPaneWindow;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelobject.PixelObject;
import jd.captcha.utils.Utilities;
import jd.controlling.JDLogger;
import jd.gui.swing.GuiRunnable;
import jd.gui.userio.DummyFrame;
import jd.nutils.Executer;
import jd.nutils.JDHash;
import jd.nutils.io.JDIO;
import jd.parser.Regex;
import jd.utils.JDUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JAntiCaptcha {
    private static Logger logger = Utilities.getLogger();
    private BasicWindow bw2;
    private BasicWindow bw3;
    private JDialog f;
    private String imageType;
    public JACScript jas;
    public ArrayList<Letter> letterDB;
    private int[][] letterMap = null;
    private int letterNum;
    private String methodDirName;
    private boolean showDebugGui = false;
    private Vector<ScrollPaneWindow> spw = new Vector();
    private Captcha workingCaptcha;
    private boolean extern;
    private String command;
    private String dstFile;
    private String srcFile;
    private Image sourceImage;

    public static String getCaptchaCode(File file, Image img, String methodname) {
        JAntiCaptcha jac = new JAntiCaptcha(methodname);
        Captcha cap = jac.createCaptcha(img);
        if (cap == null) {
            if (Utilities.isLoggerActive()) {
                logger.severe("Captcha Bild konnte nicht eingelesen werden");
            }
            return "JACerror";
        }
        String ret = jac.checkCaptcha(file, cap);
        if (Utilities.isLoggerActive()) {
            logger.info("captcha text:" + ret);
        }
        return ret;
    }

    public static void testMethod(File file) {
        int checkCaptchas = 20;
        int totalLetters = 0;
        int correctLetters = 0;
        String methodName = file.getName();
        File captchaDir = new File(String.valueOf(file.getAbsolutePath()) + "/captchas");
        if (Utilities.isLoggerActive()) {
            logger.info("Test Method: " + methodName);
        }
        new JAntiCaptcha(methodName);
        File[] entries = captchaDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jpg") || pathname.getName().endsWith(".png") || pathname.getName().endsWith(".gif");
            }
        });
        ScrollPaneWindow w = new ScrollPaneWindow();
        w.setTitle(" Test Captchas: " + file.getAbsolutePath());
        w.resizeWindow(100);
        if (Utilities.isLoggerActive()) {
            logger.info("Found Testcaptchas: " + entries.length);
        }
        int testNum = Math.min(checkCaptchas, entries.length);
        if (Utilities.isLoggerActive()) {
            logger.info("Test " + testNum + " Captchas");
        }
        int i = 0;
        i = 0;
        while (i < testNum) {
            File captchaFile = entries[(int)(Math.random() * (double)entries.length)];
            logger.info("JJJJJJJJ" + captchaFile);
            Image img = Utilities.loadImage(captchaFile);
            w.setText(0, i, captchaFile.getName());
            w.setImage(1, i, img);
            w.repack();
            JAntiCaptcha jac = new JAntiCaptcha(methodName);
            Captcha cap = jac.createCaptcha(img);
            if (cap == null) {
                if (Utilities.isLoggerActive()) {
                    logger.severe("Captcha Bild konnte nicht eingelesen werden");
                }
            } else {
                w.setImage(2, i, cap.getImage());
                String code = jac.checkCaptcha(captchaFile, cap);
                w.setImage(3, i, cap.getImage());
                w.setText(4, i, "JAC:" + code);
                w.repack();
                String inputCode = JOptionPane.showInputDialog("Bitte Captcha Code eingeben", (Object)code);
                w.setText(5, i, "User:" + inputCode);
                w.repack();
                if (code == null) {
                    code = "";
                }
                if (inputCode == null) {
                    inputCode = "";
                }
                code = code.toLowerCase();
                inputCode = inputCode.toLowerCase();
                int x = 0;
                while (x < inputCode.length()) {
                    ++totalLetters;
                    if (inputCode.length() == code.length() && inputCode.charAt(x) == code.charAt(x)) {
                        ++correctLetters;
                    }
                    ++x;
                }
                if (Utilities.isLoggerActive()) {
                    logger.info("Erkennung: " + correctLetters + "/" + totalLetters + " = " + Utilities.getPercent(correctLetters, totalLetters) + "%");
                }
            }
            ++i;
        }
        w.setText(0, i + 1, "Erkennung: " + Utilities.getPercent(correctLetters, totalLetters) + "%");
        w.setText(4, i + 1, "Richtig: " + correctLetters);
        w.setText(5, i + 1, "Falsch: " + (totalLetters - correctLetters));
        JOptionPane.showMessageDialog(new JFrame(), "Erkennung: " + correctLetters + "/" + totalLetters + " = " + Utilities.getPercent(correctLetters, totalLetters) + "%");
    }

    public static void testMethods(File[] methods) {
        File[] fileArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            File element = fileArray[n2];
            JAntiCaptcha.testMethod(element);
            ++n2;
        }
    }

    public boolean isExtern() {
        return this.extern;
    }

    public JAntiCaptcha(String methodName) {
        this.methodDirName = JACMethod.forServiceName(methodName);
        this.getJACInfo();
        this.jas = new JACScript(this, this.methodDirName);
        this.loadMTHFile();
        if (Utilities.isLoggerActive()) {
            logger.fine("letter DB loaded: Buchstaben: " + this.letterDB.size());
        }
    }

    public String checkCaptcha(File file, Captcha captcha) {
        LetterComperator akt;
        if (this.extern) {
            return this.callExtern();
        }
        this.workingCaptcha = captcha;
        this.jas.executePrepareCommands(file, captcha);
        Letter[] letters = captcha.getLetters(this.getLetterNum());
        if (letters == null) {
            captcha.setValityPercent(100.0);
            if (Utilities.isLoggerActive()) {
                logger.severe("Captcha konnte nicht erkannt werden!");
            }
            return null;
        }
        String ret = "";
        double correct = 0.0;
        Vector<LetterComperator> newLettersVector = new Vector<LetterComperator>();
        int i = 0;
        while (i < letters.length) {
            letters[i].setId(i);
            akt = letters[i].detected != null ? letters[i].detected : this.getLetter(letters[i]);
            akt.getA().setId(i);
            newLettersVector.add(akt);
            ++i;
        }
        if (letters.length > this.getLetterNum()) {
            Collections.sort(newLettersVector, new Comparator<LetterComperator>(){

                @Override
                public int compare(LetterComperator obj1, LetterComperator obj2) {
                    if (obj1.getValityPercent() < obj2.getValityPercent()) {
                        return -1;
                    }
                    if (obj1.getValityPercent() > obj2.getValityPercent()) {
                        return 1;
                    }
                    return 0;
                }
            });
            if (Utilities.isLoggerActive()) {
                logger.info(String.valueOf(this.getLetterNum()));
            }
            if (!this.jas.getBoolean("autoLetterNum")) {
                i = newLettersVector.size() - 1;
                while (i >= this.getLetterNum()) {
                    newLettersVector.remove(i);
                    --i;
                }
            }
            Collections.sort(newLettersVector, new Comparator<LetterComperator>(){

                @Override
                public int compare(LetterComperator obj1, LetterComperator obj2) {
                    if (obj1.getA().getId() < obj2.getA().getId()) {
                        return -1;
                    }
                    if (obj1.getA().getId() > obj2.getA().getId()) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
        if (this.getJas().getString("useLettercomparatorFilter") != null && this.getJas().getString("useLettercomparatorFilter").length() > 0) {
            String[] ref = this.getJas().getString("useLettercomparatorFilter").split("\\.");
            if (ref.length != 2) {
                captcha.setValityPercent(100.0);
                if (Utilities.isLoggerActive()) {
                    logger.severe("useLettercomparatorFilter should have the format Class.Method");
                }
                return null;
            }
            String cl = ref[0];
            String methodname = ref[1];
            try {
                Class<?> newClass = Class.forName("jd.captcha.specials." + cl);
                Class[] parameterTypes = new Class[]{newLettersVector.getClass(), this.getClass()};
                Method method = newClass.getMethod(methodname, parameterTypes);
                Object[] arguments = new Object[]{newLettersVector, this};
                Object instance = null;
                method.invoke(instance, arguments);
            }
            catch (Exception e) {
                if (Utilities.isLoggerActive()) {
                    logger.severe("Fehler in useLettercomparatorFilter:" + e.getLocalizedMessage() + " / " + this.getJas().getString("useLettercomparatorFilter"));
                }
                JDLogger.exception((Throwable)e);
            }
        }
        i = 0;
        while (i < newLettersVector.size()) {
            akt = (LetterComperator)newLettersVector.get(i);
            if (akt == null || akt.getValityPercent() >= 100.0) {
                ret = String.valueOf(ret) + "-";
                correct += 100.0;
            } else {
                ret = String.valueOf(ret) + akt.getDecodedValue();
                akt.getA().setId(i);
                correct += akt.getValityPercent();
            }
            ++i;
        }
        if (newLettersVector.size() == 0) {
            captcha.setValityPercent(100.0);
            return null;
        }
        captcha.setLetterComperators(newLettersVector.toArray(new LetterComperator[0]));
        if (Utilities.isLoggerActive()) {
            logger.finer("Vality: " + (int)(correct / (double)newLettersVector.size()));
        }
        captcha.setValityPercent(correct / (double)newLettersVector.size());
        if (ret == null) {
            captcha.setValityPercent(100.0);
        }
        return ret;
    }

    public void exportDB() {
        File path = Utilities.directoryChooser();
        int i = 0;
        for (Letter letter : this.letterDB) {
            BufferedImage img = letter.getFullImage();
            File file = new File(path + "/letterDB/" + i++ + "_" + letter.getDecodedValue() + ".png");
            file.mkdirs();
            try {
                logger.info("Write Db: " + file);
                ImageIO.write((RenderedImage)img, "png", file);
            }
            catch (IOException e) {
                JDLogger.getLogger().log(Level.SEVERE, "Exception occured", e);
            }
        }
    }

    private String callExtern() {
        try {
            File file = JDUtilities.getResourceFile((String)this.srcFile);
            file.getParentFile().mkdirs();
            String ext = JDIO.getFileExtension((String)this.srcFile);
            ImageIO.write((RenderedImage)((Object)this.sourceImage), ext, file);
        }
        catch (IOException e) {
            JDLogger.exception((Throwable)e);
            return null;
        }
        Executer exec = new Executer(JDUtilities.getResourceFile((String)this.command).getAbsolutePath());
        exec.setRunin(JDUtilities.getResourceFile((String)this.command).getParent());
        exec.setWaitTimeout(300);
        exec.start();
        exec.waitTimeout();
        String res = JDIO.readFileToString((File)JDUtilities.getResourceFile((String)this.dstFile));
        if (res == null) {
            return null;
        }
        return res.trim();
    }

    public String checkCaptcha(File captchafile) {
        if (Utilities.isLoggerActive()) {
            logger.finer("check " + captchafile);
        }
        Image captchaImage = Utilities.loadImage(captchafile);
        Captcha captcha = this.createCaptcha(captchaImage);
        captcha.setCaptchaFile(captchafile);
        return this.checkCaptcha(captchafile, captcha);
    }

    public Captcha createCaptcha(Image captchaImage) {
        this.sourceImage = captchaImage;
        if (this.extern) {
            return null;
        }
        if (captchaImage.getWidth(null) <= 0 || captchaImage.getHeight(null) <= 0) {
            if (Utilities.isLoggerActive()) {
                logger.severe("Image Dimensionen zu klein. Image hat keinen Inahlt. Pfad/Url pr\u00fcfen!");
            }
            return null;
        }
        Captcha ret = Captcha.getCaptcha(captchaImage, this);
        if (ret == null) {
            return null;
        }
        ret.setOwner(this);
        return ret;
    }

    private void createLetterDBFormMTH(Document mth) {
        long start1;
        block15: {
            this.letterDB = new ArrayList();
            start1 = System.currentTimeMillis();
            try {
                if (mth == null || mth.getFirstChild() == null) {
                    return;
                }
                NodeList nl = mth.getFirstChild().getChildNodes();
                int i = 0;
                while (i < nl.getLength()) {
                    Node childNode = nl.item(i);
                    if (childNode.getNodeName().equals("letter")) {
                        NamedNodeMap att = childNode.getAttributes();
                        Letter tmp = new Letter();
                        tmp.setOwner(this);
                        String id = JDUtilities.getAttribute((Node)childNode, (String)"id");
                        if (!tmp.setTextGrid(childNode.getTextContent())) {
                            logger.severe("Error in Letters DB line: " + i + ":" + childNode.getTextContent() + " id:" + id);
                        } else {
                            if (id != null) {
                                tmp.setId(Integer.parseInt(id));
                            }
                            tmp.setSourcehash(att.getNamedItem("captchaHash").getNodeValue());
                            tmp.setDecodedValue(att.getNamedItem("value").getNodeValue());
                            tmp.setBadDetections(Integer.parseInt(JDUtilities.getAttribute((Node)childNode, (String)"bad")));
                            tmp.setGoodDetections(Integer.parseInt(JDUtilities.getAttribute((Node)childNode, (String)"good")));
                            this.letterDB.add(tmp);
                        }
                    } else if (childNode.getNodeName().equals("map")) {
                        if (Utilities.isLoggerActive()) {
                            logger.fine("Parse LetterMap");
                        }
                        long start2 = System.currentTimeMillis();
                        String[] map = childNode.getTextContent().split("\\|");
                        this.letterMap = new int[map.length][map.length];
                        int x = 0;
                        while (x < map.length) {
                            String[] row = map[x].split("\\,");
                            int y = 0;
                            while (y < map.length) {
                                this.letterMap[x][y] = Integer.parseInt(row[y]);
                                ++y;
                            }
                            ++x;
                        }
                        if (Utilities.isLoggerActive()) {
                            logger.fine("LetterMap Parsing time: " + (System.currentTimeMillis() - start2));
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                JDLogger.exception((Throwable)e);
                if (!Utilities.isLoggerActive()) break block15;
                logger.severe("Fehler bein lesen der MTH Datei!!. Methode kann nicht funktionieren!");
            }
        }
        if (Utilities.isLoggerActive()) {
            logger.fine("Mth Parsing time: " + (System.currentTimeMillis() - start1));
        }
    }

    private Document createXMLFromLetterDB() {
        Document xml = JDUtilities.parseXmlString((String)"<jDownloader></jDownloader>", (boolean)false);
        if (this.letterMap != null) {
            Element element = xml.createElement("map");
            xml.getFirstChild().appendChild(element);
            element.appendChild(xml.createTextNode(this.getLetterMapString()));
        }
        int i = 0;
        for (Letter letter : this.letterDB) {
            Element element = xml.createElement("letter");
            xml.getFirstChild().appendChild(element);
            element.appendChild(xml.createTextNode(letter.getPixelString()));
            element.setAttribute("id", String.valueOf(i++));
            element.setAttribute("value", letter.getDecodedValue());
            element.setAttribute("captchaHash", letter.getSourcehash());
            element.setAttribute("good", String.valueOf(letter.getGoodDetections()));
            element.setAttribute("bad", String.valueOf(letter.getBadDetections()));
        }
        return xml;
    }

    private void destroyScrollPaneWindows() {
        while (this.spw.size() > 0) {
            new GuiRunnable<Object>(){

                public Object runSave() {
                    ((ScrollPaneWindow)JAntiCaptcha.this.spw.remove(0)).destroy();
                    return null;
                }
            }.waitForEDT();
        }
    }

    public void displayLibrary() {
        if (this.letterDB == null || this.letterDB.size() == 0) {
            return;
        }
        final JFrame w = (JFrame)new GuiRunnable<JFrame>(){

            public JFrame runSave() {
                return new JFrame();
            }
        }.getReturnValue();
        this.sortLetterDB();
        JPanel p = (JPanel)new GuiRunnable<JPanel>(){

            public JPanel runSave() {
                JPanel bp = new JPanel(new GridLayout(JAntiCaptcha.this.letterDB.size() + 1, 3));
                w.add(new JScrollPane(bp));
                return bp;
            }
        }.getReturnValue();
        Letter[] list = new Letter[this.letterDB.size()];
        int y = 0;
        int i = 0;
        ListIterator<Letter> iter = this.letterDB.listIterator(this.letterDB.size());
        final ArrayList rem = new ArrayList();
        while (iter.hasPrevious()) {
            Letter tmp;
            list[i] = tmp = iter.previous();
            JLabel lbl = (JLabel)new GuiRunnable<JLabel>(){

                public JLabel runSave() {
                    if (tmp.getGoodDetections() == 0 && tmp.getBadDetections() > 3 || (double)tmp.getBadDetections() / (double)tmp.getGoodDetections() >= 3.0) {
                        return new JLabel("<html><p><font color=\"#ff0000\" size=\"3\">" + tmp.getId() + ": " + tmp.getDecodedValue() + "(" + tmp.getGoodDetections() + "/" + tmp.getBadDetections() + ") Size: " + tmp.toPixelObject(0.85).getSize() + "</font> </p>" + "</html>");
                    }
                    return new JLabel(String.valueOf(tmp.getId()) + ": " + tmp.getDecodedValue() + "(" + tmp.getGoodDetections() + "/" + tmp.getBadDetections() + ") Size: " + tmp.toPixelObject(0.85).getSize());
                }
            }.getReturnValue();
            ImageComponent img = (ImageComponent)new GuiRunnable<ImageComponent>(){

                public ImageComponent runSave() {
                    return new ImageComponent(tmp.getImage());
                }
            }.getReturnValue();
            JCheckBox bt = (JCheckBox)new GuiRunnable<JCheckBox>(){

                public JCheckBox runSave() {
                    return new JCheckBox("DELETE");
                }
            }.getReturnValue();
            int ii = i++;
            bt.addActionListener(new ActionListener(ii){
                public Integer id;
                {
                    this.id = new Integer(n);
                }

                public void actionPerformed(ActionEvent arg) {
                    JCheckBox src = (JCheckBox)arg.getSource();
                    if (src.getText().equals("DELETE")) {
                        rem.add(this.id);
                    } else {
                        rem.remove(this.id);
                    }
                }
            });
            p.add(lbl);
            p.add(img);
            p.add(bt);
            ++y;
        }
        JButton b = (JButton)new GuiRunnable<JButton>(){

            public JButton runSave() {
                return new JButton("Invoke");
            }
        }.getReturnValue();
        p.add(b);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ArrayList<Letter> list = new ArrayList<Letter>();
                int s = JAntiCaptcha.this.letterDB.size();
                for (Integer i : rem) {
                    try {
                        Letter let = JAntiCaptcha.this.letterDB.get(s - 1 - i);
                        list.add(let);
                    }
                    catch (Exception ew) {
                        JDLogger.exception((Throwable)ew);
                    }
                }
                for (Letter letter : list) {
                    JAntiCaptcha.this.removeLetterFromLibrary(letter);
                }
                JAntiCaptcha.this.saveMTHFile();
                JAntiCaptcha.this.displayLibrary();
            }
        });
        new GuiRunnable<Object>(){

            public Object runSave() {
                w.pack();
                w.setVisible(true);
                return null;
            }
        }.waitForEDT();
    }

    public String getCodeFromFileName(String name) {
        return new Regex(name, "captcha_(.*?)_code(.*?)\\.(.*?)").getMatch(1);
    }

    public File[] getImages(String path) {
        File dir = new File(path);
        if ((dir == null || !dir.exists()) && Utilities.isLoggerActive()) {
            logger.severe("Image dir nicht gefunden " + path);
        }
        logger.info("" + dir);
        File[] entries = dir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                if (Utilities.isLoggerActive()) {
                    logger.info(pathname.getName());
                }
                return pathname.getName().endsWith(".bmp") || pathname.getName().endsWith(".jpg") || pathname.getName().endsWith(".png") || pathname.getName().endsWith(".gif");
            }
        });
        return entries;
    }

    public String getImageType() {
        return this.imageType;
    }

    private void getJACInfo() {
        File f = this.getResourceFile("jacinfo.xml");
        if (!f.exists()) {
            if (Utilities.isLoggerActive()) {
                logger.severe("jacinfo.xml is missing2");
            }
            return;
        }
        Document doc = JDUtilities.parseXmlString((String)JDIO.readFileToString((File)f), (boolean)false);
        if (doc == null) {
            if (Utilities.isLoggerActive()) {
                logger.severe("jacinfo.xml is missing2");
            }
            return;
        }
        NodeList nl = doc.getFirstChild().getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node childNode = nl.item(i);
            if (childNode.getNodeName().equals("method")) {
                try {
                    this.extern = JDUtilities.getAttribute((Node)childNode, (String)"type").equalsIgnoreCase("extern");
                }
                catch (Exception exception) {}
            } else if (childNode.getNodeName().equals("command")) {
                this.srcFile = JDUtilities.getAttribute((Node)childNode, (String)"src");
                this.dstFile = JDUtilities.getAttribute((Node)childNode, (String)"dst");
                this.command = JDUtilities.getAttribute((Node)childNode, (String)"cmd");
            } else if (childNode.getNodeName().equals("format")) {
                try {
                    this.setLetterNum(Integer.parseInt(JDUtilities.getAttribute((Node)childNode, (String)"letterNum")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.setImageType(JDUtilities.getAttribute((Node)childNode, (String)"type"));
            }
            ++i;
        }
    }

    public JACScript getJas() {
        return this.jas;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LetterComperator getLetter(Letter letter) {
        if (this.jas.getDouble("quickScanValityLimit") <= 0.0) {
            logger.info("quickscan disabled");
            return this.getLetterExtended(letter);
        }
        logger.info("Work on Letter:" + (Object)((Object)letter));
        LetterComperator res = null;
        double lastPercent = 100.0;
        try {
            if (this.letterDB == null) {
                if (Utilities.isLoggerActive()) {
                    logger.severe("letterDB nicht vorhanden");
                }
                return null;
            }
            ScrollPaneWindow w = null;
            if (this.isShowDebugGui()) {
                w = new ScrollPaneWindow();
                w.setTitle(" Letter " + letter.getId());
            }
            int bvX = this.jas.getInteger("borderVarianceX");
            int bvY = this.jas.getInteger("borderVarianceY");
            int line = 0;
            LetterComperator lc = new LetterComperator(letter, null);
            lc.setScanVariance(0, 0);
            lc.setOwner(this);
            res = lc;
            int tt = 0;
            logger.info("Do quickscan");
            Method preValueFilterMethod = null;
            Class[] preValueFilterParameterTypes = null;
            Object[] objectArray = new Object[2];
            objectArray[1] = this;
            Object[] preValueFilterArguments = objectArray;
            if (this.jas.getString("preValueFilter").length() > 0) {
                String[] ref = this.jas.getString("preValueFilter").split("\\.");
                if (ref.length != 2) {
                    if (Utilities.isLoggerActive()) {
                        logger.severe("preValueFilter should have the format Class.Method");
                    }
                    return null;
                }
                String cl = ref[0];
                String methodname = ref[1];
                try {
                    Class<?> newClass = Class.forName("jd.captcha.specials." + cl);
                    preValueFilterParameterTypes = new Class[]{LetterComperator.class, this.getClass()};
                    preValueFilterMethod = newClass.getMethod(methodname, preValueFilterParameterTypes);
                }
                catch (Exception e) {
                    JDLogger.exception((Throwable)e);
                }
            }
            Method postValueFilterMethod = null;
            Class[] postValueFilterParameterTypes = null;
            Object[] objectArray2 = new Object[2];
            objectArray2[1] = this;
            Object[] postValueFilterArguments = objectArray2;
            if (this.jas.getString("postValueFilter").length() > 0) {
                String[] ref = this.jas.getString("postValueFilter").split("\\.");
                if (ref.length != 2) {
                    if (Utilities.isLoggerActive()) {
                        logger.severe("postValueFilter should have the format Class.Method");
                    }
                    return null;
                }
                String cl = ref[0];
                String methodname = ref[1];
                try {
                    Class<?> newClass = Class.forName("jd.captcha.specials." + cl);
                    postValueFilterParameterTypes = new Class[]{LetterComperator.class, this.getClass()};
                    postValueFilterMethod = newClass.getMethod(methodname, postValueFilterParameterTypes);
                }
                catch (Exception e) {
                    JDLogger.exception((Throwable)e);
                }
            }
            for (Letter tmp : this.letterDB) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                if (Math.abs(tmp.getHeight() - letter.getHeight()) > bvY || Math.abs(tmp.getWidth() - letter.getWidth()) > bvX) continue;
                lc = new LetterComperator(letter, tmp);
                lc.setOwner(this);
                if (preValueFilterMethod != null) {
                    preValueFilterArguments[0] = tmp;
                    preValueFilterArguments[1] = lc;
                    if (!((Boolean)preValueFilterMethod.invoke(null, preValueFilterArguments)).booleanValue()) continue;
                }
                lc.run();
                ++tt;
                if (this.isShowDebugGui()) {
                    w.setText(0, line, "0\u00b0 Quick " + tt);
                    w.setImage(1, line, lc.getA().getImage(2));
                    w.setText(2, line, lc.getA().getDim());
                    w.setImage(3, line, lc.getB().getImage(2));
                    w.setText(4, line, lc.getB().getDim());
                    w.setImage(5, line, lc.getIntersectionLetter().getImage(2));
                    w.setText(6, line, lc.getIntersectionLetter().getDim());
                    w.setText(7, line, lc);
                    ++line;
                }
                postValueFilterArguments[0] = lc;
                if (postValueFilterMethod != null && !((Boolean)postValueFilterMethod.invoke(null, postValueFilterArguments)).booleanValue()) continue;
                if (res == null || lc.getValityPercent() < res.getValityPercent()) {
                    if (res != null && res.getValityPercent() < lastPercent) {
                        lastPercent = res.getValityPercent();
                    }
                    res = lc;
                    if (!(this.jas.getDouble("LetterSearchLimitPerfectPercent") >= lc.getValityPercent())) continue;
                    if (Utilities.isLoggerActive()) {
                        logger.finer(" Perfect Match: " + res.getB().getDecodedValue() + res.getValityPercent() + " good:" + tmp.getGoodDetections() + " bad: " + tmp.getBadDetections() + " - " + res);
                    }
                    res.setDetectionType(3);
                    res.setReliability(lastPercent - res.getValityPercent());
                    return res;
                }
                if (res == null || !(lc.getValityPercent() < lastPercent)) continue;
                lastPercent = lc.getValityPercent();
            }
        }
        catch (Exception e) {
            JDLogger.exception((Throwable)e);
        }
        if (res != null && res.getB() != null) {
            if (Utilities.isLoggerActive()) {
                logger.finer(" Normal Match: " + res.getB().getDecodedValue() + " " + res.getValityPercent() + " good:" + res.getB().getGoodDetections() + " bad: " + res.getB().getBadDetections());
            }
            res.setReliability(lastPercent - res.getValityPercent());
            if (res.getReliability() >= this.jas.getDouble("quickScanReliabilityLimit") && res.getValityPercent() < this.jas.getDouble("quickScanValityLimit")) {
                res.setDetectionType(2);
                logger.info("Qickscan found " + res.getValityPercent() + "<" + this.jas.getDouble("quickScanValityLimit"));
                return res;
            }
            if (Utilities.isLoggerActive()) {
                logger.warning("Letter nicht ausreichend erkannt. Try Extended " + res.getReliability() + " - " + this.jas.getDouble("quickScanReliabilityLimit") + " /" + res.getValityPercent() + "-" + this.jas.getDouble("quickScanValityLimit"));
            }
            return this.getLetterExtended(letter);
        }
        if (Utilities.isLoggerActive()) {
            logger.warning("Letter nicht erkannt. Try Extended");
        }
        return this.getLetterExtended(letter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LetterComperator getLetterExtended(Letter letter) {
        LetterComperator res = null;
        logger.info("Extended SCAN");
        double lastPercent = 100.0;
        JComponent tf = null;
        try {
            int rightAngle;
            if (this.letterDB == null) {
                if (!Utilities.isLoggerActive()) return null;
                logger.severe("letterDB nicht vorhanden");
                return null;
            }
            int leftAngle = this.jas.getInteger("scanAngleLeft");
            if (leftAngle > (rightAngle = this.jas.getInteger("scanAngleRight"))) {
                int temp = leftAngle;
                leftAngle = rightAngle;
                rightAngle = temp;
                if (Utilities.isLoggerActive()) {
                    logger.warning("param.scanAngleLeft>paramscanAngleRight");
                }
            }
            int steps = Math.max(1, this.jas.getInteger("scanAngleSteps"));
            boolean turnDB = this.jas.getBoolean("turnDB");
            Letter orgLetter = letter;
            ScrollPaneWindow w = null;
            if (this.isShowDebugGui()) {
                w = new ScrollPaneWindow();
                w.setTitle(" Letter " + letter.getId());
            }
            int line = 0;
            LetterComperator lc = new LetterComperator(letter, null);
            lc.setOwner(this);
            res = lc;
            Method preValueFilterMethod = null;
            Class[] preValueFilterParameterTypes = null;
            Object[] objectArray = new Object[2];
            objectArray[1] = this;
            Object[] preValueFilterArguments = objectArray;
            if (this.jas.getString("preValueFilter").length() > 0) {
                String[] ref = this.jas.getString("preValueFilter").split("\\.");
                if (ref.length != 2) {
                    if (!Utilities.isLoggerActive()) return null;
                    logger.severe("preValueFilter should have the format Class.Method");
                    return null;
                }
                String cl = ref[0];
                String methodname = ref[1];
                try {
                    Class<?> newClass = Class.forName("jd.captcha.specials." + cl);
                    preValueFilterParameterTypes = new Class[]{LetterComperator.class, this.getClass()};
                    preValueFilterMethod = newClass.getMethod(methodname, preValueFilterParameterTypes);
                }
                catch (Exception e) {
                    JDLogger.exception((Throwable)e);
                }
            }
            Method postValueFilterMethod = null;
            Class[] postValueFilterParameterTypes = null;
            Object[] objectArray2 = new Object[2];
            objectArray2[1] = this;
            Object[] postValueFilterArguments = objectArray2;
            if (this.jas.getString("postValueFilter").length() > 0) {
                String[] ref = this.jas.getString("postValueFilter").split("\\.");
                if (ref.length != 2) {
                    if (!Utilities.isLoggerActive()) return null;
                    logger.severe("postValueFilter should have the format Class.Method");
                    return null;
                }
                String cl = ref[0];
                String methodname = ref[1];
                try {
                    Class<?> newClass = Class.forName("jd.captcha.specials." + cl);
                    postValueFilterParameterTypes = new Class[]{LetterComperator.class, this.getClass()};
                    postValueFilterMethod = newClass.getMethod(methodname, postValueFilterParameterTypes);
                }
                catch (Exception e) {
                    JDLogger.exception((Throwable)e);
                }
            }
            int angle = Utilities.getJumperStart(leftAngle, rightAngle);
            block6: while (Utilities.checkJumper(angle, leftAngle, rightAngle)) {
                letter = turnDB ? orgLetter : orgLetter.turn(angle);
                int tt = 0;
                Iterator<Letter> iterator = this.letterDB.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        angle = Utilities.nextJump(angle, leftAngle, rightAngle, steps);
                        continue block6;
                    }
                    Letter ltr = iterator.next();
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedException();
                    }
                    Letter tmp = turnDB ? ltr.turn(angle) : ltr;
                    if (Math.abs(tmp.getHeight() - letter.getHeight()) > this.jas.getInteger("borderVarianceY") || Math.abs(tmp.getWidth() - letter.getWidth()) > this.jas.getInteger("borderVarianceX")) continue;
                    lc = new LetterComperator(letter, tmp);
                    lc.setOwner(this);
                    if (preValueFilterMethod != null) {
                        preValueFilterArguments[0] = lc;
                        preValueFilterArguments[1] = this;
                        if (!((Boolean)preValueFilterMethod.invoke(null, preValueFilterArguments)).booleanValue()) continue;
                    }
                    lc.run();
                    ++tt;
                    if (this.isShowDebugGui()) {
                        w.setText(0, line, String.valueOf(angle) + "\u00b0 " + tt);
                        w.setImage(1, line, lc.getA().getImage(2));
                        w.setText(2, line, lc.getA().getDim());
                        w.setImage(3, line, lc.getB().getImage(2));
                        w.setText(4, line, lc.getB().getDim());
                        w.setImage(5, line, lc.getIntersectionLetter().getImage(2));
                        w.setText(6, line, lc.getIntersectionLetter().getDim());
                        tf = new JTextArea();
                        w.setComponent(7, line, tf);
                        ((JTextComponent)tf).setText(lc.toString());
                        if (lc.getPreValityPercent() > (double)this.jas.getInteger("preScanFilter") && this.jas.getInteger("preScanFilter") > 0) {
                            tf.setBackground(Color.LIGHT_GRAY);
                        }
                        ++line;
                    }
                    postValueFilterArguments[0] = lc;
                    if (postValueFilterMethod != null && !((Boolean)postValueFilterMethod.invoke(null, postValueFilterArguments)).booleanValue()) continue;
                    if (res == null || lc.getValityPercent() < res.getValityPercent()) {
                        if (res != null && res.getValityPercent() < lastPercent) {
                            lastPercent = res.getValityPercent();
                        }
                        res = lc;
                        if (this.jas.getDouble("LetterSearchLimitPerfectPercent") >= lc.getValityPercent()) {
                            res.setDetectionType(1);
                            res.setReliability(lastPercent - res.getValityPercent());
                            if (Utilities.isLoggerActive()) {
                                logger.finer(" Perfect Match: " + res.getB().getDecodedValue() + " " + res.getValityPercent() + " good:" + tmp.getGoodDetections() + " bad: " + tmp.getBadDetections() + " - " + res);
                            }
                            if (!this.isShowDebugGui()) return res;
                            tf.setBackground(Color.GREEN);
                            return res;
                        }
                        if (this.isShowDebugGui()) {
                            tf.setBackground(Color.BLUE);
                        }
                        if (!Utilities.isLoggerActive()) continue;
                        logger.finer("Angle " + angle + "dim " + lc.getA().getDim() + "|" + lc.getB().getDim() + " New Best value: " + lc.getDecodedValue() + " " + lc.getValityPercent() + " good:" + tmp.getGoodDetections() + " bad: " + tmp.getBadDetections() + " - " + lc);
                        continue;
                    }
                    if (res == null || !(lc.getValityPercent() < lastPercent)) continue;
                    lastPercent = lc.getValityPercent();
                }
            }
        }
        catch (Exception e) {
            JDLogger.exception((Throwable)e);
        }
        if (res != null && res.getB() != null) {
            if (Utilities.isLoggerActive()) {
                logger.finer(" Normal Match: " + res.getB().getDecodedValue() + " " + res.getValityPercent() + " good:" + res.getB().getGoodDetections() + " bad: " + res.getB().getBadDetections());
            }
            res.setReliability(lastPercent - res.getValityPercent());
            return res;
        }
        if (this.getJas().getInteger("preScanEmergencyFilter") > this.getJas().getInteger("preScanFilter")) {
            logger.warning("nicht erkannt. Verwende erweiterte Emergencydatenbank");
            int psf = this.getJas().getInteger("preScanFilter");
            this.getJas().set("preScanFilter", this.getJas().getInteger("preScanEmergencyFilter"));
            LetterComperator ret = this.getLetterExtended(letter);
            this.getJas().set("preScanFilter", psf);
            return ret;
        }
        if (Utilities.isLoggerActive()) {
            logger.severe("Letter entg\u00fcltig nicht erkannt");
        }
        if (!this.isShowDebugGui()) return res;
        if (tf == null) return res;
        tf.setBackground(Color.RED);
        return res;
    }

    private String getLetterMapString() {
        StringBuilder ret = new StringBuilder();
        int i = 0;
        int x = 0;
        while (x < this.letterMap.length) {
            ret.append("|");
            ++i;
            int y = 0;
            while (y < this.letterMap[0].length) {
                ret.append(this.letterMap[x][y]);
                ++i;
                ret.append(",");
                ++i;
                ++y;
            }
            ret.deleteCharAt(ret.length() - 1);
            if (Utilities.isLoggerActive()) {
                logger.fine("Db String: " + x * 100 / this.letterDB.size() + "%");
            }
            ++x;
        }
        ret.deleteCharAt(0);
        return ret.toString();
    }

    public int getLetterNum() {
        return this.letterNum;
    }

    public String getMethodDirName() {
        return this.methodDirName;
    }

    public File getResourceFile(String arg) {
        return JDUtilities.getResourceFile((String)(String.valueOf(JDUtilities.getJACMethodsDirectory()) + this.methodDirName + "/" + arg));
    }

    public Captcha getWorkingCaptcha() {
        return this.workingCaptcha;
    }

    public void importDB() {
        this.importDB(Utilities.directoryChooser());
    }

    public void importDB(File path) {
        File[] images;
        String pattern = JOptionPane.showInputDialog("PATTERN", (Object)"\\d+_(.*?)\\.");
        if (JOptionPane.showConfirmDialog(null, "Delete old db?") == 0) {
            this.letterDB = new ArrayList();
        }
        this.getResourceFile("letters.mth").delete();
        System.out.println("LETTERS BEFORE: " + this.letterDB.size());
        File[] fileArray = images = this.getImages(path.getAbsolutePath());
        int n = images.length;
        int n2 = 0;
        while (n2 < n) {
            File element = fileArray[n2];
            Image image = Utilities.loadImage(element);
            try {
                image = ImageIO.read(element);
            }
            catch (IOException e) {
                JDLogger.exception((Throwable)e);
            }
            System.out.println(element.getAbsolutePath());
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            if ((width <= 0 || height <= 0) && Utilities.isLoggerActive()) {
                logger.severe("ERROR: Image nicht korrekt.");
            }
            Captcha cap = this.createCaptcha(image);
            Letter letter = new Letter();
            letter.setOwner(this);
            letter.setGrid(cap.grid);
            letter.setSourcehash(JDHash.getMD5((File)element));
            String let = new Regex(element.getName(), pattern).getMatch(0);
            letter.setDecodedValue(let);
            letter.clean();
            letter.removeSmallObjects(0.3, 0.5, 10);
            letter.setDecodedValue(let);
            if (letter != null) {
                this.letterDB.add(letter);
            }
            ++n2;
        }
        System.out.println("LETTERS AFTER: " + this.letterDB.size());
        this.sortLetterDB();
        this.saveMTHFile();
    }

    private boolean isCaptchaInMTH(String captchaHash) {
        if (this.letterDB == null) {
            return false;
        }
        for (Letter letter : this.letterDB) {
            if (!letter.getSourcehash().equals(captchaHash)) continue;
            return true;
        }
        return false;
    }

    public boolean isShowDebugGui() {
        return this.showDebugGui;
    }

    private void loadMTHFile() {
        File f = this.getResourceFile("letters.mth");
        String str = null;
        str = f.exists() ? JDIO.readFileToString((File)f) : "<jDownloader></jDownloader>";
        Document mth = JDUtilities.parseXmlString((String)str, (boolean)false);
        logger.info("Get file: " + f);
        if (mth == null && Utilities.isLoggerActive()) {
            logger.severe("MTH FILE NOT AVAILABLE.");
        }
        this.createLetterDBFormMTH(mth);
    }

    public void removeBadLetters() {
        if (Utilities.isLoggerActive()) {
            logger.info("aktuelle DB Size: " + this.letterDB.size());
        }
        ListIterator<Letter> iter = this.letterDB.listIterator(this.letterDB.size());
        while (iter.hasPrevious()) {
            Letter tmp = iter.previous();
            if (tmp.getBadDetections() <= tmp.getGoodDetections() + 2) continue;
            if (Utilities.isLoggerActive()) {
                logger.info("bad Letter entfernt: " + tmp.getDecodedValue() + " (" + tmp.getBadDetections() + "/" + tmp.getGoodDetections() + ")");
            }
            iter.remove();
        }
        if (Utilities.isLoggerActive()) {
            logger.info("neue DB Size: " + this.letterDB.size());
        }
        this.sortLetterDB();
        this.saveMTHFile();
    }

    protected void removeLetterFromLibrary(Letter letter) {
        logger.info("Remove" + (Object)((Object)letter) + " : " + this.letterDB.remove((Object)letter));
    }

    public void runTestMode(File file) {
        Image img = Utilities.loadImage(file);
        Captcha captcha = this.createCaptcha(img);
        BasicWindow.showImage(captcha.getImage(2), "Original bild");
        captcha.testColor();
        BasicWindow.showImage(captcha.getImage(2), "Farbtester. Bild sollte Identisch sein");
        BasicWindow.showImage(captcha.getImage(2));
        captcha.cleanBackgroundByColor(14408167);
        BasicWindow.showImage(captcha.getImage(2));
        Vector<PixelObject> letters = captcha.getBiggestObjects(4, 200, 0.7, 0.8);
        int i = 0;
        while (i < letters.size()) {
            PixelObject obj = letters.elementAt(i);
            Letter l = obj.toLetter();
            l.removeSmallObjects(0.3, 0.5);
            l = l.align(0.5, -45, 45);
            l.reduceWhiteNoise(2);
            l.toBlackAndWhite(0.6);
            BasicWindow.showImage(l.getImage(1));
            ++i;
        }
    }

    public synchronized void saveMTHFile() {
        String xmlString = JDUtilities.createXmlString((Document)this.createXMLFromLetterDB());
        if (!JDIO.writeLocalFile((File)this.getResourceFile("letters.mth"), (String)xmlString) && Utilities.isLoggerActive()) {
            logger.severe("MTHO file Konnte nicht gespeichert werden");
        }
    }

    public void setImageType(String imageType) {
        if (Utilities.isLoggerActive()) {
            logger.finer("SET PARAMETER: [imageType] = " + imageType);
        }
        this.imageType = imageType;
    }

    public void setLetterNum(int letterNum) {
        if (Utilities.isLoggerActive()) {
            logger.finer("SET PARAMETER: [letterNum] = " + letterNum);
        }
        this.letterNum = letterNum;
    }

    public void setShowDebugGui(boolean showDebugGui) {
        this.showDebugGui = showDebugGui;
    }

    public void setWorkingCaptcha(Captcha workingCaptcha) {
        this.workingCaptcha = workingCaptcha;
    }

    public void showPreparedCaptcha(final File captchafile) {
        if (!captchafile.exists()) {
            if (Utilities.isLoggerActive()) {
                logger.severe(String.valueOf(captchafile.getAbsolutePath()) + " existiert nicht");
            }
            return;
        }
        Image captchaImage = Utilities.loadImage(captchafile);
        BasicWindow.showImage(captchaImage);
        Captcha captcha = this.createCaptcha(captchaImage);
        logger.info("CAPTCHA :_" + this.checkCaptcha(captchafile, captcha));
        if (this.bw3 != null) {
            this.bw3.dispose();
        }
        this.bw3 = BasicWindow.showImage(captchaImage, "Captchas");
        this.bw3.add((Component)new JLabel("ORIGINAL"), Utilities.getGBC(2, 0, 2, 2));
        this.bw3.setLocationByScreenPercent(50, 70);
        this.bw3.add((Component)new ImageComponent(captcha.getImage(1)), Utilities.getGBC(0, 2, 2, 2));
        this.bw3.add((Component)new JLabel("Farbraum Anpassung"), Utilities.getGBC(2, 2, 2, 2));
        this.jas.executePrepareCommands(captchafile, captcha);
        this.bw3.add((Component)new ImageComponent(captcha.getImage(1)), Utilities.getGBC(0, 4, 2, 2));
        this.bw3.add((Component)new JLabel("Prepare Code ausgef\u00fchrt"), Utilities.getGBC(2, 4, 2, 2));
        Letter[] letters = captcha.getLetters(this.letterNum);
        if (letters == null) {
            if (Utilities.isLoggerActive()) {
                logger.severe("2. Lettererkennung ist fehlgeschlagen!");
            }
            return;
        }
        this.bw3.add((Component)new ImageComponent(captcha.getImageWithGaps(1)), Utilities.getGBC(0, 6, 2, 2));
        this.bw3.add((Component)new JLabel("Buchstaben freistellen"), Utilities.getGBC(2, 6, 2, 2));
        this.bw3.refreshUI();
        if (this.bw2 != null) {
            this.bw2.destroy();
        }
        this.bw2 = new BasicWindow();
        this.bw2.setTitle("Freigestellte Buchstaben");
        this.bw2.setLayout(new GridBagLayout());
        this.bw2.setSize(300, 300);
        if (Utilities.isLoggerActive()) {
            logger.info("display freistellen");
        }
        this.bw2.setAlwaysOnTop(true);
        this.bw2.setLocationByScreenPercent(50, 5);
        this.bw2.add((Component)new JLabel("Aus Captcha:"), Utilities.getGBC(0, 0, 2, 2));
        int i = 0;
        while (i < letters.length) {
            this.bw2.add((Component)new ImageComponent(letters[i].getImage((int)Math.ceil(this.jas.getDouble("simplifyFaktor")))), Utilities.getGBC(i * 2 + 2, 0, 2, 2));
            ++i;
        }
        this.bw2.setVisible(true);
        this.bw2.pack();
        this.bw2.setSize(300, this.bw2.getSize().height);
        LetterComperator[] lcs = captcha.getLetterComperators();
        int i2 = 0;
        while (i2 < lcs.length) {
            if (lcs[i2] != null) {
                this.bw2.add((Component)new JLabel("Aus Datenbank:"), Utilities.getGBC(0, 6, 2, 2));
                Letter dif = lcs[i2].getDifference();
                dif.removeSmallObjects(0.8, 0.8, 5);
                dif.clean();
                if (lcs[i2].getB() != null) {
                    this.bw2.add((Component)new ImageComponent(lcs[i2].getB().getImage((int)Math.ceil(this.jas.getDouble("simplifyFaktor")))), Utilities.getGBC(i2 * 2 + 2, 6, 2, 1));
                    this.bw2.add((Component)new ImageComponent(dif.getImage((int)Math.ceil(this.jas.getDouble("simplifyFaktor")))), Utilities.getGBC(i2 * 2 + 2, 7, 2, 1));
                } else {
                    this.bw2.add((Component)new JLabel("B unknown"), Utilities.getGBC(i2 * 2 + 2, 6, 2, 2));
                }
                this.bw2.add((Component)new JLabel("Wert:"), Utilities.getGBC(0, 8, 2, 2));
                this.bw2.add((Component)new JLabel("Proz.:"), Utilities.getGBC(0, 10, 2, 2));
                this.bw2.add((Component)new JLabel(String.valueOf(lcs[i2].getValityPercent()) + "%"), Utilities.getGBC(i2 * 2 + 2, 10, 2, 2));
            }
            ++i2;
        }
        JButton bt = new JButton("Train");
        this.bw2.add((Component)bt, Utilities.getGBC(0, 12, 2, 2));
        this.bw2.pack();
        this.bw2.repack();
        bt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JAntiCaptcha.this.trainCaptcha(captchafile, 4);
            }
        });
    }

    public void sortLetterDB() {
        Collections.sort(this.letterDB, new Comparator<Letter>(){

            @Override
            public int compare(Letter a, Letter b) {
                try {
                    return a.getDecodedValue().compareToIgnoreCase(b.getDecodedValue()) * -1;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 0;
                }
            }
        });
    }

    public void trainAllCaptchas(String path) {
        int successFull = 0;
        int total = 0;
        logger.info("TRain " + path);
        File[] images = this.getImages(path);
        if (images == null) {
            return;
        }
        File[] fileArray = images;
        int n = images.length;
        int n2 = 0;
        while (n2 < n) {
            File element = fileArray[n2];
            if (Utilities.isLoggerActive()) {
                logger.fine(element.toString());
            }
            int letternum = this.getLetterNum();
            int newLetters = this.trainCaptcha(element, letternum);
            if (Utilities.isLoggerActive()) {
                logger.fine("Erkannt: " + newLetters + "/" + this.getLetterNum());
            }
            if (newLetters > 0) {
                successFull += newLetters;
                total += this.getLetterNum();
                if (Utilities.isLoggerActive()) {
                    logger.info("Erkennungsrate: " + 100 * successFull / total);
                }
            } else if (newLetters == -2) {
                if (this.f == null) break;
                new GuiRunnable<Object>(){

                    public Object runSave() {
                        JAntiCaptcha.this.f.dispose();
                        return null;
                    }
                }.waitForEDT();
                break;
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int trainCaptcha(final File captchafile, int letterNum) {
        Object file3;
        String captchaHash;
        if (!captchafile.exists()) {
            if (Utilities.isLoggerActive()) {
                logger.severe(String.valueOf(captchafile.getAbsolutePath()) + " existiert nicht");
            }
            return -1;
        }
        if (this.isShowDebugGui()) {
            this.destroyScrollPaneWindows();
        }
        if (this.isCaptchaInMTH(captchaHash = JDHash.getMD5((File)captchafile))) {
            if (Utilities.isLoggerActive()) {
                logger.fine("Captcha schon aufgenommen" + captchafile);
            }
            return -1;
        }
        Image captchaImage = Utilities.loadImage(captchafile);
        final Captcha captcha = this.createCaptcha(captchaImage);
        if (captcha == null) {
            return -1;
        }
        String code = null;
        new GuiRunnable<Object>(){

            public Object runSave() {
                if (JAntiCaptcha.this.f != null) {
                    JAntiCaptcha.this.f.dispose();
                }
                JAntiCaptcha.this.f = new JDialog(DummyFrame.getDialogParent());
                JAntiCaptcha.this.f.setLocation(500, 10);
                JAntiCaptcha.this.f.setLayout(new GridBagLayout());
                JAntiCaptcha.this.f.add((Component)new JLabel("original captcha: " + captchafile.getName()), Utilities.getGBC(0, 0, 10, 1));
                JAntiCaptcha.this.f.add((Component)new ImageComponent(captcha.getImage()), Utilities.getGBC(0, 1, 10, 1));
                JAntiCaptcha.this.f.setSize(1400, 800);
                JAntiCaptcha.this.f.pack();
                JAntiCaptcha.this.f.setVisible(true);
                return null;
            }
        }.waitForEDT();
        final String guess = this.checkCaptcha(captchafile, captcha);
        final Letter[] letters = captcha.getLetters(letterNum);
        if (letters == null) {
            File file2 = this.getResourceFile("detectionErrors5/" + System.currentTimeMillis() + "_" + captchafile.getName());
            file2.getParentFile().mkdirs();
            captchafile.renameTo(file2);
            if (Utilities.isLoggerActive()) {
                logger.severe("Letter detection error");
            }
            return -1;
        }
        class MyRunnable
        implements Runnable {
            public String code = null;
            public int ret = 0;
            private final /* synthetic */ File val$captchafile;
            private final /* synthetic */ String val$guess;
            private final /* synthetic */ String val$captchaHash;

            MyRunnable(File file, String string, String string2) {
                this.val$captchafile = file;
                this.val$guess = string;
                this.val$captchaHash = string2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (JAntiCaptcha.this.getCodeFromFileName(this.val$captchafile.getName()) == null) {
                    this.code = (String)new GuiRunnable<String>(){

                        public String runSave() {
                            return JOptionPane.showInputDialog("Bitte Captcha Code eingeben (Press enter to confirm " + val$guess, (Object)val$guess);
                        }
                    }.getReturnValue();
                    if (this.code != null && this.code.equals(this.val$guess)) {
                        this.code = "";
                    } else if (this.code == null && ((Boolean)new GuiRunnable<Boolean>(){

                        public Boolean runSave() {
                            if (JOptionPane.showConfirmDialog(new JFrame(), "Ja (yes) = beenden (close) \t Nein (no) = n\u00e4chstes Captcha (next captcha)") == 0) {
                                return true;
                            }
                            return false;
                        }
                    }.getReturnValue()).booleanValue()) {
                        this.ret = -2;
                    }
                } else {
                    this.code = JAntiCaptcha.this.getCodeFromFileName(this.val$captchafile.getName());
                    if (Utilities.isLoggerActive()) {
                        logger.warning("captcha code f\u00fcr " + this.val$captchaHash + " verwendet: " + this.code);
                    }
                }
                MyRunnable myRunnable = this;
                synchronized (myRunnable) {
                    this.notify();
                }
            }
        }
        MyRunnable run = new MyRunnable(captchafile, guess, captchaHash);
        Thread inpThread = new Thread(run);
        inpThread.start();
        new GuiRunnable<Object>(){

            public Object runSave() {
                JAntiCaptcha.this.f.add((Component)new JLabel("Letter Detection"), Utilities.getGBC(0, 3, 10, 1));
                JAntiCaptcha.this.f.add((Component)new ImageComponent(captcha.getImageWithGaps(1)), Utilities.getGBC(0, 4, 10, 1));
                JAntiCaptcha.this.f.add((Component)new JLabel("Seperated"), Utilities.getGBC(0, 5, 10, 1));
                int i = 0;
                while (i < letters.length) {
                    JAntiCaptcha.this.f.add((Component)new ImageComponent(letters[i].getImage((int)Math.ceil(JAntiCaptcha.this.jas.getDouble("simplifyFaktor")))), Utilities.getGBC(i * 2 + 1, 6, 1, 1));
                    JLabel jl = new JLabel("|");
                    jl.setForeground(Color.RED);
                    JAntiCaptcha.this.f.add((Component)jl, Utilities.getGBC(i * 2 + 2, 6, 1, 1));
                    ++i;
                }
                JAntiCaptcha.this.f.pack();
                return null;
            }
        }.waitForEDT();
        final LetterComperator[] lcs = captcha.getLetterComperators();
        if (lcs == null) {
            File file3 = this.getResourceFile("detectionErrors5/" + System.currentTimeMillis() + "_" + captchafile.getName());
            file3.getParentFile().mkdirs();
            captchafile.renameTo(file3);
            if (Utilities.isLoggerActive()) {
                logger.severe("Letter detection error");
            }
            return -1;
        }
        if (lcs.length != letters.length) {
            logger.severe("ACHTUNG. lcs: " + lcs.length + " - letters: " + letters.length);
        }
        new GuiRunnable<Object>(){

            public Object runSave() {
                if (guess != null) {
                    JLabel jl;
                    JAntiCaptcha.this.f.add((Component)new JLabel("Letter Detection"), Utilities.getGBC(0, 3, 10, 1));
                    JAntiCaptcha.this.f.add((Component)new ImageComponent(captcha.getImageWithGaps(1)), Utilities.getGBC(0, 4, 10, 1));
                    JAntiCaptcha.this.f.add((Component)new JLabel("Seperated"), Utilities.getGBC(0, 5, 10, 1));
                    int i = 0;
                    while (i < letters.length) {
                        JAntiCaptcha.this.f.add((Component)new ImageComponent(letters[i].getImage((int)Math.ceil(JAntiCaptcha.this.jas.getDouble("simplifyFaktor")))), Utilities.getGBC(i * 2 + 1, 6, 1, 1));
                        jl = new JLabel("|");
                        jl.setForeground(Color.RED);
                        JAntiCaptcha.this.f.add((Component)jl, Utilities.getGBC(i * 2 + 2, 6, 1, 1));
                        ++i;
                    }
                    JAntiCaptcha.this.f.pack();
                    i = 0;
                    while (i < lcs.length) {
                        if (lcs[i] != null && lcs[i].getB() != null) {
                            JAntiCaptcha.this.f.add((Component)new ImageComponent(lcs[i].getB().getImage((int)Math.ceil(JAntiCaptcha.this.jas.getDouble("simplifyFaktor")))), Utilities.getGBC(i * 2 + 1, 8, 1, 1));
                        } else {
                            JAntiCaptcha.this.f.add((Component)new JLabel(""), Utilities.getGBC(i * 2 + 1, 8, 1, 1));
                        }
                        jl = new JLabel("|");
                        jl.setForeground(Color.RED);
                        JAntiCaptcha.this.f.add((Component)jl, Utilities.getGBC(i * 2 + 2, 6, 1, 1));
                        if (lcs[i] != null && lcs[i].getB() != null) {
                            JAntiCaptcha.this.f.add((Component)new JLabel(lcs[i].getDecodedValue()), Utilities.getGBC(i * 2 + 1, 9, 1, 1));
                        } else {
                            JAntiCaptcha.this.f.add((Component)new JLabel(""), Utilities.getGBC(i * 2 + 1, 9, 1, 1));
                        }
                        if (lcs[i] != null && lcs[i].getB() != null) {
                            JAntiCaptcha.this.f.add((Component)new JLabel("" + (double)Math.round(10.0 * lcs[i].getValityPercent()) / 10.0), Utilities.getGBC(i * 2 + 1, 10, 1, 1));
                        } else {
                            JAntiCaptcha.this.f.add((Component)new JLabel(""), Utilities.getGBC(i * 2 + 1, 10, 1, 1));
                        }
                        ++i;
                    }
                    JAntiCaptcha.this.f.pack();
                } else if (Utilities.isLoggerActive()) {
                    logger.warning("Erkennung fehlgeschlagen");
                }
                JAntiCaptcha.this.f.add((Component)new JLabel("prepared captcha"), Utilities.getGBC(0, 11, 10, 1));
                JAntiCaptcha.this.f.add((Component)new ImageComponent(captcha.getImage()), Utilities.getGBC(0, 12, 10, 1));
                JAntiCaptcha.this.f.pack();
                return null;
            }
        }.waitForEDT();
        if (Utilities.isLoggerActive()) {
            logger.info("Decoded Captcha: " + guess + " Vality: " + captcha.getValityPercent());
        }
        if (inpThread.isAlive()) {
            file3 = run;
            synchronized (file3) {
                try {
                    run.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        if (run.ret == -2) {
            return -2;
        }
        code = run.code;
        if (code == null) {
            file3 = this.getResourceFile("detectionErrors3/" + System.currentTimeMillis() + "_" + captchafile.getName());
            ((File)file3).getParentFile().mkdirs();
            captchafile.renameTo((File)file3);
            if (Utilities.isLoggerActive()) {
                logger.severe("Captcha Input error");
            }
            return -1;
        }
        if (code.length() == 0) {
            code = guess;
        }
        if (code.length() != letters.length) {
            file3 = this.getResourceFile("detectionErrors4/" + System.currentTimeMillis() + "_" + captchafile.getName());
            ((File)file3).getParentFile().mkdirs();
            captchafile.renameTo((File)file3);
            if (Utilities.isLoggerActive()) {
                logger.severe("Captcha Input error3");
            }
            return -1;
        }
        if (code.indexOf("-") < 0) {
            String[] oldName = captchafile.getName().split("\\.");
            String ext = oldName[oldName.length - 1];
            String newName = String.valueOf(captchafile.getParentFile().getAbsolutePath()) + "/captcha_" + this.getMethodDirName() + "_code" + code + "." + ext;
            captchafile.renameTo(new File(newName));
        }
        int ret = 0;
        int j = 0;
        while (j < letters.length) {
            final int i = j;
            if (!code.substring(i, i + 1).equals("-")) {
                if (guess != null && code.length() > i && guess.length() > i && code.substring(i, i + 1).equals(guess.substring(i, i + 1))) {
                    ++ret;
                    if (lcs[i] != null) {
                        lcs[i].getB().markGood();
                    }
                    if (lcs[i].getValityPercent() > 50.0) {
                        letters[i].setOwner(this);
                        letters[i].setSourcehash(captchaHash);
                        letters[i].setDecodedValue(code.substring(i, i + 1));
                        new Thread(new Runnable(){

                            public void run() {
                                final BasicWindow bws = (BasicWindow)new GuiRunnable<BasicWindow>(){

                                    public BasicWindow runSave() {
                                        return BasicWindow.showImage(letters[i].getImage(2), letters[i].getDecodedValue());
                                    }
                                }.getReturnValue();
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                new GuiRunnable<Object>(){

                                    public Object runSave() {
                                        bws.dispose();
                                        return null;
                                    }
                                }.waitForEDT();
                            }
                        }).start();
                        this.letterDB.add(letters[i]);
                    }
                    if (!this.jas.getBoolean("TrainOnlyUnknown")) {
                        letters[i].setOwner(this);
                        letters[i].setSourcehash(captchaHash);
                        letters[i].setDecodedValue(code.substring(i, i + 1));
                        this.letterDB.add(letters[i]);
                        new GuiRunnable<Object>(){

                            public Object runSave() {
                                JAntiCaptcha.this.f.add((Component)new JLabel("OK+"), Utilities.getGBC(i + 1, 13, 1, 1));
                                return null;
                            }
                        }.waitForEDT();
                    } else {
                        new GuiRunnable<Object>(){

                            public Object runSave() {
                                JAntiCaptcha.this.f.add((Component)new JLabel("OK-"), Utilities.getGBC(i + 1, 13, 1, 1));
                                return null;
                            }
                        }.waitForEDT();
                    }
                    new GuiRunnable<Object>(){

                        public Object runSave() {
                            JAntiCaptcha.this.f.pack();
                            return null;
                        }
                    }.waitForEDT();
                } else {
                    if (Utilities.isLoggerActive()) {
                        logger.info(this.letterDB + " - ");
                    }
                    if (lcs != null && lcs[i] != null && this.letterDB.size() > 30 && lcs[i] != null && lcs[i].getB() != null) {
                        lcs[i].getB().markBad();
                    }
                    letters[i].setOwner(this);
                    letters[i].setSourcehash(captchaHash);
                    letters[i].setDecodedValue(code.substring(i, i + 1));
                    this.letterDB.add(letters[i]);
                    new Thread(new Runnable(){

                        public void run() {
                            final BasicWindow bws = (BasicWindow)new GuiRunnable<BasicWindow>(){

                                public BasicWindow runSave() {
                                    return BasicWindow.showImage(letters[i].getImage(2), letters[i].getDecodedValue());
                                }
                            }.getReturnValue();
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            new GuiRunnable<Object>(){

                                public Object runSave() {
                                    bws.dispose();
                                    return null;
                                }
                            }.waitForEDT();
                        }
                    }).start();
                    new GuiRunnable<Object>(){

                        public Object runSave() {
                            JAntiCaptcha.this.f.add((Component)new JLabel("NO +"), Utilities.getGBC(i + 1, 13, 1, 1));
                            JAntiCaptcha.this.f.pack();
                            return null;
                        }
                    }.waitForEDT();
                }
            } else {
                new GuiRunnable<Object>(){

                    public Object runSave() {
                        JAntiCaptcha.this.f.add((Component)new JLabel("-"), Utilities.getGBC(i + 1, 13, 1, 1));
                        JAntiCaptcha.this.f.pack();
                        return null;
                    }
                }.waitForEDT();
            }
            ++j;
        }
        this.sortLetterDB();
        new Thread(new Runnable(){

            public void run() {
                JAntiCaptcha.this.saveMTHFile();
            }
        }).start();
        return ret;
    }

    public void cleanLibrary(double d) {
        ArrayList<Letter> newDB = new ArrayList<Letter>();
        block0: for (Letter let : this.letterDB) {
            for (Letter n : newDB) {
                if (!let.getDecodedValue().endsWith(n.getDecodedValue())) continue;
                LetterComperator lc = new LetterComperator(let, n);
                lc.setOwner(this);
                lc.run();
                n.getElementPixel();
                if (!(lc.getValityPercent() <= d)) continue;
                BasicWindow.showImage(let.getImage(), " OK ");
                if (n.getElementPixel() <= let.getElementPixel()) continue block0;
                newDB.remove((Object)let);
                break;
            }
            newDB.add(let);
        }
        this.letterDB = newDB;
        this.saveMTHFile();
    }
}

