/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.easy;

import java.awt.Image;
import java.io.File;
import jd.captcha.easy.CPoint;
import jd.captcha.easy.EasyMethodFile;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.utils.Utilities;
import jd.controlling.JDLogger;

public class BackGroundImage
extends CPoint {
    private static final long serialVersionUID = 8700548338559980634L;
    private transient Image image = null;
    private String backgroundImage;

    public String getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(String backgroundImage) {
        this.image = null;
        this.backgroundImage = backgroundImage;
    }

    public Image getImage(EasyMethodFile methode) {
        if (this.image == null) {
            this.image = Utilities.loadImage(new File(methode.file, this.getBackgroundImage()));
        }
        return this.image;
    }

    public void clearCaptcha(Captcha captchaImage) {
        EasyMethodFile methode = new EasyMethodFile(captchaImage.owner.getResourceFile("jacinfo.xml").getParentFile());
        Image bImage = this.getImage(methode);
        if (bImage == null || bImage.getWidth(null) != captchaImage.getWidth() || bImage.getHeight(null) != captchaImage.getHeight()) {
            if (Utilities.isLoggerActive()) {
                JDLogger.getLogger().info("ERROR Maske und Bild passen nicht zusammmen");
            }
            return;
        }
        Captcha cleanImg = captchaImage.owner.createCaptcha(bImage);
        int color = this.getColor();
        int x = 0;
        while (x < captchaImage.getWidth()) {
            int y = 0;
            while (y < captchaImage.getHeight()) {
                int pv = captchaImage.getPixelValue(x, y);
                this.setColor(cleanImg.getPixelValue(x, y));
                if (this.getColorDifference(pv) < (double)this.getDistance()) {
                    captchaImage.setPixelValue(x, y, color);
                }
                ++y;
            }
            ++x;
        }
        this.setColor(color);
    }

    public BackGroundImage clone() {
        BackGroundImage ret = new BackGroundImage();
        ret.setLocation(this.getLocation());
        ret.setColor(this.getColor());
        ret.setDistance(this.getDistance());
        ret.setColorDistanceMode(this.getColorDistanceMode());
        ret.setForeground(this.isForeground());
        ret.backgroundImage = this.backgroundImage;
        ret.image = this.image;
        return ret;
    }
}

