/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.easy;

import java.awt.Color;
import java.awt.Point;
import java.io.Serializable;
import jd.captcha.pixelgrid.Captcha;
import jd.nutils.Colors;

public class CPoint
extends Point
implements Serializable,
Cloneable {
    public static final byte LAB_DIFFERENCE = 1;
    public static final byte RGB_DIFFERENCE1 = 2;
    public static final byte RGB_DIFFERENCE3 = 11;
    public static final byte RGB_DIFFERENCE2 = 3;
    public static final byte HUE_DIFFERENCE = 4;
    public static final byte SATURATION_DIFFERENCE = 5;
    public static final byte BRIGHTNESS_DIFFERENCE = 6;
    public static final byte RED_DIFFERENCE = 7;
    public static final byte GREEN_DIFFERENCE = 8;
    public static final byte BLUE_DIFFERENCE = 9;
    public static final byte CMYK_DIFFERENCE = 10;
    private static final long serialVersionUID = 333616481245029882L;
    private int color;
    private int distance;
    private boolean foreground = true;
    private byte colorDifferenceMode = 1;

    public CPoint() {
    }

    public CPoint(int x, int y, int distance, Captcha captcha) {
        this(x, y, distance, captcha.getPixelValue(x, y));
    }

    public CPoint(int x, int y, int distance, int color) {
        super(x, y);
        this.color = color;
        this.distance = distance;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public byte getColorDistanceMode() {
        return this.colorDifferenceMode;
    }

    public void setColorDistanceMode(byte colorDistanceMode) {
        this.colorDifferenceMode = colorDistanceMode;
    }

    public boolean isForeground() {
        return this.foreground;
    }

    public void setForeground(boolean foreground) {
        this.foreground = foreground;
    }

    public int getDistance() {
        return this.distance;
    }

    public double getColorDifference(int color) {
        double dst = 0.0;
        if (color == this.color) {
            return dst;
        }
        switch (this.colorDifferenceMode) {
            case 1: {
                dst = Colors.getColorDifference((int)color, (int)this.color);
                break;
            }
            case 2: {
                dst = Colors.getRGBColorDifference1((int)color, (int)this.color);
                break;
            }
            case 3: {
                dst = Colors.getRGBColorDifference2((int)color, (int)this.color);
                break;
            }
            case 11: {
                dst = Colors.getRGBColorDifference3((int)color, (int)this.color);
                break;
            }
            case 4: {
                dst = Colors.getHueColorDifference360((int)color, (int)this.color);
                break;
            }
            case 5: {
                dst = Colors.getSaturationColorDifference((int)color, (int)this.color);
                break;
            }
            case 6: {
                dst = Colors.getBrightnessColorDifference((int)color, (int)this.color);
                break;
            }
            case 7: {
                dst = Math.abs(new Color(color).getRed() - new Color(this.color).getRed());
                break;
            }
            case 8: {
                dst = Math.abs(new Color(color).getGreen() - new Color(this.color).getGreen());
                break;
            }
            case 9: {
                dst = Math.abs(new Color(color).getBlue() - new Color(this.color).getBlue());
                break;
            }
            case 10: {
                dst = Colors.getCMYKColorDifference1((int)color, (int)this.color);
                break;
            }
            default: {
                dst = Colors.getColorDifference((int)color, (int)this.color);
            }
        }
        return dst;
    }

    public void setDistance(int distance) {
        this.distance = distance;
    }

    public Object clone() {
        CPoint ret = new CPoint(this.x, this.y, this.distance, this.color);
        ret.colorDifferenceMode = this.colorDifferenceMode;
        ret.foreground = this.foreground;
        return ret;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) || obj != null && obj instanceof CPoint && ((CPoint)obj).color == this.color;
    }
}

