/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.easy;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Vector;
import jd.captcha.easy.CPoint;
import jd.captcha.pixelgrid.Captcha;
import jd.nutils.Colors;
import jd.nutils.io.JDIO;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorTrainer {
    public static final int foregroundColor1 = 0xFF00FF;
    public static final int foregroundColor2 = 0xFF99FF;
    public static final int backgroundColor1 = 255;
    public static final int backgroundColor2 = 65535;
    public Captcha workingCaptcha;
    public Captcha backUpCaptcha;
    public boolean foreground = true;
    public boolean fastSelection = false;
    public boolean add = true;
    public int zoom = 400;
    public Captcha originalCaptcha;
    public int threshold = 25;
    public BufferedImage colorImage = new BufferedImage(28, 28, 1);
    public Vector<CPoint> colorPointList = new Vector();
    private Vector<CPoint> colorPointListBackUp = new Vector();
    public byte colorDifferenceMode = 1;

    private void autoSetZoomFaktor() {
        this.zoom = this.originalCaptcha.getWidth() > 200 || this.originalCaptcha.getHeight() > 100 ? 100 : (this.originalCaptcha.getWidth() > 100 || this.originalCaptcha.getHeight() > 50 ? 200 : 400);
    }

    public void removeCPoint(CPoint cPoint) {
        this.colorPointList.remove(cPoint);
        if (this.fastSelection) {
            int x = 0;
            while (x < this.workingCaptcha.getWidth()) {
                int y = 0;
                while (y < this.workingCaptcha.getHeight()) {
                    double dist = Colors.getColorDifference((int)this.originalCaptcha.getPixelValue(x, y), (int)cPoint.getColor());
                    if (dist < (double)cPoint.getDistance()) {
                        this.workingCaptcha.grid[x][y] = this.originalCaptcha.getPixelValue(x, y);
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            this.recreateWorkingCaptcha();
        }
    }

    public void addCPoint(CPoint cPoint) {
        if (!this.colorPointList.contains(cPoint)) {
            this.colorPointList.add(cPoint);
            if (this.fastSelection) {
                int x = 0;
                while (x < this.workingCaptcha.getWidth()) {
                    int y = 0;
                    while (y < this.workingCaptcha.getHeight()) {
                        this.workingCaptcha.grid[x][y] = this.workingCaptcha.getPixelValue(x, y);
                        if (cPoint.getColorDifference(this.originalCaptcha.getPixelValue(x, y)) < (double)cPoint.getDistance()) {
                            this.workingCaptcha.grid[x][y] = cPoint.isForeground() ? 0xFF00FF : 255;
                        }
                        ++y;
                    }
                    ++x;
                }
            } else {
                this.recreateWorkingCaptcha();
            }
        }
    }

    private String getDigit(int i) {
        String ret = "";
        ret = i < 10 ? String.valueOf(i) + "&nbsp;&nbsp;&nbsp;&nbsp;" : (i < 100 ? String.valueOf(i) + "&nbsp;&nbsp;" : String.valueOf(ret) + i);
        return ret;
    }

    public String getStatusString(int xb, int yb) {
        Graphics2D graphics = this.colorImage.createGraphics();
        int xc = xb * 100 / this.zoom;
        int yc = yb * 100 / this.zoom;
        Color c = new Color(this.originalCaptcha.getPixelValue(xc, yc));
        int y = 0;
        while (y < this.colorImage.getHeight()) {
            int x = 0;
            while (x < this.colorImage.getWidth()) {
                graphics.setColor(c);
                graphics.fillRect(x, y, 1, 1);
                ++x;
            }
            ++y;
        }
        int x = 0;
        while (x < this.colorImage.getWidth()) {
            graphics.setColor(Color.black);
            graphics.fillRect(x, 0, 1, 1);
            graphics.fillRect(x, this.colorImage.getHeight(), 1, 1);
            ++x;
        }
        y = 0;
        while (y < this.colorImage.getHeight()) {
            graphics.setColor(Color.black);
            graphics.fillRect(0, y, 1, 1);
            graphics.fillRect(this.colorImage.getWidth(), y, 1, 1);
            ++y;
        }
        float[] hsb = Colors.rgb2hsb((int)c.getRed(), (int)c.getGreen(), (int)c.getBlue());
        return "<HTML><BODY>" + JDL.L((String)"easycaptcha.color", (String)"Color") + ":#" + Integer.toHexString(c.getRGB() & 0xFFFFFF) + "<BR>\r\n" + xc + ":" + yc + "<BR>\r\n" + "<span style=\"color:#" + Integer.toHexString(new Color(c.getRed(), 0, 0).getRGB() & 0xFFFFFF) + "\">R:" + this.getDigit(c.getRed()) + "</span><span style=\"color:#" + Integer.toHexString(new Color(0, c.getGreen(), 0).getRGB() & 0xFFFFFF) + "\"> G:" + this.getDigit(c.getGreen()) + "</span><span style=\"color:#" + Integer.toHexString(new Color(0, 0, c.getBlue()).getRGB() & 0xFFFFFF) + "\"> B:" + this.getDigit(c.getBlue()) + "</span><BR>\r\n" + "H:" + this.getDigit(Math.round(hsb[0] * 360.0f)) + " S:" + this.getDigit(Math.round(hsb[1] * 100.0f)) + " B:" + this.getDigit(Math.round(hsb[2] * 100.0f)) + "\r\n</BODY></HTML>";
    }

    public CPoint searchCPoint(CPoint color) {
        return this.searchCPoint(color.getColor());
    }

    public CPoint searchCPoint(int color) {
        double bestDist = 2.147483647E9;
        CPoint bestPX = null;
        for (CPoint p : this.colorPointList) {
            double d;
            double dist = 0.0;
            if (p.getDistance() == 0) {
                if (color != p.getColor()) continue;
                bestPX = p;
                break;
            }
            dist = p.getColorDifference(color);
            if (!(d < (double)p.getDistance()) || !(dist < bestDist)) continue;
            bestPX = p;
            bestDist = dist;
        }
        return bestPX;
    }

    private void recreateWorkingCaptcha() {
        int x = 0;
        while (x < this.workingCaptcha.getWidth()) {
            int y = 0;
            while (y < this.workingCaptcha.getHeight()) {
                this.workingCaptcha.grid[x][y] = this.originalCaptcha.getPixelValue(x, y);
                double bestDist1 = Double.MAX_VALUE;
                CPoint cpBestDist1 = null;
                double bestDist2 = Double.MAX_VALUE;
                CPoint cpBestDist2 = null;
                for (CPoint cp : this.colorPointList) {
                    double dist = cp.getColorDifference(this.originalCaptcha.getPixelValue(x, y));
                    if (bestDist1 > dist) {
                        bestDist1 = dist;
                        cpBestDist1 = cp;
                    }
                    if (!(dist < (double)cp.getDistance()) || !(bestDist2 > dist)) continue;
                    bestDist2 = 0.0;
                    cpBestDist2 = cp;
                }
                if (cpBestDist2 != null) {
                    this.workingCaptcha.grid[x][y] = cpBestDist2.isForeground() ? 0xFF00FF : 255;
                } else if (cpBestDist1 != null) {
                    this.workingCaptcha.grid[x][y] = cpBestDist1.isForeground() ? 0xFF99FF : 65535;
                }
                ++y;
            }
            ++x;
        }
    }

    public void createWorkingCaptcha() {
        this.workingCaptcha = new Captcha(this.originalCaptcha.getWidth(), this.originalCaptcha.getHeight());
        this.workingCaptcha.grid = new int[this.originalCaptcha.getWidth()][this.originalCaptcha.getHeight()];
        this.recreateWorkingCaptcha();
    }

    public void copySettingsTo(ColorTrainer colorTrainer) {
        colorTrainer.fastSelection = this.fastSelection;
        colorTrainer.foreground = this.foreground;
        colorTrainer.add = this.add;
        colorTrainer.threshold = this.threshold;
        colorTrainer.colorDifferenceMode = this.colorDifferenceMode;
    }

    public void loadLastImage() {
        this.colorPointList = this.colorPointListBackUp;
        this.workingCaptcha = this.backUpCaptcha;
    }

    public void backUP() {
        this.colorPointListBackUp = this.colorPointList != null ? new Vector<CPoint>(this.colorPointList) : null;
        this.backUpCaptcha = new Captcha(this.workingCaptcha.getHeight(), this.workingCaptcha.getWidth());
        this.backUpCaptcha.grid = new int[this.workingCaptcha.getWidth()][this.workingCaptcha.getHeight()];
        int a = 0;
        while (a < this.workingCaptcha.grid.length) {
            this.backUpCaptcha.grid[a] = (int[])this.workingCaptcha.grid[a].clone();
            ++a;
        }
    }

    public CPoint getCPointFromMouseEvent(MouseEvent e) {
        CPoint p = new CPoint(e.getX() * 100 / this.zoom, e.getY() * 100 / this.zoom, this.threshold, this.originalCaptcha);
        p.setColorDistanceMode(this.colorDifferenceMode);
        p.setForeground(this.foreground);
        return p;
    }

    public Image getScaledWorkingCaptchaImage() {
        return this.workingCaptcha.getImage().getScaledInstance(this.workingCaptcha.getWidth() * this.zoom / 100, this.workingCaptcha.getHeight() * this.zoom / 100, 1);
    }

    public Image getScaledOriginalCaptchaImage() {
        this.autoSetZoomFaktor();
        return this.originalCaptcha.getImage().getScaledInstance(this.originalCaptcha.getWidth() * this.zoom / 100, this.originalCaptcha.getHeight() * this.zoom / 100, 1);
    }

    public static Vector<CPoint> load(File file) {
        if (file.exists()) {
            return (Vector)JDIO.loadObject(null, (File)file, (boolean)true);
        }
        return new Vector<CPoint>();
    }

    public static void saveColors(Vector<CPoint> cPoints, File file) {
        file.getParentFile().mkdirs();
        JDIO.saveObject(null, cPoints, (File)file, null, null, (boolean)true);
    }
}

