/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.easy;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jd.captcha.JAntiCaptcha;
import jd.captcha.easy.BackGroundImageManager;
import jd.captcha.easy.CPoint;
import jd.captcha.easy.ColorMode;
import jd.captcha.easy.ColorTrainer;
import jd.captcha.easy.EasyMethodFile;
import jd.captcha.gui.ImageComponent;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.PixelGrid;
import jd.captcha.utils.Utilities;
import jd.gui.swing.GuiRunnable;
import jd.gui.userio.DummyFrame;
import jd.nutils.Screen;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorTrainerGUI {
    private static final long serialVersionUID = 1L;
    private JPanel panel;
    private JPanel images;
    private ImageComponent ic;
    private ImageComponent icColorImage;
    private boolean close = true;
    private JButton back;
    private JLabel colorState;
    private JDialog frame;
    private ColorTrainer colorTrainer = new ColorTrainer();

    public ColorTrainerGUI(final JFrame owner) {
        new GuiRunnable<Object>(){

            public Object runSave() {
                ColorTrainerGUI.this.frame = new JDialog(owner);
                return null;
            }
        }.waitForEDT();
    }

    public void removePixelAbsolut(CPoint cp) {
        this.backUP();
        this.colorTrainer.removeCPoint(cp);
    }

    public void backUP() {
        this.colorTrainer.backUP();
        this.back.setEnabled(true);
    }

    private void goBack() {
        this.colorTrainer.loadLastImage();
        this.back.setEnabled(false);
        this.ic.image = this.colorTrainer.getScaledWorkingCaptchaImage();
        new GuiRunnable<Object>(){

            public Object runSave() {
                ColorTrainerGUI.this.panel.repaint();
                ColorTrainerGUI.this.panel.revalidate();
                return null;
            }
        }.waitForEDT();
    }

    private void removePixelRelativ(CPoint pr) {
        CPoint bestPX = this.colorTrainer.searchCPoint(pr);
        if (bestPX != null) {
            this.removePixelAbsolut(bestPX);
            this.ic.image = this.colorTrainer.getScaledWorkingCaptchaImage();
            new GuiRunnable<Object>(){

                public Object runSave() {
                    ColorTrainerGUI.this.panel.repaint();
                    ColorTrainerGUI.this.panel.revalidate();
                    return null;
                }
            }.waitForEDT();
        }
    }

    public void addPixel(CPoint p) {
        if (!this.colorTrainer.colorPointList.contains(p)) {
            this.backUP();
            this.colorTrainer.addCPoint(p);
            this.ic.image = this.colorTrainer.getScaledWorkingCaptchaImage();
            new GuiRunnable<Object>(){

                public Object runSave() {
                    ColorTrainerGUI.this.panel.repaint();
                    ColorTrainerGUI.this.panel.revalidate();
                    return null;
                }
            }.waitForEDT();
        }
    }

    private MouseListener getICListener() {
        return new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                CPoint p = ColorTrainerGUI.this.colorTrainer.getCPointFromMouseEvent(e);
                if (((ColorTrainerGUI)ColorTrainerGUI.this).colorTrainer.add) {
                    ColorTrainerGUI.this.addPixel(p);
                } else {
                    ColorTrainerGUI.this.removePixelRelativ(p);
                }
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        };
    }

    private void createIc() {
        this.colorTrainer.createWorkingCaptcha();
        final Image ci = this.colorTrainer.getScaledWorkingCaptchaImage();
        new GuiRunnable<Object>(){

            public Object runSave() {
                ColorTrainerGUI.this.ic = new ImageComponent(ci);
                return null;
            }
        }.waitForEDT();
        this.images.add((Component)this.ic, this.getGBC(0, 2, 1, 1));
    }

    public GridBagConstraints getGBC(int x, int y, int width, int height) {
        GridBagConstraints gbc = Utilities.getGBC(x, y, width, height);
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        return gbc;
    }

    private void addImages() {
        new GuiRunnable<Object>(){

            public Object runSave() {
                ColorTrainerGUI.this.images = new JPanel();
                ColorTrainerGUI.this.images.setBorder(new TitledBorder(JDL.L((String)"easycaptcha.images", (String)"Images:")));
                ColorTrainerGUI.this.images.setLayout(new BoxLayout(ColorTrainerGUI.this.images, 1));
                ColorTrainerGUI.this.images.add((Component)new JLabel(JDL.L((String)"easycaptcha.orginal", (String)"Original:")), ColorTrainerGUI.this.getGBC(0, 1, 1, 1));
                ImageComponent ic0 = new ImageComponent(ColorTrainerGUI.this.colorTrainer.getScaledOriginalCaptchaImage());
                ColorTrainerGUI.this.images.add((Component)ic0, ColorTrainerGUI.this.getGBC(0, 1, 1, 1));
                ColorTrainerGUI.this.images.add(Box.createRigidArea(new Dimension(0, 10)));
                ColorTrainerGUI.this.images.add((Component)new JLabel(JDL.L((String)"easycaptcha.labeled", (String)"Labeled:")), ColorTrainerGUI.this.getGBC(0, 1, 1, 1));
                ColorTrainerGUI.this.createIc();
                MouseListener icl = ColorTrainerGUI.this.getICListener();
                MouseMotionListener mml = new MouseMotionListener(){

                    public void mouseDragged(MouseEvent e) {
                    }

                    public void mouseMoved(MouseEvent e) {
                        ColorTrainerGUI.this.setStatus(e.getX(), e.getY());
                    }
                };
                ColorTrainerGUI.this.ic.addMouseListener(icl);
                ic0.addMouseListener(icl);
                ColorTrainerGUI.this.ic.addMouseMotionListener(mml);
                ic0.addMouseMotionListener(mml);
                return null;
            }
        }.waitForEDT();
    }

    public void setStatus(int xb, int yb) {
        final String statusString = this.colorTrainer.getStatusString(xb, yb);
        new GuiRunnable<Object>(){

            public Object runSave() {
                ColorTrainerGUI.this.icColorImage.setImage(((ColorTrainerGUI)ColorTrainerGUI.this).colorTrainer.colorImage);
                ColorTrainerGUI.this.icColorImage.revalidate();
                ColorTrainerGUI.this.icColorImage.repaint();
                ColorTrainerGUI.this.colorState.setText(statusString);
                return null;
            }
        }.waitForEDT();
    }

    private JPanel addStatus() {
        JPanel box = new JPanel(new GridLayout(2, 1));
        this.icColorImage = new ImageComponent(this.colorTrainer.colorImage);
        this.colorState = new JLabel();
        this.setStatus(1, 1);
        box.add(this.icColorImage);
        box.add(this.colorState);
        box.setBorder(new TitledBorder(JDL.L((String)"easycaptcha.color", (String)"Color")));
        return box;
    }

    private JPanel addSettings() {
        final JPanel box = new JPanel(new GridLayout(5, 1));
        new GuiRunnable<JComboBox>(){

            public JComboBox runSave() {
                final JComboBox<ColorMode> ret = new JComboBox<ColorMode>(ColorMode.cModes);
                box.add(ret);
                ret.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ((ColorTrainerGUI)(this).ColorTrainerGUI.this).colorTrainer.colorDifferenceMode = ((ColorMode)ret.getSelectedItem()).mode;
                    }
                });
                return null;
            }
        }.waitForEDT();
        final JCheckBox ground = (JCheckBox)new GuiRunnable<JCheckBox>(){

            public JCheckBox runSave() {
                return new JCheckBox(((ColorTrainerGUI)ColorTrainerGUI.this).colorTrainer.foreground ? JDL.L((String)"easycaptcha.foreground", (String)"foreground") : JDL.L((String)"easycaptcha.background", (String)"background"), ((ColorTrainerGUI)ColorTrainerGUI.this).colorTrainer.foreground);
            }
        }.getReturnValue();
        ground.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((ColorTrainerGUI)ColorTrainerGUI.this).colorTrainer.foreground = !((ColorTrainerGUI)ColorTrainerGUI.this).colorTrainer.foreground;
                new GuiRunnable<Object>(){

                    public Object runSave() {
                        ground.setText(((ColorTrainerGUI)(this).ColorTrainerGUI.this).colorTrainer.foreground ? JDL.L((String)"easycaptcha.foreground", (String)"foreground") : JDL.L((String)"easycaptcha.background", (String)"background"));
                        return null;
                    }
                }.waitForEDT();
            }
        });
        box.add(ground);
        final JCheckBox addb = (JCheckBox)new GuiRunnable<JCheckBox>(){

            public JCheckBox runSave() {
                return new JCheckBox(((ColorTrainerGUI)ColorTrainerGUI.this).colorTrainer.add ? JDL.L((String)"easycaptcha.add", (String)"add") : JDL.L((String)"easycaptcha.remove", (String)"remove"), ((ColorTrainerGUI)ColorTrainerGUI.this).colorTrainer.add);
            }
        }.getReturnValue();
        addb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((ColorTrainerGUI)ColorTrainerGUI.this).colorTrainer.add = !((ColorTrainerGUI)ColorTrainerGUI.this).colorTrainer.add;
                new GuiRunnable<Object>(){

                    public Object runSave() {
                        addb.setText(((ColorTrainerGUI)(this).ColorTrainerGUI.this).colorTrainer.add ? JDL.L((String)"easycaptcha.add", (String)"add") : JDL.L((String)"easycaptcha.remove", (String)"remove"));
                        return null;
                    }
                }.waitForEDT();
            }
        });
        box.add(addb);
        final ChangeListener cl = new ChangeListener(){

            public void stateChanged(final ChangeEvent e) {
                new GuiRunnable<Object>(){

                    public Object runSave() {
                        ((ColorTrainerGUI)(this).ColorTrainerGUI.this).colorTrainer.threshold = (Integer)((JSpinner)e.getSource()).getValue();
                        return null;
                    }
                }.waitForEDT();
            }
        };
        new GuiRunnable<Object>(){

            public Object runSave() {
                JPanel p = new JPanel();
                JSpinner tolleranceSP = new JSpinner(new SpinnerNumberModel(((ColorTrainerGUI)ColorTrainerGUI.this).colorTrainer.threshold, 0, 360, 1));
                tolleranceSP.setToolTipText("Threshold");
                tolleranceSP.addChangeListener(cl);
                p.add(new JLabel(JDL.L((String)"easycaptcha.threshold", (String)"Threshold:")));
                p.add(tolleranceSP);
                box.add(p);
                box.setBorder(new TitledBorder(JDL.L((String)"easycaptcha.settings", (String)"Settings:")));
                return null;
            }
        }.waitForEDT();
        return box;
    }

    private void init() {
        new GuiRunnable<Object>(){

            public Object runSave() {
                ColorTrainerGUI.this.frame.setAlwaysOnTop(true);
                ColorTrainerGUI.this.panel = new JPanel();
                ColorTrainerGUI.this.panel.setLayout(new GridBagLayout());
                ColorTrainerGUI.this.frame.setLayout(new BorderLayout());
                ColorTrainerGUI.this.frame.add((Component)new JScrollPane(ColorTrainerGUI.this.panel), "Center");
                ColorTrainerGUI.this.frame.setTitle(JDL.L((String)"easycaptcha.colorcrainer.title", (String)"Color Trainer"));
                ColorTrainerGUI.this.addImages();
                ColorTrainerGUI.this.panel.add(ColorTrainerGUI.this.images);
                JPanel pen = new JPanel();
                GridBagConstraints gb = Utilities.getGBC(0, 2, 1, 1);
                pen.add(ColorTrainerGUI.this.addStatus());
                pen.add(ColorTrainerGUI.this.addSettings());
                ColorTrainerGUI.this.panel.add((Component)pen, gb);
                gb = Utilities.getGBC(0, 4, 1, 1);
                ColorTrainerGUI.this.back = new JButton(JDL.L((String)"easycaptcha.back", (String)"back"));
                ColorTrainerGUI.this.back.setEnabled(false);
                ColorTrainerGUI.this.back.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ColorTrainerGUI.this.goBack();
                    }
                });
                Box box = new Box(0);
                box.add(ColorTrainerGUI.this.back);
                Component glue = Box.createGlue();
                glue.setSize(10, 1);
                box.add(glue);
                JButton btf = new JButton(JDL.L((String)"easycaptcha.finished", (String)"finish"));
                btf.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ColorTrainerGUI.this.destroy();
                    }
                });
                box.add(btf);
                gb.anchor = 17;
                ColorTrainerGUI.this.panel.add((Component)box, gb);
                JButton bt = new JButton(JDL.L((String)"gui.btn_ok", (String)"OK"));
                bt.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ColorTrainerGUI.this.close = false;
                        ColorTrainerGUI.this.destroy();
                    }
                });
                gb.anchor = 13;
                ColorTrainerGUI.this.panel.add((Component)bt, gb);
                ColorTrainerGUI.this.frame.pack();
                ColorTrainerGUI.this.frame.setLocation(Screen.getCenterOfComponent((Component)DummyFrame.getDialogParent(), (Component)ColorTrainerGUI.this.frame));
                ColorTrainerGUI.this.frame.setVisible(true);
                return null;
            }
        }.waitForEDT();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        new GuiRunnable<Object>(){

            public Object runSave() {
                ColorTrainerGUI.this.frame.dispose();
                return null;
            }
        }.waitForEDT();
        ColorTrainerGUI colorTrainerGUI = this;
        synchronized (colorTrainerGUI) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<CPoint> getColors(File folder, String hoster, Vector<CPoint> colorPoints, JFrame owner) {
        File file = new File(JDUtilities.getJDHomeDirectoryFromEnvironment() + "/" + JDUtilities.getJACMethodsDirectory() + hoster + "/CPoints.xml");
        File[] list = folder.listFiles();
        Captcha[] cs = new Captcha[15 < list.length ? 15 : list.length];
        JAntiCaptcha jac = new JAntiCaptcha(hoster);
        if (colorPoints == null) {
            colorPoints = ColorTrainer.load(file);
        }
        ColorTrainerGUI lastCC = null;
        int i = 0;
        while (i < cs.length) {
            Captcha captcha;
            File captchafile = list[i];
            Image captchaImage = Utilities.loadImage(captchafile);
            if (captchaImage != null && (captcha = jac.createCaptcha(captchaImage)) != null) {
                BackGroundImageManager bgit = new BackGroundImageManager(captcha);
                bgit.clearCaptchaAll();
                captcha.setOrgGrid(PixelGrid.getGridCopy(captcha.grid));
                captcha.owner.jas.executePrepareCommands(captcha.getCaptchaFile(), captcha);
                captcha.setCaptchaFile(captchafile);
                cs[i] = captcha;
                ColorTrainerGUI cc = new ColorTrainerGUI(owner);
                cc.colorTrainer.colorPointList = colorPoints;
                cc.colorTrainer.originalCaptcha = captcha;
                if (lastCC != null) {
                    lastCC.colorTrainer.copySettingsTo(cc.colorTrainer);
                }
                cc.init();
                ColorTrainerGUI colorTrainerGUI = cc;
                synchronized (colorTrainerGUI) {
                    try {
                        cc.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                lastCC = cc;
                colorPoints = cc.colorTrainer.colorPointList;
                if (cc.close) break;
            }
            ++i;
        }
        if (((Boolean)new GuiRunnable<Boolean>(){

            public Boolean runSave() {
                if (JOptionPane.showConfirmDialog(null, JDL.L((String)"gui.btn_save", (String)"Save"), JDL.L((String)"gui.btn_save", (String)"Save"), 0) == 0) {
                    return true;
                }
                return false;
            }
        }.getReturnValue()).booleanValue()) {
            ColorTrainer.saveColors(colorPoints, file);
        }
        return colorPoints;
    }

    public static Vector<CPoint> getColor(EasyMethodFile file, JFrame owner) {
        return ColorTrainerGUI.getColors(file.getCaptchaFolder(), file.file.getName(), null, owner);
    }

    public static void main(String[] args) {
        String path = JDUtilities.getJDHomeDirectoryFromEnvironment().getAbsolutePath();
        String hoster = "canna.to";
        File folder = new File(String.valueOf(path) + "/captchas/" + hoster);
        ColorTrainerGUI.getColors(folder, hoster, null, new JFrame());
    }
}

