/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import jd.captcha.gui.ImageComponent;
import jd.captcha.utils.Utilities;

public class BasicWindow
extends JFrame {
    private static final long serialVersionUID = 8474181150357563979L;

    public static BasicWindow showImage(Image img) {
        return BasicWindow.showImage(img, img.toString());
    }

    public static BasicWindow showImage(Image img, String title) {
        BasicWindow w = new BasicWindow();
        ImageComponent ic = new ImageComponent(img);
        w.setSize(ic.getImageWidth() + 10, ic.getImageHeight() + 20);
        w.setTitle(title);
        w.setLayout(new GridBagLayout());
        w.add((Component)ic, Utilities.getGBC(0, 0, 1, 1));
        w.setVisible(true);
        w.refreshUI();
        return w;
    }

    public BasicWindow() {
        this.initWindow();
    }

    public void destroy() {
        this.setVisible(false);
        this.dispose();
    }

    public GridBagConstraints getGBC(int x, int y, int width, int height) {
        GridBagConstraints gbc = Utilities.getGBC(x, y, width, height);
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        return gbc;
    }

    private void initWindow() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                BasicWindow.this.destroy();
            }
        });
        this.resizeWindow(100);
        this.setLocationByScreenPercent(50, 50);
        this.setBackground(Color.LIGHT_GRAY);
    }

    public void pack() {
        try {
            super.pack();
            Dimension screenSize = this.getToolkit().getScreenSize();
            int newWidth = (int)Math.min((double)Math.max(this.getSize().width, 300), screenSize.getWidth());
            int newHeight = (int)Math.min((double)Math.max(this.getSize().height, 300), screenSize.getHeight());
            this.setSize(newWidth, newHeight);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void refreshUI() {
        this.pack();
        this.repack();
    }

    public void repack() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SwingUtilities.updateComponentTreeUI(BasicWindow.this);
            }
        });
    }

    public void resizeWindow(int percent) {
        Dimension screenSize = this.getToolkit().getScreenSize();
        this.setSize(screenSize.width * percent / 100, screenSize.height * percent / 100);
    }

    public void setLocationByScreenPercent(int width, int height) {
        Dimension screenSize = this.getToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) * width / 100, (screenSize.height - this.getSize().height) * height / 100);
    }
}

