/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.pixelgrid;

import java.util.Vector;
import jd.captcha.JAntiCaptcha;
import jd.captcha.LetterComperator;
import jd.captcha.gui.BasicWindow;
import jd.captcha.pixelgrid.PixelGrid;
import jd.captcha.pixelobject.PixelObject;
import jd.captcha.utils.Utilities;
import jd.controlling.JDLogger;

public class Letter
extends PixelGrid {
    private static final long serialVersionUID = 1L;
    private int angle;
    private int badDetections = 0;
    private String decodedValue;
    public LetterComperator detected = null;
    private int elementPixel = 0;
    private int goodDetections = 0;
    private int id;
    private String sourcehash;

    public Letter() {
        super(0, 0);
    }

    public Letter(int averageWidth, int height) {
        super(averageWidth, height);
    }

    public Letter align(double objectContrast) {
        PixelObject obj = this.toPixelObject(objectContrast);
        PixelObject aligned = obj.align();
        Letter newLetter = aligned.toLetter();
        this.setGrid(newLetter.grid);
        return this;
    }

    public Letter align(double objectContrast, int angleA, int angleB) {
        PixelObject obj = this.toPixelObject(objectContrast);
        PixelObject aligned = obj.align(angleA, angleB);
        Letter newLetter = aligned.toLetter();
        this.setGrid(newLetter.grid);
        return this;
    }

    public Letter align(int angleA, int angleB) {
        if (angleB < angleA) {
            int tmp = angleB;
            angleB = angleA;
            angleA = tmp;
        }
        int accuracy = this.owner.getJas().getInteger("AlignAngleSteps");
        double bestValue = Double.MAX_VALUE;
        Letter res = null;
        int angle = angleA;
        while (angle < angleB) {
            Letter tmp = this.turn(angle < 0 ? 360 + angle : angle);
            if ((double)tmp.getWidth() / (double)tmp.getHeight() < bestValue) {
                bestValue = (double)tmp.getWidth() / (double)tmp.getHeight();
                res = tmp;
            }
            angle += accuracy;
        }
        return res;
    }

    public Letter betterAlign(int angleA, int angleB) {
        if (angleB < angleA) {
            int tmp = angleB;
            angleB = angleA;
            angleA = tmp;
        }
        int accuracy = this.owner.getJas().getInteger("AlignAngleSteps");
        int bestPix = this.getFirstAndLastLinePixels();
        Letter res = null;
        Letter tmp = this;
        int angle = angleA;
        while (angle < angleB) {
            tmp = this.turn(angle < 0 ? 360 + angle : angle);
            int pix = tmp.getFirstAndLastLinePixels();
            if (pix > bestPix) {
                bestPix = pix;
                res = tmp;
            }
            angle += accuracy;
        }
        return res;
    }

    public void invertIfMoreBackground() {
        long b = 0L;
        long w = 0L;
        int avg = this.getAverage();
        int y = 0;
        while (y < this.getHeight()) {
            int x = 0;
            while (x < this.getWidth()) {
                if (this.isElement(this.getPixelValue(x, y), avg)) {
                    ++b;
                } else {
                    ++w;
                }
                ++x;
            }
            ++y;
        }
        if (b > w) {
            this.invert();
        }
    }

    public void colorize(int color) {
        int x = 0;
        while (x < this.getWidth()) {
            int y = 0;
            while (y < this.getHeight()) {
                if (this.grid[x][y] < 40) {
                    this.grid[x][y] = color;
                }
                ++y;
            }
            ++x;
        }
    }

    public void fillWithObject(PixelObject p, int color) {
        int i = 0;
        while (i < p.getSize()) {
            int[] point = p.elementAt(i);
            this.grid[point[0]][point[1]] = color < 0 ? point[2] : color;
            ++i;
        }
    }

    private void followPixelObject(int x, int y, int[][] map, boolean[][] bmap) {
        if (bmap[x][y]) {
            return;
        }
        bmap[x][y] = true;
        int posX = -1;
        int posY = -1;
        try {
            if (map[x + posX][y + posY] == 0) {
                this.followPixelObject(x + posX, y + posY, map, bmap);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        posX = -1;
        posY = 0;
        try {
            if (map[x + posX][y + posY] == 0) {
                this.followPixelObject(x + posX, y + posY, map, bmap);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        posX = -1;
        posY = 1;
        try {
            if (map[x + posX][y + posY] == 0) {
                this.followPixelObject(x + posX, y + posY, map, bmap);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        posX = 0;
        posY = 1;
        try {
            if (map[x + posX][y + posY] == 0) {
                this.followPixelObject(x + posX, y + posY, map, bmap);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        posX = 1;
        posY = 1;
        try {
            if (map[x + posX][y + posY] == 0) {
                this.followPixelObject(x + posX, y + posY, map, bmap);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        posX = 1;
        posY = 0;
        try {
            if (map[x + posX][y + posY] == 0) {
                this.followPixelObject(x + posX, y + posY, map, bmap);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        posX = 1;
        posY = -1;
        try {
            if (map[x + posX][y + posY] == 0) {
                this.followPixelObject(x + posX, y + posY, map, bmap);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        posX = 0;
        posY = -1;
        try {
            if (map[x + posX][y + posY] == 0) {
                this.followPixelObject(x + posX, y + posY, map, bmap);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getAngle() {
        return this.angle;
    }

    public int getArea() {
        return this.getWidth() * this.getHeight();
    }

    public int getBadDetections() {
        return this.badDetections;
    }

    public String getDecodedValue() {
        return this.decodedValue;
    }

    public int getElementPixel() {
        if (this.elementPixel > 0) {
            return this.elementPixel;
        }
        this.elementPixel = 0;
        int x = 0;
        while (x < this.getWidth()) {
            int y = 0;
            while (y < this.getHeight()) {
                if (this.grid[x][y] == 0) {
                    ++this.elementPixel;
                }
                ++y;
            }
            ++x;
        }
        return this.elementPixel;
    }

    private int getFirstAndLastLinePixels() {
        int c = 0;
        int avg = this.getAverage();
        int y = 0;
        while (y < this.getHeight()) {
            int x = 0;
            while (x < this.getWidth()) {
                if (this.isElement(this.getPixelValue(x, y), avg)) {
                    ++c;
                }
                ++x;
            }
            if (c > 0) break;
            ++y;
        }
        int c2 = 0;
        int y2 = this.getHeight() - 1;
        while (y2 > 0) {
            int x = 0;
            while (x < this.getWidth()) {
                if (this.isElement(this.getPixelValue(x, y2), avg)) {
                    ++c2;
                }
                ++x;
            }
            if (c2 > 0) break;
            --y2;
        }
        return c + c2;
    }

    public int getGoodDetections() {
        return this.goodDetections;
    }

    public int getId() {
        return this.id;
    }

    public Letter getLinedLetter() {
        int changed;
        Letter ret = new Letter();
        ret.setOwner(this.owner);
        int count = 0;
        int firstChange = 0;
        do {
            ++count;
            changed = 0;
            PixelObject po = this.toPixelObject(0.85);
            Vector<int[]> border = po.getBorderVector(this);
            int i = 0;
            while (i < border.size()) {
                int ax = border.get(i)[0];
                int ay = border.get(i)[1];
                if (Utilities.isLoggerActive()) {
                    this.logger.info(String.valueOf(ax) + "/" + ay);
                }
                int[][] map = this.getLocalMap(this.grid, ax, ay);
                int a = this.getObjectsNum(map);
                map[1][1] = 1044480;
                int b = this.getObjectsNum(map);
                if (Utilities.isLoggerActive()) {
                    this.logger.info(String.valueOf(a) + " --->> " + b);
                }
                if (a == b) {
                    ++changed;
                    this.setPixelValue(ax, ay, 0xFF0000);
                } else {
                    if (Utilities.isLoggerActive()) {
                        this.logger.info(String.valueOf(map[0][0]) + "-" + map[1][0] + "-" + map[2][0]);
                    }
                    if (Utilities.isLoggerActive()) {
                        this.logger.info(String.valueOf(map[0][1]) + "-" + map[1][1] + "-" + map[2][1]);
                    }
                    if (Utilities.isLoggerActive()) {
                        this.logger.info(String.valueOf(map[0][2]) + "-" + map[1][2] + "-" + map[2][2]);
                    }
                    this.setPixelValue(ax, ay, 0);
                }
                ++i;
            }
            BasicWindow.showImage(this.getImage(5));
            if (Utilities.isLoggerActive()) {
                this.logger.info("changed " + changed);
            }
            if (firstChange != 0) continue;
            firstChange = changed;
        } while (changed * 20 > firstChange);
        ret.setGrid(this.grid);
        return ret;
    }

    public int[][] getLocalMap(int[][] grid, int x, int y) {
        int[][] map = new int[3][3];
        int xx = -1;
        while (xx <= 1) {
            int yy = -1;
            while (yy <= 1) {
                try {
                    map[xx + 1][yy + 1] = grid[x + xx][y + yy];
                }
                catch (Exception e) {
                    map[xx + 1][yy + 1] = -1;
                }
                ++yy;
            }
            ++xx;
        }
        return map;
    }

    /*
     * Exception decompiling
     */
    public Letter getMassLetter() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int getObjectsNum(int[][] map) {
        boolean[][] bmap = new boolean[3][3];
        int ret = 0;
        int x = 0;
        while (x < 3) {
            int y = 0;
            while (y < 3) {
                if (!bmap[x][y] && map[x][y] == 0) {
                    this.followPixelObject(x, y, map, bmap);
                    ++ret;
                }
                ++y;
            }
            ++x;
        }
        return ret;
    }

    public String getPixelString() {
        StringBuilder ret = new StringBuilder();
        int y = 0;
        while (y < this.getHeight()) {
            int x = 0;
            while (x < this.getWidth()) {
                ret.append(this.getPixelValue(x, y) / this.getMaxPixelValue());
                ++x;
            }
            ret.append('|');
            ++y;
        }
        String ps = ret.toString();
        if (ps.length() == 0) {
            System.out.println("IK");
        }
        return ps.substring(0, ps.length() - 1);
    }

    public Letter getSimplified(double faktor) {
        int y;
        if (faktor == 1.0 || faktor == 0.0) {
            return this;
        }
        int newWidth = (int)Math.ceil((double)this.getWidth() / faktor);
        int newHeight = (int)Math.ceil((double)this.getHeight() / faktor);
        Letter ret = new Letter();
        ret.setOwner(this.owner);
        int avg = this.getAverage();
        this.logger.info(String.valueOf(newWidth) + " - " + newHeight);
        int[][] newGrid = new int[newWidth][newHeight];
        int x = 0;
        while (x < newWidth) {
            y = 0;
            while (y < newHeight) {
                PixelGrid.setPixelValue(x, y, newGrid, this.getMaxPixelValue());
                ++y;
            }
            ++x;
        }
        this.elementPixel = 0;
        x = 0;
        while (x < this.getWidth()) {
            y = 0;
            while (y < this.getHeight()) {
                if (this.isElement(this.getPixelValue(x, y), avg)) {
                    int newX = (int)Math.floor((double)x / faktor);
                    int newY = (int)Math.floor((double)y / faktor);
                    PixelGrid.setPixelValue(newX, newY, newGrid, 0);
                }
                ++y;
            }
            ++x;
        }
        ret.setGrid(newGrid);
        ret.clean();
        return ret;
    }

    public String getSourcehash() {
        return this.sourcehash;
    }

    public void markBad() {
        ++this.badDetections;
        if (Utilities.isLoggerActive()) {
            this.logger.warning("Bad detection : (" + this.toString() + ") ");
        }
    }

    public void markGood() {
        ++this.goodDetections;
        if (Utilities.isLoggerActive()) {
            this.logger.warning("GOOD detection : (" + this.toString() + ") ");
        }
    }

    public void resizetoWidth(int newWidth) {
        double faktor = (double)newWidth / (double)this.getWidth();
        int newHeight = (int)Math.ceil((double)this.getHeight() * faktor);
        int[][] newGrid = new int[newWidth][newHeight];
        int elementPixel = 0;
        int x = 0;
        while (x < newWidth) {
            int y = 0;
            while (y < newHeight) {
                int v;
                newGrid[x][y] = v = this.grid[(int)Math.floor((double)x / faktor)][(int)Math.floor((double)y / faktor)];
                if (newGrid[x][y] == 0) {
                    ++elementPixel;
                }
                ++y;
            }
            ++x;
        }
        this.setElementPixel(elementPixel);
        this.setGrid(newGrid);
    }

    public void resizetoHeight(int newHeight) {
        double faktor = (double)newHeight / (double)this.getHeight();
        int newWidth = (int)Math.ceil((double)this.getWidth() * faktor);
        int[][] newGrid = new int[newWidth][newHeight];
        int elementPixel = 0;
        int x = 0;
        while (x < newWidth) {
            int y = 0;
            while (y < newHeight) {
                int v;
                newGrid[x][y] = v = this.grid[(int)Math.floor((double)x / faktor)][(int)Math.floor((double)y / faktor)];
                if (newGrid[x][y] == 0) {
                    ++elementPixel;
                }
                ++y;
            }
            ++x;
        }
        this.setElementPixel(elementPixel);
        this.setGrid(newGrid);
    }

    public void resizetoHeight(int newHeight, double d) {
        double faktor = (double)newHeight / (double)this.getHeight();
        if (Math.abs(faktor - 1.0) < d) {
            this.resizetoHeight(newHeight);
        }
    }

    private void setAngle(int angle) {
        this.angle = angle;
    }

    public void setBadDetections(int badDetections) {
        this.badDetections = badDetections;
    }

    public void setDecodedValue(String decodedValue) {
        this.decodedValue = decodedValue;
    }

    public void setElementPixel(int elementPixel) {
        this.elementPixel = elementPixel;
    }

    public void setGoodDetections(int goodDetections) {
        this.goodDetections = goodDetections;
    }

    public void setOwner(JAntiCaptcha owner) {
        this.owner = owner;
    }

    public void setSourcehash(String sourcehash) {
        this.sourcehash = sourcehash;
    }

    public boolean setTextGrid(String content) {
        String[] code = content.split("\\|");
        this.grid = null;
        int width = 0;
        int elementPixel = 0;
        int y = 0;
        while (y < code.length) {
            String line = code[y];
            width = line.length();
            if (this.grid == null) {
                this.grid = new int[width][code.length];
                if (width < 1 || code.length < 2) {
                    return false;
                }
            }
            int x = 0;
            while (x < width) {
                try {
                    this.grid[x][y] = Integer.parseInt(String.valueOf(line.charAt(x))) * this.getMaxPixelValue();
                }
                catch (Exception e) {
                    JDLogger.exception((Throwable)e);
                    return false;
                }
                if (this.grid[x][y] == 0) {
                    ++elementPixel;
                }
                ++x;
            }
            ++y;
        }
        this.setElementPixel(elementPixel);
        return true;
    }

    public PixelObject toPixelObject(double objectContrast) {
        PixelObject object = new PixelObject(this);
        object.setWhiteContrast(objectContrast);
        int x = 0;
        while (x < this.getWidth()) {
            int y = 0;
            while (y < this.getHeight()) {
                if ((double)this.getPixelValue(x, y) < (double)this.getMaxPixelValue() * objectContrast) {
                    object.add(x, y, this.getPixelValue(x, y));
                }
                ++y;
            }
            ++x;
        }
        return object;
    }

    public String toString() {
        return String.valueOf(this.getDecodedValue()) + " [" + this.getSourcehash() + "][" + this.getGoodDetections() + "/" + this.getBadDetections() + "]";
    }

    public boolean trim(int left, int right) {
        int width = right - left;
        int[][] tmp = new int[width][this.getHeight()];
        int[] nArray = new int[2];
        nArray[0] = left;
        this.setLocation(nArray);
        if (this.getWidth() < right) {
            if (Utilities.isLoggerActive()) {
                this.logger.severe("Letter dim: " + this.getWidth() + " - " + this.getHeight() + ". Cannot trim to " + left + "-" + right);
            }
            return false;
        }
        int x = 0;
        while (x < width) {
            tmp[x] = this.grid[x + left];
            ++x;
        }
        this.grid = tmp;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public Letter turn(double angle) {
        if (angle != 0.0) ** GOTO lbl4
        return this;
lbl-1000:
        // 1 sources

        {
            angle += 360.0;
lbl4:
            // 2 sources

            ** while (angle < 0.0)
        }
lbl5:
        // 1 sources

        l = this.createLetter();
        newWidth = (int)(Math.abs(Math.cos((angle /= 180.0) * 3.141592653589793) * (double)this.getWidth()) + Math.abs(Math.sin(angle * 3.141592653589793) * (double)this.getHeight()));
        newHeight = (int)(Math.abs(Math.sin(angle * 3.141592653589793) * (double)this.getWidth()) + Math.abs(Math.cos(angle * 3.141592653589793) * (double)this.getHeight()));
        left = (newWidth - this.getWidth()) / 2;
        top = (newHeight - this.getHeight()) / 2;
        elementPixel = 0;
        newGrid = new int[newWidth][newHeight];
        x = 0;
        while (x < newWidth) {
            y = 0;
            while (y < newHeight) {
                n = Utilities.turnCoordinates(x - left, y - top, this.getWidth() / 2, this.getHeight() / 2, -(angle * 180.0));
                if (n[0] < 0 || n[0] >= this.getWidth() || n[1] < 0 || n[1] >= this.getHeight()) {
                    newGrid[x][y] = this.owner.getJas().getColorFaktor() - 1;
                    if (newGrid[x][y] == 0) {
                        ++elementPixel;
                    }
                } else {
                    newGrid[x][y] = this.grid[n[0]][n[1]];
                    if (newGrid[x][y] == 0) {
                        ++elementPixel;
                    }
                }
                ++y;
            }
            ++x;
        }
        l.setGrid(newGrid);
        l.setElementPixel(elementPixel);
        l.clean();
        l.id = this.id;
        l.setDecodedValue(this.getDecodedValue());
        l.setAngle((int)(angle * 180.0));
        l.setProperties(this.getProperties());
        return l;
    }

    public void setId(int id) {
        this.id = id;
    }
}

