/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.specials;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import jd.captcha.LetterComperator;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelobject.PixelObject;
import jd.controlling.JDLogger;
import jd.nutils.Colors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Circle {
    int inBorder = 4;
    int outBorder = 2;
    int minArea = 150;
    private Captcha captcha;
    int backgroundColor = 0xFFFFFF;
    private List<PixelObject> objectArray;
    private Letter openCircle;
    Comparator<Integer> isElementColor = new Comparator<Integer>(){

        @Override
        public int compare(Integer o1, Integer o2) {
            int[] hsvC2;
            int c = o1;
            int c2 = o2;
            if (Circle.this.isBackground(o1) || Circle.this.isBackground(o2)) {
                return 0;
            }
            if (c == 0 || c2 == 0) {
                return c == c2 ? 1 : 0;
            }
            int[] hsvC = Colors.rgb2hsv((int)c);
            return hsvC[0] == (hsvC2 = Colors.rgb2hsv((int)c2))[0] && (hsvC[1] == hsvC2[1] || hsvC[2] == hsvC2[2] || hsvC[1] / hsvC2[2] == 1 || hsvC[1] / hsvC2[2] == 1) && Colors.getRGBColorDifference2((int)c, (int)c2) < 80.0 ? 1 : 0;
        }
    };

    public Circle(Captcha captcha, List<PixelObject> objectArray) {
        this.captcha = captcha;
        this.objectArray = objectArray;
    }

    private boolean equalElements(int c, int c2) {
        return this.isElementColor.compare(c, c2) == 1;
    }

    private boolean isBackground(int c) {
        return c < 0 || c == this.backgroundColor;
    }

    private PixelObject getCircle(int x, int y, int r) {
        PixelObject b = new PixelObject(this.captcha);
        int ret = 0;
        int i = -this.inBorder;
        while (i < this.outBorder / 2) {
            PixelObject n = new PixelObject(this.captcha);
            ret += this.circle(x, y, r + i, n);
            if (n.getSize() > 0) {
                b.add(n);
            }
            ++i;
        }
        if (b.getSize() > 10 && b.getArea() > 30) {
            return b;
        }
        return null;
    }

    private int checkBackground(int x, int y, PixelObject n) {
        int c = this.captcha.getPixelValue(x, y);
        boolean b = this.isBackground(c);
        if (!b) {
            n.add(x, y, c);
        }
        return b ? 1 : 0;
    }

    private int circle(int cx, int cy, int radius, PixelObject n) {
        int error = -radius;
        int x = radius;
        int y = 0;
        int ret = 0;
        while (x >= y) {
            ret += this.plot8points(cx, cy, x, y, n);
            ret += this.plot8points(cx - 1, cy, x, y, n);
            ret += this.plot8points(cx, cy - 1, x, y, n);
            error += y;
            if ((error += ++y) < 0) continue;
            error -= --x;
            error -= x;
        }
        return ret;
    }

    private int plot8points(int cx, int cy, int x, int y, PixelObject n) {
        int ret = 0;
        ret += this.plot4points(cx, cy, x, y, n);
        if (x != y) {
            ret += this.plot4points(cx, cy, y, x, n);
        }
        return ret;
    }

    private int plot4points(int cx, int cy, int x, int y, PixelObject n) {
        int ret = 0;
        ret += this.checkBackground(cx + x, cy + y, n);
        if (x != 0) {
            ret += this.checkBackground(cx - x, cy + y, n);
        }
        if (y != 0) {
            ret += this.checkBackground(cx + x, cy - y, n);
        }
        if (x != 0 && y != 0) {
            ret += this.checkBackground(cx - x, cy - y, n);
        }
        return ret;
    }

    private int[] getBounds(PixelObject pixelObject) {
        if (pixelObject.getSize() < 5 || pixelObject.getArea() < this.minArea) {
            return null;
        }
        Letter let = pixelObject.toColoredLetter();
        int r = let.getWidth() / 2;
        try {
            int ratio = pixelObject.getHeight() * 100 / pixelObject.getWidth();
            if (ratio > 95 && ratio < 105 || this.equalElements(let.getGrid()[r][0], let.getGrid()[0][r]) || this.equalElements(let.getGrid()[r][let.getWidth() - 1], let.getGrid()[0][r]) || this.equalElements(let.getGrid()[r][0], let.getGrid()[let.getWidth() - 1][r]) || this.equalElements(let.getGrid()[r][let.getWidth() - 1], let.getGrid()[let.getWidth() - 1][r])) {
                return new int[]{let.getLocation()[0] + r, let.getLocation()[1] + let.getWidth()};
            }
        }
        catch (Exception ratio) {
            // empty catch block
        }
        ArrayList<int[]> best = new ArrayList<int[]>();
        int h = let.getLocation()[1] + let.getHeight();
        int x = let.getLocation()[0];
        while (x < let.getLocation()[0] + let.getWidth()) {
            int y = let.getLocation()[1];
            int c = this.captcha.grid[x][y];
            if (!this.isBackground(c)) {
                ++y;
                while (y < h) {
                    if (this.isBackground(this.captcha.grid[x][y])) break;
                    ++y;
                }
                int oldy = y;
                while (y < h) {
                    if (!this.isBackground(this.captcha.grid[x][y]) && this.equalElements(c, this.captcha.grid[x][y])) break;
                    ++y;
                }
                if (oldy != y && h >= y) {
                    oldy = y;
                    while (y < h) {
                        if (this.isBackground(this.captcha.grid[x][y])) break;
                        ++y;
                    }
                    if (oldy != y && (y != let.getHeight() || Math.abs(let.getHeight() - let.getWidth()) <= 15)) {
                        if (best.size() > 0) {
                            if (y > ((int[])best.get(0))[0]) {
                                best = new ArrayList();
                                best.add(new int[]{x, y});
                            } else if (y == ((int[])best.get(0))[1]) {
                                best.add(new int[]{x, y});
                            }
                        } else {
                            best.add(new int[]{x, y});
                        }
                    }
                }
            }
            ++x;
        }
        if (best.size() == 0) {
            return null;
        }
        x = 0;
        for (int[] is : best) {
            x += is[0];
        }
        return new int[]{x / best.size(), ((int[])best.get(0))[1]};
    }

    private void addCircles(PixelObject pixelObject, ArrayList<PixelObject> obnew) {
        if (pixelObject.getArea() < this.minArea) {
            return;
        }
        int[] bounds = this.getBounds(pixelObject);
        int r = 0;
        if (bounds != null) {
            int ratio;
            r = (bounds[1] - pixelObject.getLocation()[1]) / 2;
            PixelObject object = this.getCircle(bounds[0], bounds[1] - r, r);
            if (object != null && (ratio = object.getHeight() * 100 / object.getWidth()) > 90 && ratio < 110) {
                obnew.add(object);
                int oldArea = pixelObject.getArea();
                pixelObject.del(object);
                if (oldArea != pixelObject.getArea()) {
                    this.addCircles(pixelObject, obnew);
                }
            }
        } else {
            JDLogger.warning((Object)"can not detect circle bounds");
        }
    }

    public ArrayList<PixelObject> getCircles() {
        ArrayList<PixelObject> obnew = new ArrayList<PixelObject>();
        for (PixelObject pixelObject : this.objectArray) {
            if (pixelObject.getArea() <= this.minArea) continue;
            this.addCircles(pixelObject, obnew);
        }
        this.objectArray = obnew;
        return obnew;
    }

    public Letter[] getOpenCirclePositionAsLetters() {
        this.openCircle = this.getOpenCircle();
        if (this.openCircle == null) {
            return null;
        }
        int x = this.openCircle.getLocation()[0] + this.openCircle.getWidth() / 2;
        int y = this.openCircle.getLocation()[1] + this.openCircle.getHeight() / 2;
        return Circle.getPostionLetters(x, y);
    }

    public static Letter[] getPostionLetters(int x, int y) {
        char[] tx = (String.valueOf(x) + ":" + y).toCharArray();
        Letter[] ret = new Letter[tx.length];
        int i = 0;
        while (i < ret.length) {
            Letter re = new Letter();
            re.setDecodedValue("" + tx[i]);
            LetterComperator let = new LetterComperator(re, re);
            let.setValityPercent(0.0);
            re.detected = let;
            ret[i] = re;
            ++i;
        }
        return ret;
    }

    public Letter getOpenCircle() {
        if (this.openCircle != null) {
            return this.openCircle;
        }
        this.getCircles();
        Letter best = null;
        int bestwda = Integer.MIN_VALUE;
        for (PixelObject pixelObject : this.objectArray) {
            int x;
            int y;
            Letter let = pixelObject.toColoredLetter();
            int w = 0;
            int x2 = 0;
            while (x2 < let.getWidth()) {
                y = 0;
                while (y < let.getHeight()) {
                    if (!this.isBackground(let.getPixelValue(x2, y))) break;
                    ++w;
                    ++y;
                }
                ++x2;
            }
            int y2 = 0;
            while (y2 < let.getHeight()) {
                x = 0;
                while (x < let.getWidth()) {
                    if (!this.isBackground(let.getPixelValue(x, y2))) break;
                    ++w;
                    ++x;
                }
                ++y2;
            }
            x2 = 0;
            while (x2 < let.getWidth()) {
                y = let.getHeight() - 1;
                while (y > 0) {
                    if (!this.isBackground(let.getPixelValue(x2, y))) break;
                    ++w;
                    --y;
                }
                ++x2;
            }
            y2 = 0;
            while (y2 < let.getHeight()) {
                x = let.getWidth() - 1;
                while (x > 0) {
                    if (!this.isBackground(let.getPixelValue(x, y2))) break;
                    ++w;
                    --x;
                }
                ++y2;
            }
            int wda = w * 100 / let.getArea();
            if (wda <= bestwda || let.getArea() <= this.minArea) continue;
            best = let;
            bestwda = wda;
        }
        this.openCircle = best;
        return best;
    }
}

