/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.specials;

import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelobject.PixelObject;

public class CryPtT {
    private static int[] getColorAndPoint(Captcha captcha) {
        int y1 = 0;
        int color = 0xFFFFFF;
        while (y1 < captcha.getHeight()) {
            if (captcha.grid[1][y1] != 0xFFFFFF && captcha.grid[captcha.getWidth() - 2][y1] != 0xFFFFFF) {
                color = captcha.grid[0][y1];
                break;
            }
            ++y1;
        }
        int y2 = captcha.getHeight() - 1;
        while (y2 >= 0) {
            if (captcha.grid[1][y2] != 0xFFFFFF && captcha.grid[captcha.getWidth() - 2][y2] != 0xFFFFFF) break;
            --y2;
        }
        return new int[]{y1, y2, color};
    }

    private static void toBlack(Captcha captcha) {
        int x = 0;
        while (x < captcha.getWidth()) {
            int y = 0;
            while (y < captcha.getHeight()) {
                captcha.grid[x][y] = captcha.grid[x][y] != 0xFFFFFF ? 0 : 0xFFFFFF;
                ++y;
            }
            ++x;
        }
    }

    private static void markColoredLayer(Captcha captcha, int[] point) {
        int x = 1;
        while (x < captcha.getWidth() - 1) {
            int y = point[0];
            while (y < point[1] + 1) {
                if (captcha.grid[x][y] == 0xFFFFFF) {
                    captcha.grid[x][y - 1] = 0xFF0000;
                    captcha.grid[x][y] = 0xFF0000;
                    captcha.grid[x][y + 1] = 0xFF0000;
                    captcha.grid[x + 1][y + 1] = 0xFF0000;
                    captcha.grid[x + 1][y] = 0xFF0000;
                    captcha.grid[x + 1][y - 1] = 0xFF0000;
                    captcha.grid[x - 1][y] = 0xFF0000;
                    captcha.grid[x - 1][y - 1] = 0xFF0000;
                    captcha.grid[x - 1][y + 1] = 0xFF0000;
                } else if (captcha.grid[x][y] == point[2]) {
                    captcha.grid[x][y] = 0xFFFFFF;
                }
                ++y;
            }
            ++x;
        }
        int y = point[0];
        while (y < point[1] + 1) {
            captcha.grid[0][y] = 0xFFFFFF;
            captcha.grid[captcha.getWidth() - 1][y] = 0xFFFFFF;
            ++y;
        }
    }

    private static PixelObject[] getObjects(Captcha captcha) {
        int y;
        PixelObject[] ret = new PixelObject[3];
        int i = 0;
        while (i < ret.length) {
            ret[i] = new PixelObject(captcha);
            ++i;
        }
        int x = 0;
        while (x < captcha.getWidth() / 3 + captcha.getWidth() / 10) {
            y = 0;
            while (y < captcha.getHeight()) {
                if (captcha.grid[x][y] != 0xFFFFFF) {
                    ret[0].add(x, y, captcha.grid[x][y]);
                }
                ++y;
            }
            ++x;
        }
        x = captcha.getWidth() / 3 - captcha.getWidth() / 20;
        while (x < captcha.getWidth() * 2 / 3 + captcha.getWidth() / 20) {
            y = 0;
            while (y < captcha.getHeight()) {
                if (captcha.grid[x][y] != 0xFFFFFF) {
                    ret[1].add(x, y, captcha.grid[x][y]);
                }
                ++y;
            }
            ++x;
        }
        x = captcha.getWidth() * 2 / 3 - captcha.getWidth() / 10;
        while (x < captcha.getWidth()) {
            y = 0;
            while (y < captcha.getHeight()) {
                if (captcha.grid[x][y] != 0xFFFFFF) {
                    ret[2].add(x, y, captcha.grid[x][y]);
                }
                ++y;
            }
            ++x;
        }
        return ret;
    }

    public static Letter[] getLetters(Captcha captcha) {
        int[] cp = CryPtT.getColorAndPoint(captcha);
        CryPtT.markColoredLayer(captcha, cp);
        CryPtT.toBlack(captcha);
        PixelObject[] os = CryPtT.getObjects(captcha);
        Letter[] lets = new Letter[os.length];
        int i = 0;
        while (i < lets.length) {
            lets[i] = os[i].toLetter();
            lets[i].resizetoHeight(30);
            ++i;
        }
        return lets;
    }
}

