/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.specials;

import java.util.Collections;
import java.util.Vector;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelgrid.PixelGrid;
import jd.captcha.pixelobject.PixelObject;
import jd.captcha.specials.EasyCaptcha;
import jd.nutils.Colors;

public class HstjNt {
    static void clearlines(Captcha captcha) {
        int[][] grid = PixelGrid.getGridCopy(captcha.grid);
        int x = 1;
        while (x < captcha.getWidth() - 1) {
            int y = 1;
            while (y < captcha.getHeight() - 1) {
                if (captcha.grid[x][y] == 0) {
                    int w = captcha.grid[x + 1][y] == 0 ? 1 : 0;
                    w += captcha.grid[x + 1][y + 1] == 0 ? 1 : 0;
                    w += captcha.grid[x][y + 1] == 0 ? 1 : 0;
                    w += captcha.grid[x - 1][y + 1] == 0 ? 1 : 0;
                    w += captcha.grid[x - 1][y - 1] == 0 ? 1 : 0;
                    w += captcha.grid[x + 1][y - 1] == 0 ? 1 : 0;
                    w += captcha.grid[x - 1][y] == 0 ? 1 : 0;
                    if ((w += captcha.grid[x][y - 1] == 0 ? 1 : 0) < 2) {
                        grid[x][y] = 0xFFFFFF;
                    } else if (w < 3 && captcha.grid[x + 1][y] == 0 && captcha.grid[x - 1][y] == 0) {
                        grid[x][y] = 0xFFFFFF;
                    }
                }
                ++y;
            }
            ++x;
        }
        captcha.grid = grid;
    }

    static void toBlack(Captcha captcha) {
        try {
            int color = captcha.getAverage();
            int x = 0;
            while (x < captcha.getWidth()) {
                int y = 0;
                while (y < captcha.getHeight()) {
                    captcha.grid[x][y] = Colors.getRGBColorDifference2((int)captcha.grid[x][y], (int)color) > 25.0 ? 0 : 0xFFFFFF;
                    ++y;
                }
                ++x;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void blurIt(Captcha captcha, int factor) {
        int[][] grid = PixelGrid.getGridCopy(captcha.grid);
        int x = 0;
        while (x < captcha.getWidth()) {
            int y = 0;
            while (y < captcha.getHeight()) {
                if (captcha.grid[x][y] == 0) {
                    int i = 0;
                    while (i < factor && x + i < captcha.getWidth()) {
                        int j = 0;
                        while (j < factor && y + j < captcha.getHeight()) {
                            grid[x + i][y + j] = 0;
                            if (x - i >= 0 && y - j >= 0) {
                                grid[x - i][y - j] = 0;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                ++y;
            }
            ++x;
        }
        captcha.grid = grid;
    }

    public static Letter[] getLetters(Captcha captcha) {
        HstjNt.toBlack(captcha);
        captcha.crop(2, 2, 2, 2);
        HstjNt.clearlines(captcha);
        captcha.removeSmallObjects(0.7, 0.7, 95);
        HstjNt.blurIt(captcha, 3);
        Vector<PixelObject> os = captcha.getObjects(0.5, 0.5);
        Collections.sort(os);
        Letter[] lets = new Letter[os.size()];
        if (os.size() == 4) {
            int i = 0;
            while (i < lets.length) {
                lets[i] = os.get(i).toLetter();
                lets[i].resizetoHeight(35);
                ++i;
            }
        } else {
            Letter[] letterArray = lets = EasyCaptcha.getLetters(captcha);
            int n = lets.length;
            int n2 = 0;
            while (n2 < n) {
                Letter letter = letterArray[n2];
                letter.resizetoHeight(35);
                ++n2;
            }
        }
        return lets;
    }
}

