/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.specials;

import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Logger;
import jd.captcha.JAntiCaptcha;
import jd.captcha.pixelgrid.Letter;
import jd.controlling.JDLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiThreadDetection {
    private static ArrayList<Letter> DETECTION_QUEUE = new ArrayList();
    private static ArrayList<DetectionThread> DETECTION_THREADS = new ArrayList();
    private JAntiCaptcha jac;
    private Logger logger = JDLogger.getLogger();
    private int maxThreads;

    public static Letter[] multiCore(Letter[] org, JAntiCaptcha jac) {
        int ths = Runtime.getRuntime().availableProcessors();
        MultiThreadDetection mtd = new MultiThreadDetection(ths, jac);
        Letter[] letterArray = org;
        int n = org.length;
        int n2 = 0;
        while (n2 < n) {
            Letter l = letterArray[n2];
            mtd.queueDetection(l);
            ++n2;
        }
        mtd.waitFor(null);
        return org;
    }

    public MultiThreadDetection(int threads, JAntiCaptcha jac) {
        this.logger.info("Run Detection on " + threads + " CPU Cores");
        this.maxThreads = threads;
        this.jac = jac;
    }

    public synchronized void queueDetection(Letter ll) {
        DETECTION_QUEUE.add(ll);
        this.startDetection(null);
    }

    private synchronized void startDetection(Thread thread) {
        if (thread != null) {
            DETECTION_THREADS.remove(thread);
            this.logger.info("Thread finished. running: " + DETECTION_THREADS.size());
        }
        if (DETECTION_QUEUE.size() > 0 && DETECTION_THREADS.size() < this.maxThreads) {
            this.startThread(DETECTION_QUEUE.remove(0));
            this.logger.info("NO RUNNING " + DETECTION_THREADS.size() + " Threads. IN queue: " + DETECTION_QUEUE.size());
        }
    }

    private void startThread(Letter l) {
        DetectionThread th = new DetectionThread(l);
        th.start();
        DETECTION_THREADS.add(th);
    }

    public void waitFor(Vector<Letter> list) {
        while (true) {
            if (list == null) {
                if (DETECTION_THREADS.size() == 0 && DETECTION_QUEUE.size() == 0) {
                    return;
                }
            } else {
                boolean found = false;
                for (DetectionThread detectionThread : DETECTION_THREADS) {
                    if (!list.contains((Object)detectionThread.letter)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return;
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                JDLogger.exception((Throwable)e);
                return;
            }
        }
    }

    class DetectionThread
    extends Thread {
        public Letter letter;

        public DetectionThread(Letter l) {
            this.letter = l;
        }

        public void run() {
            this.letter.detected = MultiThreadDetection.this.jac.getLetter(this.letter);
            MultiThreadDetection.this.startDetection(this);
        }
    }
}

