/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.specials;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jd.captcha.easy.BackGroundImageManager;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelgrid.PixelGrid;
import jd.captcha.pixelobject.PixelObject;
import jd.captcha.specials.EasyCaptcha;
import jd.nutils.Colors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PpscnRg {
    static void clearlines(Captcha captcha) {
        int x = 0;
        while (x < captcha.getWidth()) {
            int y = 0;
            while (y < captcha.getHeight()) {
                if (Colors.rgb2hsv((int)captcha.grid[x][y])[2] > 40) {
                    captcha.grid[x][y] = 0xFFFFFF;
                }
                ++y;
            }
            ++x;
        }
        int[][] grid = PixelGrid.getGridCopy(captcha.grid);
        int x2 = 1;
        while (x2 < captcha.getWidth() - 1) {
            int y = 1;
            while (y < captcha.getHeight() - 1) {
                if (captcha.grid[x2][y] != 0xFFFFFF && Colors.rgb2hsv((int)captcha.grid[x2][y])[2] > 38) {
                    int c = captcha.grid[x2][y];
                    int w = captcha.grid[x2 + 1][y] == c ? 1 : 0;
                    w += captcha.grid[x2 + 1][y + 1] == c ? 2 : 0;
                    w += captcha.grid[x2][y + 1] == c ? 2 : 0;
                    w += captcha.grid[x2 - 1][y + 1] == c ? 2 : 0;
                    w += captcha.grid[x2 - 1][y - 1] == c ? 2 : 0;
                    w += captcha.grid[x2 + 1][y - 1] == c ? 2 : 0;
                    w += captcha.grid[x2 - 1][y] == c ? 1 : 0;
                    if ((w += captcha.grid[x2][y - 1] == c ? 2 : 0) < 6) {
                        grid[x2][y] = 0xFFFFFF;
                    }
                }
                ++y;
            }
            ++x2;
        }
        captcha.grid = grid;
    }

    static void clearlines2(Captcha captcha) {
        int[][] grid = PixelGrid.getGridCopy(captcha.grid);
        int x = 1;
        while (x < captcha.getWidth() - 1) {
            int y = 1;
            while (y < captcha.getHeight() - 1) {
                if (captcha.grid[x][y] != 0xFFFFFF) {
                    int w = captcha.grid[x + 1][y] != 0xFFFFFF ? 1 : 0;
                    w += captcha.grid[x + 1][y + 1] != 0xFFFFFF ? 2 : 0;
                    w += captcha.grid[x][y + 1] != 0xFFFFFF ? 2 : 0;
                    w += captcha.grid[x - 1][y + 1] != 0xFFFFFF ? 2 : 0;
                    w += captcha.grid[x - 1][y - 1] != 0xFFFFFF ? 2 : 0;
                    w += captcha.grid[x + 1][y - 1] != 0xFFFFFF ? 2 : 0;
                    w += captcha.grid[x - 1][y] != 0xFFFFFF ? 1 : 0;
                    if ((w += captcha.grid[x][y - 1] != 0xFFFFFF ? 2 : 0) < 2) {
                        grid[x][y] = 0xFFFFFF;
                    }
                }
                ++y;
            }
            ++x;
        }
        captcha.grid = grid;
    }

    private static void toBlack(PixelGrid captcha) {
        int x = 1;
        while (x < captcha.getWidth() - 1) {
            int y = 1;
            while (y < captcha.getHeight() - 1) {
                if (captcha.grid[x][y] != 0xFFFFFF) {
                    captcha.grid[x][y] = 0;
                }
                ++y;
            }
            ++x;
        }
    }

    public static ArrayList<PixelObject> getObjects(PixelGrid grid, int neighbourradius) {
        ArrayList<PixelObject> ret = new ArrayList<PixelObject>();
        int x = 0;
        while (x < grid.getWidth()) {
            int y = 0;
            while (y < grid.getHeight()) {
                int c = grid.grid[x][y];
                if (c != 0xFFFFFF) {
                    PixelObject n = new PixelObject(grid);
                    n.add(x, y, c);
                    ArrayList<PixelObject> merge = new ArrayList<PixelObject>();
                    for (PixelObject o : ret) {
                        if (c != o.getMostcolor() || !o.isTouching(x, y, true, neighbourradius, neighbourradius)) continue;
                        merge.add(o);
                    }
                    if (merge.size() == 0) {
                        ret.add(n);
                    } else if (merge.size() == 1) {
                        ((PixelObject)merge.get(0)).add(n);
                    } else {
                        for (PixelObject po : merge) {
                            ret.remove(po);
                            n.add(po);
                        }
                        ret.add(n);
                    }
                }
                ++y;
            }
            ++x;
        }
        return ret;
    }

    private static void merge(List<PixelObject> os) {
        if (os.size() == 4) {
            return;
        }
        PixelObject aos = null;
        Iterator<PixelObject> iterator = os.iterator();
        while (iterator.hasNext()) {
            PixelObject pixelObject = iterator.next();
            if (pixelObject.getSize() >= 2) continue;
            iterator.remove();
        }
        int mergeos = Integer.MAX_VALUE;
        for (PixelObject pixelObject : os) {
            int mg = pixelObject.getSize();
            if (mergeos <= mg) continue;
            mergeos = mg;
            aos = pixelObject;
        }
        EasyCaptcha.mergeos(aos, os);
        PpscnRg.merge(os);
    }

    public static Letter[] getLetters(Captcha captcha) {
        BackGroundImageManager bgit = new BackGroundImageManager(captcha);
        bgit.setBackGroundImageListFileName("bgimages2.xml");
        bgit.clearCaptchaAll();
        PpscnRg.clearlines(captcha);
        captcha.crop(3, 30, 3, 50);
        ArrayList<PixelObject> os = PpscnRg.getObjects(captcha, 2);
        PpscnRg.merge(os);
        Collections.sort(os);
        Letter[] letters = new Letter[os.size()];
        int i = 0;
        while (i < letters.length) {
            letters[i] = os.get(i).toLetter();
            PpscnRg.toBlack(letters[i]);
            letters[i].autoAlign();
            letters[i].resizetoHeight(25);
            ++i;
        }
        return letters;
    }
}

